/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.ISaveDataTable;
import kd.bos.dataentity.metadata.ISaveMetaRow;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.orm.dataentity.BatchUpdateData;
import kd.bos.orm.dataentity.BatchUpdateTask;
import kd.bos.orm.dataentity.BatchWithGroupUpdateTask;
import kd.bos.orm.dataentity.CRUDHelper;
import kd.bos.orm.dataentity.IDatabaseTask;

class BatchUpdateTaskContainer {
    private Map<String, BatchUpdateData> _dataSet = new HashMap<String, BatchUpdateData>();
    private DBRoute dbRoute;

    public BatchUpdateTaskContainer(DBRoute dbRoute) {
        this.dbRoute = dbRoute;
    }

    public void update(ISaveDataTable table, ISaveMetaRow saveRow) {
        IColumnValuePair[] inputValues = saveRow.getDirtyValues().toArray(new IColumnValuePair[0]);
        this.getBatchUpdateData(this.getBatchTaskKey(table.getSchema(), inputValues)).insert(inputValues, saveRow);
    }

    private ThreeTuple<String, List<DbMetadataColumn>, DbMetadataTable> getBatchTaskKey(DbMetadataTable table, IColumnValuePair[] inputValues) {
        StringBuilder key = new StringBuilder();
        ArrayList<DbMetadataColumn> columns = new ArrayList<DbMetadataColumn>(inputValues.length);
        for (IColumnValuePair colVal : inputValues) {
            key.append(colVal.getColumn().getName()).append('.');
            columns.add(colVal.getColumn());
        }
        key.append(table.getName());
        return new ThreeTuple((Object)key.toString(), columns, (Object)table);
    }

    private BatchUpdateData getBatchUpdateData(ThreeTuple<String, List<DbMetadataColumn>, DbMetadataTable> key) {
        BatchUpdateData task = this._dataSet.get(key.item1);
        if (task == null) {
            task = new BatchUpdateData((DbMetadataTable)key.item3, (List)key.item2);
            this._dataSet.put((String)key.item1, task);
        }
        return task;
    }

    public List<IDatabaseTask> createTasks() {
        ArrayList<IDatabaseTask> result = new ArrayList<IDatabaseTask>();
        for (BatchUpdateData data : this._dataSet.values()) {
            DbMetadataTable table = data.getTable();
            int tableLevel = CRUDHelper.getTableLevel(table);
            List columnsByTableGroup = table.getColumnsByTableGroup(data.getColumns(), false, false);
            for (Tuple group : columnsByTableGroup) {
                String groupName = (String)group.item1;
                DbMetadataColumn[] columns = (DbMetadataColumn[])group.item2;
                if (columns.length <= 0) continue;
                int level = tableLevel * 2 - (StringUtils.isBlank((CharSequence)groupName) ? 1 : 0);
                BatchUpdateTask task = null;
                task = StringUtils.isNotBlank((CharSequence)groupName) ? new BatchWithGroupUpdateTask(table, groupName, this.dbRoute, CRUDHelper.getTableNameWithGroup(table.getName(), groupName), columns, data.getRows(), data.getOIds(), table.getPrimaryKey(), data.getIds(), data.getSaveRows(), level) : new BatchUpdateTask(this.dbRoute, CRUDHelper.getTableNameWithGroup(table.getName(), groupName), columns, data.getRows(), data.getOIds(), table.getPrimaryKey(), data.getIds(), data.getSaveRows(), level);
                result.add(task);
            }
        }
        return result;
    }
}

