/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.ISaveMetaRow;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.dataentity.BatchInsertTask;
import kd.bos.orm.dataentity.BatchUpdateTask;
import kd.bos.orm.dataentity.CRUDHelper;

public class BatchWithGroupUpdateTask
extends BatchUpdateTask {
    private static final Log log = LogFactory.getLog(BatchWithGroupUpdateTask.class);
    private DbMetadataTable table;
    private String groupName;

    public BatchWithGroupUpdateTask(DbMetadataTable table, String groupName, DBRoute dbRoute, String tableNameWithGroup, DbMetadataColumn[] columns, List<Object[]> rows, List<IColumnValuePair> oids, DbMetadataColumn primaryKey, List<Object> ids, List<ISaveMetaRow> saveRows, int level) {
        super(dbRoute, tableNameWithGroup, columns, rows, oids, primaryKey, ids, saveRows, level);
        this.table = table;
        this.groupName = groupName;
    }

    @Override
    protected void analyseUpdateResult(int[] result, List<Object[]> rows) {
        int columnIndex;
        super.analyseUpdateResult(result, rows);
        if (result == null || result.length == 0) {
            return;
        }
        if (result[0] == result.length) {
            return;
        }
        ArrayList<Integer> failedRowIndexs = new ArrayList<Integer>(10);
        for (int i = 0; i < result.length; ++i) {
            if (result[i] != 0) continue;
            failedRowIndexs.add(i);
        }
        if (failedRowIndexs.isEmpty()) {
            return;
        }
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select ", new Object[0]).append(this.primaryKey.getName(), new Object[0]).append(" from ", new Object[0]).append(CRUDHelper.getTableNameWithGroup(this.table.getName(), this.groupName), new Object[0]).append(" where ", new Object[0]).appendIn(this.primaryKey.getName(), this.ids.toArray());
        List existsIds = (List)DB.query((DBRoute)this.dbRoute, (SqlBuilder)querySql, rs -> {
            ArrayList<String> objs = new ArrayList<String>(10);
            while (rs.next()) {
                objs.add(String.valueOf(rs.getObject(this.primaryKey.getName())));
            }
            return objs;
        });
        DbMetadataColumn parentRelationCol = null;
        DbMetadataColumn primaryColumn = this.table.getPrimaryKey();
        if (CRUDHelper.getExTableHaveRelitionField() && this.table.getParentRelation() != null) {
            parentRelationCol = this.table.getParentRelation().getChildColumn();
        }
        for (DbMetadataColumn col : this.columns) {
            if (!StringUtils.equals((CharSequence)col.getName(), (CharSequence)primaryColumn.getName()) && (parentRelationCol == null || !StringUtils.equals((CharSequence)col.getName(), (CharSequence)parentRelationCol.getName()))) continue;
            log.error("exist primaryColumn or parentRelationColumn,ignore analyseUpdateResult.");
            return;
        }
        int appendColLength = parentRelationCol == null ? 1 : 2;
        DbMetadataColumn[] insertColumns = new DbMetadataColumn[this.columns.length + appendColLength];
        for (columnIndex = 0; columnIndex < this.columns.length; ++columnIndex) {
            DbMetadataColumn oriColumns = this.columns[columnIndex];
            insertColumns[columnIndex] = oriColumns.clone(oriColumns.getName(), oriColumns.getEnableNull());
            insertColumns[columnIndex].setColumnIndex(columnIndex);
        }
        if (appendColLength == 1) {
            insertColumns[columnIndex] = primaryColumn.clone(primaryColumn.getName(), primaryColumn.getEnableNull());
            insertColumns[columnIndex].setColumnIndex(columnIndex);
        } else if (appendColLength == 2) {
            insertColumns[columnIndex] = parentRelationCol.clone(parentRelationCol.getName(), parentRelationCol.getEnableNull());
            insertColumns[columnIndex].setColumnIndex(columnIndex);
            insertColumns[++columnIndex] = primaryColumn.clone(primaryColumn.getName(), primaryColumn.getEnableNull());
            insertColumns[columnIndex].setColumnIndex(columnIndex);
        }
        ArrayList<Object[]> insertRows = new ArrayList<Object[]>(this.saveRows.size());
        ArrayList<IColumnValuePair> insertOids = new ArrayList<IColumnValuePair>(this.oids.size());
        Iterator iterator = failedRowIndexs.iterator();
        while (iterator.hasNext()) {
            String idStr;
            int rowIndex = (Integer)iterator.next();
            if (!existsIds.isEmpty() && existsIds.contains(idStr = String.valueOf(this.ids.get(rowIndex)))) continue;
            Object[] rowDatas = rows.get(rowIndex);
            Object[] repairRowDatas = new Object[insertColumns.length];
            int index = 0;
            for (DbMetadataColumn dirtyCol : this.columns) {
                repairRowDatas[index++] = rowDatas[dirtyCol.getColumnIndex()];
            }
            if (appendColLength == 1) {
                repairRowDatas[index] = this.ids.get(rowIndex);
            } else if (appendColLength == 2) {
                repairRowDatas[index++] = ((ISaveMetaRow)this.saveRows.get(rowIndex)).getParentOid().getValue();
                repairRowDatas[index] = this.ids.get(rowIndex);
            }
            insertOids.add((IColumnValuePair)this.oids.get(rowIndex));
            insertRows.add(repairRowDatas);
        }
        if (!insertOids.isEmpty()) {
            BatchInsertTask repaireTask = new BatchInsertTask(this.dbRoute, this.tableName, insertColumns, this.getLevel(), insertRows, insertOids);
            repaireTask.execute();
        }
    }
}

