/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DataEntityCollection;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ISupportInitialize;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.dataentity.FieldReaders;
import kd.bos.orm.dataentity.IFieldReader;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class DynamicObjectResultSetCallback<T>
implements ResultSetHandler<List<T>> {
    private IDataEntityType dt;

    public DynamicObjectResultSetCallback() {
    }

    public DynamicObjectResultSetCallback(IDataEntityType dt) {
        this.dt = dt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<T> handle(ResultSet rs) throws Exception {
        try (TraceSpan ts = Tracer.create((String)this.getClass().getSimpleName(), (String)"handle");){
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            int fieldCount = resultSetMetaData.getColumnCount();
            RefObject refProperties = new RefObject();
            if (this.dt == null) {
                this.dt = DynamicObjectResultSetCallback.createDtFromDb(resultSetMetaData, (RefObject<ConverterPair[]>)refProperties);
            } else {
                refProperties.argvalue = this.getConverters(resultSetMetaData, this.dt);
            }
            Object col = this.dt instanceof DynamicObjectType ? new DynamicObjectCollection((DynamicObjectType)this.dt, null) : new DataEntityCollection();
            ConverterPair[] converterPairs = (ConverterPair[])refProperties.argvalue;
            ((ISupportInitialize)col).beginInit();
            while (rs.next()) {
                Object obj = this.dt.createInstance();
                ISupportInitialize si = (ISupportInitialize)(obj instanceof ISupportInitialize ? obj : null);
                if (si != null) {
                    si.beginInit();
                }
                for (int i = 1; i <= fieldCount; ++i) {
                    ConverterPair pair = converterPairs[i - 1];
                    Object value = pair.get(rs, i);
                    if (value == null) continue;
                    pair.property.setValueFast(obj, value);
                }
                if (si != null) {
                    si.endInit();
                }
                col.add(obj);
            }
            ((ISupportInitialize)col).endInit();
            DataEntityCollection dataEntityCollection = col;
            return dataEntityCollection;
        }
        catch (SQLException e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
        }
    }

    private static IDataEntityType createDtFromDb(ResultSetMetaData resultSetMetaData, RefObject<ConverterPair[]> refProperties) {
        DynamicObjectType dt = new DynamicObjectType("tempObject");
        try {
            int fieldCount = resultSetMetaData.getColumnCount();
            refProperties.argvalue = new ConverterPair[fieldCount];
            for (int i = 1; i <= fieldCount; ++i) {
                String fieldName = resultSetMetaData.getColumnName(i);
                if (fieldName.isEmpty() || dt.getProperties().containsKey((Object)fieldName)) {
                    fieldName = "Property" + i;
                }
                Class<Object> propertyType = null;
                if (BigDecimal.class.getName().equals(resultSetMetaData.getColumnClassName(i)) && resultSetMetaData.getScale(i) == 0) {
                    propertyType = Long.class;
                } else {
                    propertyType = Class.forName(resultSetMetaData.getColumnClassName(i));
                    if (Clob.class.isAssignableFrom(propertyType)) {
                        propertyType = String.class;
                    }
                }
                DynamicSimpleProperty property = new DynamicSimpleProperty(fieldName, propertyType, null);
                ISimpleProperty sp = (ISimpleProperty)dt.registerSimpleProperty(property);
                ConverterPair pair = new ConverterPair();
                pair.property = sp;
                pair.fieldReader = FieldReaders.get(sp.getPropertyType());
                ((ConverterPair[])refProperties.argvalue)[i - 1] = pair;
            }
            return dt;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
        }
    }

    private ConverterPair[] getConverters(ResultSetMetaData resultSetMetaData, IDataEntityType dt) {
        HashMap<String, ISimpleProperty> propertyMap = new HashMap<String, ISimpleProperty>(dt.getProperties().size());
        for (ISimpleProperty property : dt.getProperties().getSimpleProperties(true)) {
            propertyMap.put(property.getName().toLowerCase(), property);
            String alias = property.getAlias();
            if (StringUtils.isBlank((CharSequence)alias)) continue;
            propertyMap.put(alias.toLowerCase(), property);
        }
        try {
            ISimpleProperty sp = null;
            int fieldCount = resultSetMetaData.getColumnCount();
            ConverterPair[] pairs = new ConverterPair[fieldCount];
            for (int i = 1; i <= fieldCount; ++i) {
                sp = (ISimpleProperty)propertyMap.get(resultSetMetaData.getColumnName(i).toLowerCase());
                ConverterPair pair = new ConverterPair();
                pair.property = sp;
                pair.fieldReader = FieldReaders.get(sp.getPropertyType());
                pairs[i - 1] = pair;
            }
            return pairs;
        }
        catch (SQLException e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
        }
    }

    private static final class ConverterPair {
        private ISimpleProperty property;
        private IFieldReader fieldReader;

        private ConverterPair() {
        }

        public Object get(ResultSet rs, int colIndex) {
            try {
                return this.fieldReader.get(rs, this.property.getDbType(), colIndex);
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{BosRes.get((String)"bos-ormengine", (String)"DynamicObjectResultSetCallback_0", (String)"\u5b57\u6bb5\u503c\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff0c\u5b57\u6bb5\u540d\uff1a%1$s\uff0c%2$s\u3002", (Object[])new Object[]{this.property.getName(), e.getMessage()})});
            }
        }
    }
}

