/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.orm.dataentity.IFieldReader;

class FieldReaders {
    private static final Map<Class<?>, IFieldReader> readers = new HashMap();

    FieldReaders() {
    }

    public static IFieldReader get(Class<?> clasz) {
        IFieldReader fieldreader = readers.get(clasz);
        if (fieldreader == null) {
            throw new RuntimeException(BosRes.get((String)"bos-ormengine", (String)"FieldReaders_0", (String)"\u4e0d\u652f\u6301\u8be5\u5c5e\u6027\u7c7b\u578b\uff1a%s\u3002", (Object[])new Object[]{clasz.getName()}));
        }
        return fieldreader;
    }

    static {
        IFieldReader shortFieldReader = new IFieldReader(){

            @Override
            public Object get(ResultSet rs, int dbType, int colIndex) throws SQLException {
                return rs.getShort(colIndex);
            }
        };
        readers.put(Short.TYPE, shortFieldReader);
        readers.put(Short.class, shortFieldReader);
        IFieldReader intFieldReader = new IFieldReader(){

            @Override
            public Object get(ResultSet rs, int dbType, int colIndex) throws SQLException {
                return rs.getInt(colIndex);
            }

            @Override
            public Object get(ResultSet rs, DbMetadataColumn column, int colIndex) throws SQLException {
                if (column.getEnableNull()) {
                    Object value = rs.getObject(colIndex);
                    if (value != null) {
                        if (value.toString().indexOf(".") >= 0) {
                            return Integer.valueOf(value.toString().substring(0, value.toString().indexOf(".")));
                        }
                        return Integer.valueOf(value.toString());
                    }
                    return null;
                }
                return rs.getInt(colIndex);
            }
        };
        readers.put(Integer.TYPE, intFieldReader);
        readers.put(Integer.class, intFieldReader);
        IFieldReader longFieldReader = new IFieldReader(){

            @Override
            public Object get(ResultSet rs, int dbType, int colIndex) throws SQLException {
                return rs.getLong(colIndex);
            }

            @Override
            public Object get(ResultSet rs, DbMetadataColumn column, int colIndex) throws SQLException {
                if (column.getEnableNull()) {
                    Object value = rs.getObject(colIndex);
                    if (value != null) {
                        if (value.toString().indexOf(".") >= 0) {
                            return Long.valueOf(value.toString().substring(0, value.toString().indexOf(".")));
                        }
                        return Long.valueOf(value.toString());
                    }
                    return null;
                }
                return rs.getLong(colIndex);
            }
        };
        readers.put(Long.TYPE, longFieldReader);
        readers.put(Long.class, longFieldReader);
        readers.put(String.class, new IFieldReader(){

            @Override
            public Object get(ResultSet rs, int dbType, int colIndex) throws SQLException {
                return rs.getString(colIndex);
            }
        });
        readers.put(ILocaleString.class, new IFieldReader(){

            @Override
            public Object get(ResultSet rs, int dbType, int colIndex) throws SQLException {
                return rs.getString(colIndex);
            }
        });
        IFieldReader boolFieldReader = new IFieldReader(){

            @Override
            public Object get(ResultSet rs, int dbType, int colIndex) throws SQLException {
                if (dbType == 1) {
                    return "1".equals(rs.getString(colIndex));
                }
                return rs.getBoolean(colIndex);
            }
        };
        readers.put(Boolean.TYPE, boolFieldReader);
        readers.put(Boolean.class, boolFieldReader);
        readers.put(BigDecimal.class, new IFieldReader(){

            @Override
            public Object get(ResultSet rs, int dbType, int colIndex) throws SQLException {
                return rs.getBigDecimal(colIndex);
            }
        });
        readers.put(Date.class, new IFieldReader(){

            @Override
            public Object get(ResultSet rs, int dbType, int colIndex) throws SQLException {
                return rs.getTimestamp(colIndex);
            }
        });
        readers.put(java.sql.Date.class, new IFieldReader(){

            @Override
            public Object get(ResultSet rs, int dbType, int colIndex) throws SQLException {
                return rs.getTimestamp(colIndex);
            }
        });
        readers.put(Timestamp.class, new IFieldReader(){

            @Override
            public Object get(ResultSet rs, int dbType, int colIndex) throws SQLException {
                return rs.getTimestamp(colIndex);
            }
        });
    }
}

