/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.ISaveDataTable;
import kd.bos.dataentity.metadata.ISaveMetaRow;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.RowOperateType;
import kd.bos.fulltext.BatchValue;
import kd.bos.fulltext.FullTextFactory;
import kd.bos.fulltext.FullTextUpdater;
import kd.bos.fulltext.MatchProperty;
import kd.bos.fulltext.PropertyValue;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.SaveDataSet;
import kd.bos.orm.query.fulltext.FullTextIndex;
import kd.bos.orm.query.fulltext.FullTextIndexQuery;
import kd.bos.orm.query.fulltext.FullTextIndexWriter;
import kd.bos.orm.query.fulltext.QFullTextQuery;

public class FullTextSync {
    private static Log logger = LogFactory.getLog(FullTextSync.class);

    private FullTextSync() {
    }

    private static boolean isFullTextEnable() {
        return QFullTextQuery.isFullTextEnable();
    }

    private static final FullTextUpdater fu() {
        return FullTextFactory.getFullTextUpdater();
    }

    public static void createFullIndexFields(Set<String> fieldsToCreateSet, IDataEntityType dataEntityType) {
        ArrayList<MatchProperty> matchProperties = new ArrayList<MatchProperty>();
        for (String field : fieldsToCreateSet) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)dataEntityType.getProperties().get((Object)field);
            if (iDataEntityProperty instanceof ILocaleProperty) {
                for (Lang lang : Lang.values()) {
                    MatchProperty matchProperty = lang == Lang.zh_CN ? new MatchProperty(field, lang, true) : new MatchProperty(field, lang, false);
                    matchProperties.add(matchProperty);
                }
                continue;
            }
            matchProperties.add(new MatchProperty(field, null, false));
        }
        FullTextSync.fu().addProperty(dataEntityType.getName(), matchProperties.toArray(new MatchProperty[0]));
    }

    protected static void delete(String entityName, Object[] pkIds) {
        FullTextSync.fu().delete(entityName, pkIds);
    }

    protected static void saveFullIndexs(SaveDataSet dataSet, IDataEntityType dataEntityType) {
        if (!FullTextSync.isFullTextEnable()) {
            return;
        }
        for (ISaveDataTable table : dataSet.getTables()) {
            Map fullIndexProperties = table.getSchema().getFullIndexProperties();
            if (fullIndexProperties.size() <= 0) continue;
            if (table.getSchema().isLocale()) {
                FullTextSync.saveLocaleFullIndex(fullIndexProperties, table);
                continue;
            }
            FullTextSync.saveFullIndex(fullIndexProperties, table, dataEntityType);
        }
    }

    private static void saveLocaleFullIndex(Map<String, ISimpleProperty> fullIndexProperties, ISaveDataTable table) {
        ArrayList<BatchValue> batchUpdateValues = new ArrayList<BatchValue>();
        ISaveMetaRow[] saveRows = table.getSaveRows();
        for (int i = 0; i < saveRows.length; ++i) {
            ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>(saveRows[i].getDirtyValues().size());
            for (IColumnValuePair vp : saveRows[i].getDirtyValues()) {
                ISimpleProperty property = fullIndexProperties.get(vp.getColumn().getName());
                if (property == null || vp.getValue() == null) continue;
                String locale = (String)saveRows[i].getLocale().getValue();
                propertyValues.add(new PropertyValue(property.getName(), Lang.from((String)locale), vp.getValue().toString(), "zh_CN".equals(locale)));
            }
            if (propertyValues.isEmpty()) continue;
            BatchValue bValue = new BatchValue(saveRows[i].getParentOid().getValue(), propertyValues.toArray(new PropertyValue[0]));
            batchUpdateValues.add(bValue);
        }
        if (!batchUpdateValues.isEmpty()) {
            FullTextSync.fu().update(table.getSchema().getFullIndexName(), batchUpdateValues.toArray(new BatchValue[0]));
        }
    }

    private static void saveFullIndex(Map<String, ISimpleProperty> fullIndexProperties, ISaveDataTable table, IDataEntityType dataEntityType) {
        ArrayList<BatchValue> batchUpdateValues = new ArrayList<BatchValue>();
        ArrayList<BatchValue> batchInsertValues = new ArrayList<BatchValue>();
        ArrayList<BatchValue> batchUpdateBillNoValues = new ArrayList<BatchValue>();
        ArrayList<BatchValue> batchInsertBillNoValues = new ArrayList<BatchValue>();
        ISaveMetaRow[] saveRows = table.getSaveRows();
        for (int i = 0; i < saveRows.length; ++i) {
            ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>(saveRows[i].getDirtyValues().size());
            for (IColumnValuePair vp : saveRows[i].getDirtyValues()) {
                ISimpleProperty property = fullIndexProperties.get(vp.getColumn().getName());
                if (property == null || vp.getValue() == null) continue;
                propertyValues.add(new PropertyValue(property.getName(), null, vp.getValue().toString(), false));
                if (!property.getName().equals(table.getSchema().getBillNo())) continue;
                ArrayList<PropertyValue> billNoPropertyValues = new ArrayList<PropertyValue>(16);
                billNoPropertyValues.add(new PropertyValue("billNo", null, (String)vp.getValue(), false));
                billNoPropertyValues.add(new PropertyValue("entityNumber", null, dataEntityType.getName(), false));
                for (Map.Entry dspEntry : dataEntityType.getDisplayName().entrySet()) {
                    billNoPropertyValues.add(new PropertyValue("billNoEntityName", Lang.from((String)((String)dspEntry.getKey())), (String)dspEntry.getValue(), "zh_CN".equals(dspEntry.getKey())));
                }
                BatchValue billNoBatchValue = new BatchValue(saveRows[i].getOid().getValue(), billNoPropertyValues.toArray(new PropertyValue[0]));
                if (saveRows[i].getOperate() == RowOperateType.Insert) {
                    batchInsertBillNoValues.add(billNoBatchValue);
                    continue;
                }
                batchUpdateBillNoValues.add(billNoBatchValue);
            }
            if (propertyValues.isEmpty()) continue;
            BatchValue bValue = new BatchValue(saveRows[i].getOid().getValue(), propertyValues.toArray(new PropertyValue[0]));
            if (saveRows[i].getOperate() == RowOperateType.Insert) {
                batchInsertValues.add(bValue);
                continue;
            }
            batchUpdateValues.add(bValue);
        }
        if (!batchInsertValues.isEmpty()) {
            FullTextSync.fu().insert(table.getSchema().getFullIndexName(), batchInsertValues.toArray(new BatchValue[0]));
        }
        if (!batchUpdateValues.isEmpty()) {
            FullTextSync.fu().update(table.getSchema().getFullIndexName(), batchUpdateValues.toArray(new BatchValue[0]));
        }
        if (!batchInsertBillNoValues.isEmpty()) {
            FullTextSync.fu().insert("all_billno", batchInsertBillNoValues.toArray(new BatchValue[0]));
        }
        if (!batchUpdateBillNoValues.isEmpty()) {
            FullTextSync.fu().update("all_billno", batchUpdateBillNoValues.toArray(new BatchValue[0]));
        }
        if (table.getDeleteRows() != null) {
            Object[] oids = new Object[table.getDeleteRows().length];
            for (int i = 0; i < table.getDeleteRows().length; ++i) {
                oids[i] = table.getDeleteRows()[i].getOid();
            }
            if (oids.length > 0) {
                FullTextSync.fu().delete(table.getSchema().getFullIndexName(), oids);
            }
        }
    }

    protected static boolean isAllBillNoIndexCreated() {
        FullTextIndexQuery fullTextIndexQuery = new FullTextIndexQuery();
        return fullTextIndexQuery.isFullTextIndexesExist();
    }

    public static void createAllBillNoIndex() {
        StringBuilder errorMessage = new StringBuilder();
        FullTextIndexWriter fullTextIndexWriter = new FullTextIndexWriter();
        FullTextIndex fullTextIndex = new FullTextIndex("all_billno", "billno,billnoentityname,entitynumber");
        fullTextIndex.setSyncTime(new Date());
        if (fullTextIndexWriter.saveFullTextIndex(fullTextIndex, errorMessage)) {
            ArrayList<MatchProperty> billNoMatchProperties = new ArrayList<MatchProperty>(3);
            MatchProperty billNoMatchProperty = new MatchProperty("billno", null, false);
            MatchProperty entityNumberMatchProperty = new MatchProperty("entitynumber", null, false);
            billNoMatchProperties.add(billNoMatchProperty);
            billNoMatchProperties.add(entityNumberMatchProperty);
            for (Lang lang : Lang.values()) {
                MatchProperty nameMatchProperty = lang == Lang.zh_CN ? new MatchProperty("billnoentityname", lang, true) : new MatchProperty("billnoentityname", lang, false);
                billNoMatchProperties.add(nameMatchProperty);
            }
            FullTextSync.fu().addProperty("all_billno", billNoMatchProperties.toArray(new MatchProperty[0]));
        }
        logger.error(String.format("\u5168\u6587\u7d22\u5f15all_billno\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25:%s", errorMessage.toString()));
    }

    static {
        if (!FullTextSync.isAllBillNoIndexCreated()) {
            FullTextSync.createAllBillNoIndex();
        }
    }
}

