/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.dataentity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISaveMetaRow;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.datamanager.ParentOidColumnValuePair;
import kd.bos.orm.datamanager.SyncColumnValuePair;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.util.ArrayUtil;

public final class ShardingHinter {
    public static void todo() {
    }

    public static void todoTest() {
    }

    public static boolean isSharding(String tableName) {
        return DB.isSharded((String)tableName);
    }

    public static boolean isMainTable(String tableName) {
        return XDBConfig.getShardingConfigProvider().getConfig(tableName) instanceof MainTableConfig;
    }

    public static ShardingHintContext tryHint(IDataEntityType dt, Object[] pks) {
        String hintTable = dt.getAlias();
        if (pks.length > 0 && ShardingHinter.isSharding(hintTable) && ShardingHintContext.canHintNestedIfExistsGroupHintTable((String)hintTable)) {
            if (pks.length == 1) {
                return ShardingHintContext.create((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition(dt.getPrimaryKey().getAlias(), FilterType.eq, pks[0])});
            }
            return ShardingHintContext.create((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition(dt.getPrimaryKey().getAlias(), FilterType.in_range, (Object)pks)});
        }
        return null;
    }

    public static ShardingHintContext tryHint(DbMetadataTable rootTable, Object[] pks) {
        String hintTable = rootTable.getName();
        if (ShardingHinter.isSharding(hintTable) && ShardingHintContext.canHintNestedIfExistsGroupHintTable((String)hintTable)) {
            if (pks.length == 1) {
                return ShardingHintContext.create((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition(rootTable.getPrimaryKey().getName(), FilterType.eq, pks[0])});
            }
            return ShardingHintContext.create((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition(rootTable.getPrimaryKey().getName(), FilterType.in_range, (Object)pks)});
        }
        return null;
    }

    public static ShardingHintContext tryHint(String hintTable, String pkField, List<Object> pkIdList) {
        if (!pkIdList.isEmpty() && ShardingHinter.isSharding(hintTable) && ShardingHintContext.canHintNestedIfExistsGroupHintTable((String)hintTable)) {
            if (pkIdList.size() == 1) {
                return ShardingHintContext.create((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition(pkField, FilterType.eq, pkIdList.get(0))});
            }
            return ShardingHintContext.create((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition(pkField, FilterType.in_range, pkIdList)});
        }
        return null;
    }

    public static ShardingHintContext tryHint(String hintTable, ISaveMetaRow ... saveRows) {
        if (ShardingHinter.isSharding(hintTable) && ShardingHintContext.canHintNestedIfExistsGroupHintTable((String)hintTable)) {
            HashSet<Object> rootId = new HashSet<Object>(4);
            String pkField = null;
            AtomicReference<String> parentPKNameRef = new AtomicReference<String>();
            for (ISaveMetaRow row : saveRows) {
                DynamicObject entity = ShardingHinter.getMainEntity(row.getOid(), parentPKNameRef);
                if (entity == null) {
                    return null;
                }
                rootId.add(entity.getPkValue());
                if (pkField != null) continue;
                hintTable = entity.getDataEntityType().getAlias();
                pkField = entity.getDataEntityType().getPrimaryKey().getAlias();
            }
            if (rootId.isEmpty()) {
                return null;
            }
            if (rootId.size() == 1) {
                return ShardingHintContext.create((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition(pkField, FilterType.eq, rootId.iterator().next())});
            }
            return ShardingHintContext.create((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition(pkField, FilterType.in_range, rootId)});
        }
        return null;
    }

    public static ShardingHintContext tryHint(IColumnValuePair pp) {
        DynamicObject entity = ShardingHinter.getMainEntity(pp, null);
        if (entity == null) {
            return null;
        }
        String hintTable = entity.getDataEntityType().getAlias();
        if (ShardingHinter.isSharding(hintTable) && ShardingHintContext.canHintNestedIfExistsGroupHintTable((String)hintTable)) {
            return ShardingHintContext.create((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition(entity.getDataEntityType().getPrimaryKey().getAlias(), FilterType.eq, entity.getPkValue())});
        }
        return null;
    }

    public static DynamicObject getMainEntity(IColumnValuePair pp, AtomicReference<String> parentPKNameRef) {
        DynamicObject entity = null;
        if (pp instanceof SyncColumnValuePair) {
            entity = ((SyncColumnValuePair)pp).getDataEntity();
        } else if (pp instanceof ParentOidColumnValuePair) {
            entity = ((ParentOidColumnValuePair)pp).getDataEntity();
        }
        if (entity != null) {
            while (entity.getParent() != null) {
                entity = (DynamicObject)entity.getParent();
            }
        }
        if (entity == null) {
            return null;
        }
        IDataEntityType dt = entity.getDataEntityType();
        if (dt.getParent() == null) {
            return entity;
        }
        if (dt.getParent() != null && dt.getParent().getParent() == null) {
            Object parentId;
            String parentPKName;
            String string = parentPKName = parentPKNameRef == null ? null : parentPKNameRef.get();
            if (parentPKName == null) {
                String pkField = dt.getParent().getPrimaryKey().getAlias().toLowerCase();
                for (IDataEntityProperty dp : dt.getProperties()) {
                    if (dp.getAlias() == null || !pkField.equals(dp.getAlias().toLowerCase())) continue;
                    parentPKName = dp.getName();
                    if (parentPKNameRef == null) break;
                    parentPKNameRef.set(parentPKName);
                    break;
                }
                if (parentPKName == null) {
                    return null;
                }
            }
            if ((parentId = entity.get(parentPKName)) != null) {
                return new DynamicObject((DynamicObjectType)dt.getParent(), parentId);
            }
        }
        return null;
    }

    public static Map<Object, Long> queryShardingIndex(DBRoute dbRoute, String tableName, List<Object> noCachePKs) {
        HashMap<Object, Long> ret = new HashMap<Object, Long>();
        if (ShardingHinter.isMainTable(tableName)) {
            for (Object[] segpks : ArrayUtil.split((Object[])noCachePKs.toArray(), (int)XDBConfig.get().getQueryIndexBatchSize())) {
                StringBuilder sql = new StringBuilder();
                sql.append(NoShardingHint.genNoShardingSQL((String)("select fpk,findex from " + TableName.of((String)tableName).getPKTable() + " where fpk ")));
                StringBuilder inParam = new StringBuilder(segpks.length * 2);
                for (int i = 0; i < segpks.length; ++i) {
                    if (i > 0) {
                        inParam.append(',');
                    }
                    inParam.append('?');
                }
                sql.append(" in(");
                sql.append((CharSequence)inParam);
                sql.append(')');
                DB.query((DBRoute)dbRoute, (String)sql.toString(), (Object[])segpks, rs -> {
                    Object key;
                    boolean longType = false;
                    if (rs.next() && (key = rs.getObject(1)) instanceof Number) {
                        ret.put(rs.getLong(1), rs.getLong(2));
                        longType = true;
                    }
                    if (longType) {
                        while (rs.next()) {
                            ret.put(rs.getLong(1), rs.getLong(2));
                        }
                    } else {
                        while (rs.next()) {
                            ret.put(rs.getObject(1), rs.getLong(2));
                        }
                    }
                    return ret;
                });
            }
        }
        return ret;
    }
}

