/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datamanager;

import java.util.Iterator;

public final class ArrayBatchEnumerable
implements Iterable<Object[]> {
    private Object[] _idsArray;
    private int _batchSize;

    public ArrayBatchEnumerable(Object[] idsArray, int batchSize) {
        this._idsArray = idsArray;
        this._batchSize = batchSize;
    }

    @Override
    public Iterator<Object[]> iterator() {
        return new ArrayBatchEnumerator(this);
    }

    private static final class ArrayBatchEnumerator
    implements Iterator<Object[]>,
    Cloneable {
        private ArrayBatchEnumerable _owner;
        private int _pageIndex;

        public ArrayBatchEnumerator(ArrayBatchEnumerable arrayBatchEnumerable) {
            this._owner = arrayBatchEnumerable;
            this._pageIndex = 0;
        }

        public ArrayBatchEnumerator clone() {
            ArrayBatchEnumerator varCopy = new ArrayBatchEnumerator(this._owner);
            varCopy._pageIndex = this._pageIndex;
            return varCopy;
        }

        @Override
        public boolean hasNext() {
            int leftIndex = this._pageIndex * this._owner._batchSize;
            return leftIndex < this._owner._idsArray.length;
        }

        @Override
        public Object[] next() {
            int leftIndex = this._pageIndex * this._owner._batchSize;
            int rightIndex = (this._pageIndex + 1) * this._owner._batchSize;
            if (leftIndex < this._owner._idsArray.length) {
                if (rightIndex >= this._owner._idsArray.length) {
                    rightIndex = this._owner._idsArray.length;
                }
                int len = rightIndex - leftIndex;
                Object[] result = new Object[len];
                System.arraycopy(this._owner._idsArray, leftIndex, result, 0, len);
                ++this._pageIndex;
                return result;
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

