/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datamanager;

import java.util.Iterator;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.IFunction;
import kd.bos.dataentity.exception.ORMDesignException;

public final class BatchOrmAction<DataT, OidT>
implements Iterable<DataT> {
    private Iterable<OidT[]> _batchIds;
    private IFunction<OidT[], DataT[]> _func;
    private boolean _notFirstGet = false;

    public BatchOrmAction(Iterable<OidT[]> batchIds, IFunction<OidT[], DataT[]> func) {
        this._batchIds = batchIds;
        this._func = func;
    }

    @Override
    public Iterator<DataT> iterator() {
        if (this._notFirstGet) {
            throw new ORMDesignException("??????", BosRes.get((String)"bos-ormengine", (String)"BatchOrmAction_0", (String)"\u5bf9\u4e8e\u5927\u6279\u91cf\u6570\u636e\u7684\u64cd\u4f5c\uff0c\u4e0d\u652f\u6301\u5bf9\u7ed3\u679c\u7684\u591a\u6b21\u679a\u4e3e(ForEach\u64cd\u4f5c)\uff0c\u56e0\u4e3a\u8fd9\u6837\u4f1a\u9020\u6210\u91cd\u590d\u7684\u6570\u636e\u5e93\u64cd\u4f5c\uff0c\u8003\u8651\u4f18\u5316\u60a8\u7684\u7a0b\u5e8f\u4ee5\u907f\u514d\u591a\u6b21\u679a\u4e3e", (Object[])new Object[0]));
        }
        this._notFirstGet = true;
        return new BatchOrmEnumerator(this, this._func);
    }

    private static class BatchOrmEnumerator<DataT, OidT>
    implements Iterator<DataT> {
        private DataT _current;
        private Iterator<OidT[]> _enumerator;
        private DataT[] _currentValues;
        private int _currentIndex;
        private boolean _moveNextValue;
        private IFunction<OidT[], DataT[]> _func;

        public BatchOrmEnumerator(BatchOrmAction<DataT, OidT> batchOrmAction, IFunction<OidT[], DataT[]> func) {
            this._enumerator = ((BatchOrmAction)batchOrmAction)._batchIds.iterator();
            this._current = null;
            this._currentIndex = 0;
            this._moveNextValue = true;
            this._func = func;
        }

        @Override
        public boolean hasNext() {
            return this._moveNextValue;
        }

        @Override
        public DataT next() {
            if (!this._moveNextValue) {
                return null;
            }
            while (this._currentValues == null || this._currentIndex >= this._currentValues.length) {
                this._moveNextValue = this.GetNextResult();
                if (this._moveNextValue) {
                    if (this._currentIndex >= this._currentValues.length) continue;
                    break;
                }
                return null;
            }
            this._current = this._currentValues[this._currentIndex];
            ++this._currentIndex;
            return this._current;
        }

        private boolean GetNextResult() {
            boolean isOK = this._enumerator.hasNext();
            if (isOK) {
                this._currentValues = (Object[])this._func.apply(this._enumerator.next());
                this._currentIndex = 0;
            } else {
                this._currentValues = null;
                this._currentIndex = 0;
                this._current = null;
            }
            return isOK;
        }

        @Override
        public void remove() {
            this._enumerator.remove();
        }
    }
}

