/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datamanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.entity.DataEntityReference;
import kd.bos.dataentity.entity.DataEntityReferenceList;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.DataEntityCacheType;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.datamanager.LoadReferenceObjectManager;
import kd.bos.orm.datamanager.ReadRefCacheLog;
import kd.bos.orm.datamanager.RefCacheLimitFlow;
import kd.bos.orm.datamanager.refstrategy.BasedataRefShareFactory;
import kd.bos.orm.datamanager.refstrategy.BasedataRefShareStrategy;
import kd.bos.util.ThreadLocals;

public class CachedLoadReferenceObjectManager
extends LoadReferenceObjectManager {
    private static Log logger = LogFactory.getLog(CachedLoadReferenceObjectManager.class);
    private static ThreadLocal<Boolean> disabledRefCache = ThreadLocals.create(() -> Boolean.FALSE);

    public CachedLoadReferenceObjectManager(IDataEntityType dt, boolean onlyDbProperty) {
        super(dt, onlyDbProperty);
    }

    public static void disableRefBasedataCache(boolean disable) {
        disabledRefCache.set(disable);
    }

    @Override
    protected Object[] Read(IDataEntityType dt, Object[] oids) {
        if (this.disabledCache(dt, oids)) {
            return this.readDataInReference(dt, oids);
        }
        IDataEntityType cacheDT = dt;
        long time = System.currentTimeMillis();
        if (this.isShareCache(dt)) {
            ReadRefCacheLog.info("CachedLoadReferenceObjectManager\uff1aread isShareCache() time {}", System.currentTimeMillis() - time);
            cacheDT = this.getRefShareStrategy().getShareRefDT(dt);
        }
        time = System.currentTimeMillis();
        Object[] dataEntities = this.readDataInReference(cacheDT, oids);
        ReadRefCacheLog.info("CachedLoadReferenceObjectManager\uff1aread reference share {}: size {}, time {}", dt.getName(), oids.length, System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        this.putCache(cacheDT, oids, dataEntities);
        ReadRefCacheLog.info("CachedLoadReferenceObjectManager\uff1aput share cache {}: size {}, time {}", dt.getName(), oids.length, System.currentTimeMillis() - time);
        if (dt.getExtendName().equals(cacheDT.getExtendName())) {
            return dataEntities;
        }
        time = System.currentTimeMillis();
        Object[] newDataEntities = new DynamicObject[dataEntities.length];
        for (int i = 0; i < newDataEntities.length; ++i) {
            DynamicObject obj = (DynamicObject)dataEntities[i];
            DynamicObject newObj = (DynamicObject)dt.createInstance();
            newObj.beginInit();
            for (IDataEntityProperty prop : dt.getProperties()) {
                try {
                    prop.setValueFast((Object)newObj, prop.getValue((Object)obj));
                }
                catch (Exception e) {
                    HashMap<String, String> tags = new HashMap<String, String>(2);
                    tags.put("PROP", prop.toPlainString());
                    tags.put("DT", dt.toPlainString());
                    tags.put("OBJ", (String)obj);
                    EntityTracer.throwException((String)"CachedLoadReferenceObjectManager", (String)"Read", null, (Throwable)e, tags);
                    throw e;
                }
            }
            newObj.endInit();
            newDataEntities[i] = newObj;
        }
        ReadRefCacheLog.info("CachedLoadReferenceObjectManager\uff1aload {}({}) ref share convert time:{}", dt.getName(), newDataEntities.length, System.currentTimeMillis() - time);
        return newDataEntities;
    }

    private boolean disabledCache(IDataEntityType dt, Object[] oids) {
        if (Boolean.TRUE == disabledRefCache.get()) {
            return true;
        }
        RefCacheLimitFlow limitFlow = new RefCacheLimitFlow();
        return limitFlow.isCacheFlowControl(dt, oids);
    }

    @Override
    protected Collection<DataEntityReferenceList> GetTasks(Object[] dataEntities) {
        Collection<DataEntityReferenceList> tasks = super.GetTasks(dataEntities);
        for (DataEntityReferenceList task : tasks) {
            if (this.isShareCache(task.getDataEntityType())) {
                this.doTaskFromCacheWithShare(task);
                continue;
            }
            this.doTaskFromCache(task);
        }
        return tasks;
    }

    private void doTaskFromCache(DataEntityReferenceList task) {
        DynamicObject o;
        ArrayList<DynamicObject> fromCacheObjects = new ArrayList<DynamicObject>(task.size());
        HashSet<Object> pkids = new HashSet<Object>(task.size());
        for (DataEntityReference item : task) {
            pkids.add(item.getOid());
        }
        boolean bShare = task.getDataEntityType().getCacheType() == DataEntityCacheType.Share;
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(task.getDataEntityType());
        Map<Object, Object> cacheMap = cacheManager.get(pkids.toArray());
        ReadRefCacheLog.readTypeStatistics(task);
        for (DataEntityReference item : task) {
            DynamicObject dataEntity = (DynamicObject)cacheMap.get(item.getOid());
            if (dataEntity != null) {
                if (bShare) {
                    item.setDataEntity((Object)dataEntity);
                } else {
                    DynamicObjectType dt = (DynamicObjectType)task.getDataEntityType();
                    DynamicObject newobj = new DynamicObject(dt);
                    for (IDataEntityProperty prop : cacheManager.getDataEntityType().getProperties()) {
                        Object val = prop.getValue(item.getDataEntity());
                        prop.setValue((Object)newobj, val);
                    }
                    item.setDataEntity((Object)newobj);
                    fromCacheObjects.add(newobj);
                }
                fromCacheObjects.add(dataEntity);
                continue;
            }
            if (!cacheManager.isNotExistPK(item.getOid())) continue;
            item.setDataEntity(null);
        }
        CachedLoadReferenceObjectManager manager = new CachedLoadReferenceObjectManager(cacheManager.getDataEntityType(), super.getOnlyDbProperty());
        Object[] cacheObjects = fromCacheObjects.toArray();
        if (Boolean.getBoolean("QueryOrmError") && cacheObjects.length > 0 && cacheObjects[0] instanceof DynamicObject && (o = (DynamicObject)cacheObjects[0]).getDataEntityType() != cacheManager.getDataEntityType()) {
            String error = BosRes.get((String)"bos-ormengine", (String)"CachedLoadReferenceObjectManager_0", (String)"\u7f13\u5b58\u4e2d\u5bf9\u8c61\u5c5e\u6027\u4e3a\uff1a{0}", (Object[])new Object[]{o.getDataEntityType().getName() + o.getDataEntityType().getExtendName() + this.getPropertiesString(o.getDataEntityType())});
            error = error + BosRes.get((String)"bos-ormengine", (String)"CachedLoadReferenceObjectManager_1", (String)"\u7f13\u5b58\u7ba1\u7406\u7684\u5bf9\u8c61\u5c5e\u6027\uff1a{0}", (Object[])new Object[]{cacheManager.getDataEntityType().getName() + cacheManager.getDataEntityType().getExtendName() + this.getPropertiesString(cacheManager.getDataEntityType())});
            throw new RuntimeException(error);
        }
        manager.Load(cacheObjects);
    }

    private void doTaskFromCacheWithShare(DataEntityReferenceList task) {
        DynamicObject o;
        DynamicObjectType det = (DynamicObjectType)task.getDataEntityType();
        IDataEntityType shareDt = this.getShareRefDT((IDataEntityType)det);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(shareDt);
        ArrayList<DynamicObject> fromCacheObjects = new ArrayList<DynamicObject>(task.size());
        HashSet<Object> pkids = new HashSet<Object>(task.size());
        for (DataEntityReference item : task) {
            pkids.add(item.getOid());
        }
        Map<Object, Object> cacheMap = cacheManager.get(pkids.toArray());
        ReadRefCacheLog.readTypeStatistics(task);
        boolean bShare = det.getCacheType() == DataEntityCacheType.Share;
        for (DataEntityReference item : task) {
            DynamicObject dataEntity = (DynamicObject)cacheMap.get(item.getOid());
            if (dataEntity != null) {
                DynamicObject newobj;
                if (bShare) {
                    if (det.equals((Object)shareDt)) {
                        item.setDataEntity((Object)dataEntity);
                        fromCacheObjects.add(dataEntity);
                        continue;
                    }
                    newobj = new DynamicObject(det);
                    for (IDataEntityProperty prop : det.getProperties()) {
                        IDataEntityProperty shareProp = (IDataEntityProperty)shareDt.getProperties().get((Object)prop.getName());
                        Object val = shareProp.getValue((Object)dataEntity);
                        prop.setValue((Object)newobj, val);
                    }
                    this.copyState(dataEntity, newobj);
                    item.setDataEntity((Object)newobj);
                    fromCacheObjects.add(newobj);
                    continue;
                }
                newobj = new DynamicObject(det);
                for (IDataEntityProperty prop : det.getProperties()) {
                    Object val = prop.getValue(item.getDataEntity());
                    prop.setValue((Object)newobj, val);
                }
                item.setDataEntity((Object)newobj);
                fromCacheObjects.add(newobj);
                continue;
            }
            if (!cacheManager.isNotExistPK(item.getOid())) continue;
            item.setDataEntity(null);
        }
        CachedLoadReferenceObjectManager manager = new CachedLoadReferenceObjectManager(cacheManager.getDataEntityType(), super.getOnlyDbProperty());
        Object[] cacheObjects = fromCacheObjects.toArray();
        if (Boolean.getBoolean("QueryOrmError") && cacheObjects.length > 0 && cacheObjects[0] instanceof DynamicObject && (o = (DynamicObject)cacheObjects[0]).getDataEntityType() != cacheManager.getDataEntityType()) {
            String error = BosRes.get((String)"bos-ormengine", (String)"CachedLoadReferenceObjectManager_0", (String)"\u7f13\u5b58\u4e2d\u5bf9\u8c61\u5c5e\u6027\u4e3a\uff1a{0}", (Object[])new Object[]{o.getDataEntityType().getName() + o.getDataEntityType().getExtendName() + this.getPropertiesString(o.getDataEntityType())});
            error = error + BosRes.get((String)"bos-ormengine", (String)"CachedLoadReferenceObjectManager_1", (String)"\u7f13\u5b58\u7ba1\u7406\u7684\u5bf9\u8c61\u5c5e\u6027\uff1a{0}", (Object[])new Object[]{cacheManager.getDataEntityType().getName() + cacheManager.getDataEntityType().getExtendName() + this.getPropertiesString(cacheManager.getDataEntityType())});
            throw new RuntimeException(error);
        }
        manager.Load(cacheObjects);
    }

    private void copyState(DynamicObject dataEntity, DynamicObject newobj) {
        DataEntityState oldState = dataEntity.getDataEntityState();
        PkSnapshotSet oldSet = oldState.getPkSnapshotSet();
        DataEntityState newState = newobj.getDataEntityState();
        newState.setFromDatabase(oldState.getFromDatabase());
        PkSnapshotSet set = new PkSnapshotSet();
        set.Snapshots = new ArrayList(oldSet.Snapshots.size());
        for (PkSnapshot oPKSnap : oldSet.Snapshots) {
            PkSnapshot snap = new PkSnapshot();
            snap.TableName = oPKSnap.TableName;
            if (oPKSnap.Oids != null) {
                snap.Oids = Arrays.copyOf(oPKSnap.Oids, oPKSnap.Oids.length);
            }
            if (oPKSnap.Opids != null) {
                snap.Opids = Arrays.copyOf(oPKSnap.Opids, oPKSnap.Opids.length);
            }
            set.Snapshots.add(snap);
        }
        newState.setPkSnapshotSet(set);
    }

    private String getPropertiesString(IDataEntityType type) {
        StringBuilder sb = new StringBuilder();
        for (IDataEntityProperty p : type.getProperties()) {
            sb.append(p.getName()).append(',');
        }
        return sb.toString();
    }

    private Object[] readDataInReference(IDataEntityType dt, Object[] oids) {
        Object[] dataEntities = super.Read(dt, oids);
        CachedLoadReferenceObjectManager manager = new CachedLoadReferenceObjectManager(dt, false);
        manager.Load(dataEntities);
        return dataEntities;
    }

    private IDataEntityType getShareRefDT(IDataEntityType dt) {
        return this.getRefShareStrategy().getShareRefDT(dt);
    }

    private void putCache(IDataEntityType dt, Object[] oids, Object[] dataEntities) {
        ISimpleProperty pk = dt.getPrimaryKey();
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(dt);
        if (pk != null && dataEntities.length > 0) {
            cacheManager.put(dataEntities);
        }
        if (oids != null && oids.length > dataEntities.length) {
            cacheManager.putNotExistPKs(oids, dataEntities);
        }
    }

    private boolean isShareCache(IDataEntityType dt) {
        if (this.getRefShareStrategy().getClass().getName().equals("kd.bos.orm.datamanager.refstrategy.DefaultRefShareStrategy")) {
            return false;
        }
        IDataEntityType shareDT = this.getShareRefDT(dt);
        DataEntityPropertyCollection props = shareDT.getProperties();
        if (props.size() < dt.getProperties().size()) {
            ReadRefCacheLog.info("CachedLoadReferenceObjectManager-shareCache: cachetype miss hit,cachedt={}, dt={}.", shareDT.getExtendName(), dt.getExtendName());
            return false;
        }
        if (!this.containsAll(props, dt.getProperties())) {
            ReadRefCacheLog.info("CachedLoadReferenceObjectManager-shareCache: cachetype miss hit,cachedt={}, dt={}.", shareDT.getExtendName(), dt.getExtendName());
            return false;
        }
        return true;
    }

    private BasedataRefShareStrategy getRefShareStrategy() {
        return BasedataRefShareFactory.createRefShareStrategy();
    }

    private boolean containsAll(DataEntityPropertyCollection props, DataEntityPropertyCollection subProps) {
        for (IDataEntityProperty prop : subProps) {
            if (this.containProp(props, prop)) continue;
            return false;
        }
        return true;
    }

    private boolean containProp(DataEntityPropertyCollection propCollection, IDataEntityProperty prop) {
        for (IDataEntityProperty propItem : propCollection) {
            if (!StringUtils.equals((CharSequence)propItem.getName(), (CharSequence)prop.getName()) || propItem.getPropertyType() != prop.getPropertyType()) continue;
            return true;
        }
        return false;
    }
}

