/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datamanager;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bundle.BosRes;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ConcurrentReferenceHashMap;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.ConfigurationUtil;

class DataEntityLocalCacheManager {
    private LocalMemoryCache rootCache;
    private Map<Object, Object> subDataEntityCache;
    private IDataEntityType dt;
    private String rootType;
    private String rootFilterType;
    private String rootNotExistPKs;
    private static final String BASEDATA_LOCALCACHE_WEAKCFG = "basedata.localcache.weakcfg";
    private static final String BASEDATA_LOCALCACHE_MAX_ITEMSIZE = "basedata.localcache.maxitemsize";
    private static Map<String, Integer> basedataWeakLimit;
    private static int maxItemSize;

    public DataEntityLocalCacheManager(String tableName) {
        this.rootType = tableName.toLowerCase();
        this.rootFilterType = this.rootType + ".filter";
        this.rootNotExistPKs = this.rootType + ".notexistpks";
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(3600);
        info.setMaxItemSize(this.getMaxItemSize());
        this.rootCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.get().getAccountId(), "bd", info);
    }

    public Object[] getCachePks(QFilter[] filters) {
        String key = this.getFilterKey(filters);
        return this.getFilterCache().get(key);
    }

    public void putCachePks(QFilter[] filters, Object[] pks) {
        String key = this.getFilterKey(filters);
        this.getFilterCache().put(key, pks);
    }

    private String getFilterKey(QFilter[] filters) {
        if (filters == null || filters.length == 0) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(20);
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] == null) continue;
            sb.append(filters[i]).append(',');
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private Map<String, Object[]> getFilterCache() {
        ConcurrentReferenceHashMap filterCache = (ConcurrentReferenceHashMap)this.rootCache.get(this.rootFilterType);
        if (filterCache == null) {
            filterCache = new ConcurrentReferenceHashMap();
            this.rootCache.put(this.rootFilterType, filterCache);
        }
        return filterCache;
    }

    private Map<String, Map<Object, Object>> getDataEntityCache() {
        ConcurrentReferenceHashMap dataEntityCache = (ConcurrentReferenceHashMap)this.rootCache.get(this.rootType);
        if (dataEntityCache == null) {
            dataEntityCache = new ConcurrentReferenceHashMap();
            this.rootCache.put(this.rootType, dataEntityCache);
        }
        return dataEntityCache;
    }

    public DataEntityLocalCacheManager(IDataEntityType dt) {
        this(dt.getAlias().toLowerCase());
        if (dt.getPrimaryKey() == null) {
            throw new IllegalArgumentException(BosRes.get((String)"bos-ormengine", (String)"DataEntityLocalCacheManager_0", (String)"\u5b9e\u4f53\u7f3a\u4e4f\u4e3b\u952e\uff0c\u65e0\u6cd5\u7f13\u5b58\u5904\u7406\u3002", (Object[])new Object[]{null}));
        }
        this.dt = dt;
        this.subDataEntityCache = this.getCache(this.getSubType());
    }

    private Map<Object, Object> getCache(String subType) {
        Map<String, Map<Object, Object>> dataEntityCache = this.getDataEntityCache();
        Map<Object, Object> retcache = dataEntityCache.get(subType);
        if (retcache == null) {
            retcache = new ConcurrentReferenceHashMap<Object, Object>();
            dataEntityCache.put(subType, retcache);
        }
        return retcache;
    }

    private Map<Object, Object> get(String[] pks, List<String> notFindpks) {
        HashMap<Object, Object> cacheMap = new HashMap<Object, Object>();
        if (pks.length > 0) {
            ISimpleProperty pkProp = this.dt.getPrimaryKey();
            for (String pk : pks) {
                Object obj = this.subDataEntityCache.get(pk);
                if (obj != null && !DataDirtyChecker.isDirty(obj)) {
                    cacheMap.put(pkProp.getValueFast(obj), obj);
                    continue;
                }
                notFindpks.add(pk);
            }
        }
        return cacheMap;
    }

    public void put(Object[] dataEntities) {
        ISimpleProperty pkProp = this.dt.getPrimaryKey();
        if (dataEntities.length > this.getMaxKeySize()) {
            return;
        }
        this.convertWeakHashMap(dataEntities.length);
        for (Object obj : dataEntities) {
            if (obj instanceof DynamicObject) {
                ((DynamicObject)obj).setShared(true);
            }
            this.subDataEntityCache.put(this.getKey(pkProp.getValueFast(obj)), obj);
        }
    }

    private void convertWeakHashMap(int dataSize) {
        if (this.isWeakRefenceLimit(dataSize) && !(this.subDataEntityCache instanceof ConcurrentReferenceHashMap)) {
            Map<String, Map<Object, Object>> dataEntityCache = this.getDataEntityCache();
            ConcurrentReferenceHashMap<Object, Object> weakHashMap = new ConcurrentReferenceHashMap<Object, Object>(16);
            weakHashMap.putAll(this.subDataEntityCache);
            dataEntityCache.put(this.getSubType(), weakHashMap);
            this.subDataEntityCache = weakHashMap;
        }
    }

    public void put(Map<Object, Object> dataEntities) {
        if (dataEntities.size() > this.getMaxKeySize()) {
            return;
        }
        this.convertWeakHashMap(dataEntities.size());
        for (Map.Entry<Object, Object> it : dataEntities.entrySet()) {
            if (!(it.getValue() instanceof DynamicObject)) continue;
            ((DynamicObject)it.getValue()).setShared(true);
        }
        this.subDataEntityCache.putAll(dataEntities);
    }

    public void putNotExistPKs(Object[] notExistPKs) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        Date currTime = new Date();
        for (Object pk : notExistPKs) {
            if (pk == null) continue;
            map.put(pk.toString(), currTime.getTime());
        }
        if (!map.isEmpty()) {
            Map<String, Long> notExistPKsCache = this.getNotExistPKsCache();
            if (map.size() + notExistPKsCache.size() < this.getMaxKeySize()) {
                notExistPKsCache.putAll(map);
            }
        }
    }

    public void removeByDt() {
        this.rootCache.remove(new String[]{this.rootType});
        this.removeByFilterDt();
    }

    public void removeByFilterDt() {
        this.rootCache.remove(new String[]{this.rootFilterType});
        this.rootCache.remove(new String[]{this.rootNotExistPKs});
    }

    private String getSubType() {
        String subType;
        if (this.dt instanceof DynamicObjectType) {
            subType = ((DynamicObjectType)this.dt).getExtendName();
            String cacheFlag = ((DynamicObjectType)this.dt).getCacheFlag();
            if (StringUtils.isNotBlank((CharSequence)cacheFlag)) {
                subType = String.format("%s-%s", subType, cacheFlag);
            }
        } else {
            subType = this.dt.getName();
        }
        return subType;
    }

    private String getKey(Object id) {
        return id.toString();
    }

    public Map<Object, Object> get(Object[] pkArray, List<String> notFindpks) {
        String[] pks = new String[pkArray.length];
        for (int i = 0; i < pkArray.length; ++i) {
            pks[i] = pkArray[i].toString();
        }
        return this.get(pks, notFindpks);
    }

    public IDataEntityType getDataEntityType() {
        return this.dt;
    }

    private boolean isWeakRefenceLimit(int dataSize) {
        Integer size = DataEntityLocalCacheManager.getBasedataWeakLimit().get(this.rootType);
        return size != null && dataSize > size || dataSize > 100000;
    }

    private static void readConfig() {
        String tenantId = RequestContext.get().getTenantId();
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            String weakcfg = SystemPropertyUtils.getProptyByTenant((String)BASEDATA_LOCALCACHE_WEAKCFG, (String)tenantId);
            basedataWeakLimit = StringUtils.isNotBlank((CharSequence)weakcfg) ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)weakcfg, Map.class) : new HashMap<String, Integer>();
            String itemSizeStr = SystemPropertyUtils.getProptyByTenant((String)BASEDATA_LOCALCACHE_MAX_ITEMSIZE, (String)tenantId);
            maxItemSize = StringUtils.isNotBlank((CharSequence)itemSizeStr) ? Integer.parseInt(itemSizeStr) : 100000;
        }
    }

    private static Map<String, Integer> getBasedataWeakLimit() {
        if (basedataWeakLimit == null) {
            DataEntityLocalCacheManager.readConfig();
        }
        return basedataWeakLimit;
    }

    private int getMaxItemSize() {
        if (maxItemSize == 0) {
            DataEntityLocalCacheManager.readConfig();
        }
        return maxItemSize;
    }

    private int getMaxKeySize() {
        String s = System.getProperty("orm.dataentity.localcache.maxkeysize");
        if (s != null) {
            return Integer.parseInt(s.trim());
        }
        return 300000;
    }

    public void putNotExistPKs(Object[] oids, Object[] dataEntities) {
        if (oids == null || oids.length == 0) {
            return;
        }
        if (dataEntities != null && oids.length <= dataEntities.length) {
            return;
        }
        if (dataEntities == null || dataEntities.length == 0) {
            this.putNotExistPKs(oids);
        }
        HashSet<String> existPKs = new HashSet<String>(16);
        ISimpleProperty pkProp = this.dt.getPrimaryKey();
        if (dataEntities != null) {
            for (Object dataEntity : dataEntities) {
                existPKs.add(this.getKey(pkProp.getValueFast(dataEntity)));
            }
        }
        ArrayList<String> notExistPKs = new ArrayList<String>();
        for (Object oid : oids) {
            String pkValue;
            if (oid == null || existPKs.contains(pkValue = oid.toString())) continue;
            notExistPKs.add(pkValue);
        }
        if (!notExistPKs.isEmpty()) {
            this.putNotExistPKs(notExistPKs.toArray(new String[0]));
        }
    }

    public boolean isNotExistPK(Object pk) {
        if (pk == null) {
            return false;
        }
        Map<String, Long> notExistPKsCache = this.getNotExistPKsCache();
        return notExistPKsCache.containsKey(pk.toString());
    }

    private Map<String, Long> getNotExistPKsCache() {
        ConcurrentHashMap notExistPKsCache = (ConcurrentHashMap)this.rootCache.get(this.rootNotExistPKs);
        if (notExistPKsCache == null) {
            notExistPKsCache = new ConcurrentHashMap();
            this.rootCache.put(this.rootNotExistPKs, notExistPKsCache);
        }
        return notExistPKsCache;
    }

    static {
        maxItemSize = 0;
        ConfigurationUtil.observeChange((String)BASEDATA_LOCALCACHE_WEAKCFG, (key, newValue) -> DataEntityLocalCacheManager.readConfig());
        ConfigurationUtil.observeChange((String)BASEDATA_LOCALCACHE_MAX_ITEMSIZE, (key, newValue) -> DataEntityLocalCacheManager.readConfig());
    }

    static class DataDirtyChecker {
        private DataDirtyChecker() {
        }

        public static boolean isDirty(Object obj) {
            try {
                if (!(obj instanceof DynamicObject)) {
                    return false;
                }
                if (!((DynamicObject)obj).isShared()) {
                    return true;
                }
                return DataDirtyChecker.isDirty((DynamicObject)obj, 1);
            }
            catch (RuntimeException exp) {
                return false;
            }
        }

        private static boolean isDirty(DynamicObject obj, int callCount) {
            if (callCount > 4 || obj == null) {
                return false;
            }
            boolean dirty = obj.getDataEntityState().getDataEntityDirty();
            if (dirty) {
                return true;
            }
            Boolean removeItems = obj.getDataEntityState().getRemovedItems();
            if (removeItems != null && removeItems.booleanValue()) {
                return true;
            }
            DynamicObject root = DataDirtyChecker.getRootEntity(obj);
            for (ICollectionProperty colp : obj.getDataEntityType().getProperties().getCollectionProperties(false)) {
                Object colpVal = obj.getDataStorage().getLocalValue((IDataEntityProperty)colp);
                if (!(colpVal instanceof LocaleDynamicObjectCollection) && !(colpVal instanceof MulBasedataDynamicObjectCollection)) continue;
                DynamicObjectCollection rows = (DynamicObjectCollection)colpVal;
                PkSnapshot snapshot = DataDirtyChecker.getPkSnapshot(root, colp);
                if (snapshot != null && snapshot.Oids.length != rows.size()) {
                    return true;
                }
                for (DynamicObject row : rows) {
                    boolean colpDirty = DataDirtyChecker.isDirty(row, callCount + 1);
                    if (!colpDirty) continue;
                    return true;
                }
            }
            return false;
        }

        private static DynamicObject getRootEntity(DynamicObject obj) {
            if (obj == null) {
                return null;
            }
            DynamicObject parent = obj;
            DynamicObject grandpa = (DynamicObject)parent.getParent();
            if (grandpa != null) {
                return grandpa;
            }
            return parent;
        }

        private static PkSnapshot getPkSnapshot(DynamicObject root, ICollectionProperty colp) {
            if (root == null || root.getDataEntityState() == null || root.getDataEntityState().getPkSnapshotSet() == null || root.getDataEntityState().getPkSnapshotSet().Snapshots == null || colp.getItemType() == null) {
                return null;
            }
            for (PkSnapshot snapshot : root.getDataEntityState().getPkSnapshotSet().Snapshots) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)snapshot.TableName, (CharSequence)colp.getItemType().getAlias())) continue;
                return snapshot;
            }
            return null;
        }
    }
}

