/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datamanager;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ConcurrentMap;
import kd.bos.dataentity.IFunction;

public final class ObjectCache<K, V> {
    private ConcurrentMap<K, V> cache;
    private static final int CPU_NUM = Runtime.getRuntime().availableProcessors();

    public static <K, V> ObjectCache<K, V> create() {
        return new ObjectCache<K, V>();
    }

    private ObjectCache() {
        Cache cc = CacheBuilder.newBuilder().concurrencyLevel(Math.max(CPU_NUM - 1, 1)).initialCapacity(16).maximumSize(65536L).build();
        this.cache = cc.asMap();
    }

    public int size() {
        return this.cache.size();
    }

    public V remove(K key) {
        return this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    public V getOrAdd(K key, IFunction<K, V> valueFactory) {
        return (V)this.cache.computeIfAbsent(key, k -> valueFactory.apply(k));
    }
}

