/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datamanager;

import java.util.ArrayList;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityReferenceList;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

class ReadRefCacheLog {
    private static Log log = LogFactory.getLog(ReadRefCacheLog.class);
    private static List<String> logObjectList;
    private static Boolean isOutLog;
    private static String refcache_log_object;
    private static String out_log;

    ReadRefCacheLog() {
    }

    public static void info(String s, Object ... vars) {
        if (ReadRefCacheLog.getOutLog()) {
            log.info(s, vars);
        }
    }

    public static void readTypeStatistics(DataEntityReferenceList task) {
        List<String> logObjects = ReadRefCacheLog.getLogObject();
        if (logObjects == null || logObjects.isEmpty()) {
            return;
        }
        IDataEntityType dt = task.getDataEntityType();
        if (logObjects.contains(dt.getName())) {
            String totalKey = RequestContext.get().getAccountId() + task.getDataEntityType().getExtendName();
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy());
            String total = (String)cache.get("redis_monitor_basehit", totalKey);
            if (StringUtils.isBlank((CharSequence)total)) {
                total = "0";
            }
            total = String.valueOf(Integer.parseInt(total) + 1);
            cache.put("redis_monitor_basehit", totalKey, total, 86400);
        }
    }

    private static List<String> getLogObject() {
        if (logObjectList == null) {
            ReadRefCacheLog.readLogObjectParam();
        }
        return logObjectList;
    }

    private static void readLogObjectParam() {
        String tenantId = RequestContext.get().getTenantId();
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            String refLogObject = SystemPropertyUtils.getProptyByTenant((String)refcache_log_object, (String)tenantId);
            logObjectList = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)refLogObject)) {
                String[] splitStr;
                for (String str : splitStr = refLogObject.split(",")) {
                    logObjectList.add(str.trim());
                }
            }
        }
    }

    private static boolean getOutLog() {
        String tenantId;
        if (isOutLog == null && StringUtils.isNotBlank((CharSequence)(tenantId = RequestContext.get().getTenantId()))) {
            isOutLog = Boolean.parseBoolean(SystemPropertyUtils.getProptyByTenant((String)out_log, (String)tenantId));
        }
        return isOutLog;
    }

    static {
        refcache_log_object = "basedata.rediscache.log.object";
        out_log = "basedata.rediscache.outlog";
        ConfigurationUtil.observeChange((String)refcache_log_object, (key, newValue) -> ReadRefCacheLog.readLogObjectParam());
        ConfigurationUtil.observeChange((String)out_log, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                String tenantId = RequestContext.get().getTenantId();
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    isOutLog = Boolean.parseBoolean(SystemPropertyUtils.getProptyByTenant((String)out_log, (String)tenantId));
                }
            }
        });
    }
}

