/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datamanager;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

class RefCacheLimitFlow {
    private static Log logger = LogFactory.getLog(RefCacheLimitFlow.class);
    private static String CACHE_LIMIT_P = "basedata.rediscache.limit";
    private static String CACHE_LIMIT_LOG_P = "basedata.rediscache.log";
    private static int cacheLimit;
    private static Boolean outLimitLog;

    RefCacheLimitFlow() {
    }

    boolean isCacheFlowControl(IDataEntityType dt, Object[] pkArray) {
        if (cacheLimit == 0) {
            String cacheLimitStr = SystemPropertyUtils.getProptyByTenant((String)CACHE_LIMIT_P, (String)RequestContext.get().getTenantId());
            cacheLimit = StringUtils.isNotBlank((CharSequence)cacheLimitStr) ? Integer.parseInt(cacheLimitStr) : 200000;
        }
        if (outLimitLog == null) {
            outLimitLog = Boolean.parseBoolean(SystemPropertyUtils.getProptyByTenant((String)CACHE_LIMIT_LOG_P, (String)RequestContext.get().getTenantId()));
        }
        if (pkArray.length > cacheLimit && outLimitLog.booleanValue()) {
            StringBuilder sb = new StringBuilder();
            StackTraceElement[] stes = Thread.currentThread().getStackTrace();
            int size = Math.min(stes.length, 50);
            for (int i = 1; i < size; ++i) {
                sb.append("\n\tat ").append(stes[i]);
            }
            logger.info("exceed max cache limit. dt:{} put:{} stacktrace:{}", new Object[]{dt.getExtendName(), pkArray.length, sb});
            return true;
        }
        return false;
    }

    static {
        ConfigurationUtil.observeChange((String)CACHE_LIMIT_P, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                String cacheLimitStr;
                String tenantId = RequestContext.get().getTenantId();
                if (StringUtils.isNotBlank((CharSequence)tenantId) && StringUtils.isNotBlank((CharSequence)(cacheLimitStr = SystemPropertyUtils.getProptyByTenant((String)CACHE_LIMIT_P, (String)tenantId)))) {
                    cacheLimit = Integer.parseInt(cacheLimitStr);
                }
            }
        });
        ConfigurationUtil.observeChange((String)CACHE_LIMIT_LOG_P, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                String tenantId = RequestContext.get().getTenantId();
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    outLimitLog = Boolean.parseBoolean(SystemPropertyUtils.getProptyByTenant((String)CACHE_LIMIT_LOG_P, (String)tenantId));
                }
            }
        });
    }
}

