/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.datamanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bundle.BosRes;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.EntryInfo;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IDeleteMetaRow;
import kd.bos.dataentity.metadata.ISaveDataTable;
import kd.bos.dataentity.metadata.ISaveMetaRow;
import kd.bos.dataentity.metadata.RowOperateType;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DeleteRow;
import kd.bos.orm.datamanager.ParentOidColumnValuePair;
import kd.bos.orm.datamanager.SaveRow;
import kd.bos.session.SystemPropertyUtils;

public final class SaveDataTable
implements ISaveDataTable {
    private static final Log log = LogFactory.getLog(SaveDataTable.class);
    private Map<Object, EntryInfo> mapEntryInfo = null;
    private Map<Object, Integer> changeRowCount = new HashMap<Object, Integer>();
    private ISaveMetaRow[] privateSaveRows;
    private IDeleteMetaRow[] privateDeleteRows;
    private DbMetadataTable privateSchema;
    private IColumnValuePair parentOid;

    public SaveDataTable(DbMetadataTable schema, int rowCount) {
        this.setSchema(schema);
        this.setSaveRows(new SaveRow[rowCount]);
    }

    public void setEntryInfo(Map<Object, EntryInfo> mapEntryInfo) {
        this.mapEntryInfo = mapEntryInfo;
    }

    public void analyseRows(PkSnapshot pkSnapshot) {
        int DelRowCount;
        int rightNowIndex = 0;
        Object OidLeft = null;
        Object OidRight = null;
        Object OidTemp = null;
        boolean isFound = false;
        boolean isNullSnapshot = pkSnapshot == null || pkSnapshot.Oids == null;
        boolean oidTypeChecked = false;
        for (ISaveMetaRow row : this.getSaveRows()) {
            SaveRow curRow = (SaveRow)row;
            if (!isNullSnapshot) {
                OidLeft = curRow.getOid() == null ? null : curRow.getOid().getValue();
                isFound = false;
                if (OidLeft != null) {
                    for (int j = rightNowIndex; j < pkSnapshot.Oids.length; ++j) {
                        OidRight = pkSnapshot.Oids[j];
                        if (!oidTypeChecked && OidRight != null) {
                            oidTypeChecked = true;
                            if (OidLeft.getClass() != OidRight.getClass()) {
                                throw new ORMDesignException("??????", BosRes.get((String)"bos-ormengine", (String)"SaveDataTable_0", (String)"\u8868%1$s\u6240\u5bf9\u5e94\u7684\u5b9e\u4f53\u4e0e\u6570\u636e\u5e93\u8bbe\u8ba1\u4e0d\u4e00\u81f4\uff0c\u6b64\u8868\u4e3b\u952e\u7c7b\u578b\u4e3a%2$s\uff0c\u800c\u5b9e\u4f53\u4e2d\u7c7b\u578b\u4e3a%3$s\u3002\u8bf7\u4fee\u6539\u3002", (Object[])new Object[]{this.getSchema().getName(), OidRight.getClass().getName(), OidLeft.getClass().getName()}));
                            }
                        }
                        if (!OidLeft.equals(OidRight)) continue;
                        OidTemp = pkSnapshot.Oids[rightNowIndex];
                        pkSnapshot.Oids[rightNowIndex] = OidRight;
                        pkSnapshot.Oids[j] = OidTemp;
                        if (pkSnapshot.Opids != null) {
                            Object oprId = pkSnapshot.Opids[j];
                            Object OpidTemp = pkSnapshot.Opids[rightNowIndex];
                            pkSnapshot.Opids[rightNowIndex] = oprId;
                            pkSnapshot.Opids[j] = OpidTemp;
                        }
                        ++rightNowIndex;
                        isFound = true;
                        break;
                    }
                }
            }
            if (isFound) {
                if (curRow.getDirtyValues().size() > 0) {
                    curRow.setOperate(RowOperateType.Update);
                    curRow.RebuildOutputValues();
                    continue;
                }
                curRow.setOperate(RowOperateType.None);
                continue;
            }
            curRow.setOperate(RowOperateType.Insert);
            if (curRow.getDirtyValues().size() == 0) {
                curRow.getDirtyValues().add(curRow.getOid());
            }
            if (this.getSchema().getParentRelation() != null) {
                curRow.getDirtyValues().add(new ParentOidColumnValuePair(this.getSchema().getParentRelation().getChildColumn(), null, null, curRow.getParentOid()));
                if (this.mapEntryInfo != null) {
                    Object parentPk = curRow.getParentOid().getValue();
                    this.updateChangeRows(parentPk, 1);
                }
            }
            curRow.RebuildOutputValues();
        }
        if (!isNullSnapshot && (DelRowCount = pkSnapshot.Oids.length - rightNowIndex) > 0) {
            int i;
            this.setDeleteRows(new DeleteRow[DelRowCount]);
            int k = 0;
            for (i = rightNowIndex; i < pkSnapshot.Oids.length; ++i) {
                DeleteRow tempVar2 = new DeleteRow();
                tempVar2.setOid(pkSnapshot.Oids[i]);
                this.getDeleteRows()[k] = tempVar2;
                ++k;
            }
            this.checkDeleteData(this.getDeleteRows(), this.getSchema());
            if (this.mapEntryInfo != null) {
                int len;
                if (pkSnapshot.Opids != null) {
                    for (i = rightNowIndex; i < pkSnapshot.Opids.length; ++i) {
                        Object parentPk = pkSnapshot.Opids[i];
                        this.updateChangeRows(parentPk, -1);
                    }
                } else if (this.parentOid != null && (len = rightNowIndex - pkSnapshot.Oids.length) < 0) {
                    this.updateChangeRows(this.parentOid.getValue(), len);
                }
            }
        }
    }

    private boolean checkDeleteData(IDeleteMetaRow[] rows, DbMetadataTable tableScheme) {
        DBRoute route;
        if (rows.length == 0) {
            return true;
        }
        Boolean needCheck = SystemPropertyUtils.getBooleanExt((String)RequestContext.get().getTenantId(), (String)"orm.deletecheck.enable", (Boolean)true);
        if (!needCheck.booleanValue()) {
            return true;
        }
        int rowCount = rows.length;
        int moreRows = 10;
        int emptyRowCount = 0;
        String sql = null;
        SqlParameter param = null;
        for (IDeleteMetaRow row : rows) {
            Object currentValue = row.getOid();
            if (currentValue == null) {
                sql = String.format("select top %s %s from %s where %s is null", rowCount + moreRows, tableScheme.getPrimaryKey().getName(), tableScheme.getName(), tableScheme.getPrimaryKey().getName());
                param = null;
                ++emptyRowCount;
                continue;
            }
            if (currentValue instanceof String && (((String)currentValue).length() == 0 || StringUtils.equals((CharSequence)"0", (CharSequence)((String)currentValue)))) {
                sql = String.format("select top %s %s from %s where %s = ?", rowCount + moreRows, tableScheme.getPrimaryKey().getName(), tableScheme.getName(), tableScheme.getPrimaryKey().getName());
                param = new SqlParameter(tableScheme.getPrimaryKey().getName(), 12, currentValue);
                ++emptyRowCount;
                continue;
            }
            if (!(currentValue instanceof Number) || ((Number)currentValue).longValue() != 0L) continue;
            sql = String.format("select top %s %s from %s where %s = ?", rowCount + moreRows, tableScheme.getPrimaryKey().getName(), tableScheme.getName(), tableScheme.getPrimaryKey().getName());
            param = new SqlParameter(tableScheme.getPrimaryKey().getName(), -5, currentValue);
            ++emptyRowCount;
        }
        if (sql != null && (route = this.getDBRoute(tableScheme)) != null) {
            Throwable throwable;
            int count = 0;
            try {
                Object[] objectArray;
                String string = this.getClass().getName() + ".checkDeleteData";
                if (param == null) {
                    objectArray = null;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = param;
                }
                throwable = null;
                try (DataSet dataSet = DB.queryDataSet((String)string, (DBRoute)route, sql, objectArray);){
                    while (dataSet.hasNext()) {
                        dataSet.next();
                        ++count;
                    }
                }
                catch (Throwable currentValue) {
                    throwable = currentValue;
                    throw currentValue;
                }
            }
            catch (Exception dataSet) {
                // empty catch block
            }
            if (count >= emptyRowCount + moreRows) {
                EntityTraceSpan span = EntityTracer.create((String)"SaveDataTable", (String)"checkDeleteData", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());
                throwable = null;
                try {
                    try {
                        OrmException exp = new OrmException("DataManagerImplement.delete", BosRes.get((String)"bos-ormengine", (String)"SaveDataTable_1", (String)"\u4e3b\u952e\u6570\u636e\u64cd\u4f5c\u5f02\u5e38\u3002", (Object[])new Object[0]));
                        span.addLocaleTag("rows.size", (Object)rowCount);
                        span.addLocaleTag("param.Empty.Rows", (Object)emptyRowCount);
                        span.addLocaleTag("load.Empty.Rows", (Object)count);
                        span.addLocaleTag("sql", (Object)sql);
                        span.addLocaleTag("param", (Object)param);
                        span.throwException((Throwable)exp);
                        throw exp;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (span != null) {
                        if (throwable != null) {
                            try {
                                span.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            span.close();
                        }
                    }
                    throw throwable3;
                }
            }
            if (count > 1) {
                log.error(BosRes.get((String)"bos-ormengine", (String)"SaveDataTable_1", (String)"\u4e3b\u952e\u6570\u636e\u64cd\u4f5c\u5f02\u5e38\u3002", (Object[])new Object[0]));
            }
        }
        return true;
    }

    private DBRoute getDBRoute(DbMetadataTable tableScheme) {
        String currentTableRoute = tableScheme.getDataEntityTypeMap().getDataEntityType().getDBRouteKey();
        try {
            int count;
            if (StringUtils.isBlank((CharSequence)currentTableRoute)) {
                DbMetadataTable current = tableScheme;
                for (count = 0; StringUtils.isBlank((CharSequence)currentTableRoute) && current.getParentRelation() != null && current.getParentRelation().getParentTable() != null && count < 10; ++count) {
                    current = current.getParentRelation().getParentTable();
                    currentTableRoute = current.getDataEntityTypeMap().getDataEntityType().getDBRouteKey();
                }
            }
            if (StringUtils.isBlank((CharSequence)currentTableRoute)) {
                String currentDTName = tableScheme.getDataEntityTypeMap().getDataEntityType().getParent().getName();
                IDataEntityType main = tableScheme.getDataEntityTypeMap().getDataEntityType();
                for (count = 0; main.getParent() != null && count < 10; ++count) {
                    main = main.getParent();
                }
                log.error(String.format("dbroute is empty, table is %s, currentDT is , mainDT is %s", currentDTName, main.toPlainString()));
                return null;
            }
        }
        catch (Exception e) {
            log.error(String.format("SaveDataTable.getDBRoute error,msg is %s", e.getMessage()), (Throwable)e);
            return null;
        }
        return new DBRoute(currentTableRoute);
    }

    public List<ThreeTuple<Object, Object, Integer>> getChangeRows() {
        if (this.changeRowCount.size() == 0) {
            return null;
        }
        ArrayList<ThreeTuple<Object, Object, Integer>> retChangeRows = new ArrayList<ThreeTuple<Object, Object, Integer>>(this.changeRowCount.size());
        for (Map.Entry<Object, Integer> crow : this.changeRowCount.entrySet()) {
            EntryInfo info = this.mapEntryInfo.get(crow.getKey());
            if (info == null || info.getStartRowIndex() + info.getPageSize() - crow.getValue() > info.getRowCount() - crow.getValue() || crow.getValue() == 0) continue;
            retChangeRows.add((ThreeTuple<Object, Object, Integer>)new ThreeTuple(crow.getKey(), (Object)(info.getStartRowIndex() + info.getPageSize() - crow.getValue()), (Object)crow.getValue()));
        }
        return retChangeRows;
    }

    private void updateChangeRows(Object parentPk, int len) {
        Integer changeRows = this.changeRowCount.get(parentPk);
        if (changeRows == null) {
            changeRows = len;
            this.changeRowCount.put(parentPk, changeRows);
        } else {
            changeRows = changeRows + len;
            this.changeRowCount.put(parentPk, changeRows);
        }
    }

    public ISaveMetaRow[] getSaveRows() {
        return this.privateSaveRows;
    }

    private void setSaveRows(ISaveMetaRow[] value) {
        this.privateSaveRows = value;
    }

    public IDeleteMetaRow[] getDeleteRows() {
        return this.privateDeleteRows;
    }

    private void setDeleteRows(IDeleteMetaRow[] value) {
        this.privateDeleteRows = value;
    }

    public DbMetadataTable getSchema() {
        return this.privateSchema;
    }

    private void setSchema(DbMetadataTable value) {
        this.privateSchema = value;
    }

    public void setParentOid(IColumnValuePair parentOid) {
        this.parentOid = parentOid;
    }

    public IColumnValuePair getParentOid() {
        return this.parentOid;
    }

    public String toString() {
        return this.privateSchema.getName();
    }

    public SaveDataTable mergeAndCreateNew(SaveDataTable other) {
        int rightDeleteSize;
        int n;
        if (other.getSchema() == null || !StringUtils.equals((CharSequence)other.getSchema().getName(), (CharSequence)this.getSchema().getName())) {
            throw new RuntimeException("table not equal , merge error");
        }
        SaveDataTable leftTable = this;
        SaveDataTable rightTable = other;
        SaveDataTable mergeTable = new SaveDataTable(leftTable.getSchema(), leftTable.getSaveRows().length + rightTable.getSaveRows().length);
        if (leftTable.getParentOid() != null) {
            mergeTable.setParentOid(leftTable.getParentOid());
        }
        ISaveMetaRow[] saveMetaRows = mergeTable.getSaveRows();
        int sr_i = 0;
        ISaveMetaRow[] iSaveMetaRowArray = leftTable.getSaveRows();
        int n2 = iSaveMetaRowArray.length;
        for (n = 0; n < n2; ++n) {
            ISaveMetaRow lr;
            saveMetaRows[sr_i] = lr = iSaveMetaRowArray[n];
            ++sr_i;
        }
        iSaveMetaRowArray = rightTable.getSaveRows();
        n2 = iSaveMetaRowArray.length;
        for (n = 0; n < n2; ++n) {
            ISaveMetaRow rr;
            saveMetaRows[sr_i] = rr = iSaveMetaRowArray[n];
            ++sr_i;
        }
        int leftDeleteSize = leftTable.getDeleteRows() != null ? leftTable.getDeleteRows().length : 0;
        int deleteSize = leftDeleteSize + (rightDeleteSize = rightTable.getDeleteRows() != null ? rightTable.getDeleteRows().length : 0);
        if (deleteSize > 0) {
            IDeleteMetaRow dRow;
            int n3;
            int n4;
            IDeleteMetaRow[] iDeleteMetaRowArray;
            IDeleteMetaRow[] deleteMetaRows = new DeleteRow[deleteSize];
            int del_i = 0;
            if (leftTable.getDeleteRows() != null) {
                iDeleteMetaRowArray = leftTable.getDeleteRows();
                n4 = iDeleteMetaRowArray.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    deleteMetaRows[del_i] = dRow = iDeleteMetaRowArray[n3];
                    ++del_i;
                }
            }
            if (rightTable.getDeleteRows() != null) {
                iDeleteMetaRowArray = rightTable.getDeleteRows();
                n4 = iDeleteMetaRowArray.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    deleteMetaRows[del_i] = dRow = iDeleteMetaRowArray[n3];
                    ++del_i;
                }
            }
            mergeTable.setDeleteRows(deleteMetaRows);
        }
        return mergeTable;
    }
}

