/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISaveDataSet;
import kd.bos.dataentity.metadata.database.DataEntityTypeMap;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.db.DBRoute;
import kd.bos.orm.dataentity.DataManagerImplement;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.ReadWhere;

public class DataManager
implements IDataManager {
    private IDataManager impl;

    public DataManager(IDataEntityType dataEntityType) {
        this(dataEntityType, new DBRoute(dataEntityType.getDBRouteKey()));
    }

    DataManager(IDataEntityType dataEntityType, DBRoute dbRoute) {
        this.impl = new DataManagerImplement(dataEntityType, dbRoute);
    }

    @Override
    public IDataEntityType getDataEntityType() {
        return this.impl.getDataEntityType();
    }

    @Override
    public void setDataEntityType(IDataEntityType dataEntityType) {
        this.impl.setDataEntityType(dataEntityType);
    }

    @Override
    public Object read(Object pk) {
        return this.impl.read(pk);
    }

    @Override
    public Object[] read(List<Object> pks) {
        return this.impl.read(pks);
    }

    @Override
    public Object[] read(Object[] pks) {
        return this.impl.read(pks);
    }

    @Override
    public Object[] read(ReadWhere where) {
        return this.impl.read(where);
    }

    @Override
    public List<Object> select(String where) {
        return this.impl.select(where);
    }

    @Override
    public List<Object> select(List<Object> pks) {
        return this.impl.select(pks);
    }

    @Override
    public ISaveDataSet getSaveDataSet(Object[] dataEntities, boolean includeDefaultValue) {
        return this.impl.getSaveDataSet(dataEntities, includeDefaultValue);
    }

    @Override
    public void save(Object dataEntity) {
        this.save(new Object[]{dataEntity});
    }

    @Override
    public void save(Object[] dataEntities) {
        Object[] updatePks = this.getUpdatePks(this.impl.getDataEntityType(), dataEntities);
        this.impl.save(dataEntities);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(this.impl.getDataEntityType());
        if (updatePks.length > 0) {
            cacheManager.removeByPrimaryKey(updatePks);
        } else {
            cacheManager.removeByFilterDt();
        }
    }

    @Override
    public void save(Object[] dataEntities, boolean commitSnapData) {
        this.impl.save(dataEntities, commitSnapData);
    }

    @Override
    public void commitSnapData(Object[] dataEntities) {
        this.impl.commitSnapData(dataEntities);
    }

    @Override
    public boolean delete(Object pk) {
        return this.impl.delete(pk);
    }

    @Override
    public int delete(List<? extends Object> pks) {
        return this.impl.delete(pks);
    }

    @Override
    public int delete(Object[] pks) {
        int count = this.impl.delete(pks);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(this.impl.getDataEntityType());
        cacheManager.removeByPrimaryKey(pks);
        return count;
    }

    @Override
    public boolean tryGetTableMaping(String path, RefObject<DbMetadataTable> table, RefObject<String> errorMessage) {
        return this.impl.tryGetTableMaping(path, table, errorMessage);
    }

    @Override
    public boolean tryGetColumnMaping(String path, RefObject<DbMetadataColumn> column, RefObject<String> errorMessage) {
        return this.impl.tryGetColumnMaping(path, column, errorMessage);
    }

    @Override
    public DataEntityTypeMap getDataEntityTypeMap() {
        return this.impl.getDataEntityTypeMap();
    }

    @Override
    public void setStartRowIndex(int start) {
        this.impl.setStartRowIndex(start);
    }

    @Override
    public void setPageSize(Integer pageSize) {
        this.impl.setPageSize(pageSize);
    }

    @Override
    public void update(Object[] dataEntities) {
        Object[] updatePks = this.getUpdatePks(this.impl.getDataEntityType(), dataEntities);
        this.impl.update(dataEntities);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(this.impl.getDataEntityType());
        if (updatePks.length > 0) {
            cacheManager.removeByPrimaryKey(updatePks);
        } else {
            cacheManager.removeByFilterDt();
        }
    }

    private Object[] getUpdatePks(IDataEntityType dt, Object[] dataEntities) {
        ArrayList<Object> pks = new ArrayList<Object>();
        block0: for (int rowIndex = 0; rowIndex < dataEntities.length; ++rowIndex) {
            PkSnapshotSet snapshotSetTemp = dt.getPkSnapshot(dataEntities[rowIndex]);
            if (snapshotSetTemp == null) continue;
            for (PkSnapshot item : snapshotSetTemp.Snapshots) {
                if (!item.TableName.equalsIgnoreCase(dt.getAlias())) continue;
                if (item.Oids == null) continue block0;
                for (Object id : item.Oids) {
                    pks.add(id);
                }
            }
        }
        return pks.toArray();
    }

    @Override
    public void setOption(OperateOption option) {
        this.impl.setOption(option);
    }
}

