/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMEntityInvoker;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ConfigurationUtil;

public class ORMConfiguration {
    private static Log log = LogFactory.getLog(ORMConfiguration.class);
    private static ORMEntityInvoker ormEntityInvoker;
    private static Class<?> multiLangTextPropCls;
    private static Class<?> entryPropCls;
    private static Class<?> entryEntityTypeCls;
    private static Class<?> subEntryEntityTypeCls;
    private static Class<?> baseDataEntityTypeCls;
    private static Class<?> refEntityTypeCls;
    private static final Map<String, Boolean> accountSingleLangCache;
    private static boolean qfilterCheckParameterType;
    private static boolean qfilterAutoConvertParameterType;
    private static boolean enableSingleLang;

    public static boolean isQFilterCheckParameterType() {
        return qfilterCheckParameterType;
    }

    public static boolean isQFilterAutoConvertParameterType() {
        return qfilterAutoConvertParameterType;
    }

    public static boolean isEntryEntityType(IDataEntityType entityType) {
        return entryEntityTypeCls.isAssignableFrom(entityType.getClass()) || subEntryEntityTypeCls.isAssignableFrom(entityType.getClass());
    }

    public static boolean isSubEntityType(IDataEntityType entityType) {
        return subEntryEntityTypeCls.isAssignableFrom(entityType.getClass());
    }

    public static boolean isBasedataRoute(IDataEntityType entityType) {
        return DBRoute.basedata.getRouteKey().equalsIgnoreCase(entityType.getDBRouteKey());
    }

    public static boolean isBasedata(IDataEntityType entityType) {
        return baseDataEntityTypeCls.isAssignableFrom(entityType.getClass());
    }

    public static boolean isRefEntity(IDataEntityType entityType) {
        return refEntityTypeCls.isAssignableFrom(entityType.getClass());
    }

    public static IDataEntityType getMulBasedataProp(IDataEntityProperty propertyType) {
        IDataEntityType mulBasedataPropDataEntityType = ormEntityInvoker.getMulBasedataPropDataEntityType(propertyType);
        try {
            return (IDataEntityType)mulBasedataPropDataEntityType.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("clone error", e);
        }
    }

    public static boolean isMulBasedataProp(IDataEntityProperty propertyType) {
        return ormEntityInvoker.getMulBasedataPropDataEntityType(propertyType) != null;
    }

    public static boolean isMulBasedata(IDataEntityType entityType) {
        IDataEntityType mulbdMainEntityType = entityType.getParent();
        if (mulbdMainEntityType != null) {
            IDataEntityProperty fkProperty = (IDataEntityProperty)mulbdMainEntityType.getProperties().get((Object)entityType.getName());
            return ORMConfiguration.isMulBasedataProp(fkProperty);
        }
        return false;
    }

    public static IDataEntityType cloneDataEntityType(IDataEntityType dt) {
        try (TraceSpan ts = Tracer.create((String)"ORM", (String)"cloneDataEntityType");){
            IDataEntityType clone = ormEntityInvoker.cloneDataEntityType(dt);
            DataEntityPropertyCollection clonePS = clone.getProperties();
            HashMap<String, Object> propertiesSet = new HashMap<String, Object>(clonePS.size());
            int n = clonePS.size();
            for (int i = 0; i < n; ++i) {
                propertiesSet.put(((IDataEntityProperty)clonePS.get(i)).getName().toLowerCase(), clonePS.get(i));
            }
            clonePS.clear();
            DataEntityPropertyCollection dtPS = dt.getProperties();
            int n2 = dtPS.size();
            for (int i = 0; i < n2; ++i) {
                clonePS.add(propertiesSet.get(((IDataEntityProperty)dtPS.get(i)).getName().toLowerCase()));
            }
            IDataEntityType iDataEntityType = clone;
            return iDataEntityType;
        }
    }

    @Deprecated
    public static DynamicObjectType getBaseDataEntityType(IComplexProperty basedataProperty, Map<String, IDataEntityType> entityTypeCache) {
        return (DynamicObjectType)ORMConfiguration.innerGetBaseDataEntityType(basedataProperty, entityTypeCache);
    }

    public static IDataEntityType innerGetBaseDataEntityType(IComplexProperty basedataProperty, Map<String, IDataEntityType> entityTypeCache) {
        String entityName = ormEntityInvoker.getBaseDataEntityName(basedataProperty);
        if (entityName == null) {
            throw new RuntimeException(BosRes.get((String)"bos-ormengine", (String)"ORMConfiguration_0", (String)"{0}'s property\"{1}\" referenced object is null.", (Object[])new Object[]{basedataProperty.getParent(), basedataProperty.getName()}));
        }
        IDataEntityType ret = ORMConfiguration.getDataEntityType(entityName, entityTypeCache, true);
        if (ret == null) {
            ret = basedataProperty.getComplexType() != null ? basedataProperty.getComplexType() : ORMConfiguration.getDataEntityType(entityName, entityTypeCache, false);
        }
        return ret;
    }

    public static boolean isMultiLangPropertyType(IDataEntityProperty peropertyType) {
        IDataEntityType dt;
        boolean b = multiLangTextPropCls.isAssignableFrom(peropertyType.getClass());
        if (!b && (dt = peropertyType.getParent()) != null) {
            b = ORMConfiguration.isMultiLangDataEntityType(dt);
        }
        return b;
    }

    public static boolean isGLPropertyType(IDataEntityType dt, String propertyName) {
        if (dt == null) {
            return false;
        }
        IDataEntityProperty prop = (IDataEntityProperty)dt.getProperties().get((Object)propertyName);
        return multiLangTextPropCls.isAssignableFrom(prop.getClass()) && !prop.isDbIgnore();
    }

    public static boolean isEntryProPropertyType(IDataEntityProperty peropertyType) {
        return entryPropCls.isAssignableFrom(peropertyType.getClass());
    }

    public static boolean isMultiLangDataEntityType(IDataEntityType dt) {
        if (dt != null) {
            return dt.getName().equalsIgnoreCase("locale") || dt.getAlias() != null && dt.getAlias().endsWith("_L") && !dt.getAlias().toUpperCase().startsWith("TEMP_");
        }
        return false;
    }

    public static void setEntityMetaProvider(ORMEntityInvoker ormEntityInvoker) {
        ORMConfiguration.ormEntityInvoker = ormEntityInvoker;
    }

    @Deprecated
    public static DynamicObjectType getDataEntityType(String entityNamePath, Map<String, IDataEntityType> entityTypeCache) {
        return (DynamicObjectType)ORMConfiguration.innerGetDataEntityType(entityNamePath, entityTypeCache);
    }

    public static IDataEntityType innerGetDataEntityType(String entityNamePath, Map<String, IDataEntityType> entityTypeCache) {
        return ORMConfiguration.getDataEntityType(entityNamePath, entityTypeCache, false);
    }

    private static IDataEntityType getDataEntityType(String entityNamePath, Map<String, IDataEntityType> entityTypeCache, boolean onlyAtCache) {
        IDataEntityType root;
        if (entityNamePath.indexOf(46) == -1) {
            if (onlyAtCache) {
                return entityTypeCache == null ? null : entityTypeCache.get(entityNamePath.toLowerCase());
            }
            return ORMConfiguration.doGetDataEntityType(entityNamePath, entityTypeCache);
        }
        String[] entityNames = entityNamePath.split("\\.");
        IDataEntityType ret = root = ORMConfiguration.doGetDataEntityType(entityNames[0], entityTypeCache);
        for (int i = 1; i < entityNames.length; ++i) {
            String entityName = entityNames[i].trim();
            IDataEntityProperty dp = (IDataEntityProperty)ret.getProperties().get((Object)entityName);
            if (dp instanceof ICollectionProperty) {
                ret = ((ICollectionProperty)dp).getItemType();
                continue;
            }
            if (dp instanceof IComplexProperty) {
                ret = ((IComplexProperty)dp).getComplexType();
                if (onlyAtCache) {
                    return entityTypeCache == null ? null : entityTypeCache.get(ret.getName().toLowerCase());
                }
                ret = ORMConfiguration.doGetDataEntityType(ret.getName(), entityTypeCache);
                continue;
            }
            throw new IllegalArgumentException(entityName + " is not an entity.");
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    private static IDataEntityType doGetDataEntityType(String entityName, Map<String, IDataEntityType> entityTypeCache) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean useSingleLang() {
        if (enableSingleLang) {
            String accountId = RequestContextInfo.get().getAccountId();
            Boolean b = accountSingleLangCache.get(accountId);
            if (b == null) {
                int count = (Integer)DB.query((DBRoute)DBRoute.basedata, (String)"select count(1) c from t_int_enabledlanguage", rs -> {
                    rs.next();
                    int c = rs.getInt(1);
                    return c == 0 ? 1 : c;
                });
                b = count == 1;
                accountSingleLangCache.put(accountId, b);
            }
            return b;
        }
        return false;
    }

    public static void clearUseSingleLangCache() {
        accountSingleLangCache.clear();
    }

    static {
        accountSingleLangCache = new ConcurrentHashMap<String, Boolean>(16);
        qfilterCheckParameterType = false;
        qfilterAutoConvertParameterType = false;
        enableSingleLang = false;
        String invokerImpl = "kd.bos.entity.query.ORMEntityInvokerImpl";
        try {
            multiLangTextPropCls = Class.forName("kd.bos.entity.property.MuliLangTextProp");
            entryPropCls = Class.forName("kd.bos.entity.property.EntryProp");
            entryEntityTypeCls = Class.forName("kd.bos.entity.EntryType");
            subEntryEntityTypeCls = Class.forName("kd.bos.entity.SubEntryType");
            baseDataEntityTypeCls = Class.forName("kd.bos.entity.BasedataEntityType");
            refEntityTypeCls = Class.forName("kd.bos.entity.RefEntityType");
            ormEntityInvoker = (ORMEntityInvoker)Class.forName(invokerImpl).newInstance();
        }
        catch (Exception e) {
            log.warn("Failed to init ORMConfiguration:" + e.getMessage(), (Throwable)e);
        }
        ConfigurationUtil.observeBoolean((String)"orm.qfilter.checkParameterType", (boolean)qfilterCheckParameterType, v -> {
            qfilterCheckParameterType = v;
        });
        ConfigurationUtil.observeBoolean((String)"orm.qfilter.autoConvertParameterType", (boolean)qfilterAutoConvertParameterType, v -> {
            qfilterAutoConvertParameterType = v;
        });
        ConfigurationUtil.observeString((String)"orm.accountLang.clearCache", (String)"ANY", v -> ORMConfiguration.clearUseSingleLangCache());
        ConfigurationUtil.observeBoolean((String)"orm.accountLang.enable", (boolean)enableSingleLang, v -> {
            enableSingleLang = v;
        });
    }
}

