/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.impl;

import java.io.Closeable;
import kd.bos.util.ThreadLocals;

public class ORMCostStat
implements Closeable {
    public static final String orm_cost_stat = "orm.cost.stat";
    private static final ThreadLocal<ORMCostStat> tlCache = ThreadLocals.create(() -> new ORMCostStat());
    private long trace_sql_meta;
    private long sql_meta;
    private long meta;
    private long per_trace_sql_meta;
    private long per_sql_meta;
    private long per_meta;
    private long count_trace_sql_meta;
    private long count_sql_meta;
    private long count_meta;

    public static ORMCostStat get() {
        return tlCache.get();
    }

    public ORMCostStat beginTrace() {
        ++this.count_trace_sql_meta;
        this.per_trace_sql_meta = System.currentTimeMillis();
        return this;
    }

    public void endTrace() {
        this.trace_sql_meta += System.currentTimeMillis() - this.per_trace_sql_meta;
    }

    public ORMCostStat beginSql() {
        ++this.count_sql_meta;
        this.per_sql_meta = System.currentTimeMillis();
        return this;
    }

    public void endSql() {
        this.sql_meta += System.currentTimeMillis() - this.per_sql_meta;
    }

    public ORMCostStat beginMeta() {
        ++this.count_meta;
        this.per_meta = System.currentTimeMillis();
        return this;
    }

    public void endMeta() {
        this.meta += System.currentTimeMillis() - this.per_meta;
    }

    public long getAll() {
        return this.trace_sql_meta;
    }

    public long getTrace() {
        return this.trace_sql_meta - this.sql_meta;
    }

    public long getSqlAndMeta() {
        return this.sql_meta;
    }

    public long getMeta() {
        return this.meta;
    }

    public void dumpStat() {
    }

    private String getCost() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("[ORM_COST_STAT]\ntotal.").append(this.count_trace_sql_meta + this.count_sql_meta + this.count_meta).append('\t').append(this.getAll()).append("ms");
        sb.append("\ntracer.").append(this.count_trace_sql_meta).append('\t').append(this.getTrace()).append("ms");
        sb.append("\noql+meta.").append(this.count_sql_meta).append('\t').append(this.getSqlAndMeta()).append("ms");
        sb.append("\nall_meta.").append(this.count_meta).append('\t').append(this.getMeta()).append("ms");
        return sb.toString();
    }

    @Override
    public void close() {
    }
}

