/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.impl;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.util.DateUtil;

class ORMEntityTypeCacheMap
implements Map<String, IDataEntityType> {
    private Map<String, IDataEntityType> globalCache;
    private Map<String, IDataEntityType> instanceCache = new HashMap<String, IDataEntityType>();
    private final long globalCacheCreateTime;
    private final long instanceCacheCreateTime = System.nanoTime();
    private final String globalCacheCreateThread;
    private final String instanceCacheCreateThread;
    private static final Log log = LogFactory.getLog(ORMEntityTypeCacheMap.class);
    static Method toJsonString;

    public ORMEntityTypeCacheMap(Map<String, IDataEntityType> globalCache, long globalCacheCreateTime, String globalCacheCreateThread) {
        this.globalCache = globalCache;
        this.globalCacheCreateTime = globalCacheCreateTime;
        this.globalCacheCreateThread = globalCacheCreateThread;
        this.instanceCacheCreateThread = Thread.currentThread().getName();
    }

    public IDataEntityType putInstanceCache(String key, IDataEntityType value) {
        return this.instanceCache.put(key.toLowerCase(), value);
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.globalCache.isEmpty() && this.instanceCache.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        String lk = ((String)key).toLowerCase();
        return this.globalCache.containsKey(lk) || this.instanceCache.containsKey(lk);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.globalCache.containsValue(value) || this.instanceCache.containsValue(value);
    }

    @Override
    public IDataEntityType get(Object key) {
        if (key == null) {
            return null;
        }
        String lk = ((String)key).toLowerCase();
        IDataEntityType dt = this.instanceCache.get(lk);
        if (dt != null) {
            return dt;
        }
        return this.globalCache.get(lk);
    }

    @Override
    public IDataEntityType put(String key, IDataEntityType value) {
        key = key.toLowerCase();
        IDataEntityType dt2 = this.instanceCache.remove(key);
        IDataEntityType dt1 = this.globalCache.put(key, value);
        return dt2 == null ? dt1 : dt2;
    }

    @Override
    public IDataEntityType remove(Object key) {
        if (key == null) {
            return null;
        }
        String lk = ((String)key).toLowerCase();
        IDataEntityType dt1 = this.globalCache.remove(lk);
        IDataEntityType dt2 = this.instanceCache.remove(lk);
        return dt2 == null ? dt1 : dt2;
    }

    @Override
    public void putAll(Map<? extends String, ? extends IDataEntityType> m) {
        this.instanceCache.clear();
        for (Map.Entry<? extends String, ? extends IDataEntityType> entry : m.entrySet()) {
            this.globalCache.put(entry.getKey().toLowerCase(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.globalCache.clear();
        this.instanceCache.clear();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>(this.globalCache.size() + this.instanceCache.size());
        set.addAll(this.globalCache.keySet());
        set.addAll(this.instanceCache.keySet());
        return set;
    }

    @Override
    public Collection<IDataEntityType> values() {
        HashSet<IDataEntityType> set = new HashSet<IDataEntityType>(this.globalCache.size() + this.instanceCache.size());
        set.addAll(this.globalCache.values());
        set.addAll(this.instanceCache.values());
        return set;
    }

    @Override
    public Set<Map.Entry<String, IDataEntityType>> entrySet() {
        HashSet<Map.Entry<String, IDataEntityType>> set = new HashSet<Map.Entry<String, IDataEntityType>>(this.globalCache.size() + this.instanceCache.size());
        set.addAll(this.globalCache.entrySet());
        set.addAll(this.instanceCache.entrySet());
        return set;
    }

    public String toDumpString() {
        SimpleDateFormat sdf = DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss.SSS");
        StringBuilder sb = new StringBuilder();
        this.dumpMap(sdf, sb, "InstanceCache", this.instanceCache, this.instanceCacheCreateTime, this.instanceCacheCreateThread);
        sb.append('\n');
        this.dumpMap(sdf, sb, "GlobalCache", this.globalCache, this.globalCacheCreateTime, this.globalCacheCreateThread);
        return sb.toString();
    }

    private void dumpMap(SimpleDateFormat sdf, StringBuilder sb, String name, Map<String, IDataEntityType> map, long createTime, String createThread) {
        sb.append(name).append('=').append(map.size()).append(" create by ").append(createThread).append(" @").append(sdf.format(new Date(createTime)));
        int i = 0;
        for (Map.Entry<String, IDataEntityType> entry : map.entrySet()) {
            String json;
            IDataEntityType dt = entry.getValue();
            sb.append("\n\t").append(++i).append('#').append(entry.getKey()).append('=').append(dt.getClass().getName()).append('@').append(Integer.toHexString(dt.hashCode()));
            try {
                try {
                    Method getVersion = dt.getClass().getMethod("getVersion", new Class[0]);
                    String version = (String)getVersion.invoke((Object)dt, new Object[0]);
                    sb.append(", version=").append(version);
                }
                catch (NoSuchMethodException e) {
                    log.error((Throwable)e);
                }
                json = (String)toJsonString.invoke(null, dt);
            }
            catch (Exception e) {
                json = "toJsonString error: " + e.getMessage();
            }
            sb.append("\n\t").append(json);
        }
    }

    static {
        try {
            toJsonString = Class.forName("kd.bos.entity.EntityItemTypes").getMethod("toJsonString", IDataEntityType.class);
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException((Throwable)e);
        }
    }
}

