/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.audit.Audit;
import kd.bos.audit.orm.NoFilterQuery;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DBRoute;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORMHint;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.dataentity.AggregateFuncs;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMEntityTypeCacheMap;
import kd.bos.orm.impl.ORMImplBase;
import kd.bos.orm.impl.ORMOptimization;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.SqlTreeNode;
import kd.bos.orm.query.crud.read.SelectFieldBuilder;
import kd.bos.orm.query.multi.MultiQuery;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.multi.PropertySegExpress;
import kd.bos.orm.query.multi.QueryUtils;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.orm.query.optimize.PrepareJoinDB;
import kd.bos.orm.query.optimize.QueryTreeNode;
import kd.bos.orm.query.oql.g.expr.SelectFields;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.exception.ExceptionUtil;

public abstract class ORMImplStandard
extends ORMImplBase {
    private static final Log log = LogFactory.getLog((String)"ORM");
    private static final String AUDIT_ORM_EMPTY_SELECTFIELDS = "orm,orm_empty_selectfields";
    private static final String AUDIT_ORM_WITHALL_SELECTFIELDS = "orm,orm_withall_selectfields";
    private static boolean dumpMetaCacheOnError = false;
    private static final String ORM_DUMP_METACACHE_ON_ERROR = "orm.dump_metacache_on_error";

    public ORMImplStandard(Map<String, IDataEntityType> entityTypeCache, ORMHint ormHint, ORMOptimization optimization) {
        super(entityTypeCache, ormHint, optimization);
    }

    @Override
    public DynamicObjectCollection getByFilter(String entityName, QFilter[] filters, String orderBys, int top) {
        String selectFields = new SelectFieldBuilder(entityName, this.entityTypeCache).buildSelectFields(true);
        return this.query(entityName, selectFields, filters, orderBys, top);
    }

    @Override
    protected DataSet queryDataSet(String algoKey, String entityName, String selectFields, boolean shouldSelectPK, QFilter[] filters, String groupBys, QFilter[] havings, String orderBys, int from, int length, Distinctable distinctable) {
        int top;
        if (from < 0) {
            from = 0;
        }
        if (length < 0) {
            top = -1;
            length = Integer.MAX_VALUE;
        } else {
            top = from + length;
        }
        try {
            MultiQuery mq = this.doCreateMultiQuery(entityName, selectFields, shouldSelectPK, filters, groupBys, havings, orderBys, top, from, length, distinctable);
            DataSet ds = mq.query(algoKey, filters, orderBys);
            if (!(mq.isQueryWithTop() || from <= 0 && top == -1)) {
                ds = ds.range(from, length);
            }
            return ds;
        }
        catch (Exception e) {
            if (dumpMetaCacheOnError) {
                StringBuilder metaString = new StringBuilder("Dump meta cache on error: ");
                if (this.entityTypeCache instanceof ORMEntityTypeCacheMap) {
                    metaString.append(((ORMEntityTypeCacheMap)this.entityTypeCache).toDumpString());
                } else {
                    metaString.append(this.entityTypeCache);
                }
                if (log.isErrorEnabled()) {
                    log.error(metaString.toString(), (Throwable)e);
                }
            }
            throw ExceptionUtil.asRuntimeException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String handleIdAsterisk(String selectFields, String entityName, IDataEntityType dt) {
        if (StringUtil.isEmpty((String)selectFields)) return selectFields;
        List<PropertyField> fields = SelectFields.parseFrom(selectFields = selectFields.trim()).createPropertyFields(entityName);
        if (CollectionUtils.isEmpty(fields)) {
            return selectFields;
        }
        boolean containsStar = false;
        try {
            StringBuilder startColumn = new StringBuilder();
            for (int i = 0; i < fields.size(); ++i) {
                PropertyField propertyField = fields.get(i);
                PropertySegExpress propertySegExpress = propertyField.getPropertySegExpress();
                if (propertySegExpress != null || !"*".equals(propertyField.getAlias()) && !propertyField.getAlias().contains("*")) continue;
                containsStar = true;
                startColumn.append(propertyField.getAlias()).append(",");
            }
            if (!containsStar) return selectFields;
            String column = startColumn.toString();
            column = column.substring(0, column.length() - 1);
            List<PropertyField> propertyFields = ORMUtil.parseQueryFieldInfo(column, entityName, dt);
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (true) {
                if (i >= fields.size()) {
                    return builder.toString();
                }
                PropertyField propertyField = fields.get(i);
                PropertySegExpress propertySegExpress = propertyField.getPropertySegExpress();
                if (propertySegExpress == null) {
                    if (!"*".equals(propertyField.getAlias()) && !propertyField.getAlias().contains("*")) {
                        log.warn(propertyField.getName() + "'s PropertySegExpress is empty." + selectFields);
                        return selectFields;
                    }
                    builder.append(propertyField.getAlias());
                } else {
                    String fieldName = propertySegExpress.toString().trim();
                    if (this.needSetAlias(entityName, fieldName, propertyField.getAlias(), propertyFields)) {
                        builder.append(fieldName).append(" ").append(fieldName).append("2");
                    } else if (propertyField.getName().equals(propertyField.getAlias())) {
                        builder.append(fieldName);
                    } else {
                        builder.append(fieldName).append(" ").append(propertyField.getAlias());
                    }
                }
                if (i != fields.size() - 1) {
                    builder.append(",");
                }
                ++i;
            }
        }
        catch (Exception e) {
            log.error("Parse select fields error", (Throwable)e);
        }
        return selectFields;
    }

    private boolean needSetAlias(String entityName, String fieldName, String alias, List<PropertyField> propertyFields) {
        if (!fieldName.equals(alias)) {
            return false;
        }
        if (!fieldName.startsWith(entityName)) {
            fieldName = entityName + "." + fieldName;
        }
        for (PropertyField field : propertyFields) {
            if (!fieldName.equals(field.getAlias())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected SqlTreeNode getQuerySql(String entityName, String selectFields, boolean shouldSelectPK, QFilter[] filters, String groupBys, QFilter[] havings, String orderBys, int from, int length, Distinctable distinctable) {
        int top;
        if (from < 0) {
            from = 0;
        }
        if (length < 0) {
            top = -1;
            length = Integer.MAX_VALUE;
        } else {
            top = from + length;
        }
        MultiQuery mq = this.createMultiQuery(entityName, selectFields, shouldSelectPK, filters, groupBys, havings, orderBys, top, distinctable);
        return mq.getQuerySql();
    }

    @Override
    protected boolean isQueryInSameDB(String entityName, String selectFields, QFilter[] filters) {
        MultiQuery mq = this.createMultiQuery(entityName, selectFields, false, filters, null, null, null, -1, null);
        RequestContext rc = RequestContext.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        Set mergedDBConfigSet = null;
        for (SingleQuery query : mq.getQueries()) {
            Set<String> tables = query.getTables(true, true, true, true);
            Set queryDBConfigSet = DataSourceFactory.getDBConfigs((String)tenantId, (String)query.getDBRoute().getRouteKey(), (String)accountId, (String[])tables.toArray(new String[tables.size()]));
            if (mergedDBConfigSet == null) {
                mergedDBConfigSet = queryDBConfigSet;
                continue;
            }
            mergedDBConfigSet.retainAll(queryDBConfigSet);
        }
        return mergedDBConfigSet != null && !mergedDBConfigSet.isEmpty();
    }

    @Override
    public int count(String algoKey, String entityName, String selectFields, QFilter[] filters, Distinctable distinct) {
        return this.count(algoKey, entityName, selectFields, filters, distinct, -1);
    }

    @Override
    public int count(String algoKey, String entityName, String selectFields, QFilter[] filters, Distinctable distinct, int top) {
        if (top <= 0) {
            top = -1;
        }
        MultiQuery mq = this.createMultiQuery(entityName, selectFields, false, filters, null, null, null, top, distinct);
        QContext allCtx = mq.getQueries()[0].getAllCtx();
        if (mq.getQueries().length == 1) {
            return mq.queryForCount(algoKey, false, top, filters, 1, null);
        }
        if (SystemPropertyUtils.getBooleanExt((String)RequestContext.get().getTenantId(), (String)"orm.opt.count.inmemory", (Boolean)true).booleanValue()) {
            QueryTreeNode root = QueryTreeNode.create(mq.getQueries());
            QueryUtils.tryMergeQuery(root, allCtx, this.optimization.isReduceUnnessesaryJoin());
            if (root.isLeaf()) {
                return mq.queryForCount(algoKey, false, top, filters, 2, root.getQuery());
            }
            mq = this.createMultiQuery(entityName, selectFields, false, filters, null, null, null, top, distinct);
        }
        return mq.queryForCount(algoKey, false, top, filters, 3, null);
    }

    @Override
    public Object[] aggregate(String algoKey, String entityName, String[] funcs, QFilter[] filters) {
        Object[] result;
        AggregateFuncs aggregateFuncs = new AggregateFuncs(funcs);
        String queryFields = ORMUtil.generateSelectFields(aggregateFuncs);
        MultiQuery mq = this.createMultiQuery(entityName, queryFields, false, filters, null, null, null, -1, null);
        QContext allCtx = mq.getQueries()[0].getAllCtx();
        allCtx.setAggregate(true);
        allCtx.setFuncs(funcs);
        if (ORMConfig.AGGREGATE_BY_SQL.getBoolean()) {
            if (mq.getQueries().length == 1) {
                try {
                    result = this.aggregateInSameDB(mq, false, funcs, aggregateFuncs, entityName, filters, algoKey);
                }
                catch (Exception e) {
                    log.error("aggregate error", (Throwable)e);
                    result = mq.queryForAggregate(algoKey, aggregateFuncs, filters);
                }
            } else {
                QueryTreeNode root = QueryTreeNode.create(mq.getQueries());
                QueryUtils.tryMergeQuery(root, allCtx, this.optimization.isReduceUnnessesaryJoin());
                if (root.isLeaf()) {
                    try {
                        result = this.aggregateInSameDB(mq, true, funcs, aggregateFuncs, entityName, filters, algoKey);
                    }
                    catch (Exception e) {
                        log.error("aggregate error", (Throwable)e);
                        result = mq.queryForAggregate(algoKey, aggregateFuncs, filters);
                    }
                } else {
                    result = mq.queryForAggregate(algoKey, aggregateFuncs, filters);
                }
            }
        } else {
            result = mq.queryForAggregate(algoKey, aggregateFuncs, filters);
        }
        return result;
    }

    @Override
    public DataSet aggregate(String algoKey, String entityName, String[] funcs, QFilter[] filters, String[] groupbyFields) {
        boolean needDistinct;
        AggregateFuncs aggregateFuncs = new AggregateFuncs(funcs);
        String queryFields = ORMUtil.generateSelectFields(aggregateFuncs);
        String groupFieldsJoin = String.join((CharSequence)",", groupbyFields);
        MultiQuery mq = this.createMultiQuery(entityName, queryFields + "," + groupFieldsJoin, false, filters, null, null, null, -1, null);
        boolean useSqlAggregate = false;
        try {
            List<PropertyField> pfs = SelectFields.parseFrom(queryFields).createPropertyFields(entityName);
            needDistinct = ORMUtil.needDistinct(pfs.toArray(new PropertyField[pfs.size()]), mq.getQueries()[0].getAllCtx(), filters);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(entityName + " select field error: " + queryFields, e);
        }
        String[] ids = ORMUtil.getIds(aggregateFuncs.getFields());
        HashSet<String> idSet = new HashSet<String>(2);
        for (String id : ids) {
            idSet.add(id);
        }
        if (mq.getQueries().length == 1 && !needDistinct && idSet.size() <= 1) {
            useSqlAggregate = true;
        } else {
            QContext allCtx = mq.getQueries()[0].getAllCtx();
            QueryTreeNode root = QueryTreeNode.create(mq.getQueries());
            QueryUtils.reduceUnnessesaryJoin(root, allCtx, this.optimization.isReduceUnnessesaryJoin());
            PrepareJoinDB.prepare(root);
            QueryUtils.joinInSameDatabase(root);
            if (root.isLeaf() && !needDistinct && idSet.size() <= 1) {
                useSqlAggregate = true;
            }
        }
        if (useSqlAggregate && ORMConfig.AGGREGATE_INMEMORY.getBoolean()) {
            String queryField = String.join((CharSequence)",", String.join((CharSequence)",", funcs), groupFieldsJoin);
            mq = this.createMultiQuery(entityName, queryField, false, filters, groupFieldsJoin, null, null, -1, null);
            QContext allCtx = mq.getQueries()[0].getAllCtx();
            allCtx.setAggregateByGroup(true);
            return mq.query(algoKey);
        }
        return mq.queryForAggregate(algoKey, aggregateFuncs, groupbyFields);
    }

    private MultiQuery createMultiQuery(String entityName, String selectFields, boolean shouldSelectPK, QFilter[] filters, String groupBys, QFilter[] havings, String orderBys, int top, Distinctable distinctable) {
        return this.doCreateMultiQuery(entityName, selectFields, shouldSelectPK, filters, groupBys, havings, orderBys, top, 0, 0, distinctable);
    }

    private MultiQuery doCreateMultiQuery(String entityName, String selectFields, boolean shouldSelectPK, QFilter[] filters, String groupBys, QFilter[] havings, String orderBys, int top, int start, int length, Distinctable distinctable) {
        try (TraceSpan ts = Tracer.create((String)"ORM", (String)"doCreateMultiQuery");){
            MultiQuery mq;
            if (Audit.isEnable()) {
                boolean notTopNoFilter;
                boolean bl = notTopNoFilter = top < 0;
                if (notTopNoFilter) {
                    notTopNoFilter = this.judgeNotTopNoFilter(filters, notTopNoFilter);
                    notTopNoFilter = this.judgeNotTopNoFilter(havings, notTopNoFilter);
                }
                if (notTopNoFilter) {
                    NoFilterQuery.audit((String)("No top no filter query, oql=select " + selectFields + " from " + entityName + "."));
                }
                if (Audit.isEnable((String)AUDIT_ORM_EMPTY_SELECTFIELDS) && (selectFields == null || selectFields.trim().length() == 0)) {
                    Audit.auditDirect((String)AUDIT_ORM_EMPTY_SELECTFIELDS, (int)1, (long)0L, (long)0L, (Object[])new Object[]{ExceptionUtil.getStackTrace((String)"selectFields is empty")});
                }
                if (Audit.isEnable((String)AUDIT_ORM_WITHALL_SELECTFIELDS) && selectFields != null && selectFields.indexOf(42) != -1) {
                    Audit.auditDirect((String)AUDIT_ORM_WITHALL_SELECTFIELDS, (int)1, (long)0L, (long)0L, (Object[])new Object[]{ExceptionUtil.getStackTrace((String)("selectFields with * : " + selectFields))});
                }
            }
            IDataEntityType dt = ORMConfiguration.innerGetDataEntityType(entityName, this.entityTypeCache);
            DBRoute dbRoute = new DBRoute(dt.getDBRouteKey());
            DataEntityPropertyCollection fields = dt.getProperties();
            if (Boolean.getBoolean("orm.datatype.strict")) {
                this.resetFiterType(fields, filters);
            }
            selectFields = this.handleIdAsterisk(selectFields, entityName, dt);
            MultiQuery multiQuery = mq = MultiQuery.create(dbRoute, dt, selectFields, shouldSelectPK, filters, groupBys, havings, orderBys, top, start, length, this.entityTypeCache, this.ormHint, this.optimization, distinctable);
            return multiQuery;
        }
    }

    @Override
    public RowMeta genRowMeta(String entityName, String selectFields) {
        IDataEntityType dt = ORMConfiguration.innerGetDataEntityType(entityName, this.entityTypeCache);
        DBRoute dbRoute = new DBRoute(dt.getDBRouteKey());
        MultiQuery mq = MultiQuery.create(dbRoute, dt, selectFields, false, null, null, null, null, 1, 0, 0, this.entityTypeCache, this.ormHint, this.optimization, null);
        return mq.genRowMeta();
    }

    private void resetFiterType(DataEntityPropertyCollection fields, QFilter[] filters) {
        if (filters == null) {
            return;
        }
        HashMap refEntityNames = new HashMap(4);
        for (QFilter filter : filters) {
            if (filter == null) continue;
            this.parseEntityNameFromFilter(filter, refEntityNames, 1);
        }
        HashMap fieldTypeMapping = new HashMap();
        fields.forEach(v -> {
            try {
                if (v instanceof DynamicProperty) {
                    DynamicProperty dp = (DynamicProperty)v;
                    String subEntityName = dp.getName();
                    Map nameMap = (Map)refEntityNames.get(subEntityName);
                    Method m = this.getDbTypeMethod(v.getClass());
                    if (m != null) {
                        int dbtype = (Integer)m.invoke(v, new Object[0]);
                        fieldTypeMapping.put(dp.getName(), dbtype);
                        if (nameMap != null && dp instanceof DynamicComplexProperty) {
                            DynamicComplexProperty dcp = (DynamicComplexProperty)dp;
                            DynamicObjectType subentityType = dcp.getDynamicComplexPropertyType();
                            this.getSubEntityFieldtype(nameMap, fieldTypeMapping, subEntityName, (IDataEntityType)subentityType);
                        }
                    } else if (dp instanceof ICollectionProperty && nameMap != null) {
                        ICollectionProperty dcp = (ICollectionProperty)dp;
                        IDataEntityType subentityType = dcp.getItemType();
                        this.getSubEntityFieldtype(nameMap, fieldTypeMapping, subEntityName, subentityType);
                    }
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        });
        for (QFilter filter : filters) {
            List<QFilter.QFilterNest> nestFilters;
            if (filter == null) continue;
            String propF = filter.getProperty();
            Integer type = (Integer)fieldTypeMapping.get(propF);
            if (type != null) {
                Object v2 = filter.getValue();
                this.resetFilterValue(filter, type, v2);
            }
            if ((nestFilters = filter.getNests(true)) == null) continue;
            nestFilters.forEach(nfilter -> {
                QFilter _qf = nfilter.getFilter();
                Integer _type = (Integer)fieldTypeMapping.get(_qf.getProperty());
                if (_type != null) {
                    Object v = _qf.getValue();
                    this.resetFilterValue(_qf, _type, v);
                }
            });
        }
    }

    private Method getDbTypeMethod(Class<? extends IDataEntityProperty> class1) {
        try {
            Method m = class1.getMethod("getDbType", new Class[0]);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException e) {
            log.error(class1.getName() + "not exists method : getDbType");
        }
        catch (SecurityException e) {
            log.error((Throwable)e);
        }
        return null;
    }

    private void parseEntityNameFromFilter(QFilter filter, Map refEntityNames, int level) {
        List<QFilter.QFilterNest> nestFilters;
        if (filter == null || level > 5) {
            return;
        }
        String propF = filter.getProperty();
        if (propF.indexOf(46) > 0) {
            String[] subEntitys = propF.split("\\.");
            Map _entitys = refEntityNames;
            for (int i = 0; i < subEntitys.length - 1; ++i) {
                if (!_entitys.containsKey(subEntitys[i])) {
                    _entitys.put(subEntitys[i], new HashMap(4));
                }
                _entitys = (Map)_entitys.get(subEntitys[i]);
            }
        }
        if ((nestFilters = filter.getNests(true)) != null) {
            nestFilters.forEach(nfilter -> {
                QFilter _qf = nfilter.getFilter();
                this.parseEntityNameFromFilter(_qf, refEntityNames, level + 1);
            });
        }
    }

    private void getSubEntityFieldtype(Map entityNames, Map<String, Integer> resultFiledType, String pre, IDataEntityType subentityType) {
        DataEntityPropertyCollection fields = subentityType.getProperties();
        fields.forEach(v -> {
            Method m = this.getDbTypeMethod(v.getClass());
            if (m != null) {
                try {
                    int dbtype = (Integer)m.invoke(v, new Object[0]);
                    if (v instanceof DynamicProperty) {
                        Map nameMap;
                        DynamicProperty dp = (DynamicProperty)v;
                        String subEntityName = dp.getName();
                        resultFiledType.put(pre + "." + dp.getName(), dbtype);
                        if (dp instanceof DynamicComplexProperty && (nameMap = (Map)entityNames.get(subEntityName)) != null) {
                            DynamicComplexProperty dcp = (DynamicComplexProperty)dp;
                            DynamicObjectType subsubentityType = dcp.getDynamicComplexPropertyType();
                            this.getSubEntityFieldtype(nameMap, resultFiledType, pre + "." + subEntityName, (IDataEntityType)subsubentityType);
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        });
    }

    private void resetFilterValue(QFilter filter, int type, Object v) {
        Object vvi;
        Object[] vv;
        LinkedList<Object> list;
        if (filter.isExpressValue()) {
            return;
        }
        if (type == -5) {
            if (v == null) {
                filter.__setValue(0L);
            } else if (v instanceof String) {
                filter.__setValue(this.stringToLong((String)v));
            } else if (v instanceof Iterable) {
                list = new LinkedList<Object>();
                for (Object vvi2 : (Iterable)v) {
                    if (vvi2 instanceof String) {
                        list.add(this.stringToLong((String)vvi2));
                        continue;
                    }
                    list.add(vvi2);
                }
                filter.__setValue(list);
            } else if (v.getClass().isArray()) {
                int c = Array.getLength(v);
                vv = new Object[c];
                for (int i = 0; i < vv.length; ++i) {
                    vvi = Array.get(v, i);
                    vv[i] = vvi instanceof String ? this.stringToLong((String)vvi) : vvi;
                }
                filter.__setValue(vv);
            }
        }
        if (!(type != 12 && type != 1 || v instanceof String || v instanceof Boolean)) {
            if (v == null) {
                return;
            }
            if (v instanceof Iterable) {
                list = new LinkedList();
                for (Object vvi3 : (Iterable)v) {
                    if (!(vvi3 instanceof String) && !(vvi3 instanceof Boolean)) {
                        list.add(String.valueOf(vvi3));
                        continue;
                    }
                    list.add(vvi3);
                }
                filter.__setValue(list);
            } else if (v.getClass().isArray()) {
                int c = Array.getLength(v);
                vv = new Object[c];
                for (int i = 0; i < vv.length; ++i) {
                    vvi = Array.get(v, i);
                    vv[i] = !(vvi instanceof String) && !(vvi instanceof Boolean) ? String.valueOf(vvi) : vvi;
                }
                filter.__setValue(vv);
            } else {
                filter.__setValue(String.valueOf(v));
            }
        } else if (type == 93) {
            if (v == null) {
                filter.__setValue(new Timestamp(System.currentTimeMillis()));
            } else if (v instanceof String) {
                filter.__setValue(Timestamp.valueOf((String)v));
            }
        }
    }

    public Object stringToLong(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (Exception e) {
            throw new RuntimeException("not long value ", e);
        }
    }

    @Override
    protected int getMaxQueryJoinTableCount(String entityName, String selectFields, QFilter[] filters, String orderBys) {
        IDataEntityType dt = ORMConfiguration.innerGetDataEntityType(entityName, this.entityTypeCache);
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        DataEntityPropertyCollection fields = dt.getProperties();
        if (Boolean.getBoolean("orm.datatype.strict")) {
            this.resetFiterType(fields, filters);
        }
        MultiQuery mq = MultiQuery.create(dbRoute, dt, selectFields, false, filters, null, null, orderBys, -1, 0, Integer.MAX_VALUE, this.entityTypeCache, this.ormHint, this.optimization, null);
        return mq.getMaxQueryJoinTableCount();
    }

    @Override
    protected MultiQuery $createMultiQuery(String entityName, String selectFields, QFilter[] filters) {
        return this.createMultiQuery(entityName, selectFields, false, filters, null, null, null, -1, null);
    }

    private boolean judgeNotTopNoFilter(QFilter[] filters, boolean notTopNoFilter) {
        if (filters != null && filters.length > 0) {
            for (QFilter f : filters) {
                if (f == null) continue;
                notTopNoFilter = false;
                break;
            }
        }
        return notTopNoFilter;
    }

    private Object[] aggregateInSameDB(MultiQuery originMq, boolean shouldMerge, String[] funcs, AggregateFuncs aggregateFuncs, String entityName, QFilter[] filters, String algoKey) {
        Map<String, List<Integer>> listListMap = ORMUtil.groupBy(aggregateFuncs);
        if (listListMap.size() == 1) {
            return originMq.aggregateBySql(shouldMerge, algoKey, aggregateFuncs, filters);
        }
        Object[] result = new Object[funcs.length];
        for (Map.Entry<String, List<Integer>> next : listListMap.entrySet()) {
            List<Integer> fieldIndex = next.getValue();
            AggregateFuncs newAggFunc = ORMUtil.rebuildFuncs(fieldIndex, funcs);
            String queryFields = ORMUtil.generateSelectFields(newAggFunc);
            MultiQuery newMq = this.createMultiQuery(entityName, queryFields, false, filters, null, null, null, -1, null);
            Object[] newResult = newMq.aggregateBySql(shouldMerge, algoKey, newAggFunc, filters);
            if (newResult == null || newResult.length <= 0) continue;
            for (int i = 0; i < newResult.length; ++i) {
                result[fieldIndex.get((int)i).intValue()] = newResult[i];
            }
        }
        return result;
    }

    static {
        ConfigurationUtil.observeBoolean((String)ORM_DUMP_METACACHE_ON_ERROR, (boolean)dumpMetaCacheOnError, v -> {
            dumpMetaCacheOnError = v;
        });
    }
}

