/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.impl;

import kd.bos.db.tx.JoinInSameDBStrategy;
import kd.bos.orm.query.JoinInSameDBStrategyCtrl;
import kd.bos.util.ConfigurationUtil;

public class ORMOptimization {
    private static final String orm_opt_pageSize = "orm.opt.pageSize";
    private static final String orm_opt_roleOnCostThreshold = "orm.opt.roleOnCostThreshold";
    private static final String orm_opt_rootForcePushDownCostThreshold = "orm.opt.rootForcePushDownCostThreshold";
    private static final String orm_opt_forcePushToRoot = "orm.opt.forcePushToRoot";
    private static final String orm_opt_forcePushEnabled = "orm.opt.forcePushEnabled";
    private static int default_pageSize = 1000;
    private static int default_roleOnCostThreshold = 2000;
    private static int default_rootForcePushDownCostThreshold = 1000;
    private static boolean default_forcePushToRoot = false;
    private static boolean default_forcePushEnabled = true;
    private boolean isTurnOff = false;
    private boolean reduceUnnessesaryJoin = true;
    private boolean joinInSameDatabase = true;
    private boolean roleOnPK = true;
    private boolean roleOnCost = true;
    private int pageSize = default_pageSize;
    private int roleOnCostThreshold = default_roleOnCostThreshold;
    private int rootForcePushDownCostThreshold = default_rootForcePushDownCostThreshold;
    private boolean forcePushToRoot = default_forcePushToRoot;
    private boolean forcePushEnabled = default_forcePushEnabled;

    public ORMOptimization() {
        this.joinInSameDatabase = JoinInSameDBStrategyCtrl.first() != JoinInSameDBStrategy.no_join;
    }

    public boolean isJoinInSameDatabase() {
        return this.joinInSameDatabase;
    }

    public void setJoinInSameDatabase(boolean joinInSameDatabase) {
        this.joinInSameDatabase = joinInSameDatabase;
    }

    public boolean isReduceUnnessesaryJoin() {
        return this.reduceUnnessesaryJoin;
    }

    public void setReduceUnnessesaryJoin(boolean reduceUnnessesaryJoin) {
        this.reduceUnnessesaryJoin = reduceUnnessesaryJoin;
    }

    public boolean isRoleOnPK() {
        return this.roleOnPK;
    }

    public void setRoleOnPK(boolean roleOnPK) {
        this.roleOnPK = roleOnPK;
    }

    public boolean isRoleOnCost() {
        return this.roleOnCost;
    }

    public void setRoleOnCost(boolean roleOnCost) {
        this.roleOnCost = roleOnCost;
    }

    public int getRoleOnCostThreshold() {
        return this.roleOnCostThreshold;
    }

    public int getRootForcePushDownCostThreshold() {
        return this.rootForcePushDownCostThreshold;
    }

    public void setRoleOnCostThreshold(int roleOnCostThreshold) {
        this.roleOnCostThreshold = roleOnCostThreshold;
    }

    public boolean isTurnOff() {
        return this.isTurnOff;
    }

    public boolean isForcePushToRoot() {
        return this.forcePushToRoot;
    }

    public boolean isForcePushEnabled() {
        return this.forcePushEnabled;
    }

    public void turnOff(boolean turnOff) {
        this.isTurnOff = turnOff;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    static {
        ConfigurationUtil.observeInteger((String)orm_opt_pageSize, (int)default_pageSize, v -> {
            default_pageSize = v;
        });
        ConfigurationUtil.observeInteger((String)orm_opt_roleOnCostThreshold, (int)default_roleOnCostThreshold, v -> {
            default_roleOnCostThreshold = v <= 0 ? Integer.MAX_VALUE : v;
        });
        ConfigurationUtil.observeInteger((String)orm_opt_rootForcePushDownCostThreshold, (int)default_rootForcePushDownCostThreshold, v -> {
            default_rootForcePushDownCostThreshold = v;
        });
        ConfigurationUtil.observeBoolean((String)orm_opt_forcePushToRoot, (boolean)default_forcePushToRoot, v -> {
            default_forcePushToRoot = v;
        });
        ConfigurationUtil.observeBoolean((String)orm_opt_forcePushEnabled, (boolean)default_forcePushEnabled, v -> {
            default_forcePushEnabled = v;
        });
    }
}

