/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORMHint;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.EntityItemJoinProperty;
import kd.bos.orm.query.EntityItemLazyLoader;
import kd.bos.orm.query.EntityItemProperty;
import kd.bos.orm.query.MergeDBBeacon;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.multi.GroupByInfo;
import kd.bos.orm.query.multi.JoinTableInfo;
import kd.bos.orm.query.multi.JoinTableTypeEnum;
import kd.bos.orm.query.multi.OrderByInfo;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.multi.PropertySegExpress;
import kd.bos.orm.sequence.DBType;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;

public final class QContext {
    private static boolean ignoreNoneSelectObject = true;
    private final Map<String, IDataEntityType> entityTypeCache;
    private final Set<String> joinAliasSet = new HashSet<String>(5);
    private final List<JoinTableInfo> joinTableList = new ArrayList<JoinTableInfo>(5);
    private final Map<String, String> simpleEntityAliasMap;
    private final Set<String> currentSelectObjectSet = new HashSet<String>();
    private final Map<String, List<PropertyField>> selectFieldMap = new HashMap<String, List<PropertyField>>();
    private final Map<String, List<PropertyField>> performJoinFieldMap = new HashMap<String, List<PropertyField>>();
    final EntityItemLazyLoader entityItemLoader;
    private final String objectFullName;
    private final EntityItem entityItem;
    private final ORMHint ormHint;
    private final Distinctable distinctable;
    private boolean silenceHandleAllFilterAndOrderAndGroupBy;
    private PropertyField[] userSelectFields;
    private boolean allAndQFilter;
    private Set<String> gLanTransLanFullObjectNameSet;
    private final Set<EntityItem> innerJoinFilterEntityItemSet;
    private final Map<String, EntityItem> innerJoinFilterEntityItemMap;
    private static final String BOS_ORMENGINE = "bos-ormengine";
    private static final Log logger;
    private Map<String, String> replaceEntityAliasMap;
    private boolean aggregate;
    private String[] funcs;
    private boolean crossAggregateIntoSql;
    private boolean isAggregateByGroup;
    private boolean hasOrderField;

    public QContext(IDataEntityType entityType, String objectFullName, PropertyField[] fields, Map<String, IDataEntityType> entityTypeCache, ORMHint ormHint, Distinctable distinctable, boolean silenceHandleAllFilterAndOrderAndGroupBy, Map<String, String> simpleEntityAliasMap, QContext allCtx) {
        this.entityTypeCache = entityTypeCache;
        this.objectFullName = objectFullName;
        this.ormHint = ormHint;
        this.distinctable = distinctable;
        this.simpleEntityAliasMap = simpleEntityAliasMap;
        this.getSimpleEntityAlias(objectFullName);
        this.entityItemLoader = new EntityItemLazyLoader(ormHint, allCtx, entityTypeCache);
        if (allCtx == null) {
            this.entityItem = this.entityItemLoader.load(entityType, objectFullName);
            this.innerJoinFilterEntityItemSet = new HashSet<EntityItem>();
            this.innerJoinFilterEntityItemMap = new HashMap<String, EntityItem>();
        } else {
            this.entityItem = allCtx.entityItem;
            this.innerJoinFilterEntityItemSet = allCtx.innerJoinFilterEntityItemSet;
            this.innerJoinFilterEntityItemMap = allCtx.innerJoinFilterEntityItemMap;
        }
        this.addField2map(objectFullName, null, this.selectFieldMap, true);
        this.silenceHandleAllFilterAndOrderAndGroupBy = false;
        this.userSelectFields = fields;
        for (PropertyField field : fields) {
            this.putField(field, true, false);
        }
        this.silenceHandleAllFilterAndOrderAndGroupBy = silenceHandleAllFilterAndOrderAndGroupBy;
    }

    public QContext tempOf(IDataEntityType entityType, String objectFullName) {
        return new QContext(entityType, objectFullName, new PropertyField[0], this.entityTypeCache, this.ormHint, this.distinctable, this.silenceHandleAllFilterAndOrderAndGroupBy, new HashMap<String, String>(), null);
    }

    public boolean isInnerJoinEntityItem(EntityItem ei) {
        return this.innerJoinFilterEntityItemSet.contains(ei);
    }

    public void addInnerJoinEntityItem(EntityItem ei) {
        this.innerJoinFilterEntityItemSet.add(ei);
    }

    public void addInnerJoinEntityItem(String propertyName, EntityItem ei) {
        this.innerJoinFilterEntityItemMap.put(propertyName, ei);
    }

    private void ensureJoined(EntityItem ei) {
        String alias = ei.getFullObjectName().toLowerCase(Locale.ENGLISH);
        if (alias.equals(this.objectFullName)) {
            return;
        }
        if (!this.joinAliasSet.contains(alias)) {
            JoinTableTypeEnum joinTableType = ORMConfiguration.isBasedata(ei.entityType) ? JoinTableTypeEnum.basedata : JoinTableTypeEnum.entry;
            this.addJoin(ei, joinTableType, false, null);
            String pproperty = ei.getFullObjectName() + '.' + ei.entityType.getPrimaryKey().getName();
            this.putField(new PropertyField(pproperty), false, false);
        }
    }

    private void addField2map(String fullObjectName, PropertyField field, Map<String, List<PropertyField>> map, boolean add2CurrentSelectObject) {
        int dot;
        EntityItem ei;
        if (add2CurrentSelectObject) {
            boolean ignore = false;
            if ((field == null || field.getField() == null) && ignoreNoneSelectObject) {
                ignore = true;
            }
            if (!ignore) {
                this.currentSelectObjectSet.add(fullObjectName);
            }
        }
        if ((ei = this.getEntityItem(fullObjectName)) == null || ORMConfiguration.isEntryEntityType(ei.entityType)) {
            return;
        }
        List<PropertyField> list = map.get(fullObjectName);
        if (list == null) {
            list = new ArrayList<PropertyField>();
            map.put(fullObjectName, list);
        }
        if (field != null) {
            boolean exists = false;
            String fieldName = field.getFullObjectName() + "_" + field.getName() + "_" + field.getField();
            HashSet<String> aliasSet = new HashSet<String>();
            for (PropertyField property : list) {
                String propertyField = property.getFullObjectName() + "_" + property.getName() + "_" + property.getField();
                if (!fieldName.equalsIgnoreCase(propertyField)) continue;
                exists = true;
                aliasSet.add(property.getAlias());
            }
            boolean add = true;
            if (exists) {
                String annotherAlias = field.getAlias();
                String root = this.getMainFullObjectName(ei).toLowerCase();
                for (String alias : aliasSet) {
                    String aliasLow;
                    if (StringUtils.isEmpty((String)alias) && StringUtils.isEmpty((String)annotherAlias)) {
                        field.setAlias(root + "_" + field.getName());
                        break;
                    }
                    if (StringUtils.isEmpty((String)alias) || StringUtils.isEmpty((String)annotherAlias)) continue;
                    String annotherLow = annotherAlias;
                    if (annotherLow.indexOf(root + ".") != -1) {
                        annotherLow = annotherLow.substring((root + ".").length());
                    }
                    if ((aliasLow = alias).indexOf(root + ".") != -1) {
                        aliasLow = aliasLow.substring((root + ".").length());
                    }
                    if (!annotherLow.equalsIgnoreCase(aliasLow)) continue;
                    add = false;
                    break;
                }
            }
            if (add) {
                list.add(field);
            }
        }
        if ((dot = fullObjectName.lastIndexOf(46)) != -1) {
            this.addField2map(fullObjectName.substring(0, dot), null, map, false);
        }
    }

    private String getMainFullObjectName(EntityItem ei) {
        EntityItem parentEntityItem = ei.getParentEntityItem();
        if (parentEntityItem != null) {
            return this.getMainFullObjectName(parentEntityItem);
        }
        return ei.getFullObjectName();
    }

    private PropertyField putJoinField(PropertyField field, boolean add2SelectObjectMap, boolean add2PerformJoinFieldList, QFilter joinFilter, String joinFilterProperty) {
        if (joinFilter != null) {
            String fullObjectName = field.getFullObjectName().toLowerCase();
            EntityItem ei = this.getEntityItem(fullObjectName);
            if (ei == null && (ei = this.getEntityItem(fullObjectName = fullObjectName.substring(fullObjectName.indexOf(46) + 1))) != null) {
                field.setFullObjectName(fullObjectName);
                if (ei.joinProperty == null) {
                    String property;
                    EntityItem parentEntityItem;
                    int dot = joinFilterProperty.lastIndexOf(46);
                    if (dot != -1) {
                        parentEntityItem = this.getEntityItem(joinFilterProperty.substring(0, dot));
                        if (parentEntityItem == null) {
                            throw new IllegalArgumentException(BosRes.get((String)BOS_ORMENGINE, (String)"QContext_0", (String)"The parent entity is not exists, name={0}, joinFilterProperty={1}, fullObjectName={2}.", (Object[])new Object[]{joinFilterProperty.substring(0, dot), joinFilterProperty, fullObjectName}));
                        }
                        property = joinFilterProperty.substring(dot + 1);
                    } else {
                        parentEntityItem = this.getEntityItem(this.objectFullName);
                        if (parentEntityItem == null) {
                            throw new IllegalArgumentException(BosRes.get((String)BOS_ORMENGINE, (String)"QContext_1", (String)"The parent entity is not exists\uff0cname=%1$s\uff0cfullObjectName=%2$s\u3002", (Object[])new Object[]{this.objectFullName, fullObjectName}));
                        }
                        property = joinFilterProperty;
                    }
                    String eiJoinPropertyName = joinFilter.getValue().toString().substring(fullObjectName.length() + 1);
                    ei.joinProperty = new EntityItemJoinProperty(parentEntityItem, parentEntityItem.getPropertyItem(property).getPropertyType(), ei.getPropertyItem(eiJoinPropertyName).getPropertyType());
                }
            }
            if (joinFilter.getJoinHint() == ORMHint.JoinHint.INNER) {
                this.innerJoinFilterEntityItemSet.add(ei);
                this.innerJoinFilterEntityItemMap.put(fullObjectName.toLowerCase(), ei);
            }
        }
        return this.putField(field, add2SelectObjectMap, add2PerformJoinFieldList, joinFilter == null ? null : joinFilter.getJoinHint());
    }

    private PropertyField putField(PropertyField field, boolean add2SelectObjectMap, boolean add2PerformJoinFieldList) {
        return this.putField(field, add2SelectObjectMap, add2PerformJoinFieldList, null);
    }

    private PropertyField putField(PropertyField field, boolean add2SelectObjectMap, boolean add2PerformJoinFieldList, ORMHint.JoinHint filterJoinHint) {
        String fullObjectName = field.getFullObjectName().toLowerCase(Locale.ENGLISH);
        boolean isExpress = field.isExpress();
        EntityItem ei = this.getEntityItem(fullObjectName);
        if (ei == null) {
            fullObjectName = fullObjectName.substring(fullObjectName.indexOf(46) + 1);
            field.setFullObjectName(fullObjectName);
            ei = this.getEntityItem(fullObjectName);
        }
        if (ei == null && !isExpress) {
            if (this.silenceHandleAllFilterAndOrderAndGroupBy) {
                MergeDBBeacon.markAboutHandleAllFilterAndOrderAndGroupBy();
                logger.error("PropertyNotExistsError:the entity " + this.objectFullName + " has no property '" + field.getAlias() + "'.");
                return null;
            }
            throw new RuntimeException(BosRes.get((String)BOS_ORMENGINE, (String)"QContext_2", (String)"Cannot find sub object %2$s in object %1$s, sub object is not defined in metadata, or the two are not parent-child relationships (incorrect filtering criteria: 'or' relationship is not allowed between attributes %4$s and %5$s of %3$s).", (Object[])new Object[]{this.objectFullName, fullObjectName, fullObjectName, field.getName(), this.objectFullName}));
        }
        if (ei != null) {
            boolean maybeJoinBD;
            boolean bl = maybeJoinBD = !fullObjectName.equals(this.objectFullName);
            if (ORMConfiguration.isEntryEntityType(ei.entityType)) {
                EntityItem joinEI;
                int dot;
                maybeJoinBD = false;
                do {
                    joinEI = ei;
                    this.addJoin(joinEI, JoinTableTypeEnum.entry, false, null);
                    dot = fullObjectName.lastIndexOf(46);
                } while (dot != -1 && (joinEI = this.getEntityItem(fullObjectName = fullObjectName.substring(0, dot))) != null && ORMConfiguration.isEntryEntityType(joinEI.entityType));
            }
            if (!isExpress) {
                PropertyField newPut = this.putPropertyItem(field, ei.getPropertyItem(field.getName()));
                if (newPut != null) {
                    return this.putField(newPut, add2SelectObjectMap, true);
                }
                IDataEntityProperty propertyType = field.getPeropertyType();
                field.setMultiLangProperty(ORMConfiguration.isMultiLangPropertyType(propertyType));
                if (field.isMultiLangProperty()) {
                    maybeJoinBD = false;
                    this.ensureJoined(ei);
                    String parentAlias = ei.getFullObjectName();
                    String langAlias = parentAlias + "_L";
                    field.setEntityAlias(langAlias);
                    if (ORMConfiguration.useSingleLang() && field.isGLField()) {
                        if (add2PerformJoinFieldList) {
                            EntityItem parentItem = ei.parentItem;
                            while (parentItem != null && ORMConfiguration.isEntryEntityType(parentItem.entityType)) {
                                parentItem = parentItem.parentItem;
                            }
                            if (parentItem == null) {
                                add2PerformJoinFieldList = false;
                            }
                        }
                        field.setEntityAlias(parentAlias);
                    } else {
                        this.addJoinLang(ei, parentAlias, langAlias);
                    }
                } else {
                    String tableGroup = propertyType.getTableGroup();
                    if (tableGroup != null && tableGroup.length() > 0) {
                        maybeJoinBD = false;
                        this.ensureJoined(ei);
                        String groupAlias = ei.getFullObjectName() + '_' + tableGroup;
                        field.setEntityAlias(groupAlias);
                        boolean isEntry = ORMConfiguration.isEntryEntityType(propertyType.getParent());
                        this.addJoinExtend(fullObjectName, ei, propertyType, tableGroup, groupAlias, isEntry);
                    }
                }
                if (maybeJoinBD) {
                    this.addJoin(ei, JoinTableTypeEnum.basedata, ORMConfiguration.isMulBasedata(ei.entityType), filterJoinHint);
                } else if (ORMConfiguration.isMulBasedataProp(propertyType) && field.isInnerField()) {
                    IDataEntityType entryParentDT;
                    String mulFullObjectName = ORMConfiguration.isEntryEntityType(propertyType.getParent()) ? ((entryParentDT = propertyType.getParent().getParent()) != null && ORMConfiguration.isEntryEntityType(entryParentDT) ? fullObjectName + '.' + entryParentDT.getName() + '.' + propertyType.getParent().getName() + '.' + propertyType.getName() : fullObjectName + '.' + propertyType.getParent().getName() + '.' + propertyType.getName()) : fullObjectName + '.' + propertyType.getName();
                    EntityItem mulEI = this.getEntityItem(mulFullObjectName);
                    this.addJoin(mulEI, JoinTableTypeEnum.basedata, true, filterJoinHint);
                    EntityItemProperty pi = mulEI.getPropertyItem(mulEI.entityType.getPrimaryKey().getName());
                    this.putPropertyItem(field, pi);
                    String fieldName = mulEI.entityType.getPrimaryKey().getAlias();
                    ((DynamicProperty)propertyType).setAlias(fieldName);
                    PropertyField mainPKField = new PropertyField(mulFullObjectName + '.' + mulEI.entityType.getPrimaryKey().getName());
                    this.putField(mainPKField, true, false);
                }
            }
            if (add2SelectObjectMap) {
                this.addField2map(fullObjectName, field, this.selectFieldMap, true);
            }
            if (add2PerformJoinFieldList) {
                this.addField2map(fullObjectName, field, this.performJoinFieldMap, true);
                this.addField2map(fullObjectName, null, this.selectFieldMap, true);
            }
        }
        if (field.isExpress()) {
            this.performJoin(field.getPropertySegExpress());
        }
        return field;
    }

    private void addJoinLang(EntityItem ei, String parentAlias, String langAlias) {
        if (this.joinAliasSet.contains(langAlias.toLowerCase())) {
            return;
        }
        this.joinAliasSet.add(langAlias.toLowerCase());
        JoinTableInfo join = new JoinTableInfo(ei, JoinTableTypeEnum.multi_lang);
        join.setTable(ei.entityType.getAlias() + "_L");
        EntityItem entityItem = this.innerJoinFilterEntityItemMap.get(ei.getFullObjectName() + "_L");
        if (ORMHint.isInnerJoinConfigured(join.getTable())) {
            join.setJoin(ORMHint.JoinHint.INNER);
        } else if (ORMUtil.useInnerJoin(this.ormHint) && entityItem != null && entityItem.equals(ei)) {
            join.setJoin(ORMHint.JoinHint.INNER);
        } else {
            join.setJoin(this.ormHint.joinHint(ORMUtil.getFullObjNameWithoutRoot(parentAlias)));
        }
        join.setTableAlias(langAlias);
        String joinField = ei.entityType.getPrimaryKey().getAlias();
        join.setField(joinField);
        join.setJoinField(joinField);
        join.setJoinTableAlias(parentAlias);
        join.setAndExpress(this.getSimpleEntityAlias(langAlias) + '.' + "FLocaleId" + "='" + this.ormHint.getLang() + '\'');
        this.joinTableList.add(join);
    }

    private void addJoinExtend(String fullObjectName, EntityItem ei, IDataEntityProperty propertyType, String tableGroup, String groupAlias, boolean isEntry) {
        String joinTableAlias;
        String joinField;
        if (this.joinAliasSet.contains(groupAlias.toLowerCase())) {
            return;
        }
        this.joinAliasSet.add(groupAlias.toLowerCase());
        JoinTableInfo join = new JoinTableInfo(ei, JoinTableTypeEnum.extend);
        String tableName = (isEntry ? propertyType.getParent().getAlias() : ei.entityType.getAlias()) + '_' + tableGroup;
        join.setTable(tableName);
        EntityItem entityItem = this.innerJoinFilterEntityItemMap.get(ei.getFullObjectName() + "_" + tableGroup);
        if (ORMHint.isInnerJoinConfigured(join.getTable())) {
            join.setJoin(ORMHint.JoinHint.INNER);
        } else if (ORMUtil.useInnerJoin(this.ormHint) && entityItem != null && entityItem.equals(ei)) {
            join.setJoin(ORMHint.JoinHint.INNER);
        } else {
            join.setJoin(this.ormHint.joinHint(ORMUtil.getFullObjNameWithoutRoot(fullObjectName)));
        }
        join.setTableAlias(groupAlias);
        if (isEntry) {
            joinField = propertyType.getParent().getPrimaryKey().getAlias();
            joinTableAlias = ei.getFullObjectName();
        } else {
            joinField = ei.entityType.getPrimaryKey().getAlias();
            joinTableAlias = fullObjectName;
        }
        join.setField(joinField);
        join.setJoinField(joinField);
        join.setJoinTableAlias(joinTableAlias);
        this.joinTableList.add(join);
    }

    private void addJoin(EntityItem joinEntityItem, JoinTableTypeEnum joinTableType, boolean baseDataAndMul, ORMHint.JoinHint filterJoinHint) {
        String tableGroup;
        if (joinEntityItem.joinProperty == null) {
            return;
        }
        String joinAlias = joinEntityItem.getFullObjectName();
        if (this.joinAliasSet.contains(joinAlias)) {
            return;
        }
        this.joinAliasSet.add(joinAlias);
        JoinTableInfo join = new JoinTableInfo(joinEntityItem, joinTableType);
        join.setTable(joinEntityItem.entityType.getAlias());
        EntityItem innerJoinentityItem = this.innerJoinFilterEntityItemMap.get(joinEntityItem.getFullObjectName());
        if (this.innerJoinFilterEntityItemSet.contains(joinEntityItem) && innerJoinentityItem != null && innerJoinentityItem.equals(joinEntityItem)) {
            join.setJoin(ORMHint.JoinHint.INNER);
        } else if (ORMHint.isInnerJoinConfigured(join.getTable())) {
            join.setJoin(ORMHint.JoinHint.INNER);
        } else {
            join.setJoin(this.ormHint.joinHint(ORMUtil.getFullObjNameWithoutRoot(joinAlias)));
        }
        join.setTableAlias(joinAlias);
        if (joinTableType == JoinTableTypeEnum.entry) {
            if (joinEntityItem.parentItem != null) {
                join.setField(joinEntityItem.getFkFieldName());
            } else {
                join.setField(joinEntityItem.joinProperty.getSubJoinPropertyType().getAlias());
            }
        } else {
            if (!baseDataAndMul) {
                baseDataAndMul = ORMConfiguration.isMulBasedataProp(joinEntityItem.joinProperty.getParentJoinPropertyType());
            }
            if (baseDataAndMul) {
                if (joinEntityItem.parentItem != null) {
                    join.setField(joinEntityItem.parentItem.entityType.getPrimaryKey().getAlias());
                } else {
                    join.setField(joinEntityItem.joinProperty.getSubJoinPropertyType().getAlias());
                }
            } else {
                join.setField(joinEntityItem.joinProperty.getSubJoinPropertyType().getAlias());
            }
        }
        String joinField = joinEntityItem.joinProperty.getParentJoinPropertyType().getAlias();
        if (joinField == null || joinField.length() == 0) {
            joinField = joinEntityItem.parentItem.entityType.getPrimaryKey().getAlias();
        }
        EntityItem parentEI = joinEntityItem.joinProperty.getParentEntityItem();
        String parentAlias = parentEI.getFullObjectName();
        IDataEntityType joinPropertyDT = joinEntityItem.joinProperty.getParentJoinPropertyType().getParent();
        if (ORMConfiguration.isMultiLangDataEntityType(joinPropertyDT)) {
            parentAlias = parentAlias + "_L";
        }
        join.setJoinTableAlias(parentAlias);
        if (baseDataAndMul) {
            join.setJoinField(join.getField());
        } else {
            join.setJoinField(joinField);
        }
        if (parentEI != this.entityItem && !this.joinAliasSet.contains(parentAlias)) {
            String pproperty = parentEI.getFullObjectName() + "." + parentEI.entityType.getPrimaryKey().getName();
            this.putField(new PropertyField(pproperty), false, false);
        }
        if ((tableGroup = joinEntityItem.joinProperty.getParentJoinPropertyType().getTableGroup()) != null && tableGroup.length() > 0) {
            String groupAlias;
            String fullObjectName;
            boolean isEntry = ORMConfiguration.isEntryEntityType(parentEI.entityType);
            if (isEntry) {
                fullObjectName = parentAlias.substring(0, parentAlias.lastIndexOf(46));
                groupAlias = fullObjectName + '.' + parentEI.entityType.getName() + '_' + tableGroup;
            } else {
                fullObjectName = parentAlias;
                groupAlias = parentAlias + '_' + tableGroup;
            }
            join.setJoinTableAlias(groupAlias);
            this.addJoinExtend(fullObjectName, parentEI, joinEntityItem.joinProperty.getParentJoinPropertyType(), tableGroup, groupAlias, isEntry);
        }
        this.joinTableList.add(join);
    }

    private PropertyField putPropertyItem(PropertyField field, EntityItemProperty pi) {
        if (ORMConfiguration.isEntryProPropertyType(pi.getPropertyType())) {
            IDataEntityType itemType = ((ICollectionProperty)pi.getPropertyType()).getItemType();
            PropertyField ret = new PropertyField(pi.getEntityItem().getFullObjectName() + '.' + field.getName(), itemType.getPrimaryKey().getName(), field.getAlias());
            EntityItem ei = pi.getEntityItem().toEntityItemMap().get(ret.getFullObjectName());
            pi = ei.getPropertyItem(ei.entityType.getPrimaryKey().getName());
            ret.setEntityAlias(pi.getEntityItem().getFullObjectName());
            ret.setEntityType(pi.getEntityItem().entityType);
            ret.setPeropertyType(pi.getPropertyType());
            ret.setField(pi.getPropertyType().getAlias());
            field.setEntityAlias(pi.getEntityItem().getFullObjectName());
            field.setEntityType(pi.getEntityItem().entityType);
            field.setPeropertyType(pi.getPropertyType());
            field.setField(pi.getPropertyType().getAlias());
            return ret;
        }
        field.setEntityAlias(pi.getEntityItem().getFullObjectName());
        field.setEntityType(pi.getEntityItem().entityType);
        field.setPeropertyType(pi.getPropertyType());
        if (ORMConfiguration.isMulBasedataProp(pi.getPropertyType())) {
            field.setField(pi.getPropertyType().getParent().getPrimaryKey().getAlias());
        } else {
            field.setField(pi.getPropertyType().getAlias());
        }
        field.setPropertyItem(pi);
        return null;
    }

    public PropertyField addSelectField(PropertyField field) {
        return this.putField(field, true, false);
    }

    public List<JoinTableInfo> getJoinTableList() {
        return this.joinTableList;
    }

    public String getGroupBy(GroupByInfo ... groupBys) {
        StringBuilder sb = new StringBuilder();
        for (GroupByInfo groupBy : groupBys) {
            this.performJoin(groupBy.getPropertySegExpress());
            sb.append(groupBy.toGroupByString(this));
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public String getOrderBy(OrderByInfo ... orderBys) {
        StringBuilder sb = new StringBuilder();
        for (OrderByInfo orderBy : orderBys) {
            this.performJoin(orderBy.getPropertySegExpress());
            sb.append(orderBy.toOrderByString(this));
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public String getSelects(String defaultEntityAlias, PropertyField ... selectFields) {
        return this.getSelects0(defaultEntityAlias, false, selectFields);
    }

    public String getSelects(String defaultEntityAlias, boolean distinct, PropertyField ... selectFields) {
        return this.getSelects0(defaultEntityAlias, distinct, selectFields);
    }

    private void performJoin(PropertySegExpress pse) {
        List<String> pns = pse.getFullPropertyNames();
        if (pns.size() > 0) {
            String rootObjName = this.getRootObjName();
            for (String propertyName : pns) {
                String fullPropertyName = rootObjName + "." + propertyName;
                PropertyField pf = this.putField(new PropertyField(fullPropertyName), false, true);
                pse.putFieldMap(fullPropertyName, pf);
            }
        }
    }

    private String getRootObjName() {
        int dot = this.objectFullName.indexOf(46);
        String rootObjName = dot == -1 ? this.objectFullName : this.objectFullName.substring(0, dot);
        return rootObjName;
    }

    public String getSimpleEntityAlias(String entityAlias) {
        String simpleAlias;
        String replaceAlias;
        if (this.replaceEntityAliasMap != null && !this.replaceEntityAliasMap.isEmpty() && (replaceAlias = this.replaceEntityAliasMap.get(entityAlias.toLowerCase())) != null) {
            entityAlias = replaceAlias;
        }
        if ((simpleAlias = this.simpleEntityAliasMap.get(entityAlias.toLowerCase())) == null) {
            char ch = (char)(65 + this.simpleEntityAliasMap.size());
            simpleAlias = ch <= 'Z' ? String.valueOf(ch) : "T" + String.valueOf(this.simpleEntityAliasMap.size() - 26);
            this.simpleEntityAliasMap.put(entityAlias.toLowerCase(), simpleAlias);
        }
        return simpleAlias;
    }

    public Map<String, String> getSimpleEntityAliasMap() {
        return this.simpleEntityAliasMap;
    }

    public void setReplaceEntityAliasMap(Map<String, String> langReplaceMainAliasMap) {
        this.replaceEntityAliasMap = langReplaceMainAliasMap;
    }

    public Map<String, List<PropertyField>> getSelectObjectMap() {
        return this.selectFieldMap;
    }

    public Set<String> getCurrentSelectObjectSet() {
        return this.currentSelectObjectSet;
    }

    public EntityItem getMainEntityItem() {
        return this.entityItem;
    }

    public EntityItem getEntityItem(String fullObjectName) {
        return this.entityItemLoader.load(fullObjectName.toLowerCase(Locale.ENGLISH));
    }

    public PropertyField putPerformJoinField(PropertyField field, QFilter joinFilter, String joinFilterProperty) {
        if (field == null || field.getFullName() == null) {
            return null;
        }
        List<PropertyField> list = this.performJoinFieldMap.get(field.getFullName().toLowerCase());
        if (list != null) {
            for (PropertyField pf : list) {
                if (!pf.isSameWith(field)) continue;
                return pf;
            }
        }
        return this.putJoinField(field, false, true, joinFilter, joinFilterProperty);
    }

    public PropertyField putPerformJoinField(PropertyField field) {
        return this.putPerformJoinField(field, null, null);
    }

    public List<PropertyField> getPerformJoinFieldList(String fullObjectName) {
        return this.performJoinFieldMap.get(fullObjectName);
    }

    public ORMHint getORMHint() {
        return this.ormHint;
    }

    public Distinctable getDistinctable() {
        return this.distinctable;
    }

    public Map<String, IDataEntityType> getEntityTypeCache() {
        return this.entityTypeCache;
    }

    public PropertyField[] getUserSelectFields() {
        return this.userSelectFields;
    }

    public void setUserSelectFields(PropertyField[] userSelectFields) {
        this.userSelectFields = userSelectFields;
    }

    public boolean isAllAndQFilter() {
        return this.allAndQFilter;
    }

    public void setAllAndQFilter(boolean allAndQFilter) {
        this.allAndQFilter = allAndQFilter;
    }

    public boolean isAggregate() {
        return this.aggregate;
    }

    public void setAggregate(boolean aggregate) {
        this.aggregate = aggregate;
    }

    public String[] getFuncs() {
        return this.funcs;
    }

    public void setFuncs(String[] funcs) {
        this.funcs = funcs;
    }

    public boolean isCrossAggregateIntoSql() {
        return this.crossAggregateIntoSql;
    }

    public void setCrossAggregateIntoSql(boolean crossAggregateIntoSql) {
        this.crossAggregateIntoSql = crossAggregateIntoSql;
    }

    public boolean isAggregateByGroup() {
        return this.isAggregateByGroup;
    }

    public void setAggregateByGroup(boolean aggregateByGroup) {
        this.isAggregateByGroup = aggregateByGroup;
    }

    private boolean isLargeText(PropertyField propertyField) {
        if (propertyField.getEntityType() != null) {
            IDataEntityType entityType = propertyField.getEntityType();
            IDataEntityProperty peropertyType = propertyField.getPeropertyType();
            String name = peropertyType.getName();
            if (name.toLowerCase(Locale.ENGLISH).endsWith("_tag")) {
                int tag = name.lastIndexOf("_tag");
                String realName = name.substring(0, tag);
                IDataEntityProperty property = (IDataEntityProperty)entityType.getProperties().get((Object)realName);
                if (property != null && "kd.bos.entity.property.LargeTextProp".equalsIgnoreCase(property.getClass().getName())) {
                    return true;
                }
            }
        }
        return false;
    }

    private String getSelects0(String defaultEntityAlias, boolean distinct, PropertyField ... selectFields) {
        StringBuilder sql = new StringBuilder(256);
        HashSet<String> aliasSet = new HashSet<String>(4);
        DBType dbType = null;
        for (PropertyField propertyField : selectFields) {
            String alias;
            String name;
            boolean addToChar;
            if (!propertyField.isExpress() && propertyField.getEntityAlias().length() == 0) {
                propertyField.setEntityAlias(defaultEntityAlias);
            }
            if (dbType == null) {
                dbType = this.getDBType(propertyField);
            }
            boolean bl = addToChar = distinct && dbType != null && dbType == DBType.Oracle && this.isLargeText(propertyField);
            if (addToChar) {
                name = propertyField.toSelectField(false, this);
                alias = "to_char(" + name + ")" + propertyField.genShortAlias(name, false);
            } else {
                alias = propertyField.toSelectField(true, this);
            }
            if (aliasSet.add(alias)) {
                sql.append(alias);
            } else {
                if (addToChar) {
                    name = propertyField.toSelectField(false, this);
                    alias = "to_char(" + name + ")" + propertyField.genShortAlias(name, true);
                } else {
                    alias = propertyField.toSelectField(true, true, this);
                }
                sql.append(alias);
            }
            sql.append(", ");
        }
        if (sql.length() == 0) {
            sql.append("1 INNER__NONE");
        } else {
            sql.setLength(sql.length() - 2);
        }
        return sql.toString();
    }

    public void setHasOrderField(boolean hasOrderField) {
        this.hasOrderField = hasOrderField;
    }

    public boolean isHasOrderField() {
        return this.hasOrderField;
    }

    private DBType getDBType(PropertyField propertyField) {
        IDataEntityType entityType = propertyField.getEntityType();
        if (entityType == null) {
            return null;
        }
        String dbRouteKey = entityType.getDBRouteKey();
        if (dbRouteKey == null || dbRouteKey.trim().length() == 0) {
            return null;
        }
        return ORMUtil.getDBType(dbRouteKey);
    }

    public Set<String> getgLanTransLanFullObjectNameSet() {
        if (this.gLanTransLanFullObjectNameSet == null) {
            this.gLanTransLanFullObjectNameSet = new HashSet<String>();
        }
        return this.gLanTransLanFullObjectNameSet;
    }

    public Map<String, String> getReplaceEntityAliasMap() {
        return this.replaceEntityAliasMap;
    }

    static {
        ConfigurationUtil.observeBoolean((String)"orm.ignoreNoneSelectObject", (boolean)ignoreNoneSelectObject, v -> {
            ignoreNoneSelectObject = v;
        });
        logger = LogFactory.getLog(QContext.class);
    }
}

