/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IJoinProperty;
import kd.bos.exception.KDExceptionKit;
import kd.bos.orm.ORMHint;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.FTLikeHint;
import kd.bos.orm.query.LikeHint;
import kd.bos.orm.query.MergeDBBeacon;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.NotLikeHint;
import kd.bos.orm.query.QCP;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilterEvaluator;
import kd.bos.orm.query.QFilterHint;
import kd.bos.orm.query.QFilterUtil;
import kd.bos.orm.query.QFilterValue;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.orm.query.optimize.QueryTreeNode;
import kd.bos.orm.query.oql.g.expr.SelectFields;
import kd.bos.orm.query.oql.g.expr.WhereQFilters;
import kd.bos.orm.query.privacy.PrivacyDataQuery;
import kd.bos.orm.util.StringUtils;
import kd.bos.xdb.merge.resultset.ObjectConverter;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class QFilter
implements QCP,
Serializable {
    private static final long serialVersionUID = -7194347055529047190L;
    private String property;
    private String cp;
    private Object value;
    private boolean expressValue;
    private boolean parseExpressValue = true;
    private List<QFilterNest> nests = new LinkedList<QFilterNest>();
    private static final String JOINSQL_ENTITYPATH_PREFIX = "_JOINSQL_";
    private static final String FILTER_ON_METAPROPERTY_ENTITYPATH_PREFIX = "_FILTERONMETAPROPERTY_";
    private static final String JOINFILTER_ENTITYPATH_PREFIX = "_JOINFILTER_";
    private String joinEntityPath;
    private boolean innerJoin;
    private boolean joinThisEntity;
    private boolean existsFilter;
    private boolean parseExistsValue;
    private QueryTreeNode subQueryNode;
    private transient QParameter selfDefinedQParameter = null;
    private transient PropertyField parsedProperty;
    private transient PropertyField parsedExpressValue;
    private transient List<PropertyField> parsedPropertyFields;
    private transient boolean isPrivacyQFilter;
    private QFilterHint qFilterHint;
    private static final String EXP_EQ = "1=1";
    private static final String EXP_NE = "1!=1";
    private static final String BOS_ORMENGINE = "bos-ormengine";
    private static final String KD_BOS = "kd.bos.";
    private static final String SERIALIZE_CHARSET = "UTF-8";
    private static final String WRITE_OBJECT_VERSION = "v1";
    private static final String WRITE_OBJECT_HEADERCONTENT_PREFIX = "=";

    public static QFilter of(String exp, Object ... params) {
        return new QFilter(exp, params);
    }

    public static QFilter join(String property, String joinEntityProperty, QFilter filter) {
        QFilter joinFilter = new QFilter(property, WRITE_OBJECT_HEADERCONTENT_PREFIX, (Object)joinEntityProperty, true);
        String joinEntityPath = joinEntityProperty.substring(0, joinEntityProperty.lastIndexOf(46));
        joinFilter.__setJoinEntityPath("_JOINFILTER_." + joinEntityPath);
        joinFilter.innerJoin = true;
        joinFilter.joinThisEntity = true;
        if (filter != null) {
            filter.__setJoinEntityPath("_JOINFILTER_." + joinEntityPath);
        }
        return filter == null ? joinFilter : joinFilter.and(filter);
    }

    public static QFilter join(String property, String joinEntityProperty, QFilter filter, ORMHint.JoinHint joinHint, boolean joinThisEntity) {
        QFilter joinFilter = new QFilter(property, WRITE_OBJECT_HEADERCONTENT_PREFIX, (Object)joinEntityProperty, true);
        String joinEntityPath = joinEntityProperty.substring(0, joinEntityProperty.lastIndexOf(46));
        joinFilter.__setJoinEntityPath("_JOINFILTER_." + joinEntityPath);
        joinFilter.innerJoin = joinHint == ORMHint.JoinHint.INNER;
        joinFilter.joinThisEntity = joinThisEntity;
        if (filter != null) {
            filter.__setJoinEntityPath("_JOINFILTER_." + joinEntityPath);
        }
        return filter == null ? joinFilter : joinFilter.and(filter);
    }

    public static QFilter join(String property, String joinEntityProperty) {
        return QFilter.join(property, joinEntityProperty, null);
    }

    public static QFilter filterOnMetaJoinProperty(String joinOnEntityPath, QFilter joinOnFilter) {
        joinOnFilter.__setJoinEntityPath("_FILTERONMETAPROPERTY_." + joinOnEntityPath);
        joinOnFilter.innerJoin = true;
        return joinOnFilter;
    }

    public static QFilter joinSQL(String joinEntity, String joinSQL, Object[] params) {
        QFilter filter = new QFilter();
        filter.property = joinSQL;
        filter.cp = WRITE_OBJECT_HEADERCONTENT_PREFIX;
        filter.value = params;
        filter.expressValue = true;
        filter.__setJoinEntityPath("_JOINSQL_." + joinEntity);
        return filter;
    }

    @SdkInternal
    public static QFilter contains(String property, String value) {
        return new QFilter(property, "ftlike", value);
    }

    public static QFilter ftlike(String value, String ... properties) {
        return QMatches.ftlike(new String[]{value}, properties);
    }

    @SdkInternal
    public static QFilter ftlike(boolean leftMatch, String value, String ... properties) {
        return QMatches.ftlike(new String[]{value}, leftMatch, properties);
    }

    public static QFilter ftlike(String[] values, String ... properties) {
        return QMatches.ftlike(values, properties);
    }

    @SdkInternal
    public static QFilter ftlike(boolean leftMatch, String[] values, String ... properties) {
        return QMatches.ftlike(values, leftMatch, properties);
    }

    public static QFilter ftlikeMultiValue(String value, String ... properties) {
        return QMatches.ftlikeMultiValue(new String[]{value}, properties);
    }

    public static QFilter ftlikeMultiValue(String[] values, String ... properties) {
        return QMatches.ftlikeMultiValue(values, properties);
    }

    @Deprecated
    @SdkInternal
    public static QFilter match(String value, String ... properties) {
        return QMatches.ftlike(new String[]{value}, properties);
    }

    @Deprecated
    @SdkInternal
    public static QFilter match(String[] values, String ... properties) {
        return QMatches.ftlike(values, properties);
    }

    @Deprecated
    @SdkInternal
    public static QFilter matchMultiValue(String value, String ... properties) {
        return QMatches.ftlikeMultiValue(new String[]{value}, properties);
    }

    @Deprecated
    @SdkInternal
    public static QFilter matchMultiValue(String[] values, String ... properties) {
        return QMatches.ftlikeMultiValue(values, properties);
    }

    public static QFilter like(String property, String value) {
        return new QFilter(property, "like", QMatches.appendWildcard(value));
    }

    @SdkInternal
    public static QFilter likeUnEscape(String property, String value) {
        return new QFilter(property, "like", QMatches.appendWildcard(value));
    }

    public static QFilter notLike(String property, String value) {
        return new QFilter(property, "not like", QMatches.appendWildcard(value));
    }

    @SdkInternal
    public static QFilter notLikeUnEscape(String property, String value) {
        return new QFilter(property, "not like", QMatches.appendWildcard(value));
    }

    public static QFilter emptyOrNotExists(String property) {
        QFilter filter = QFilter.notExists(property);
        int currentDot = property.indexOf(".");
        while (currentDot != -1) {
            filter.or(QFilter.notExists(property.substring(0, currentDot)));
            currentDot = property.indexOf(".", currentDot + 1);
        }
        return filter;
    }

    public static QFilter notEqualsContainsEmpty(String property, String value) {
        if (StringUtils.isEmpty(value)) {
            return QFilter.emptyCondition(property);
        }
        QFilter filter = new QFilter(property, "!=", value);
        QFilter.orEmptyCondition(property, filter);
        return filter;
    }

    public static QFilter notLikeContainsEmpty(String property, String value) {
        if (StringUtils.isEmpty(value)) {
            return QFilter.emptyCondition(property);
        }
        QFilter filter = new QFilter(property, "not like", (Object)value, QFilterHint.NOT_CONTAINS);
        QFilter.orEmptyConditionNew(property, filter);
        return filter;
    }

    public static QFilter notInContainsEmpty(String property, Object value) {
        QFilter filter = new QFilter(property, "not in", value);
        QFilter.orEmptyCondition(property, filter);
        return filter;
    }

    private static QFilter emptyCondition(String property) {
        QFilter filter = QFilter.exists(property);
        int currentDot = property.indexOf(".");
        while (currentDot != -1) {
            filter.and(QFilter.exists(property.substring(0, currentDot)));
            currentDot = property.indexOf(".", currentDot + 1);
        }
        return filter;
    }

    private static void orEmptyCondition(String property, QFilter filter) {
        int currentDot = property.indexOf(".");
        while (currentDot != -1) {
            filter.or(QFilter.notExists(property.substring(0, currentDot)));
            currentDot = property.indexOf(".", currentDot + 1);
        }
    }

    private static void orEmptyConditionNew(String property, QFilter filter) {
        filter.or(QFilter.notExists(property));
        int currentDot = property.indexOf(".");
        while (currentDot != -1) {
            filter.or(QFilter.notExists(property.substring(0, currentDot)));
            currentDot = property.indexOf(".", currentDot + 1);
        }
    }

    public static QFilter exists(String refEntityPKProperty) {
        return new QFilter(refEntityPKProperty, "!=", QEmptyValue.value);
    }

    public static QFilter notExists(String refEntityPKProperty) {
        return new QFilter(refEntityPKProperty, WRITE_OBJECT_HEADERCONTENT_PREFIX, QEmptyValue.value);
    }

    public static QFilter exists(String fkProperty, QFilter refObjectFilter) {
        QFilter.setProperty(fkProperty, refObjectFilter);
        return new QFilter(fkProperty, "exists", new QFilterValue(refObjectFilter));
    }

    public static QFilter notExists(String fkProperty, QFilter refObjectFilter) {
        QFilter.setProperty(fkProperty, refObjectFilter);
        return new QFilter(fkProperty, "not exists", new QFilterValue(refObjectFilter));
    }

    public static QFilter isNull(String property) {
        return new QFilter(property, "is null", null);
    }

    public static QFilter isNotNull(String property) {
        return new QFilter(property, "is not null", null);
    }

    @SdkInternal
    public static QFilter sqlExpress(String property, String cp, String sql) {
        QFilter q = new QFilter(property, cp, (Object)sql, true);
        q.parseExpressValue = false;
        return q;
    }

    @Deprecated
    @SdkInternal
    public static QFilter parse(String exp, Object ... params) {
        return QFilter.of(exp, params);
    }

    @Deprecated
    @SdkInternal
    public static QFilter and(QFilter f1, QFilter f2) {
        return f1.and(f2);
    }

    @Deprecated
    @SdkInternal
    public static QFilter or(QFilter f1, QFilter f2) {
        return f1.or(f2);
    }

    private QFilter() {
    }

    private QFilter(String exp, Object[] params) {
        int pcount;
        WhereQFilters wf = WhereQFilters.parseFrom(exp);
        QFilter root = wf.createQFilter(params);
        int n = pcount = params == null ? 0 : params.length;
        if (pcount != wf.usedParamCount()) {
            throw new IllegalArgumentException(BosRes.get((String)BOS_ORMENGINE, (String)"QFilter_0", (String)"The size of Parameters not match\uff1a%s\u3002", (Object[])new Object[]{exp}));
        }
        this.property = root.property;
        this.cp = root.cp;
        this.value = root.value;
        this.expressValue = root.expressValue;
        this.nests = root.nests;
        for (QFilterNest nest : this.nests) {
            nest.parent = this;
        }
    }

    public QFilter(String property, String cp, Object value) {
        this(property, cp, value, false);
    }

    public QFilter(String property, String cp, Object value, QFilterHint qFilterHint) {
        this(property, cp, value, false);
        this.checkQFilter(qFilterHint);
        this.qFilterHint = qFilterHint;
    }

    @SdkInternal
    public QFilter(String property, String cp, Object value, boolean expressValue) {
        if (property == null && cp != null) {
            if ("is null".equalsIgnoreCase(cp.trim())) {
                property = "1";
                cp = WRITE_OBJECT_HEADERCONTENT_PREFIX;
                value = 1;
            } else if ("is not null".equalsIgnoreCase(cp.trim())) {
                property = "1";
                cp = "!=";
                value = 1;
            }
        }
        this.__setProperty(property);
        this.__setCP(cp);
        this.value = value;
        this.expressValue = expressValue;
        this.transferNull(cp, value);
        this.transferMultiBaseData(value);
    }

    public QFilter or(QFilter p) {
        return this.addNest(p, "OR");
    }

    public QFilter or(String property, String cp, Object value) {
        return this.or(new QFilter(property, cp, value));
    }

    public QFilter and(QFilter p) {
        return this.addNest(p, "AND");
    }

    private QFilter addNest(QFilter p, String op) {
        if (p != null) {
            if ("OR".equals(op) && !Objects.equals(p.joinEntityPath, this.joinEntityPath)) {
                throw new IllegalArgumentException(BosRes.get((String)BOS_ORMENGINE, (String)"QFilter_1", (String)"join filter can not be related with non-join filter for or\uff1a%s\u3002", (Object[])new Object[]{this + " " + op + " " + p}));
            }
            this.nests.add(new QFilterNest(op, p, this));
        }
        return this;
    }

    @SdkInternal
    public QFilter addFirstNest(QFilter p, String op) {
        if (p != null) {
            if ("OR".equals(op) && !Objects.equals(p.joinEntityPath, this.joinEntityPath)) {
                throw new IllegalArgumentException(BosRes.get((String)BOS_ORMENGINE, (String)"QFilter_1", (String)"join filter can not be related with non-join filter for or\uff1a%s\u3002", (Object[])new Object[]{this + " " + op + " " + p}));
            }
            ((LinkedList)this.nests).addFirst(new QFilterNest(op, p, this));
        }
        return this;
    }

    public QFilter and(String property, String cp, Object value) {
        return this.and(new QFilter(property, cp, value));
    }

    public void maskCurrent() {
        this.expressValue = false;
        this.property = "1";
        this.value = 1;
        this.cp = WRITE_OBJECT_HEADERCONTENT_PREFIX;
        this.selfDefinedQParameter = null;
        this.parsedProperty = null;
        this.parsedExpressValue = null;
        this.parsedPropertyFields = null;
        this.joinEntityPath = null;
        this.existsFilter = false;
        this.parseExistsValue = false;
        this.subQueryNode = null;
        this.qFilterHint = null;
    }

    public QFilter copy() {
        return this.__copy(true);
    }

    @SdkInternal
    public QFilter __copy(boolean withNest) {
        QFilter filter = new QFilter();
        filter.property = this.property;
        filter.cp = this.cp;
        filter.value = this.value;
        filter.expressValue = this.expressValue;
        filter.joinEntityPath = this.joinEntityPath;
        filter.innerJoin = this.innerJoin;
        filter.parseExpressValue = this.parseExpressValue;
        filter.joinThisEntity = this.joinThisEntity;
        if (withNest) {
            for (QFilterNest nest : this.getNests(false)) {
                if (nest.isAnd()) {
                    filter = filter.and(nest.filter.copy());
                    continue;
                }
                filter = filter.or(nest.filter.copy());
            }
        }
        filter.selfDefinedQParameter = this.selfDefinedQParameter;
        filter.parsedPropertyFields = this.parsedPropertyFields;
        filter.parsedProperty = this.parsedProperty;
        filter.parsedExpressValue = this.parsedExpressValue;
        filter.existsFilter = this.existsFilter;
        filter.parseExistsValue = this.parseExistsValue;
        filter.subQueryNode = this.subQueryNode;
        filter.isPrivacyQFilter = this.isPrivacyQFilter;
        filter.qFilterHint = this.qFilterHint;
        return filter;
    }

    private void remoldFromSerializedObject(QFilter f) {
        this.property = f.property;
        this.cp = f.cp;
        this.value = f.value;
        this.expressValue = f.expressValue;
        this.joinEntityPath = f.joinEntityPath;
        this.innerJoin = f.innerJoin;
        this.parseExpressValue = f.parseExpressValue;
        this.nests = f.nests;
        for (QFilterNest nest : f.getNests(false)) {
            nest.parent = this;
        }
        this.selfDefinedQParameter = f.selfDefinedQParameter;
        this.parsedPropertyFields = f.parsedPropertyFields;
        this.parsedProperty = f.parsedProperty;
        this.parsedExpressValue = f.parsedExpressValue;
        this.qFilterHint = f.qFilterHint;
    }

    public QFilter[] recombine() {
        ArrayList<QFilter[]> list = new ArrayList<QFilter[]>(1 + this.nests.size());
        list.add(new QFilter[]{this.__copy(false)});
        for (int i = 0; i < this.nests.size(); ++i) {
            QFilterNest nest = this.nests.get(i);
            if (nest.isAnd()) {
                list.add(nest.filter.recombine());
                continue;
            }
            QFilter before = null;
            QFilter[] qFilterArray = list.iterator();
            while (qFilterArray.hasNext()) {
                QFilter[] befores;
                for (QFilter each : befores = (QFilter[])qFilterArray.next()) {
                    if (before == null) {
                        before = each;
                        continue;
                    }
                    before.and(each);
                }
            }
            list.clear();
            if (before == null) continue;
            list.add(new QFilter[]{before.or(nest.filter)});
        }
        if (list.size() == 1) {
            return (QFilter[])list.get(0);
        }
        ArrayList<QFilter> ret = new ArrayList<QFilter>(list.size() + 1);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            QFilter[] fs;
            for (QFilter f : fs = (QFilter[])iterator.next()) {
                ret.add(f);
            }
        }
        return ret.toArray(new QFilter[ret.size()]);
    }

    @SdkInternal
    public List<QFilterNest> getNests(boolean recursive) {
        if (recursive) {
            LinkedList<QFilterNest> ret = new LinkedList<QFilterNest>();
            for (QFilterNest nest : this.nests) {
                ret.add(nest);
                ret.addAll(nest.getFilter().getNests(true));
            }
            return ret;
        }
        return new LinkedList<QFilterNest>(this.nests);
    }

    @Deprecated
    @SdkInternal
    public void setProperty(String property) {
        this.__setProperty(property);
    }

    @SdkInternal
    public final void __setProperty(String property) {
        String string = this.property = property == null ? "" : property.trim();
        if (this.property.length() == 0) {
            throw new IllegalArgumentException(BosRes.get((String)BOS_ORMENGINE, (String)"QFilter_2", (String)"property must be not null\u3002 ", (Object[])new Object[]{null}));
        }
        if (!this.expressValue && this.property.indexOf(32) != -1) {
            throw new IllegalArgumentException(BosRes.get((String)BOS_ORMENGINE, (String)"QFilter_3", (String)"property is incrroect\uff1a%s\u3002", (Object[])new Object[]{this.property}));
        }
    }

    @SdkInternal
    public void __setValue(Object value) {
        this.value = value;
    }

    @SdkInternal
    public String getProperty() {
        return this.property;
    }

    @SdkInternal
    public String[] getProperties() {
        if (("ftlike".equalsIgnoreCase(this.cp) || "match".equalsIgnoreCase(this.cp)) && QMatches._isMatchSolt(this.property)) {
            String filterValue = String.valueOf(this.value);
            int splitIndex = filterValue.indexOf("#");
            return filterValue.substring(0, splitIndex).split(",");
        }
        return new String[]{this.property};
    }

    public Object getValue() {
        if (this.qFilterHint != null) {
            FTLikeHint ftLikeHint;
            if (this.qFilterHint instanceof LikeHint) {
                LikeHint likeHint = (LikeHint)this.qFilterHint;
                return this.getValue(likeHint.isAppendLeftPercent(), likeHint.isAppendRightPercent(), false);
            }
            if (this.qFilterHint instanceof NotLikeHint) {
                NotLikeHint notLikeHint = (NotLikeHint)this.qFilterHint;
                return this.getValue(notLikeHint.isAppendLeftPercent(), notLikeHint.isAppendRightPercent(), false);
            }
            if (this.qFilterHint instanceof FTLikeHint && !(ftLikeHint = (FTLikeHint)this.qFilterHint).isAppendLeftPercent() && ftLikeHint.isAppendRightPercent()) {
                StringBuilder builder = new StringBuilder();
                if (!QMatches._isMatchSolt(this.property)) {
                    this.getFtlikeValue(ftLikeHint, this.value, builder);
                } else {
                    String realValue = (String)this.value;
                    int splitIndex = realValue.indexOf("#");
                    String properties = realValue.substring(0, splitIndex);
                    builder.append(properties).append("#");
                    this.getFtlikeValue(ftLikeHint, realValue.substring(splitIndex + 1), builder);
                }
                return builder.toString();
            }
        }
        return this.value;
    }

    private void getFtlikeValue(FTLikeHint ftLikeHint, Object value, StringBuilder builder) {
        String[] values = String.valueOf(value).split("\b");
        for (int i = 0; i < values.length; ++i) {
            if (ORMUtil.isFtlikeStartWith(ftLikeHint)) {
                builder.append(values[i]).append("%");
            } else {
                builder.append("%").append(values[i]).append("%");
            }
            if (i >= values.length - 1) continue;
            builder.append("\b");
        }
    }

    private Object getValue(boolean addLeftPercent, boolean addRightPercent, boolean escape) {
        if (!(this.value instanceof String)) {
            return this.value;
        }
        String newValue = (String)this.value;
        if (escape) {
            newValue = ORMUtil.escapeChars(newValue, null);
        }
        if (addLeftPercent) {
            newValue = "%" + newValue;
        }
        if (addRightPercent) {
            newValue = newValue + "%";
        }
        return newValue;
    }

    public Object getOriginValue() {
        return this.value;
    }

    public boolean isExpressValue() {
        return this.expressValue;
    }

    @SdkInternal
    public final void __setCP(String cp) {
        String string = this.cp = cp == null ? "" : cp.trim();
        if (!this.isCP(this.cp)) {
            throw new RuntimeException(BosRes.get((String)BOS_ORMENGINE, (String)"QFilter_4", (String)"The cp is incorrect\uff1a%s\u3002", (Object[])new Object[]{cp}));
        }
        this.qFilterHint = null;
    }

    public String getCP() {
        return this.cp;
    }

    @SdkInternal
    public String getJoinEntityPath() {
        if (this.joinEntityPath == null) {
            return null;
        }
        if (this.isJoinSQLFilter()) {
            return this.joinEntityPath.substring(JOINSQL_ENTITYPATH_PREFIX.length() + 1);
        }
        if (this.isOnMetaJoinPropertyFilter()) {
            return this.joinEntityPath.substring(FILTER_ON_METAPROPERTY_ENTITYPATH_PREFIX.length() + 1);
        }
        if (this.joinEntityPath.startsWith(JOINFILTER_ENTITYPATH_PREFIX)) {
            return this.joinEntityPath.substring(JOINFILTER_ENTITYPATH_PREFIX.length() + 1);
        }
        return this.joinEntityPath;
    }

    @SdkInternal
    public ORMHint.JoinHint getJoinHint() {
        return this.innerJoin ? ORMHint.JoinHint.INNER : ORMHint.JoinHint.LEFT;
    }

    @SdkInternal
    public boolean isJoinFilter() {
        return this.joinEntityPath != null && this.joinEntityPath.length() > 0;
    }

    @SdkInternal
    public boolean isJoinSQLFilter() {
        return this.joinEntityPath != null && this.joinEntityPath.startsWith(JOINSQL_ENTITYPATH_PREFIX);
    }

    @SdkInternal
    public boolean isOnMetaJoinPropertyFilter() {
        return this.joinEntityPath != null && this.joinEntityPath.startsWith(FILTER_ON_METAPROPERTY_ENTITYPATH_PREFIX);
    }

    private void __setJoinEntityPath(String joinEntityPath) {
        this.joinEntityPath = joinEntityPath == null ? null : joinEntityPath.trim();
        for (QFilterNest nest : this.nests) {
            nest.filter.__setJoinEntityPath(this.joinEntityPath);
        }
    }

    @Deprecated
    @SdkInternal
    public void setJoinEntityPath(String joinEntityPath) {
        this.__setJoinEntityPath(joinEntityPath);
    }

    @SdkInternal
    public QParameter toQParameter(QContext ctx) {
        String fullObjectName = ctx.getMainEntityItem().getFullObjectName();
        String rootObjName = ORMUtil.getRootObjName(fullObjectName);
        return this._toQParameter(ctx, rootObjName);
    }

    private QParameter _toQParameter(QContext ctx, String rootObjName) {
        IDataEntityProperty joinProperty;
        IDataEntityProperty jp;
        this.parsedPropertyFields = new ArrayList<PropertyField>(1);
        PropertyExpressInfo pei = null;
        if (!this.isJoinSQLFilter()) {
            pei = this._getPropertyString(ctx, rootObjName, this.property);
        }
        String lcp = this.cp.toLowerCase(Locale.ENGLISH);
        AbstractList params = new LinkedList<Object>();
        StringBuilder s = new StringBuilder(128);
        if (!this.isPrivacyQFilter) {
            this.isPrivacyQFilter = PrivacyDataQuery.handlPrivacyFilterPropery(pei == null ? null : pei.field, this, ctx, rootObjName);
            if (this.isPrivacyQFilter && !this.isJoinSQLFilter()) {
                this.parsedPropertyFields = new ArrayList<PropertyField>(1);
                pei = this._getPropertyString(ctx, rootObjName, this.property);
            }
        }
        if (this.selfDefinedQParameter != null) {
            this.selfDefinedQParameter.setQContext(ctx);
            s.append(this.selfDefinedQParameter.getSql());
            params.addAll(this.selfDefinedQParameter.getParameters() == null ? Collections.emptyList() : Arrays.asList(this.selfDefinedQParameter.getParameters()));
        } else if (lcp.equals("ftlike") || lcp.equals("match")) {
            QParameter matchQP;
            if (!"2".equals(this.property) && !"1".equals(this.property)) {
                this.value = QMatches._encodeMatch(new QMatches.Match(new String[]{(String)this.value}, new String[]{this.property}));
                this.property = "1";
                this.parsedPropertyFields = new ArrayList<PropertyField>(1);
                if (!this.isJoinSQLFilter()) {
                    pei = this._getPropertyString(ctx, rootObjName, this.property);
                }
            }
            QParameter qParameter = matchQP = this.selfDefinedQParameter == null ? (this.selfDefinedQParameter = QMatches.toQParameter(ctx, rootObjName, pei, this)) : this.selfDefinedQParameter;
            if (QMatches.isMultiPropertiesMatch(this)) {
                s.append('(').append(matchQP.getSql()).append(')');
            } else {
                s.append(matchQP.getSql());
            }
            params.addAll(matchQP.getParameters() == null ? Collections.emptyList() : Arrays.asList(matchQP.getParameters()));
        } else if (this.expressValue) {
            s.append(pei);
            s.append(' ').append(this.cp).append(' ');
            if (!this.parseExpressValue) {
                s.append('(').append(this.value).append(')');
            } else {
                PropertyField pf = this.parsePropertyField(ctx, rootObjName, String.valueOf(this.value), false);
                if (pf == null) {
                    s.append('#').append(this.value);
                } else {
                    s.append(pf.toSelectField(false, ctx, true));
                }
            }
        } else if (lcp.equals("in") || lcp.equals("not in")) {
            if (this.value instanceof QParameter) {
                s.append(pei);
                s.append(' ').append(this.cp).append(' ');
                s.append('(').append(((QParameter)this.value).getSql()).append(')');
                Object[] parameters = ((QParameter)this.value).getParameters();
                if (parameters != null) {
                    Collections.addAll(params, parameters);
                }
            } else {
                Object[] inParams = QFilterUtil.getWithoutDuplicateInValues(this.value);
                if (inParams != null && inParams.length > 0) {
                    int len = inParams.length;
                    String fp = String.valueOf(pei);
                    boolean sqlWithParam = false;
                    Object inParam0 = inParams[0];
                    if (HugeInConfig.isParamWithSql() && !(inParam0 instanceof BigDecimal) && inParam0 instanceof Number && len <= ORMUtil.toTempTableSize(ctx.getORMHint())) {
                        sqlWithParam = true;
                    }
                    QParameter inQP = QFilterUtil.getInQParameter(inParams, sqlWithParam);
                    if (len == 1) {
                        String ecp = lcp.equals("in") ? WRITE_OBJECT_HEADERCONTENT_PREFIX : "!=";
                        s.append(fp).append(ecp).append(inQP.getSql());
                    } else if (HugeInConfig.isEnableOpt() && HugeInConfig.getOptType() == HugeInConfig.OptType.split_in && len > ORMUtil.toTempTableSize(ctx.getORMHint())) {
                        int N = len;
                        int SIZE = ORMUtil.toTempTableSize(ctx.getORMHint());
                        int MOD_VALUE = N % SIZE;
                        int round = N / SIZE + (MOD_VALUE == 0 ? 0 : 1);
                        s.append('(');
                        String and_or = lcp.equals("in") ? " OR " : " AND ";
                        int from = 0;
                        for (int r = 0; r < round; ++r) {
                            if (r > 0) {
                                s.append(and_or);
                            }
                            s.append(fp).append(' ').append(this.cp).append(' ');
                            int count = SIZE;
                            if (r == round - 1 && MOD_VALUE != 0) {
                                count = MOD_VALUE;
                            }
                            if (sqlWithParam) {
                                Object[] splitParams = Arrays.copyOfRange(inParams, from, from + count);
                                s.append('(').append(QFilterUtil.multiParamsSQL(splitParams)).append(')');
                                from += count;
                                continue;
                            }
                            s.append('(').append(QFilterUtil.multiParamsSQL(count)).append(')');
                        }
                        s.append(')');
                    } else {
                        s.append(fp).append(' ').append(this.cp).append(' ');
                        s.append('(').append(inQP.getSql()).append(')');
                    }
                    for (Object value : inQP.getParameters()) {
                        params.add((Object)value);
                    }
                } else if (lcp.equals("in")) {
                    s.append(EXP_NE);
                } else {
                    s.append(EXP_EQ);
                }
            }
        } else if (lcp.equals("is null")) {
            s.append(pei).append(' ').append("is null");
        } else if (lcp.equals("is not null")) {
            s.append(pei).append(' ').append("is not null");
        } else if (pei == null) {
            MergeDBBeacon.markAboutHandleAllFilterAndOrderAndGroupBy();
            s.append("2=2");
        } else if (this.value instanceof QEmptyValue) {
            boolean isEntryPK;
            Object[] type = pei.field.getPropertyItem().getPropertyType();
            boolean bl = isEntryPK = ORMConfiguration.isEntryEntityType(pei.field.getEntityType()) && pei.field.getEntityType().getPrimaryKey().getName().equalsIgnoreCase(pei.field.getName());
            if (isEntryPK) {
                s.append(pei);
                if ("!=".equals(this.cp)) {
                    s.append(" is not null");
                } else {
                    s.append(" is null");
                }
            } else {
                this.getQEmptyValueSql((IDataEntityProperty)type, s, params, pei);
            }
        } else if (this.value instanceof QFilterValue) {
            this.handleExists(s, params, ctx);
        } else if (this.value instanceof QParameter) {
            s.append(pei).append(' ').append(this.cp).append(' ');
            s.append('(').append(((QParameter)this.value).getSql()).append(')');
            for (Object v : ((QParameter)this.value).getParameters()) {
                params.add((Object)v);
            }
        } else {
            ArrayList<Object> paramsValue = new ArrayList<Object>();
            if (this.value instanceof MultiBaseDataFilterValue) {
                Object originValue = ((MultiBaseDataFilterValue)this.value).getValue();
                if (originValue instanceof Collection) {
                    paramsValue.addAll((Collection)originValue);
                } else {
                    paramsValue.add(originValue);
                }
            } else {
                paramsValue.add(this.value);
            }
            IDataEntityType entityType = ctx.getMainEntityItem().entityType;
            if (ORMUtil.isContains(this.qFilterHint) || ORMUtil.isStartWith(this.qFilterHint) || ORMUtil.isEndWith(this.qFilterHint)) {
                s.append(pei).append(' ').append(ORMUtil.getLikeCP(entityType)).append(" ?");
            } else if (ORMUtil.isNotContains(this.qFilterHint)) {
                s.append(pei).append(' ').append(ORMUtil.getNotLikeCP(entityType)).append(" ?");
            } else {
                s.append(pei).append(' ').append(this.cp).append(" ?");
            }
            if (ORMUtil.isFuzzyQuery(this.qFilterHint)) {
                params.add((Object)ORMUtil.transferAndAppendPercent(this.qFilterHint, String.valueOf(paramsValue.get(0)), entityType));
                s.append(ORMUtil.addEscapeClause(entityType));
            } else if ("like".equals(lcp) || "ilike".equals(lcp) || "not like".equals(lcp) || "not ilike".equals(lcp)) {
                params.add((Object)ORMUtil.escapeSpecialChar(entityType, String.valueOf(paramsValue.get(0))));
                s.append(ORMUtil.addEscapeClause(entityType));
            } else {
                params.addAll(paramsValue);
            }
        }
        if (ORMConfiguration.isQFilterCheckParameterType() && pei != null && pei.field != null && pei.field.getPeropertyType() != null && !params.isEmpty()) {
            jp = pei.field.getPeropertyType();
            Class cls = jp instanceof ICollectionProperty ? ((ICollectionProperty)jp).getItemType().getPrimaryKey().getPropertyType() : (jp instanceof IComplexProperty ? ((IComplexProperty)jp).getComplexType().getPrimaryKey().getPropertyType() : jp.getPropertyType());
            if (cls.isPrimitive()) {
                if (cls == Long.TYPE) {
                    cls = Long.class;
                } else if (cls == Integer.TYPE) {
                    cls = Integer.class;
                } else if (cls == Boolean.TYPE) {
                    cls = Boolean.class;
                } else if (cls == Double.TYPE) {
                    cls = Double.class;
                } else if (cls == Float.TYPE) {
                    cls = Float.class;
                }
            }
            Class<?> pcls = null;
            for (Object p : params) {
                if (p == null) continue;
                pcls = p.getClass();
                break;
            }
            if (!(pcls == null || cls.isAssignableFrom(pcls) || pcls.getName().startsWith(KD_BOS) || cls.getName().startsWith(KD_BOS))) {
                if (ORMConfiguration.isQFilterAutoConvertParameterType()) {
                    ArrayList<Object> cparams = new ArrayList<Object>(params.size());
                    for (Object p : params) {
                        if (p instanceof Boolean && cls == String.class) {
                            cparams.add((Boolean)p != false ? "1" : "0");
                            continue;
                        }
                        cparams.add(ObjectConverter.convert(p, (Class)cls));
                    }
                    params = cparams;
                } else if (!(pcls.getName().startsWith(KD_BOS) || cls.getName().startsWith(KD_BOS) || Number.class.isAssignableFrom(pcls) && Number.class.isAssignableFrom(cls) || pcls == Boolean.class && cls == Character.class || pcls == Character.class && cls == Boolean.class || pcls == Boolean.class && cls == String.class || pcls == String.class && cls == Boolean.class || pcls == String.class && cls == Character.class || pcls == Character.class && cls == String.class)) {
                    throw new IllegalArgumentException("QFilter value type error: except=" + cls + ", actual=" + pcls);
                }
            }
        }
        if (!this.nests.isEmpty()) {
            LinkedList<Object> refParams = params;
            this.resolveNests(s, nest -> {
                s.append(' ').append(nest.op).append(' ');
                QParameter nestQP = nest.filter._toQParameter(ctx, rootObjName);
                s.append(nestQP.getSql().trim());
                for (Object value : nestQP.getParameters()) {
                    refParams.add(value);
                }
                return null;
            });
        }
        if (pei != null && (jp = pei.field.getPeropertyType()) instanceof IJoinProperty && (joinProperty = ((IJoinProperty)jp).getJoinProperty()) != joinProperty.getParent().getPrimaryKey()) {
            Object[] propertyValues = QMatches.queryPropertyValueByPKs(joinProperty.getParent().getName(), joinProperty.getName(), params.toArray(), ctx);
            params.clear();
            params.addAll(Arrays.asList(propertyValues));
        }
        QParameter qp = new QParameter(s.toString(), params.toArray());
        qp.setQContext(ctx);
        return qp;
    }

    private void resolveNests(StringBuilder s, Function<QFilterNest, Void> nestFun) {
        boolean withOr = false;
        boolean allOr = true;
        for (QFilterNest nest : this.nests) {
            if (nest.isAnd()) {
                allOr = false;
                continue;
            }
            withOr = true;
        }
        if (withOr) {
            s.insert(0, '(');
        }
        if (allOr) {
            for (QFilterNest nest : this.nests) {
                nestFun.apply(nest);
            }
        } else {
            boolean preIsAnd = true;
            for (QFilterNest nest : this.nests) {
                boolean and = nest.isAnd();
                if (!preIsAnd && and) {
                    s.insert(0, '(');
                    s.append(')');
                }
                nestFun.apply(nest);
                preIsAnd = and;
            }
        }
        if (withOr) {
            s.append(')');
        }
    }

    private PropertyExpressInfo _getPropertyString(QContext ctx, String rootObjName, String property) {
        PropertyField pf = this.parsePropertyField(ctx, rootObjName, property, true);
        if (pf == null) {
            MergeDBBeacon.markAboutHandleAllFilterAndOrderAndGroupBy();
            return null;
        }
        return new PropertyExpressInfo(pf.toSelectField(false, ctx, true), pf);
    }

    private PropertyField parsePropertyField(QContext ctx, String rootObjName, String express, boolean property) {
        PropertyField pf = SelectFields.parseFrom(express).createPropertyFields(rootObjName).get(0);
        if (property) {
            this.parsedProperty = pf;
        } else {
            this.parsedExpressValue = pf;
        }
        PropertyField ret = ctx.putPerformJoinField(pf, this.isJoinFilter() ? this : null, this._getJoinFilterProperty(rootObjName, property));
        if (pf.getPropertySegExpress() == null) {
            if ((pf = ctx.putPerformJoinField(pf)) != null) {
                this.parsedPropertyFields.add(pf);
            }
        } else {
            for (String p : pf.getPropertySegExpress().getFullPropertyNames()) {
                PropertyField epf = new PropertyField(rootObjName + '.' + p);
                if ((epf = ctx.putPerformJoinField(epf)) == null) continue;
                this.parsedPropertyFields.add(epf);
            }
        }
        return ret;
    }

    private String _getJoinFilterProperty(String rootObjName, boolean property) {
        if (property) {
            return this.isJoinFilter() ? String.valueOf(this.value) : "";
        }
        return this.isJoinFilter() && this.joinThisEntity ? rootObjName + "." + this.property : this.property;
    }

    @SdkInternal
    public PropertyField __getParsedProperty(QContext ctx) {
        if (this.parsedProperty == null) {
            this.toQParameter(ctx);
        }
        return this.parsedProperty;
    }

    @SdkInternal
    public PropertyField __getParsedExpressValue(QContext ctx) {
        if (this.parsedProperty == null) {
            this.toQParameter(ctx);
        }
        return this.parsedExpressValue;
    }

    @SdkInternal
    public List<PropertyField> __getParsedPropertyFields() {
        return this.parsedPropertyFields == null ? Collections.emptyList() : this.parsedPropertyFields;
    }

    public boolean eval(QFilterEvaluator evalor) {
        boolean b = evalor.eval(this);
        for (QFilterNest nest : this.getNests(false)) {
            boolean bb = nest.filter.eval(evalor);
            if (nest.isAnd()) {
                b &= bb;
                continue;
            }
            b |= bb;
        }
        return b;
    }

    public QFilter[] toArray() {
        return new QFilter[]{this};
    }

    @SdkInternal
    public String toCurrentString() {
        return this.toString(false, QFilterUtil::parametertoString);
    }

    public String toString() {
        return this.toString(true, QFilterUtil::parametertoString);
    }

    @SdkInternal
    public String __toStringWithParamEncode(Function<Object, String> param2StringFnc) {
        return this.toString(true, param2StringFnc);
    }

    private String toString(boolean recursive, Function<Object, String> param2StringFnc) {
        StringBuilder s = new StringBuilder(128);
        if (this.isJoinSQLFilter()) {
            s.append(this.property);
        } else {
            s.append(this.property).append(' ').append(this.cp);
            Object value = this.value;
            if (!this.expressValue) {
                value = ORMUtil.isContains(this.qFilterHint) || ORMUtil.isNotContains(this.qFilterHint) ? "'%" + value + "%'" : (ORMUtil.isStartWith(this.qFilterHint) ? "'" + value + "%'" : (ORMUtil.isEndWith(this.qFilterHint) ? "'%" + value + "'" : param2StringFnc.apply(value)));
            }
            if (this.cp.equalsIgnoreCase("in") || this.cp.equalsIgnoreCase("not in")) {
                s.append(" (").append(value).append(')');
            } else {
                s.append(' ').append(value);
            }
        }
        if (recursive && !this.nests.isEmpty()) {
            this.resolveNests(s, nest -> {
                s.append(' ').append(nest.op).append(' ').append(nest.getFilter().__toStringWithParamEncode(param2StringFnc));
                return null;
            });
        }
        return s.toString();
    }

    public String toSerializedString() {
        return QFilterSerializer.encodeQFilter(this);
    }

    public static QFilter fromSerializedString(String s) {
        return QFilterSerializer.decodeQFilter(s);
    }

    @SdkInternal
    public QFilter trans(Function<QFilter, QFilter> singleTransFunc) {
        for (QFilterNest nest : this.nests) {
            nest.filter = nest.filter.trans(singleTransFunc);
        }
        QFilter root = singleTransFunc.apply(this);
        ArrayList<QFilterNest> oldNests = new ArrayList<QFilterNest>(this.nests);
        if (root == this) {
            root.nests.clear();
        }
        for (QFilterNest nest : oldNests) {
            if (nest.isAnd()) {
                root.and(nest.filter);
                continue;
            }
            root.or(nest.filter);
        }
        return root;
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
        boolean withVersion = true;
        os.writeUTF(this.encodeWriteObjectHeader());
        String s = this.toSerializedString();
        byte[] bs = s.getBytes(SERIALIZE_CHARSET);
        os.writeInt(bs.length);
        os.write(bs);
    }

    private String encodeWriteObjectHeader() throws UnsupportedEncodingException {
        return WRITE_OBJECT_HEADERCONTENT_PREFIX + Base64.getEncoder().encodeToString(WRITE_OBJECT_VERSION.getBytes(SERIALIZE_CHARSET));
    }

    private boolean isWriteObjectHeader(String headerContent) {
        return headerContent.startsWith(WRITE_OBJECT_HEADERCONTENT_PREFIX);
    }

    private String decodeWriteObjectHeader(String headerContent) throws UnsupportedEncodingException {
        return new String(Base64.getDecoder().decode(headerContent.substring(WRITE_OBJECT_HEADERCONTENT_PREFIX.length())), SERIALIZE_CHARSET);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        String contentSerializedString;
        is.defaultReadObject();
        String s = is.readUTF();
        boolean withVersion = this.isWriteObjectHeader(s);
        if (withVersion) {
            String curVersion = this.decodeWriteObjectHeader(s);
            boolean isV1 = WRITE_OBJECT_VERSION.equals(curVersion);
            int len = is.readInt();
            byte[] bs = new byte[len];
            is.readFully(bs);
            contentSerializedString = new String(bs, SERIALIZE_CHARSET);
        } else {
            contentSerializedString = s;
        }
        QFilter f = QFilter.fromSerializedString(contentSerializedString);
        this.remoldFromSerializedObject(f);
    }

    @SdkInternal
    public void __setSelfDefinedQParameter(QParameter selfDefinedQParameter) {
        this.selfDefinedQParameter = selfDefinedQParameter;
    }

    @SdkInternal
    public QParameter __getSelfDefinedQParameter() {
        return this.selfDefinedQParameter;
    }

    private void handleExists(StringBuilder s, List<Object> params, QContext ctx) {
        if (WRITE_OBJECT_HEADERCONTENT_PREFIX.equalsIgnoreCase(this.cp)) {
            this.cp = "not exists";
        } else if ("!=".equalsIgnoreCase(this.cp)) {
            this.cp = "exists";
        }
        if (this.parseExistsValue) {
            if (this.subQueryNode != null) {
                s.setLength(0);
                s.append(" ").append(this.cp).append(" ( ");
                SingleQuery query = this.subQueryNode.getQuery();
                SingleQuery.QueryParameter queryParameter = query.getQueryParameter();
                s.append(queryParameter.getSql());
                params.addAll(Arrays.asList(queryParameter.getParams()));
            }
        } else {
            s.append(" ").append(this.cp).append(" ( ");
            s.append("  ? ");
            params.add(((QFilterValue)this.value).getValue());
        }
        s.append(" )");
    }

    private static void setProperty(String fkProperty, QFilter refObjectFilter) {
        List<QFilterNest> nests;
        if (refObjectFilter == null) {
            return;
        }
        if (refObjectFilter.getProperty().contains(fkProperty)) {
            int index = refObjectFilter.getProperty().indexOf(fkProperty) + fkProperty.length() + 1;
            refObjectFilter.__setProperty(refObjectFilter.getProperty().substring(index));
        }
        if (!(nests = refObjectFilter.getNests(true)).isEmpty()) {
            for (QFilterNest nest : nests) {
                QFilter filter = nest.getFilter();
                if (!filter.getProperty().contains(fkProperty)) continue;
                int index = filter.getProperty().indexOf(fkProperty) + fkProperty.length() + 1;
                filter.__setProperty(filter.getProperty().substring(index));
            }
        }
    }

    public void clearNests() {
        this.nests = new LinkedList<QFilterNest>();
    }

    private void transferNull(String cp, Object value) {
        if (value == null) {
            if (cp.equals(WRITE_OBJECT_HEADERCONTENT_PREFIX)) {
                this.__setCP("is null");
                this.__setValue(null);
            } else if (cp.equals("!=")) {
                this.__setCP("is not null");
                this.__setValue(null);
            }
        }
    }

    private void transferMultiBaseData(Object value) {
        String multiValue;
        if (value instanceof String && (multiValue = (String)value).startsWith("multibasedata[") && multiValue.endsWith("]")) {
            MultiBaseDataFilterValue multi;
            int endIndex;
            int startIndex = multiValue.indexOf("[");
            String originValue = multiValue.substring(startIndex + 1, endIndex = multiValue.lastIndexOf("]"));
            String[] valueSplits = originValue.split(",");
            if (valueSplits.length < 3) {
                throw new IllegalArgumentException("multi type basedata params length must greater equals 3");
            }
            if (valueSplits.length == 3) {
                multi = new MultiBaseDataFilterValue(valueSplits[0].trim(), valueSplits[1].trim(), valueSplits[2]);
            } else {
                ArrayList<String> realValues = new ArrayList<String>(2);
                for (int i = 2; i < valueSplits.length; ++i) {
                    realValues.add(valueSplits[i]);
                }
                if (this.cp.equalsIgnoreCase(WRITE_OBJECT_HEADERCONTENT_PREFIX)) {
                    this.__setCP("in");
                } else if (this.cp.equalsIgnoreCase("!=") || this.cp.equalsIgnoreCase("<>")) {
                    this.__setCP("not in");
                }
                multi = new MultiBaseDataFilterValue(valueSplits[0], valueSplits[1], realValues);
            }
            this.__setValue(multi);
        }
    }

    private void getQEmptyValueSql(IDataEntityProperty type, StringBuilder s, List<Object> params, PropertyExpressInfo pei) {
        Class cls = type instanceof IJoinProperty ? ((IJoinProperty)type).getJoinProperty().getPropertyType() : (type instanceof IComplexProperty ? ((IComplexProperty)type).getComplexType().getPrimaryKey().getPropertyType() : (type.getParent().getPrimaryKey() == type ? type.getPropertyType() : ("kd.bos.entity.property.MulBasedataProp".equalsIgnoreCase(type.getClass().getName()) ? type.getParent().getPrimaryKey().getPropertyType() : ("kd.bos.entity.property.AttachmentProp".equalsIgnoreCase(type.getClass().getName()) ? type.getParent().getPrimaryKey().getPropertyType() : type.getPropertyType()))));
        boolean twoParam = true;
        if (cls == Integer.TYPE || cls == Integer.class || cls == Byte.TYPE || cls == Byte.class || cls == Short.TYPE || cls == Short.class) {
            s.append('(').append(pei).append(this.cp).append(" ?");
            params.add(0);
        } else if (cls == Long.TYPE || cls == Long.class) {
            s.append('(').append(pei).append(this.cp).append(" ?");
            params.add(0L);
        } else if (cls == java.util.Date.class || cls == Timestamp.class || cls == Date.class) {
            twoParam = false;
        } else if (cls == BigDecimal.class || cls == Number.class || cls == Double.TYPE || cls == Double.class) {
            s.append('(').append(pei).append(this.cp).append(" ?");
            params.add(0.0);
        } else {
            s.append('(').append(pei).append(this.cp).append(" ?");
            params.add(" ");
        }
        if ("!=".equals(this.cp) || "<>".equals(this.cp)) {
            if (twoParam) {
                s.append(" AND ");
            }
            s.append(pei).append(" is not null");
        } else {
            if (twoParam) {
                s.append(" OR ");
            }
            s.append(pei).append(" is null");
        }
        if (twoParam) {
            s.append(')');
        }
    }

    private void checkQFilter(QFilterHint qFilterHint) {
        if (qFilterHint != null) {
            if (qFilterHint instanceof LikeHint && !"like".equalsIgnoreCase(this.cp) && !"ilike".equalsIgnoreCase(this.cp)) {
                throw new IllegalArgumentException("when QfilterHint is LikeHint,the cp must be 'like' !!!");
            }
            if (qFilterHint instanceof NotLikeHint && !"not like".equalsIgnoreCase(this.cp) && !"not ilike".equalsIgnoreCase(this.cp)) {
                throw new IllegalArgumentException("when QfilterHint is NotLikeHint,the cp must be 'not like' !!!");
            }
            if (qFilterHint instanceof FTLikeHint && !"ftlike".equalsIgnoreCase(this.cp) && !"match".equalsIgnoreCase(this.cp)) {
                throw new IllegalArgumentException("when QfilterHint is FTLikeHint,the cp must be 'ftlike' or 'match' !!!");
            }
        }
    }

    @SdkInternal
    public boolean isExistsFilter() {
        return this.existsFilter;
    }

    @SdkInternal
    public void setExistsFilter(boolean existsFilter) {
        this.existsFilter = existsFilter;
    }

    @SdkInternal
    public boolean isParseExistsValue() {
        return this.parseExistsValue;
    }

    @SdkInternal
    public void setParseExistsValue(boolean parseExistsValue) {
        this.parseExistsValue = parseExistsValue;
    }

    @SdkInternal
    public QueryTreeNode getSubQueryNode() {
        return this.subQueryNode;
    }

    @SdkInternal
    public void setSubQueryNode(QueryTreeNode subQueryNode) {
        this.subQueryNode = subQueryNode;
    }

    @SdkInternal
    public QFilterHint getQFilterHint() {
        return this.qFilterHint;
    }

    @SdkInternal
    public void setQFilterHint(QFilterHint qFilterHint) {
        this.qFilterHint = qFilterHint;
    }

    @SdkInternal
    public String getPropertyAlias(QContext ctx, PropertyField pf) {
        PropertyExpressInfo propertyExpressInfo = new PropertyExpressInfo(pf.toSelectField(false, ctx, true), pf);
        return String.valueOf(propertyExpressInfo);
    }

    public String tryConvertToAlgoExpression() throws IllegalArgumentException {
        StringBuilder s = new StringBuilder(128);
        this.tryConvertToAlgoExpression(s);
        if (!this.nests.isEmpty()) {
            this.resolveNests(s, nest -> {
                s.append(' ').append(nest.op).append(' ').append(nest.getFilter().tryConvertToAlgoExpression());
                return null;
            });
        }
        return s.toString();
    }

    private void tryConvertToAlgoExpression(StringBuilder s) {
        String lcp = this.cp.toLowerCase(Locale.ENGLISH);
        if ("exists".equals(lcp) || "not exists".equals(lcp)) {
            throw new IllegalArgumentException("Cannot convert to Algo expression. QCP.EXISTS, QCP.NOT_EXISTS does not supported.");
        }
        if (this.isJoinFilter()) {
            throw new IllegalArgumentException("Cannot convert to Algo expression. Join filter does not supported.");
        }
        if (this.selfDefinedQParameter != null) {
            throw new IllegalArgumentException("Cannot convert to Algo expression. SelfDefinedQParameter does not supported.");
        }
        if (this.isExpressValue()) {
            throw new IllegalArgumentException("Cannot convert to Algo expression. ExpressValue does not supported.");
        }
        boolean needAppendCp = true;
        boolean needAppendValue = true;
        if ("ftlike".equals(lcp) || "match".equals(lcp)) {
            QFilter qFilter = this.parseFtlike();
            s.append(qFilter.tryConvertToAlgoExpression());
            return;
        }
        s.append(this.property).append(' ');
        if (this.qFilterHint != null) {
            Object v = null;
            if (this.qFilterHint instanceof LikeHint) {
                LikeHint likeHint = (LikeHint)this.qFilterHint;
                v = this.getValue(likeHint.isAppendLeftPercent(), likeHint.isAppendRightPercent(), likeHint.isEscape());
            } else if (this.qFilterHint instanceof NotLikeHint) {
                NotLikeHint notLikeHint = (NotLikeHint)this.qFilterHint;
                v = this.getValue(notLikeHint.isAppendLeftPercent(), notLikeHint.isAppendRightPercent(), notLikeHint.isEscape());
            } else if (this.qFilterHint instanceof FTLikeHint) {
                FTLikeHint ftLikeHint = (FTLikeHint)this.qFilterHint;
                v = this.getValue(ftLikeHint.isAppendLeftPercent(), ftLikeHint.isAppendRightPercent(), ftLikeHint.isEscape());
            }
            s.append(lcp).append(' ').append('\'').append(v).append('\'');
            needAppendCp = false;
            needAppendValue = false;
        }
        if (this.value instanceof QEmptyValue) {
            if (WRITE_OBJECT_HEADERCONTENT_PREFIX.equals(lcp)) {
                s.append("is null");
                needAppendCp = false;
                needAppendValue = false;
            } else if ("!=".equals(lcp)) {
                s.append("is not null");
                needAppendCp = false;
                needAppendValue = false;
            }
        }
        if (needAppendCp) {
            s.append(lcp);
        }
        if (lcp.equals("is null") || lcp.equals("is not null")) {
            needAppendValue = false;
        }
        if (needAppendValue) {
            HashSet set;
            Object[] params = null;
            if (this.value.getClass().isArray()) {
                int c = Array.getLength(this.value);
                Object[] set2 = new HashSet(c);
                for (int i = 0; i < c; ++i) {
                    set2.add(Array.get(this.value, i));
                }
                params = set2.toArray(new Object[0]);
            } else if (this.value instanceof Set) {
                params = ((Set)this.value).toArray(new Object[0]);
            } else if (this.value instanceof Collection) {
                set = new HashSet((Collection)this.value);
                params = set.toArray(new Object[0]);
            } else if (this.value instanceof Iterable) {
                set = new HashSet(16);
                for (Object item : (Iterable)this.value) {
                    set.add(item);
                }
                params = set.toArray(new Object[0]);
            } else {
                Object originValue;
                params = this.value instanceof MultiBaseDataFilterValue ? ((originValue = ((MultiBaseDataFilterValue)this.value).getValue()) instanceof Collection ? ((Collection)originValue).toArray() : new Object[]{originValue}) : new Object[]{this.value};
            }
            StringBuilder sb = new StringBuilder(params.length * 10);
            for (Object param : params) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                if (param == null) continue;
                Class<?> cls = param.getClass();
                if (QFilterUtil.isNumber(cls) || cls == Boolean.class) {
                    sb.append(param);
                    continue;
                }
                sb.append('\'').append(param).append('\'');
            }
            String valueString = sb.toString();
            if (lcp.equals("in") || lcp.equals("not in")) {
                s.append(" (").append(valueString).append(')');
            } else {
                s.append(' ').append(valueString);
            }
        }
    }

    private QFilter parseFtlike() {
        boolean isMatchSolt = QMatches._isMatchSolt(this.property);
        QMatches.Match m = isMatchSolt ? QMatches.__decode(String.valueOf(this.getOriginValue())) : new QMatches.Match(new String[]{String.valueOf(this.getOriginValue())}, new String[]{this.getProperty()});
        boolean isMultiValue = QMatches.__isMultiValueMatchSolt(this.getProperty());
        QFilter ret = null;
        String lcp = "like";
        for (String property : m.getProperties()) {
            for (String value : m.getValues()) {
                QFilter f;
                if (isMultiValue) {
                    String[] andVS = QMatches.splitMultiValue(value);
                    QFilter f2 = null;
                    for (String v : andVS) {
                        QFilter ff;
                        if (ORMUtil.isFtlikeStartWith(this.getQFilterHint())) {
                            ff = new QFilter(property, lcp, (Object)v, QFilterHint.STARTWITH);
                        } else if (ORMUtil.isFtlikeContains(this.getQFilterHint())) {
                            ff = new QFilter(property, lcp, (Object)v, QFilterHint.CONTAINS);
                        } else {
                            v = "%" + v + "%";
                            ff = new QFilter(property, lcp, v);
                        }
                        f2 = f2 == null ? ff : f2.and(ff);
                    }
                    ret = ret == null ? f2 : ret.or(f2);
                    continue;
                }
                if (ORMUtil.isFtlikeStartWith(this.getQFilterHint())) {
                    f = new QFilter(property, lcp, (Object)value, QFilterHint.STARTWITH);
                } else if (ORMUtil.isFtlikeContains(this.getQFilterHint())) {
                    f = new QFilter(property, lcp, (Object)value, QFilterHint.CONTAINS);
                } else {
                    value = "%" + value + "%";
                    f = new QFilter(property, lcp, value);
                }
                ret = ret == null ? f : ret.or(f);
            }
        }
        return ret;
    }

    private static class QFilterSerializer
    implements Serializable {
        private static final long serialVersionUID = -7696874631062903504L;
        private static Map<Class<?>, ValueType> valeTypeMap = new ConcurrentHashMap();
        private static Map<String, Integer> cpMap = new HashMap<String, Integer>();
        private static Map<Integer, String> cpAntiMap = new HashMap<Integer, String>();

        private QFilterSerializer() {
        }

        static String encodeQFilter(QFilter filter) {
            String json = JSON.toJSONString(QFilterSerializer.toSerializedList(filter));
            return (String)QFilterSerializer.encodeValue(json, ValueType.OtherObject);
        }

        static QFilter decodeQFilter(String s) {
            s = (String)QFilterSerializer.decodeValue(s, ValueType.OtherObject);
            List list = (List)JSON.parseObject((String)s, List.class);
            return QFilterSerializer.parseQFilter(list);
        }

        private static List<Object> toSerializedList(QFilter filter) {
            ArrayList<Object> s = new ArrayList<Object>(10);
            s.add(filter.property);
            s.add(QFilterSerializer.getCPValue(filter.cp));
            ValueType type = QFilterSerializer.getValueType(filter.value);
            s.add(type.ordinal());
            s.add(QFilterSerializer.encodeValue(filter.value, type));
            s.add(filter.expressValue ? 1 : 0);
            s.add(filter.joinEntityPath);
            s.add(filter.innerJoin ? 1 : 0);
            s.add(filter.parseExpressValue ? 1 : 0);
            if (filter.qFilterHint != null) {
                ValueType serialType = QFilterSerializer.getValueType(filter.qFilterHint);
                s.add(serialType.ordinal());
                s.add(QFilterSerializer.encodeValue(filter.qFilterHint, serialType));
            }
            for (QFilterNest nest : filter.nests) {
                s.add(QFilterSerializer.toSerializedList(nest));
            }
            return s;
        }

        private static List<Object> toSerializedList(QFilterNest nest) {
            ArrayList<Object> s = new ArrayList<Object>(2);
            s.add(nest.isAnd() ? 1 : 0);
            s.add(QFilterSerializer.toSerializedList(nest.filter));
            return s;
        }

        private static QFilter parseQFilter(List<Object> list) {
            QFilter q;
            block10: {
                q = new QFilter();
                q.property = (String)list.get(0);
                q.cp = QFilterSerializer.getCP((Integer)list.get(1));
                ValueType type = ValueType.values()[(Integer)list.get(2)];
                q.value = QFilterSerializer.decodeValue(list.get(3), type);
                q.expressValue = (Integer)list.get(4) == 1;
                int n = list.size();
                if (n <= 5) break block10;
                boolean oldVersion = list.get(5) instanceof List;
                if (oldVersion) {
                    for (int i = 5; i < n; ++i) {
                        List nestList = (List)list.get(i);
                        q.nests.add(QFilterSerializer.parseQFilterNest(q, nestList));
                    }
                } else {
                    q.joinEntityPath = (String)list.get(5);
                    q.innerJoin = (Integer)list.get(6) == 1;
                    if (n > 9 && list.get(9) instanceof String && list.get(8) instanceof Integer) {
                        q.parseExpressValue = (Integer)list.get(7) == 1;
                        ValueType serialType = ValueType.values()[(Integer)list.get(8)];
                        q.qFilterHint = (QFilterHint)QFilterSerializer.decodeValue(list.get(9), serialType);
                        for (int i = 10; i < n; ++i) {
                            List nestList = (List)list.get(i);
                            q.nests.add(QFilterSerializer.parseQFilterNest(q, nestList));
                        }
                    } else if (n > 7 && list.get(7) instanceof Integer) {
                        q.parseExpressValue = (Integer)list.get(7) == 1;
                        for (int i = 8; i < n; ++i) {
                            List nestList = (List)list.get(i);
                            q.nests.add(QFilterSerializer.parseQFilterNest(q, nestList));
                        }
                    } else {
                        for (int i = 7; i < n; ++i) {
                            List nestList = (List)list.get(i);
                            q.nests.add(QFilterSerializer.parseQFilterNest(q, nestList));
                        }
                    }
                }
            }
            return q;
        }

        private static QFilterNest parseQFilterNest(QFilter parnet, List<Object> list) {
            QFilterNest nest = new QFilterNest();
            nest.parent = parnet;
            nest.op = (Integer)list.get(0) == 1 ? "AND" : "OR";
            nest.filter = QFilterSerializer.parseQFilter((List)list.get(1));
            return nest;
        }

        private static ValueType getValueType(Object value) {
            if (value == null) {
                return ValueType.Null;
            }
            return valeTypeMap.computeIfAbsent(value.getClass(), cls -> {
                if (Number.class.isAssignableFrom((Class<?>)cls)) {
                    return ValueType.Number;
                }
                if (String.class.isAssignableFrom((Class<?>)cls)) {
                    return ValueType.String;
                }
                if (Boolean.class.isAssignableFrom((Class<?>)cls)) {
                    return ValueType.Boolean;
                }
                if (java.util.Date.class.isAssignableFrom((Class<?>)cls)) {
                    return ValueType.DateTime;
                }
                if (Character.class.isAssignableFrom((Class<?>)cls)) {
                    return ValueType.Character;
                }
                if (QEmptyValue.class.isAssignableFrom((Class<?>)cls)) {
                    return ValueType.QEmptyValue;
                }
                return ValueType.OtherObject;
            });
        }

        private static Object encodeValue(Object value, ValueType type) {
            switch (type) {
                case Boolean: {
                    return (Boolean)((Object)value) != false ? 1 : 0;
                }
                case DateTime: {
                    return ((java.util.Date)((Object)value)).getTime();
                }
                case QEmptyValue: {
                    return 0;
                }
                case OtherObject: {
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
                        ObjectOutputStream os = new ObjectOutputStream(out);
                        if (value instanceof Iterable && !(value instanceof Serializable)) {
                            ArrayList serializableList = new ArrayList(4);
                            if (value instanceof Collection) {
                                serializableList.addAll(value);
                            } else {
                                for (Object item : (Iterable)value) {
                                    serializableList.add(item);
                                }
                            }
                            value = serializableList;
                        }
                        os.writeObject(value);
                        return Base64.getEncoder().encodeToString(out.toByteArray());
                    }
                    catch (Exception e) {
                        throw KDExceptionKit.wrapRuntimeException((Throwable)e);
                    }
                }
            }
            return value;
        }

        private static Object decodeValue(Object value, ValueType type) {
            switch (type) {
                case Boolean: {
                    return (Integer)value == 1;
                }
                case DateTime: {
                    return new java.util.Date(Long.parseLong(value.toString()));
                }
                case QEmptyValue: {
                    return QEmptyValue.value;
                }
                case OtherObject: {
                    try {
                        ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode((String)value));
                        ObjectInputStream is = new ObjectInputStream(in);
                        return is.readObject();
                    }
                    catch (Exception e) {
                        throw KDExceptionKit.wrapRuntimeException((Throwable)e);
                    }
                }
            }
            return value;
        }

        private static int getCPValue(String cp) {
            return cpMap.get(cp.toLowerCase());
        }

        private static String getCP(int cpValue) {
            return cpAntiMap.get(cpValue);
        }

        static {
            Field[] fs = QCP.class.getDeclaredFields();
            int i = 0;
            try {
                for (Field f : fs) {
                    f.setAccessible(true);
                    if (f.getType() != String.class) continue;
                    String cp = (String)f.get(null);
                    cpMap.put(cp, i);
                    cpAntiMap.put(i, cp);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static enum ValueType {
            Null,
            Character,
            Boolean,
            String,
            Number,
            DateTime,
            OtherObject,
            QEmptyValue;

        }
    }

    private static class PropertyExpressInfo {
        String express;
        PropertyField field;

        PropertyExpressInfo(String express, PropertyField field) {
            this.express = express;
            this.field = field;
        }

        public String toString() {
            return this.express;
        }
    }

    @SdkPublic
    public static class QFilterNest
    implements Serializable {
        private static final long serialVersionUID = -4247197451967531145L;
        private static final String AND = "AND";
        private static final String OR = "OR";
        String op;
        QFilter filter;
        QFilter parent;

        private QFilterNest() {
        }

        QFilterNest(String op, QFilter filter, QFilter parent) {
            this.op = op;
            this.filter = filter;
            this.parent = parent;
        }

        public QFilter getFilter() {
            return this.filter;
        }

        public QFilter getParent() {
            return this.parent;
        }

        public void remove() {
            this.parent.nests.remove(this);
        }

        public void maskCurrent() {
            this.filter.expressValue = false;
            this.filter.property = "1";
            this.filter.value = 1;
            this.filter.cp = this.isAnd() ? QFilter.WRITE_OBJECT_HEADERCONTENT_PREFIX : "!=";
        }

        public String toString() {
            return this.op + " " + this.filter;
        }

        public boolean isAnd() {
            return AND.equals(this.op);
        }

        public String getOp() {
            return this.op;
        }
    }
}

