/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.util.DateUtil;

public class QFilterUtil {
    private static final ThreadLocal<SimpleDateFormat> thSDF = ThreadLocals.create(() -> DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss"));
    private static final Set<Class<?>> numberClsSet = new HashSet();
    private static final Log logger = LogFactory.getLog(QFilterUtil.class);

    public static boolean isNumber(Class<?> cls) {
        return numberClsSet.contains(cls);
    }

    private static String toSqlValueString(Object value) {
        String v = String.valueOf(value);
        return v.replaceAll("'", "''");
    }

    static String parametertoString(Object value) {
        QParameter p = QFilterUtil.getInQParameter(value);
        if (p == null) {
            return "";
        }
        Object[] params = p.getParameters();
        StringBuilder s = new StringBuilder(params.length * 10);
        for (Object param : params) {
            if (s.length() > 0) {
                s.append(',');
            }
            if (param == null) {
                s.append("''");
                continue;
            }
            Class<?> cls = param.getClass();
            if (QFilterUtil.isNumber(cls) || cls == Boolean.class) {
                s.append(param);
                continue;
            }
            if (Date.class.isAssignableFrom(cls)) {
                s.append('\'').append(thSDF.get().format((Date)param)).append('\'');
                continue;
            }
            if (cls.isArray()) {
                int n = Array.getLength(param);
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        s.append(',');
                    }
                    s.append(QFilterUtil.parametertoString(Array.get(param, i)));
                }
                continue;
            }
            if (value instanceof MultiBaseDataFilterValue) {
                MultiBaseDataFilterValue multi = (MultiBaseDataFilterValue)value;
                s.append("{\"baseDataName\":\"").append(multi.getBaseDataName()).append("\",\"joinProperty\":\"").append(multi.getJoinProperty()).append("\",\"value\":\"").append(multi.getValue()).append("\"}");
                continue;
            }
            s.append('\'').append(QFilterUtil.toSqlValueString(param)).append('\'');
        }
        return s.toString();
    }

    static QParameter getInQParameter(Object value) {
        if (value == null) {
            return null;
        }
        Object[] params = QFilterUtil.getWithoutDuplicateInValues(value);
        int c = params.length;
        if (c > 0) {
            String sql = QFilterUtil.multiParamsSQL(c);
            return new QParameter(sql, params);
        }
        return null;
    }

    public static QParameter getInQParameter(Object value, boolean sqlWithParam) {
        if (value == null) {
            return null;
        }
        Object[] params = QFilterUtil.getWithoutDuplicateInValues(value);
        int c = params.length;
        if (c > 0) {
            if (sqlWithParam) {
                String sql = QFilterUtil.multiParamsSQL(params);
                return new QParameter(sql, new Object[0]);
            }
            String sql = QFilterUtil.multiParamsSQL(c);
            return new QParameter(sql, params);
        }
        return null;
    }

    public static QParameter getInQParameter(Object[] params, boolean sqlWithParam) {
        int c = params.length;
        if (c > 0) {
            if (sqlWithParam) {
                String sql = QFilterUtil.multiParamsSQL(params);
                return new QParameter(sql, new Object[0]);
            }
            String sql = QFilterUtil.multiParamsSQL(c);
            return new QParameter(sql, params);
        }
        return null;
    }

    static String multiParamsSQL(int c) {
        StringBuilder s = new StringBuilder(c * 2);
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append('?');
        }
        return s.toString();
    }

    static String multiParamsSQL(Object[] params) {
        Object param0 = params[0];
        if (!(param0 instanceof Number)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"Unsupported data type:" + param0.getClass()});
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append(params[i]);
        }
        return s.toString();
    }

    public static Object[] distinctAndIgnoreNullValue(Object values) {
        if (values == null) {
            return null;
        }
        if (values.getClass().isArray()) {
            int c = Array.getLength(values);
            HashSet<Object> set = new HashSet<Object>(c);
            for (int i = 0; i < c; ++i) {
                Object value = Array.get(values, i);
                if (value == null) continue;
                set.add(value);
            }
            c = set.size();
            HugeInConfig.limitInSize(c);
            return set.toArray(new Object[c]);
        }
        if (values instanceof Iterable) {
            return QFilterUtil.iterableToArray(((Iterable)values).iterator());
        }
        if (values instanceof MultiBaseDataFilterValue) {
            Object originValue = ((MultiBaseDataFilterValue)values).getValue();
            if (originValue != null) {
                if (originValue instanceof Collection) {
                    return QFilterUtil.iterableToArray(((Collection)originValue).iterator());
                }
                return new Object[]{originValue};
            }
            return null;
        }
        return new Object[]{values};
    }

    private static Object[] iterableToArray(Iterator iterator) {
        HashSet set = new HashSet(16);
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (value == null) continue;
            set.add(value);
        }
        int c = set.size();
        HugeInConfig.limitInSize(c);
        return set.toArray(new Object[c]);
    }

    public static Object[] getWithoutDuplicateInValues(Object values) {
        if (values == null) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        Object[] params = null;
        if (values.getClass().isArray()) {
            int c = Array.getLength(values);
            HashSet<Object> set = new HashSet<Object>(c);
            for (int i = 0; i < c; ++i) {
                set.add(Array.get(values, i));
            }
            c = set.size();
            HugeInConfig.limitInSize(c);
            params = set.toArray(new Object[c]);
        } else if (values instanceof Set) {
            params = ((Set)values).toArray(new Object[((Set)values).size()]);
        } else if (values instanceof Collection) {
            HashSet set = new HashSet((Collection)values);
            int c = set.size();
            HugeInConfig.limitInSize(c);
            params = set.toArray(new Object[c]);
        } else if (values instanceof Iterable) {
            HashSet set = new HashSet(16);
            for (Object item : (Iterable)values) {
                set.add(item);
            }
            int c = set.size();
            HugeInConfig.limitInSize(c);
            params = set.toArray(new Object[c]);
        } else {
            Object originValue;
            params = values instanceof MultiBaseDataFilterValue ? ((originValue = ((MultiBaseDataFilterValue)values).getValue()) instanceof Collection ? ((Collection)originValue).toArray() : new Object[]{originValue}) : new Object[]{values};
        }
        if (ORMConfig.LOG_RECORD.getBoolean()) {
            logger.info("getWithoutDuplicateInValues cost : [" + (System.currentTimeMillis() - startTime) + "]ms");
        }
        return params;
    }

    public static int getValueSize(Object values) {
        if (values == null) {
            return 0;
        }
        if (values.getClass().isArray()) {
            return Array.getLength(values);
        }
        if (values instanceof Collection) {
            return ((Collection)values).size();
        }
        if (values instanceof Iterable) {
            int count = 0;
            for (Object item : (Iterable)values) {
                ++count;
            }
            return count;
        }
        if (values instanceof MultiBaseDataFilterValue) {
            Object originValue = ((MultiBaseDataFilterValue)values).getValue();
            if (originValue == null) {
                return 0;
            }
            if (originValue instanceof Collection) {
                return ((Collection)originValue).size();
            }
        }
        return 1;
    }

    static {
        numberClsSet.add(Integer.TYPE);
        numberClsSet.add(Long.TYPE);
        numberClsSet.add(Short.TYPE);
        numberClsSet.add(Float.TYPE);
        numberClsSet.add(Double.TYPE);
        numberClsSet.add(Integer.class);
        numberClsSet.add(Long.class);
        numberClsSet.add(Short.class);
        numberClsSet.add(Float.class);
        numberClsSet.add(Double.class);
        numberClsSet.add(BigDecimal.class);
    }
}

