/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.cache;

import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.HashTable;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.CopiedDataSet2;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.dataset.hashjoin.AbstractHashTable;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.PeekingDataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.cache.QueryHashJoinDataSetContext;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.xdb.util.LRUCacheMap;

public final class CacheableLazyQueryHashJoinDataSet
extends CopiedDataSet2 {
    private static final String name = CacheableLazyQueryHashJoinDataSet.class.getSimpleName();
    private static final String cannot_be_iterate = "Lazy hash dataset can't be iterate!";
    private final AbstractDataSet inner;
    private final RowMeta rowMeta;
    private final SingleQuery query;
    private final LRUCacheMap<Object, Row> rowCache;
    private final Set<Object> nullRowSet = new HashSet<Object>();
    private String queryRowSql;
    private Object[] queryRowParams;
    private HashTable cachedHashTable;

    public static PeekingDataSet queryPeekingForHashJoin(SingleQuery query, QueryHashJoinDataSetContext ctx) {
        int queryTop;
        int roleOnCostThreshold = ctx.getRoleOnCostThreshold();
        PeekingDataSet pd = query.queryPeekingWithTopForLazyQuery(name, roleOnCostThreshold, queryTop = ctx.getQueryTop());
        if (pd.getPeekingRowCount() == roleOnCostThreshold) {
            pd.setDataSetCreator((fetched, remaining, withRemainingData) -> new CacheableLazyQueryHashJoinDataSet((AbstractDataSet)(withRemainingData ? fetched.union(remaining) : fetched), query, ctx.getCacheSize()));
        }
        return pd;
    }

    private CacheableLazyQueryHashJoinDataSet(AbstractDataSet fetchedDataSet, SingleQuery query, int cacheSize) {
        super(fetchedDataSet);
        this.inner = fetchedDataSet;
        this.rowMeta = fetchedDataSet.getRowMeta();
        this.query = query;
        this.rowCache = new LRUCacheMap(cacheSize);
    }

    public InnerRowIterator createIterator() {
        throw new IllegalStateException(cannot_be_iterate);
    }

    public RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    public void realClose() {
        this.inner.realClose();
        this.nullRowSet.clear();
        this.rowCache.clear();
    }

    public boolean hasNext() {
        throw new IllegalStateException(cannot_be_iterate);
    }

    public Row next() {
        throw new IllegalStateException(cannot_be_iterate);
    }

    private Row queryRow(PropertyField field, Object value) {
        if (this.queryRowSql == null) {
            QFilter addFilter = new QFilter(field.getOriginalPropertyString(), "=", value);
            QFilter filter = this.query.getWhereFilter();
            filter = filter == null ? addFilter : addFilter.and(filter);
            SingleQuery sq = this.query.optResetFilter(filter);
            SingleQuery.QueryParameter qp = sq.getQueryParameter();
            this.queryRowSql = qp.getSql();
            this.queryRowSql = this.queryRowSql.replaceFirst("SELECT ", "SELECT TOP 1 ");
            this.queryRowParams = qp.getParams();
        } else {
            this.queryRowParams[0] = value;
        }
        return (Row)DB.query((DBRoute)this.query.getDBRoute(), (String)this.queryRowSql, (Object[])this.queryRowParams, rs -> {
            if (rs.next()) {
                return ((AbstractRow)RowFactory.createRow((RowMeta)this.rowMeta, (ResultSet)rs)).persist();
            }
            return null;
        });
    }

    public HashTable toHashTable(String keyField) {
        if (this.cachedHashTable == null) {
            keyField = keyField.toLowerCase(Locale.ENGLISH);
            int fieldIndex = this.rowMeta.getFieldIndex(keyField);
            while (this.inner.hasNext()) {
                AbstractRow row = ((AbstractRow)this.inner.next()).persist();
                this.rowCache.put(row.get(fieldIndex), (Object)row);
            }
            PropertyField field = null;
            for (PropertyField pf : this.query.getSelectFields()) {
                if (!keyField.equals(pf.getAlias().toLowerCase(Locale.ENGLISH))) continue;
                field = pf;
                break;
            }
            final PropertyField whereField = field;
            final String keyField2 = keyField;
            this.cachedHashTable = new AbstractHashTable(){
                private Row row;

                public RowMeta getRowMeta() {
                    return CacheableLazyQueryHashJoinDataSet.this.rowMeta;
                }

                public Row lookup(Object key) {
                    this.row = (Row)CacheableLazyQueryHashJoinDataSet.this.rowCache.get(key);
                    if (this.row != null) {
                        return this.row;
                    }
                    if (CacheableLazyQueryHashJoinDataSet.this.nullRowSet.contains(key)) {
                        return null;
                    }
                    this.row = CacheableLazyQueryHashJoinDataSet.this.queryRow(whereField, key);
                    if (this.row != null) {
                        CacheableLazyQueryHashJoinDataSet.this.rowCache.put(key, (Object)this.row);
                        return this.row;
                    }
                    CacheableLazyQueryHashJoinDataSet.this.nullRowSet.add(key);
                    return null;
                }

                public void close() {
                }

                public boolean exceedMemory() {
                    return false;
                }

                public String getKeyField() {
                    return keyField2;
                }

                public DataSet toDataSet() {
                    throw new IllegalStateException("Lazy hash dataset can't be toDataSet!");
                }
            };
        }
        return this.cachedHashTable;
    }
}

