/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.cache;

import kd.bos.util.ConfigurationUtil;

public final class QueryHashJoinDataSetContext {
    private static boolean cache_enable = false;
    private static boolean lazyQuery_enable = false;
    private static int default_queryTop = 100000;
    private static int default_cacheSize = 200000;
    private int roleOnCostThreshold;
    private int queryTop = default_queryTop;
    private int cacheSize = default_cacheSize;

    public static boolean isCacheEnable() {
        return cache_enable;
    }

    public static boolean isLazyQueryEnable() {
        return lazyQuery_enable;
    }

    public QueryHashJoinDataSetContext(int roleOnCostThreshold) {
        this.roleOnCostThreshold = roleOnCostThreshold;
    }

    public int getQueryTop() {
        if (this.queryTop < this.roleOnCostThreshold) {
            this.queryTop = this.roleOnCostThreshold;
        }
        return this.queryTop;
    }

    public int getRoleOnCostThreshold() {
        return this.roleOnCostThreshold;
    }

    public void setQueryTopSize(int queryTopSize) {
        this.queryTop = queryTopSize;
    }

    public int getCacheSize() {
        if (this.cacheSize < this.queryTop) {
            this.cacheSize = this.queryTop;
        }
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public static void setCacheEnable(boolean cache_enable) {
        QueryHashJoinDataSetContext.cache_enable = cache_enable;
    }

    public static void setLazyQueryEnable(boolean lazyQuery_enable) {
        QueryHashJoinDataSetContext.lazyQuery_enable = lazyQuery_enable;
    }

    static {
        ConfigurationUtil.observeBoolean((String)"orm.opt.hashjoin.cache.enable", (boolean)cache_enable, v -> {
            cache_enable = v;
        });
        ConfigurationUtil.observeBoolean((String)"orm.opt.hashjoin.lazyQuery.enable", (boolean)lazyQuery_enable, v -> {
            lazyQuery_enable = v;
        });
        ConfigurationUtil.observeInteger((String)"orm.opt.hashjoin.queryTop", (int)default_queryTop, v -> {
            default_queryTop = v;
        });
        ConfigurationUtil.observeInteger((String)"orm.opt.hashjoin.cacheSize", (int)default_cacheSize, v -> {
            default_cacheSize = v;
        });
    }
}

