/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.crossdb;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.datasource.DBConfig;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.bos.orm.query.QFilterUtil;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.query.fulltext.QMatches;

public class CrossDBORQuery {
    private static final Object[] emptyIds = new Object[0];
    private static final Log logger = LogFactory.getLog(CrossDBORQuery.class);

    public static void tranferFilterForCrossDBOR(QContext ctx, String rootObjName, QFilter filter) {
        boolean existsCrossDBOR;
        HashMap<String, Set<DBConfig>> configs = new HashMap<String, Set<DBConfig>>();
        try {
            existsCrossDBOR = CrossDBORQuery.isExistsCrossDBOR(ctx, rootObjName, filter, configs);
        }
        catch (Exception e) {
            logger.error("judge cross db or error", (Throwable)e);
            return;
        }
        if (existsCrossDBOR) {
            logger.info("\u8de8\u5e93or\u7684QFilter\u4e3a:" + filter.toSerializedString());
            Map<String, List<QFilter>> groupFilter = CrossDBORQuery.groupQFilterByFullObjectName(ctx, rootObjName, filter, configs);
            CrossDBORQuery.queryInDB(ctx, groupFilter, rootObjName, configs);
        }
    }

    private static void queryInDB(QContext ctx, Map<String, List<QFilter>> groupFilter, String rootName, Map<String, Set<DBConfig>> configs) {
        if (groupFilter == null || groupFilter.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<QFilter>> next : groupFilter.entrySet()) {
            String fullObjectName = next.getKey();
            List<QFilter> filters = next.getValue();
            EntityItem entityItem1 = ctx.getEntityItem(fullObjectName);
            if (entityItem1 == null) {
                throw new IllegalArgumentException(" the entity  " + fullObjectName + " not exists");
            }
            IDataEntityType dt = entityItem1.entityType;
            DBRoute dbRoute = CrossDBORQuery.getDBroute(dt);
            for (QFilter filter : filters) {
                String pk;
                if (filter == null) continue;
                filter.toQParameter(ctx);
                dt = entityItem1.entityType;
                if ("ftlike".equals(filter.getCP()) || "match".equals(filter.getCP())) {
                    CrossDBORQuery.handFtlike(ctx, filter, configs);
                    continue;
                }
                Object filterValue = filter.getValue();
                if (filterValue instanceof MultiBaseDataFilterValue) {
                    CrossDBORQuery.handMultiTypeBasedata(ctx, filter);
                    continue;
                }
                String filterProperty = ORMUtil.getFilterProperty(ctx, filter, rootName);
                int index = filterProperty.lastIndexOf(".") + 1;
                String property = filterProperty.substring(index);
                IDataEntityProperty dp = (IDataEntityProperty)dt.getProperties().get((Object)property);
                String field = ORMUtil.getField(dp);
                if (field.equals(pk = ORMUtil.getRelationKey(dt, entityItem1))) {
                    filter.__setProperty(filterProperty.substring(0, index - 1));
                    int lastDotIndex = filter.getProperty().lastIndexOf(".");
                    if (lastDotIndex < 0) continue;
                    HashMap<String, List<QFilter>> newgroupFilter = new HashMap<String, List<QFilter>>();
                    ArrayList<QFilter> list = new ArrayList<QFilter>();
                    list.add(filter);
                    int fullDox = fullObjectName.lastIndexOf(".");
                    newgroupFilter.put(fullObjectName.substring(0, fullDox), list);
                    CrossDBORQuery.queryInDB(ctx, newgroupFilter, rootName, configs);
                    continue;
                }
                Object[] result = CrossDBORQuery.query(property, pk, field, dp, filter, ctx, dbRoute, dt);
                CrossDBORQuery.handleContinue(fullObjectName, filter, result, rootName, ctx, configs);
            }
        }
    }

    private static Object[] getResult(String pk, String field, IDataEntityProperty dp, QFilter filter, QContext ctx, DBRoute dbRoute, IDataEntityType dt) {
        StringBuilder sql = new StringBuilder(128);
        sql.append("/*ORM*/ ").append("SELECT ").append(pk).append(" FROM ").append(CrossDBORQuery.getTable(dp)).append(" WHERE ");
        LinkedList<Object> plist = new LinkedList<Object>();
        if (filter.getValue() instanceof QEmptyValue) {
            QFilter copyFilter = filter.__copy(false);
            QParameter qParameter = copyFilter.toQParameter(ctx);
            String parameterSql = qParameter.getSql();
            Object[] parameters = qParameter.getParameters();
            int index = parameterSql.indexOf(".");
            String alias = parameterSql.substring(0, index);
            if (alias.startsWith("(")) {
                int lastBracketIndex = alias.lastIndexOf("(");
                alias = alias.substring(lastBracketIndex + 1);
            }
            parameterSql = parameterSql.replace(alias + ".", "");
            sql.append(parameterSql);
            for (int i = 0; i < parameters.length; ++i) {
                plist.add(parameters[i]);
            }
        } else {
            Object[] params;
            if ("in".equals(filter.getCP())) {
                Object[] params2 = CrossDBORQuery.getParams(filter.getValue());
                if (params2.length == 0) {
                    return new Object[0];
                }
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("/*ORM*/ ", new Object[0]).append("SELECT ", new Object[0]).append(pk, new Object[0]).append(" FROM ", new Object[0]).append(CrossDBORQuery.getTable(dp), new Object[0]).append(" WHERE ", new Object[0]);
                sqlBuilder.appendIn(field, params2);
                return (Object[])DB.query((DBRoute)dbRoute, (SqlBuilder)sqlBuilder, rs -> CrossDBORQuery.parseIds(rs, dt.getPrimaryKey().getPropertyType() != String.class));
            }
            if ("not in".equals(filter.getCP()) && (params = CrossDBORQuery.getParams(filter.getValue())).length == 0) {
                sql.append("1=1");
                return (Object[])DB.query((DBRoute)dbRoute, (String)sql.toString(), (Object[])plist.toArray(), rs -> CrossDBORQuery.parseIds(rs, dt.getPrimaryKey().getPropertyType() != String.class));
            }
            QFilterHint qFilterHint = filter.getQFilterHint();
            if (ORMUtil.isContains(qFilterHint) || ORMUtil.isStartWith(qFilterHint) || ORMUtil.isEndWith(qFilterHint)) {
                sql.append(field).append(" ").append(ORMUtil.getLikeCP(dt));
            } else if (ORMUtil.isNotContains(qFilterHint)) {
                sql.append(field).append(' ').append(ORMUtil.getNotLikeCP(dt));
            } else {
                sql.append(field).append(" ").append(filter.getCP());
            }
            CrossDBORQuery.joinQuestionMark(sql, filter.getOriginValue(), plist, filter, dt);
            if (ORMUtil.isFuzzyQuery(filter.getQFilterHint())) {
                sql.append(ORMUtil.addEscapeClause(dt));
            } else if ("like".equalsIgnoreCase(filter.getCP()) && ORMUtil.isEffective(dt)) {
                for (int i = 0; i < plist.size(); ++i) {
                    plist.set(i, ORMUtil.escapeSpecialChar((String)plist.get(i)));
                }
                sql.append(ORMUtil.addEscapeClause(dt));
            }
        }
        return (Object[])DB.query((DBRoute)dbRoute, (String)sql.toString(), (Object[])plist.toArray(), rs -> CrossDBORQuery.parseIds(rs, dt.getPrimaryKey().getPropertyType() != String.class));
    }

    private static Object[] getParams(Object value) {
        Object originValue;
        Object[] params = value instanceof Collection ? ((Collection)value).toArray() : (value instanceof Object[] ? (Object[])value : (value instanceof MultiBaseDataFilterValue ? ((originValue = ((MultiBaseDataFilterValue)value).getValue()) instanceof Collection ? ((Collection)originValue).toArray() : new Object[]{originValue}) : new Object[]{value}));
        return params;
    }

    private static Object[] getResultLang(IDataEntityType dt, QFilter filter, String propertyName, String pk, String field, QContext ctx) {
        String mainTable = dt.getAlias();
        ICollectionProperty localeProperty = (ICollectionProperty)dt.getProperties().get((Object)"multilanguagetext");
        String localeField = ((IDataEntityProperty)localeProperty.getItemType().getProperties().get((Object)"localeid")).getAlias();
        String langTable = localeProperty.getItemType().getAlias();
        String tableGroup = localeProperty.getTableGroup();
        if (tableGroup != null && tableGroup.length() > 0) {
            mainTable = mainTable + '_' + tableGroup;
            langTable = langTable + '_' + tableGroup;
        }
        StringBuilder sql = new StringBuilder(256);
        LinkedList<Object> plist = new LinkedList<Object>();
        String mainTableAlias = "A";
        String langTableAlias = "B";
        String mainTableWithAlias = mainTable + " " + mainTableAlias + " ";
        String langTableWithAlias = langTable + " " + langTableAlias + " ";
        String joinField = dt.getPrimaryKey().getAlias();
        String glField = mainTableAlias + "." + field;
        String langField = langTableAlias + "." + field;
        StringBuilder tempSb = new StringBuilder();
        if (ORMConfiguration.isGLPropertyType(dt, propertyName)) {
            sql.append("/*ORM*/ ").append("SELECT ").append(mainTableAlias).append('.').append(pk).append(" FROM ").append(mainTableWithAlias).append(" LEFT JOIN ").append(langTableWithAlias).append(" ON ").append(mainTableAlias).append(".").append(joinField).append('=').append(langTableAlias).append('.').append(joinField).append(" AND ").append(langTableAlias).append('.').append(localeField).append(" =? ").append(" WHERE ").append(" (");
            tempSb.append(langField);
            field = tempSb.toString();
        } else {
            sql.append("/*ORM*/ ").append("SELECT ").append(langTableAlias).append('.').append(pk).append(" FROM ").append(langTableWithAlias).append(" WHERE ").append(langTableAlias).append('.').append(localeField).append(" =? ").append(" AND (");
            field = langField;
        }
        plist.add(ctx.getORMHint().getLang().toString());
        if (filter.getValue() instanceof QEmptyValue) {
            if ("=".equals(filter.getCP())) {
                sql.append(langField).append(" IS NULL OR ").append(langField).append("='' OR ").append(langField).append("=?");
            } else {
                sql.append(field).append(" ");
                sql.append("is not null and ").append(field).append("!=").append("?");
            }
            sql.append(")");
            plist.add(" ");
        } else {
            Object[] params;
            if ("in".equals(filter.getCP()) && (params = CrossDBORQuery.getParams(filter.getValue())).length == 0) {
                return new Object[0];
            }
            if ("not in".equals(filter.getCP()) && (params = CrossDBORQuery.getParams(filter.getValue())).length == 0) {
                sql.append("1=1)");
                return (Object[])DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)sql.toString(), (Object[])plist.toArray(), rs -> CrossDBORQuery.parseIds(rs, dt.getPrimaryKey().getPropertyType() != String.class));
            }
            sql.append(field).append(" ");
            QFilterHint qFilterHint = filter.getQFilterHint();
            if (ORMUtil.isContains(qFilterHint) || ORMUtil.isStartWith(qFilterHint) || ORMUtil.isEndWith(qFilterHint)) {
                sql.append(ORMUtil.getLikeCP(dt));
            } else if (ORMUtil.isNotContains(qFilterHint)) {
                sql.append(ORMUtil.getNotLikeCP(dt));
            } else {
                sql.append(filter.getCP());
            }
            CrossDBORQuery.joinQuestionMark(sql, filter.getOriginValue(), plist, filter, dt);
            if (ORMUtil.isFuzzyQuery(filter.getQFilterHint())) {
                sql.append(ORMUtil.addEscapeClause(dt));
            } else if ("like".equalsIgnoreCase(filter.getCP()) && ORMUtil.isEffective(dt)) {
                for (int i = 1; i < plist.size(); ++i) {
                    plist.set(i, ORMUtil.escapeSpecialChar((String)plist.get(i)));
                }
                sql.append(ORMUtil.addEscapeClause(dt));
            }
            sql.append(" )");
        }
        return (Object[])DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)sql.toString(), (Object[])plist.toArray(), rs -> CrossDBORQuery.parseIds(rs, dt.getPrimaryKey().getPropertyType() != String.class));
    }

    private static void joinQuestionMark(StringBuilder sql, Object value, List<Object> plist, QFilter filter, IDataEntityType dt) {
        Object originValue;
        String cp = filter.getCP();
        if ("is not null".equals(cp) || "is null".equals(cp)) {
            return;
        }
        sql.append(" (");
        Object[] params = value instanceof Collection ? ((Collection)value).toArray() : (value instanceof Object[] ? (Object[])value : (value instanceof MultiBaseDataFilterValue ? ((originValue = ((MultiBaseDataFilterValue)value).getValue()) instanceof Collection ? ((Collection)originValue).toArray() : (ORMUtil.isFuzzyQuery(filter.getQFilterHint()) ? new Object[]{ORMUtil.transferAndAppendPercent(filter.getQFilterHint(), String.valueOf(originValue), dt)} : new Object[]{originValue})) : (ORMUtil.isFuzzyQuery(filter.getQFilterHint()) ? new Object[]{ORMUtil.transferAndAppendPercent(filter.getQFilterHint(), String.valueOf(value), dt)} : new Object[]{value})));
        for (int i = 0; i < params.length; ++i) {
            if (params.length == 1 || i >= params.length - 1) {
                sql.append("?");
            } else {
                sql.append("?,");
            }
            plist.add(params[i]);
        }
        sql.append(" )");
    }

    private static void addFullObjectName(QContext ctx, QFilter filter, Set<String> allFullObjNames, Set<String> curFullObjNames, String rootObjectName) {
        int index;
        String filterProperty = ORMUtil.getFilterProperty(ctx, filter, rootObjectName);
        int filterDotIndex = filterProperty.lastIndexOf(".");
        if (filterDotIndex > 0) {
            curFullObjNames.add(filterProperty.substring(0, filterDotIndex));
        } else {
            curFullObjNames.add(rootObjectName);
        }
        while ((index = filterProperty.lastIndexOf(".")) > 0) {
            String subFullObjectName = filterProperty.substring(0, index);
            allFullObjNames.add(subFullObjectName);
            filterProperty = subFullObjectName;
        }
    }

    private static boolean isExistsCrossDBOR(QContext ctx, String rootObjectName, QFilter filter, Map<String, Set<DBConfig>> configs) {
        if (!ORMConfig.ENALBE_CROSSDB_OR.getBoolean()) {
            logger.info("cross db or not open ,if want to support ,please config the parameter 'orm.enable.crossdbor=true'");
            return false;
        }
        HashSet<String> allFullObjNames = new HashSet<String>();
        HashSet<String> curFullObjNames = new HashSet<String>();
        allFullObjNames.add(rootObjectName);
        CrossDBORQuery.addFullObjectName(ctx, filter, allFullObjNames, curFullObjNames, rootObjectName);
        List<QFilter.QFilterNest> nests = filter.getNests(true);
        boolean existsOR = false;
        for (QFilter.QFilterNest nest : nests) {
            QFilter nestFi = nest.getFilter();
            CrossDBORQuery.addFullObjectName(ctx, nestFi, allFullObjNames, curFullObjNames, rootObjectName);
            if (nest.isAnd()) continue;
            existsOR = true;
        }
        if (!existsOR) {
            return false;
        }
        if (curFullObjNames.size() <= 1) {
            return false;
        }
        return ORMUtil.isExistsCrossDB(ctx, rootObjectName, configs, allFullObjNames);
    }

    private static Map<String, List<QFilter>> groupQFilterByFullObjectName(QContext ctx, String rootObjectName, QFilter filter, Map<String, Set<DBConfig>> configs) {
        HashMap<String, List<QFilter>> map = new HashMap<String, List<QFilter>>();
        String filterProperty = ORMUtil.getFilterProperty(ctx, filter, rootObjectName);
        if (!CrossDBORQuery.isPropertyOfMainEntity(filterProperty) && !CrossDBORQuery.isSameDB(filterProperty, rootObjectName, configs)) {
            ArrayList<QFilter> mapFilters = new ArrayList<QFilter>();
            mapFilters.add(filter);
            int index = filterProperty.lastIndexOf(".");
            String key = rootObjectName + "." + filterProperty.substring(0, index);
            if (filter.getValue() instanceof MultiBaseDataFilterValue) {
                MultiBaseDataFilterValue multiBaseDataVale = (MultiBaseDataFilterValue)filter.getValue();
                key = rootObjectName + "." + multiBaseDataVale.getJoinProperty();
            }
            map.put(key, mapFilters);
        }
        List<QFilter.QFilterNest> nests = filter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            ArrayList<QFilter> filters;
            QFilter nestFilter = nest.getFilter();
            String nestFilterProperty = ORMUtil.getFilterProperty(ctx, nestFilter, rootObjectName);
            if (CrossDBORQuery.isPropertyOfMainEntity(nestFilterProperty) || CrossDBORQuery.isSameDB(nestFilterProperty, rootObjectName, configs)) continue;
            int index = nestFilterProperty.lastIndexOf(".");
            String nestFilterFullObjectName = rootObjectName + "." + nestFilterProperty.substring(0, index);
            if (nestFilter.getValue() instanceof MultiBaseDataFilterValue) {
                MultiBaseDataFilterValue multiBaseDataVale = (MultiBaseDataFilterValue)nestFilter.getValue();
                nestFilterFullObjectName = rootObjectName + "." + multiBaseDataVale.getJoinProperty();
            }
            if ((filters = (ArrayList<QFilter>)map.get(nestFilterFullObjectName)) == null) {
                filters = new ArrayList<QFilter>();
                map.put(nestFilterFullObjectName, filters);
            }
            filters.add(nestFilter);
        }
        return map;
    }

    private static boolean isPropertyOfMainEntity(String property) {
        return !property.contains(".");
    }

    private static boolean isSameDB(String property, String rootObjectName, Map<String, Set<DBConfig>> configs) {
        int index;
        while ((index = property.lastIndexOf(".")) != -1) {
            String subEntityKey = rootObjectName + "." + property.substring(0, index);
            Set<DBConfig> dbConfigs = configs.get(rootObjectName);
            Set<DBConfig> propertyConfigs = configs.get(subEntityKey);
            if (dbConfigs == null || propertyConfigs == null) {
                return false;
            }
            for (DBConfig config : dbConfigs) {
                for (DBConfig innerConfig : propertyConfigs) {
                    if (config.canSharing(innerConfig)) continue;
                    return false;
                }
            }
            property = property.substring(0, index);
        }
        return true;
    }

    private static String getTable(IDataEntityProperty dp) {
        String table = dp.getParent().getAlias();
        String tableGroup = dp.getTableGroup();
        if (tableGroup != null && tableGroup.length() > 0) {
            table = table + '_' + tableGroup;
        }
        return table;
    }

    private static Object[] parseIds(ResultSet rs, boolean isNumber) throws Exception {
        HashSet<Object> list = new HashSet<Object>();
        if (isNumber) {
            while (rs.next()) {
                list.add(rs.getLong(1));
            }
        } else {
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        if (list.size() == 0) {
            return emptyIds;
        }
        Object[] ret = new Object[list.size()];
        int i = 0;
        for (Object e : list) {
            ret[i++] = e;
        }
        return ret;
    }

    private static void handFtlike(QContext ctx, QFilter filter, Map<String, Set<DBConfig>> configs) {
        String rootObjName = ctx.getMainEntityItem().getFullObjectName();
        QParameter qParameter = QMatches.toQParameter(ctx, rootObjName, new Object(), filter);
        QFilter matchTransferQFilter = qParameter.getMatchTransferQFilter();
        boolean hasParameter = CrossDBORQuery.hasParameter(matchTransferQFilter.getValue());
        filter.maskCurrent();
        if (hasParameter) {
            if (ORMUtil.isFuzzyQuery(matchTransferQFilter.getQFilterHint())) {
                filter.__setProperty(matchTransferQFilter.getProperty());
                filter.__setCP(matchTransferQFilter.getCP());
                filter.__setValue(matchTransferQFilter.getOriginValue());
                filter.setQFilterHint(matchTransferQFilter.getQFilterHint());
            } else {
                filter.__setProperty(matchTransferQFilter.getProperty());
                filter.__setCP(matchTransferQFilter.getCP());
                filter.__setValue(matchTransferQFilter.getValue());
            }
        } else {
            filter.__setProperty("1");
            filter.__setCP("!=");
            filter.__setValue(1);
            return;
        }
        int lastDotIndex = filter.getProperty().lastIndexOf(".");
        if (lastDotIndex == -1) {
            return;
        }
        HashMap<String, List<QFilter>> newgroupFilter = new HashMap<String, List<QFilter>>();
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(filter);
        newgroupFilter.put(rootObjName + "." + filter.getProperty().substring(0, lastDotIndex), list);
        CrossDBORQuery.queryInDB(ctx, newgroupFilter, rootObjName, configs);
    }

    private static boolean hasParameter(Object value) {
        try {
            return QFilterUtil.getValueSize(value) > 0;
        }
        catch (Exception e) {
            logger.error("hasParameter error", (Throwable)e);
            return value != null;
        }
    }

    private static void handleContinue(String fullObjectName, QFilter filter, Object[] result, String rootName, QContext ctx, Map<String, Set<DBConfig>> configs) {
        int propertyIndex = fullObjectName.indexOf(".");
        String newProperty = fullObjectName.substring(propertyIndex + 1);
        filter.__setProperty(newProperty);
        filter.__setCP("in");
        if (result == null || result.length <= 0) {
            filter.__setValue(1);
            filter.__setProperty("1");
            filter.__setCP("!=");
            return;
        }
        filter.__setValue(result);
        int dotIndex = newProperty.lastIndexOf(".");
        if (dotIndex > -1) {
            if (CrossDBORQuery.isSameDB(newProperty, rootName, configs)) {
                return;
            }
            int lastDotIndex = fullObjectName.lastIndexOf(".");
            HashMap<String, List<QFilter>> newgroupFilter = new HashMap<String, List<QFilter>>();
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            list.add(filter);
            newgroupFilter.put(fullObjectName.substring(0, lastDotIndex), list);
            CrossDBORQuery.queryInDB(ctx, newgroupFilter, rootName, configs);
        }
    }

    private static DBRoute getDBroute(IDataEntityType dt) {
        IDataEntityType billRootDT = dt;
        while (ORMConfiguration.isEntryEntityType(billRootDT)) {
            billRootDT = billRootDT.getParent();
        }
        return DBRoute.of((String)billRootDT.getDBRouteKey());
    }

    public static Object[] query(String property, String pk, String field, IDataEntityProperty dp, QFilter filter, QContext ctx, DBRoute dbRoute, IDataEntityType dt) {
        Object[] result = ORMConfiguration.isMultiLangPropertyType(dp) ? (ORMConfiguration.useSingleLang() && ORMConfiguration.isGLPropertyType(dt, property) ? CrossDBORQuery.getResult(pk, field, dp, filter, ctx, dbRoute, dt) : CrossDBORQuery.getResultLang(dt, filter, property, pk, field, ctx)) : CrossDBORQuery.getResult(pk, field, dp, filter, ctx, dbRoute, dt);
        return result;
    }

    private static void handMultiTypeBasedata(QContext ctx, QFilter filter) {
        String newProperty;
        int dotIndex;
        MultiBaseDataFilterValue filterValue = (MultiBaseDataFilterValue)filter.getValue();
        do {
            String pk;
            String filterProperty;
            int index;
            if ((index = (filterProperty = filter.getProperty()).lastIndexOf(".")) == -1) {
                filter.__setProperty(filterValue.getJoinProperty());
                return;
            }
            EntityItem entityItem = ctx.getEntityItem(filterProperty.substring(0, index));
            IDataEntityType dt = entityItem.entityType;
            String property = filterProperty.substring(index + 1);
            IDataEntityProperty dp = (IDataEntityProperty)dt.getProperties().get((Object)property);
            String field = ORMUtil.getField(dp);
            if (field.equals(pk = ORMUtil.getRelationKey(dt, entityItem))) {
                filter.__setProperty(filterValue.getJoinProperty());
                return;
            }
            DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
            Object[] result = CrossDBORQuery.query(property, pk, field, dp, filter, ctx, dbRoute, dt);
            newProperty = filterProperty.substring(0, index);
            filter.__setProperty(newProperty);
            filter.__setCP("in");
            if (result == null || result.length <= 0) {
                filter.__setValue(1);
                filter.__setProperty("1");
                filter.__setCP("!=");
                return;
            }
            filter.__setValue(result);
        } while ((dotIndex = newProperty.lastIndexOf(".")) != -1);
        filter.__setProperty(filterValue.getJoinProperty());
    }
}

