/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.crossdb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.crossdb.CorssDBType;
import kd.bos.orm.query.crossdb.CrossDBConfig;

public class TenantAccountCrossDBRuntime {
    private static final Log log = LogFactory.getLog(TenantAccountCrossDBRuntime.class);
    private static final Map<String, TenantAccountCrossDBRuntime> runtimeMap = new ConcurrentHashMap<String, TenantAccountCrossDBRuntime>();
    private Map<String, String> entityVersionMap = new ConcurrentHashMap<String, String>();
    private Map<String, DBConfig> tableDBConfigMap = new ConcurrentHashMap<String, DBConfig>();
    private Map<String, DBConfig> routeDBConfigMap = new ConcurrentHashMap<String, DBConfig>();

    public static boolean isCrossDBEnable() {
        return CrossDBConfig.isCrossDBEnable();
    }

    public static String getCrossDBTable(String table, String crossToRouteKey, boolean withCrossDBObjectOrFilter) {
        if (crossToRouteKey != null && CrossDBConfig.isCrossDBEnable() && (CrossDBConfig.isCrossDBEnableOnlyOrFilter() && withCrossDBObjectOrFilter || !CrossDBConfig.isCrossDBEnableOnlyOrFilter())) {
            RequestContextInfo rc = RequestContextInfo.get();
            String key = rc.getTenantId() + '#' + rc.getAccountId();
            TenantAccountCrossDBRuntime runtime = runtimeMap.computeIfAbsent(key, k -> new TenantAccountCrossDBRuntime());
            return runtime.doGetCrossDBTable(table, crossToRouteKey);
        }
        return table;
    }

    public static String getCrossDBTable(String tableRouteKey, String table, String crossToRouteKey, boolean withCrossDBObjectOrFilter) {
        if (crossToRouteKey != null && CrossDBConfig.isCrossDBEnable() && (CrossDBConfig.isCrossDBEnableOnlyOrFilter() && withCrossDBObjectOrFilter || !CrossDBConfig.isCrossDBEnableOnlyOrFilter())) {
            RequestContextInfo rc = RequestContextInfo.get();
            String key = rc.getTenantId() + '#' + rc.getAccountId();
            TenantAccountCrossDBRuntime runtime = runtimeMap.computeIfAbsent(key, k -> new TenantAccountCrossDBRuntime());
            return runtime.doGetCrossDBTable(tableRouteKey, table, crossToRouteKey);
        }
        return table;
    }

    public static void parseEntityTables(IDataEntityType dt, Map<String, IDataEntityType> entityTypeCache) {
        if (CrossDBConfig.isCrossDBEnable() && (CrossDBConfig.isAllEntity() || CrossDBConfig.getCrossDBEntitySet().contains(dt.getName().toLowerCase()))) {
            RequestContextInfo rc = RequestContextInfo.get();
            String key = rc.getTenantId() + '#' + rc.getAccountId();
            TenantAccountCrossDBRuntime runtime = runtimeMap.computeIfAbsent(key, k -> new TenantAccountCrossDBRuntime());
            runtime.parseTables(dt, entityTypeCache);
        }
    }

    public static boolean useSameDB(Set<String> routeKeys) {
        if (routeKeys.size() <= 1) {
            return true;
        }
        RequestContextInfo rc = RequestContextInfo.get();
        String key = rc.getTenantId() + '#' + rc.getAccountId();
        TenantAccountCrossDBRuntime runtime = runtimeMap.computeIfAbsent(key, k -> new TenantAccountCrossDBRuntime());
        HashSet<String> dbId = new HashSet<String>(routeKeys.size());
        for (String routeKey : routeKeys) {
            dbId.add(runtime.getDBConfig(routeKey).getSharingId());
        }
        return dbId.size() == 1;
    }

    static void clearRuntime() {
        runtimeMap.clear();
    }

    private TenantAccountCrossDBRuntime() {
    }

    private void parseTables(IDataEntityType dt, Map<String, IDataEntityType> entityTypeCache) {
        try {
            DBConfig dbConfig;
            String newVersion;
            boolean crossDBLogChange = CrossDBConfig.isCrossDBLogChange();
            if (ORMConfiguration.isRefEntity(dt)) {
                dt = ORMConfiguration.innerGetDataEntityType(dt.getName(), entityTypeCache);
            }
            if ((newVersion = dt.getVersion()) != null && newVersion.length() > 0) {
                String name = dt.getName();
                String oldVersion = this.entityVersionMap.get(name);
                if (oldVersion == null || !newVersion.equals(oldVersion)) {
                    if (crossDBLogChange) {
                        log.error("[Trace-CorssDB-parseTables] " + name + ": oldVersion=" + oldVersion + ", newVersion=" + newVersion);
                    }
                    this.entityVersionMap.put(name, newVersion);
                } else {
                    DBConfig dbConfig2;
                    if (crossDBLogChange && (dbConfig2 = this.getDBConfig(dt.getDBRouteKey())) != null) {
                        Map<String, DBConfig> map = this.getEntityTablesDBConfigMap(dt, dbConfig2);
                        List<String> runtimeTables = this.getRuntimeSchemaTables(dbConfig2);
                        if (!runtimeTables.containsAll(map.keySet())) {
                            ArrayList<String> missTables = new ArrayList<String>(runtimeTables);
                            missTables.removeAll(map.keySet());
                            log.error("[Trace-CorssDB-parseTables]" + name + ": error, runtimeTables miss " + missTables + "\nnewTables=" + map.keySet() + '\n' + dbConfig2.getSchema() + "-runtimeTables=" + runtimeTables);
                        }
                    }
                    return;
                }
            }
            if ((dbConfig = this.getDBConfig(dt.getDBRouteKey())) != null) {
                Map<String, DBConfig> map = this.getEntityTablesDBConfigMap(dt, dbConfig);
                if (crossDBLogChange) {
                    List<String> runtimeTables = this.getRuntimeSchemaTables(dbConfig);
                    log.error("[Trace-CorssDB-parseTables] " + dt.getName() + ": newTables=" + map.keySet() + '\n' + dbConfig.getSchema() + "-runtimeTables=" + runtimeTables);
                }
                this.tableDBConfigMap.putAll(map);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private List<String> getRuntimeSchemaTables(DBConfig dbConfig) {
        TreeMap<String, DBConfig> bufMap = new TreeMap<String, DBConfig>(this.tableDBConfigMap);
        ArrayList<String> runtimeTables = new ArrayList<String>();
        for (Map.Entry entry : bufMap.entrySet()) {
            if (entry.getValue() != dbConfig) continue;
            runtimeTables.add((String)entry.getKey());
        }
        return runtimeTables;
    }

    private Map<String, DBConfig> getEntityTablesDBConfigMap(IDataEntityType dt, DBConfig dbConfig) {
        HashSet<String> tables = new HashSet<String>(4);
        this.collectTable(dt, tables);
        HashMap<String, DBConfig> map = new HashMap<String, DBConfig>(tables.size());
        for (String table : tables) {
            map.put(table, dbConfig);
        }
        return map;
    }

    private void collectTable(IDataEntityType dt, Set<String> tables) {
        String mainTable = dt.getAlias();
        if (mainTable == null || mainTable.length() == 0) {
            return;
        }
        String routeKeyPrefix = dt.getDBRouteKey() == null ? "" : dt.getDBRouteKey().toLowerCase(Locale.ENGLISH) + "#";
        tables.add(routeKeyPrefix + mainTable.toLowerCase());
        DataEntityPropertyCollection dps = dt.getProperties();
        int n = dps.size();
        for (int i = 0; i < n; ++i) {
            String tableGroup;
            IDataEntityProperty dp = (IDataEntityProperty)dps.get(i);
            if (dp instanceof ICollectionProperty) {
                if (dp instanceof DynamicLocaleProperty) {
                    tables.add(routeKeyPrefix + mainTable.toLowerCase() + "_l");
                    continue;
                }
                IDataEntityType itemDT = ((ICollectionProperty)dp).getItemType();
                if (!ORMConfiguration.isEntryEntityType(itemDT) || itemDT.getAlias() == null || itemDT.getAlias().trim().length() <= 0) continue;
                this.collectTable(itemDT, tables);
                continue;
            }
            if (ORMUtil.isDbIgnoreRefBaseData(dp) || ORMUtil.isDbIgnore(dp) || (tableGroup = dp.getTableGroup()) == null || tableGroup.length() <= 0) continue;
            tables.add(routeKeyPrefix + (mainTable + '_' + tableGroup).toLowerCase());
        }
    }

    private String doGetCrossDBTable(String table, String crossToRouteKey) {
        return this.doGetCrossDBTable(null, table, crossToRouteKey);
    }

    private String doGetCrossDBTable(String tableRouteKey, String table, String crossToRouteKey) {
        CorssDBType type;
        DBConfig mainDBConfig;
        String key = tableRouteKey == null ? table.toLowerCase(Locale.ENGLISH) : tableRouteKey.toLowerCase(Locale.ENGLISH) + "#" + table.toLowerCase(Locale.ENGLISH);
        DBConfig tableDBConfig = this.tableDBConfigMap.get(key);
        if (tableDBConfig != null && (mainDBConfig = this.getDBConfig(crossToRouteKey)) != null && ((type = CrossDBConfig.getCorssDBType()) == CorssDBType.schema && !tableDBConfig.canSharing(mainDBConfig) || type == CorssDBType.link)) {
            return CrossDBConfig.getCorssDBPattern(tableDBConfig.getDBType()).genCrossDBTable(tableDBConfig.getUser(), tableDBConfig.getSchema(), table);
        }
        return table;
    }

    private DBConfig getDBConfig(String routeKey) {
        return this.routeDBConfigMap.computeIfAbsent(routeKey.toLowerCase(), k -> {
            try (DelegateConnection con = (DelegateConnection)TX.__getConnectionSkipWriteArchiveCheck((String)routeKey, (boolean)false);){
                DBConfig dBConfig = con.getDBConfig();
                return dBConfig;
            }
            catch (Exception e) {
                return null;
            }
        });
    }
}

