/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.crud.read;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;

public class SelectFieldBuilder {
    private IDataEntityType entityType;

    public SelectFieldBuilder(String entityName, Map<String, IDataEntityType> entityTypeCache) {
        this.entityType = ORMConfiguration.innerGetDataEntityType(entityName, entityTypeCache);
    }

    public String buildSelectFields(boolean loadRefDatabase) {
        ArrayList<String> list = new ArrayList<String>();
        this.collectFields("", this.entityType, loadRefDatabase, list, false, false);
        StringBuilder sb = new StringBuilder(list.size() * 10);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append((String)list.get(i));
        }
        return sb.toString();
    }

    public String buildSelectPKs() {
        ArrayList<String> list = new ArrayList<String>();
        this.collectFields("", this.entityType, false, list, false, true);
        StringBuilder sb = new StringBuilder(list.size() * 10);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append((String)list.get(i));
        }
        return sb.toString();
    }

    private void collectFields(String fullObjName, IDataEntityType entityType, boolean loadRefDatabase, List<String> list, boolean isLocaleEntity, boolean onlyPK) {
        if (entityType == null) {
            return;
        }
        String prefix = fullObjName.length() == 0 ? fullObjName : fullObjName + ".";
        DataEntityPropertyCollection ps = entityType.getProperties();
        for (IDataEntityProperty dp : ps) {
            if (dp instanceof ICollectionProperty) {
                String subFullObjName;
                if (dp instanceof DynamicLocaleProperty) {
                    subFullObjName = fullObjName;
                    this.collectFields(subFullObjName, ((ICollectionProperty)dp).getItemType(), false, list, true, onlyPK);
                    continue;
                }
                String tableName = ((ICollectionProperty)dp).getItemType().getAlias();
                if (tableName == null || tableName.trim().length() == 0) continue;
                subFullObjName = prefix + dp.getName();
                this.collectFields(subFullObjName, ((ICollectionProperty)dp).getItemType(), loadRefDatabase, list, false, onlyPK);
                continue;
            }
            if (dp instanceof IComplexProperty) {
                if (ORMUtil.isDbIgnoreRefBaseData(dp)) continue;
                if (loadRefDatabase) {
                    this.collectFields(prefix + dp.getName(), ((IComplexProperty)dp).getComplexType(), false, list, false, onlyPK);
                    continue;
                }
                list.add(prefix + dp.getName() + '.' + ((IComplexProperty)dp).getComplexType().getPrimaryKey().getName());
                continue;
            }
            if (onlyPK) {
                if (dp != entityType.getPrimaryKey()) {
                    continue;
                }
            } else {
                if (ORMUtil.isDbIgnore(dp)) continue;
                String name = dp.getName().toLowerCase();
                if (isLocaleEntity && ("pkid".equals(name) || "localeid".equals(name)) || name.endsWith("_id") && ps.containsKey((Object)name.substring(0, name.length() - "_id".length()))) continue;
            }
            list.add(prefix + dp.getName());
        }
    }
}

