/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.fulltext;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.CollectionProperty;
import kd.bos.dataentity.metadata.clr.ComplexProperty;
import kd.bos.dataentity.metadata.clr.SimpleProperty;
import org.apache.commons.beanutils.PropertyUtils;

@DataEntityTypeAttribute(tableName="T_BAS_FULLTEXTINDEX", dbRouteKey="basedata")
public class FullTextIndex {
    DataEntityState dataEntityState = new DefaultDataEntityState(FullTextIndex.class);
    long id;
    String entityNumber;
    String fieldName;
    Date syncTime;

    public FullTextIndex() {
    }

    public FullTextIndex(String entityNumber, String fieldName) {
        this.entityNumber = entityNumber;
        this.fieldName = fieldName;
    }

    public DataEntityState getDataEntityState() {
        return this.dataEntityState;
    }

    public void setDataEntityState(DataEntityState dataEntityState) {
        this.dataEntityState = dataEntityState;
    }

    @SimplePropertyAttribute(isPrimaryKey=true, alias="FID", dbType=-5)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @SimplePropertyAttribute(alias="FENTITYNUMBER", dbType=12)
    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    @SimplePropertyAttribute(alias="FFIELDNAME", dbType=12)
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @SimplePropertyAttribute(alias="FSYNCTIME", dbType=91)
    public Date getSyncTime() {
        return this.syncTime;
    }

    public void setSyncTime(Date syncTime) {
        this.syncTime = syncTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FullTextIndex)) {
            return false;
        }
        FullTextIndex fullTextIndex = (FullTextIndex)o;
        return Objects.equals(this.entityNumber, fullTextIndex.entityNumber) && Objects.equals(this.fieldName, fullTextIndex.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.entityNumber, this.fieldName);
    }

    public String toString() {
        return this.entityNumber + "." + this.fieldName;
    }

    private static class DefaultDataEntityState
    extends DataEntityState {
        private static final long serialVersionUID = -6564320589975175916L;
        Class<?> type;

        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public DefaultDataEntityState(Class<?> type) {
            this.type = type;
        }

        public void setPropertyChanged(PropertyChangeEvent arg0) {
        }

        public void setDirty(boolean arg0) {
        }

        public boolean getDataEntityDirty() {
            return false;
        }

        public List<IDataEntityProperty> GetDirtyProperties(boolean arg0) {
            PropertyDescriptor[] propertyInfos = PropertyUtils.getPropertyDescriptors(this.type);
            ArrayList<IDataEntityProperty> list = new ArrayList<IDataEntityProperty>(propertyInfos.length);
            int ordinal = 0;
            for (PropertyDescriptor pitem : propertyInfos) {
                SimpleProperty property;
                Method readMethod = pitem.getReadMethod();
                if (readMethod == null) continue;
                if (readMethod.isAnnotationPresent(SimplePropertyAttribute.class)) {
                    property = new SimpleProperty(pitem, ordinal++);
                    list.add((IDataEntityProperty)property);
                    continue;
                }
                if (readMethod.isAnnotationPresent(ComplexPropertyAttribute.class)) {
                    property = new ComplexProperty(pitem, ordinal++);
                    list.add((IDataEntityProperty)property);
                    continue;
                }
                if (!readMethod.isAnnotationPresent(CollectionPropertyAttribute.class)) continue;
                CollectionProperty cproperty = new CollectionProperty(pitem, ordinal++);
                list.add((IDataEntityProperty)cproperty);
            }
            list.trimToSize();
            return list;
        }

        public List<IDataEntityProperty> GetDirtyProperties() {
            return null;
        }

        public long[] getDirtyFlags() {
            return null;
        }

        public void setDirtyFlags(long[] values) {
        }
    }
}

