/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.fulltext;

import java.io.IOException;
import java.io.StringReader;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.fulltext.FullTextFactory;
import kd.bos.fulltext.FullTextQuery;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;

public class QFullTextQuery {
    private static final String FT_ENABLE = "ft.enable";
    private static final String bos_fulltext_server = "elasticsearch.server.quicksearch";
    private static final String basedata_gl = "basedata.generalLang.enable";
    private static final Object[] emptyIds = new Object[0];
    private static boolean enableFT = false;
    private static boolean enableGL = Boolean.getBoolean("basedata.generalLang.enable");
    private static final Log log = LogFactory.getLog(QFullTextQuery.class);
    private static final Class<?> entryProp;
    private Map<String, IDataEntityType> entityTypeCache;

    private static boolean isCofigFullTextEnable(String configValue) {
        Properties prop = new Properties();
        StringReader reader = new StringReader(configValue);
        try {
            prop.load(reader);
        }
        catch (IOException e) {
            log.error("key:elasticsearch.server.quicksearchvalue:" + configValue + "\u914d\u7f6e\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002" + e.getMessage());
        }
        String enableStr = prop.getProperty("enable");
        if (StringUtils.isEmpty((String)enableStr)) {
            enableStr = "true";
        }
        return "true".equals(System.getProperty(FT_ENABLE, "true")) && Boolean.parseBoolean(enableStr);
    }

    static FullTextQuery ft() {
        return FullTextFactory.getFullTextQuery();
    }

    static QFullTextQuery db(Map<String, IDataEntityType> entityTypeCache) {
        return new QFullTextQuery(entityTypeCache);
    }

    public static boolean isFullTextEnable() {
        return enableFT;
    }

    private QFullTextQuery(Map<String, IDataEntityType> entityTypeCache) {
        this.entityTypeCache = entityTypeCache;
    }

    Object[] inQuery(String entityName, String propertyName, Object[] values) {
        IDataEntityType dt = ORMConfiguration.innerGetDataEntityType(entityName, this.entityTypeCache);
        return this.inQuery(dt, propertyName, values);
    }

    Object[] inQuery(IDataEntityType dt, String propertyName, Object[] values) {
        IDataEntityType billRootDT = dt;
        while (ORMConfiguration.isEntryEntityType(billRootDT)) {
            billRootDT = billRootDT.getParent();
        }
        DBRoute dbRoute = DBRoute.of((String)billRootDT.getDBRouteKey());
        IDataEntityProperty dp = (IDataEntityProperty)dt.getProperties().get((Object)propertyName);
        String field = this.getField(dp);
        String pk = this.getPrimaryKey(dt);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("/*ORM*/ ", new Object[0]).append("SELECT ", new Object[0]).append(pk, new Object[0]).append(" FROM ", new Object[0]).append(this.getTable(dp), new Object[0]).append(" WHERE ", new Object[0]);
        sqlBuilder.appendIn(field, values);
        return (Object[])DB.query((DBRoute)dbRoute, (SqlBuilder)sqlBuilder, rs -> this.parseIds(rs, dt.getPrimaryKey().getPropertyType() != String.class));
    }

    private String getPrimaryKey(IDataEntityType dt) {
        String pk;
        if (ORMConfiguration.isSubEntityType(dt)) {
            pk = dt.getPrimaryKey().getAlias();
        } else {
            if (ORMConfiguration.isMulBasedata(dt)) {
                return this.getMultiPrimaryKey(dt);
            }
            pk = dt.getPrimaryKey().getAlias();
        }
        return pk;
    }

    private String getMultiPrimaryKey(IDataEntityType dt) {
        IDataEntityType parent;
        String primaryKey = dt.getPrimaryKey().getAlias();
        while ((parent = dt.getParent()) != null) {
            if (ORMConfiguration.isMulBasedata(parent)) continue;
            primaryKey = parent.getPrimaryKey().getAlias();
            break;
        }
        return primaryKey;
    }

    Object[] queryPropertyValueByPKs(String entityName, String propertyName, Object[] values) {
        IDataEntityType dt;
        if (values == null || values.length == 0) {
            return new Object[0];
        }
        IDataEntityType billRootDT = dt = ORMConfiguration.innerGetDataEntityType(entityName, this.entityTypeCache);
        while (ORMConfiguration.isEntryEntityType(billRootDT)) {
            billRootDT = billRootDT.getParent();
        }
        DBRoute dbRoute = DBRoute.of((String)billRootDT.getDBRouteKey());
        IDataEntityProperty dp = (IDataEntityProperty)dt.getProperties().get((Object)propertyName);
        String field = this.getField(dp);
        StringBuilder sql = new StringBuilder(128 + values.length * 2);
        sql.append("/*ORM*/ ").append("SELECT ").append(field).append(" FROM ").append(this.getTable(dp)).append(" WHERE ").append(dt.getPrimaryKey().getAlias()).append(" IN (");
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sql.append(',');
            }
            sql.append('?');
        }
        sql.append(") ");
        return (Object[])DB.query((DBRoute)dbRoute, (String)sql.toString(), (Object[])values, rs -> this.parseIds(rs, dp.getPropertyType() != String.class));
    }

    Object[] queryNormal(IDataEntityType dt, String propertyName, String[] values, boolean isMultiValue, boolean isDBFulltextField, QFilter matchFilter) {
        IDataEntityType billRootDT = dt;
        while (ORMConfiguration.isEntryEntityType(billRootDT)) {
            billRootDT = billRootDT.getParent();
        }
        DBRoute dbRoute = DBRoute.of((String)billRootDT.getDBRouteKey());
        IDataEntityProperty dp = (IDataEntityProperty)dt.getProperties().get((Object)propertyName);
        String field = this.getField(dp);
        String pk = this.getPrimaryKey(dt);
        StringBuilder sql = new StringBuilder(128 + values.length * 10);
        sql.append("/*ORM*/ ").append("SELECT ").append(pk).append(" FROM ").append(this.getTable(dp)).append(" WHERE ");
        ArrayList<Object> plist = new ArrayList<Object>(values.length);
        for (String value : values) {
            this.add2SQL(sql, field, value, isMultiValue, plist, isDBFulltextField, dt, matchFilter);
        }
        return (Object[])DB.query((DBRoute)dbRoute, (String)sql.toString(), (Object[])plist.toArray(), rs -> this.parseIds(rs, dt.getPrimaryKey().getPropertyType() != String.class));
    }

    Object[] queryLang(IDataEntityType dt, String propertyName, Lang lang, String[] values, boolean isMultiValue, boolean isDBFulltextField, QFilter matchFilter) {
        String mainTable = dt.getAlias();
        ICollectionProperty localeProperty = (ICollectionProperty)dt.getProperties().get((Object)"multilanguagetext");
        String localeField = ((IDataEntityProperty)localeProperty.getItemType().getProperties().get((Object)"localeid")).getAlias();
        IDataEntityProperty dp = (IDataEntityProperty)dt.getProperties().get((Object)propertyName);
        String field = this.getField(dp);
        String pk = this.getPrimaryKey(dt);
        String langTable = localeProperty.getItemType().getAlias();
        String tableGroup = localeProperty.getTableGroup();
        if (tableGroup != null && tableGroup.length() > 0) {
            mainTable = mainTable + '_' + tableGroup;
            langTable = langTable + '_' + tableGroup;
        }
        StringBuilder sql = new StringBuilder(256 + values.length * 10);
        LinkedList<Object> plist = new LinkedList<Object>();
        boolean joinMainTable = ORMConfiguration.isGLPropertyType(dt, propertyName);
        if (joinMainTable && enableGL) {
            String mainTableAlias = "A";
            String langTableAlias = "B";
            String mainTableWithAlias = mainTable + " " + mainTableAlias + " ";
            String langTableWithAlias = langTable + " " + langTableAlias + " ";
            sql.append("/*ORM*/ ").append("SELECT ").append(mainTableAlias).append('.').append(pk).append(" FROM ").append(mainTableWithAlias).append(" LEFT JOIN ").append(langTableWithAlias).append(" ON ").append(mainTableAlias).append(".").append(pk).append('=').append(langTableAlias).append('.').append(pk).append(" AND ").append(langTableAlias).append('.').append(localeField).append(" =? ").append(" WHERE ").append(" (");
            String glField = mainTableAlias + "." + field;
            String langField = langTableAlias + "." + field;
            StringBuilder tempSb = new StringBuilder();
            tempSb.append("CASE WHEN ").append(langField).append(" IS NULL THEN ").append(glField).append(" WHEN ").append(langField).append(" = '' THEN ").append(glField).append(" WHEN ").append(langField).append(" = ' ' THEN ").append(glField).append(" ELSE ").append(langField).append(" END");
            field = tempSb.toString();
        } else {
            sql.append("/*ORM*/ ").append("SELECT ").append(pk).append(" FROM ").append(langTable).append(" WHERE ").append(localeField).append("=? AND (");
        }
        for (String value : values) {
            this.add2SQL(sql, field, value, isMultiValue, plist, isDBFulltextField, dt, matchFilter);
        }
        sql.append(')');
        plist.add(0, lang.toString());
        return (Object[])DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)sql.toString(), (Object[])plist.toArray(), rs -> this.parseIds(rs, dt.getPrimaryKey().getPropertyType() != String.class));
    }

    private void add2SQL(StringBuilder sql, String field, String value, boolean isMultiValue, List<Object> plist, boolean isDBFulltextField, IDataEntityType dataEntityType, QFilter matchFilter) {
        if (!plist.isEmpty()) {
            sql.append(" OR ");
        }
        if (isMultiValue) {
            String[] andVS = QMatches.splitMultiValue(value);
            sql.append('(');
            for (int i = 0; i < andVS.length; ++i) {
                if (i > 0) {
                    sql.append(" AND ");
                }
                if (isDBFulltextField) {
                    sql.append(field).append(" MATCH ?");
                } else {
                    sql.append(field).append(" ").append(ORMUtil.getLikeCP(dataEntityType)).append(" ?").append(ORMUtil.addEscapeClause(dataEntityType));
                }
                QFilterHint qFilterHint = matchFilter.getQFilterHint();
                String v = ORMUtil.isContains(qFilterHint) ? ORMUtil.transferAndAppendPercent(qFilterHint, andVS[i], dataEntityType) : (ORMUtil.isFtlikeContains(qFilterHint) ? ORMUtil.transferAndAppendPercent(QFilterHint.CONTAINS, andVS[i], dataEntityType) : (ORMUtil.isFtlikeStartWith(qFilterHint) ? ORMUtil.transferAndAppendPercent(QFilterHint.STARTWITH, andVS[i], dataEntityType) : QMatches.appendWildcard(ORMUtil.escapeSpecialChar(dataEntityType, andVS[i]))));
                plist.add(v);
            }
            sql.append(')');
        } else {
            if (isDBFulltextField) {
                sql.append(field).append(" MATCH ?");
            } else {
                sql.append(field).append(" ").append(ORMUtil.getLikeCP(dataEntityType)).append(" ?").append(ORMUtil.addEscapeClause(dataEntityType));
            }
            QFilterHint qFilterHint = matchFilter.getQFilterHint();
            value = ORMUtil.isContains(qFilterHint) ? ORMUtil.transferAndAppendPercent(qFilterHint, value, dataEntityType) : (ORMUtil.isFtlikeContains(qFilterHint) ? ORMUtil.transferAndAppendPercent(QFilterHint.CONTAINS, value, dataEntityType) : (ORMUtil.isFtlikeStartWith(qFilterHint) ? ORMUtil.transferAndAppendPercent(QFilterHint.STARTWITH, value, dataEntityType) : QMatches.appendWildcard(ORMUtil.escapeSpecialChar(dataEntityType, value))));
            plist.add(value);
        }
    }

    private Object[] parseIds(ResultSet rs, boolean isNumber) throws Exception {
        LinkedList<Object> list = new LinkedList<Object>();
        if (isNumber) {
            while (rs.next()) {
                list.add(rs.getLong(1));
            }
        } else {
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        if (list.size() == 0) {
            return emptyIds;
        }
        return list.toArray();
    }

    private String getTable(IDataEntityProperty dp) {
        String table = dp.getParent().getAlias();
        String tableGroup = dp.getTableGroup();
        if (tableGroup != null && tableGroup.length() > 0) {
            table = table + '_' + tableGroup;
        }
        return table;
    }

    private String getField(IDataEntityProperty dp) {
        if (entryProp.isAssignableFrom(dp.getClass())) {
            return dp.getParent().getPrimaryKey().getAlias();
        }
        if (ORMConfiguration.isMulBasedataProp(dp)) {
            return dp.getParent().getPrimaryKey().getAlias();
        }
        return dp.getAlias();
    }

    static {
        String configValue = System.getProperty(bos_fulltext_server);
        if (StringUtils.isEmpty((String)configValue)) {
            enableFT = false;
        } else {
            enableFT = QFullTextQuery.isCofigFullTextEnable(configValue);
            ConfigurationUtil.observeChange((String)bos_fulltext_server, (ConfigurationChangeListener)new ConfigurationChangeListener(){

                public void onChange(Object key, Object newValue) {
                    String configValueChange = System.getProperty(QFullTextQuery.bos_fulltext_server);
                    enableFT = QFullTextQuery.isCofigFullTextEnable(configValueChange);
                }
            });
            ConfigurationUtil.observeChange((String)FT_ENABLE, (ConfigurationChangeListener)new ConfigurationChangeListener(){

                public void onChange(Object key, Object newValue) {
                    String configValueChange = System.getProperty(QFullTextQuery.bos_fulltext_server);
                    enableFT = QFullTextQuery.isCofigFullTextEnable(configValueChange);
                }
            });
            ConfigurationUtil.observeChange((String)basedata_gl, (ConfigurationChangeListener)new ConfigurationChangeListener(){

                public void onChange(Object key, Object newValue) {
                    enableGL = Boolean.parseBoolean((String)newValue);
                }
            });
        }
        try {
            entryProp = Class.forName("kd.bos.entity.property.EntryProp");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

