/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.fulltext;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kd.bos.bundle.BosRes;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.fulltext.FTCompare;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.FTFilter;
import kd.bos.fulltext.FTRowData;
import kd.bos.fulltext.FTValue;
import kd.bos.fulltext.FullTextFactory;
import kd.bos.fulltext.FullTextQuery;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.datasync.DtsAccountPower;
import kd.bos.orm.datasync.agent.DataSyncAgent;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;
import kd.bos.orm.datasync.query.DtsQueryFactory;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.ORMException;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.query.fulltext.ESAdapterContext;
import kd.bos.orm.query.fulltext.QFullTextQuery;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;

public class QMatches {
    private static Log logger = LogFactory.getLog(QMatches.class);
    private static Set<String> TENANTIDS = new HashSet<String>();
    public static final String MATCH_SINGLE_VALUE_PROPERTIES_SOLT = "1";
    public static final String MATCH_MULTI_VALUE_PROPERTIES_SOLT = "2";
    private static final char DELIM_PROPERTY_VALUE = '#';
    private static final char DELIM_PROPERTY = ',';
    private static final char DELIM_VALUE = '\b';

    public static String escapeWildcard(String value) {
        return value;
    }

    public static String[] splitMultiValue(String value) {
        String[] stringArray;
        if (value == null || value.length() == 0) {
            return new String[]{" "};
        }
        char[] delim = new char[]{' '};
        if (delim.length > 0) {
            ArrayList<String> ret = new ArrayList<String>();
            String split = new String(delim);
            char[] chs = value.toCharArray();
            StringBuilder token = new StringBuilder();
            int n = chs.length;
            for (int i = 0; i < n; ++i) {
                char ch = chs[i];
                if (split.indexOf(ch) != -1) {
                    if (token.toString().trim().length() > 0) {
                        ret.add(token.toString().trim());
                    }
                    token.setLength(0);
                    continue;
                }
                token.append(ch);
            }
            if (split.indexOf(chs[chs.length - 1]) == -1 && token.toString().trim().length() > 0) {
                ret.add(token.toString().trim());
            }
            return ret.toArray(new String[0]);
        }
        if ((value = value.trim()).length() == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = " ";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = value;
        }
        return stringArray;
    }

    public static String appendWildcard(String value) {
        if (value == null) {
            return null;
        }
        boolean hasWildKey = false;
        char[] chs = value.toCharArray();
        int n = chs.length;
        for (int i = 0; i < n; ++i) {
            char ch = chs[i];
            if (ch != '%' || i != 0 && chs[i - 1] == '\\') continue;
            hasWildKey = true;
            break;
        }
        if (!hasWildKey) {
            return '%' + value + '%';
        }
        return value;
    }

    public static QFilter ftlike(String[] values, String ... properties) {
        return new QFilter(MATCH_SINGLE_VALUE_PROPERTIES_SOLT, "ftlike", QMatches.encodeMatch(new Match(values, properties)));
    }

    public static QFilter ftlike(String[] values, boolean leftMatch, String ... properties) {
        QFilter filter = new QFilter(MATCH_SINGLE_VALUE_PROPERTIES_SOLT, "ftlike", QMatches.encodeMatch(new Match(values, properties)));
        if (leftMatch) {
            filter.setQFilterHint(QFilterHint.FTLIKE_STARTWITH);
        } else {
            filter.setQFilterHint(QFilterHint.FTLIKE_CONTAINS);
        }
        return filter;
    }

    public static QFilter ftlikeMultiValue(String[] values, String ... properties) {
        return new QFilter(MATCH_MULTI_VALUE_PROPERTIES_SOLT, "ftlike", QMatches.encodeMatch(new Match(values, properties)));
    }

    @Deprecated
    public static QFilter match(String[] values, String ... properties) {
        return new QFilter(MATCH_SINGLE_VALUE_PROPERTIES_SOLT, "match", QMatches.encodeMatch(new Match(values, properties)));
    }

    @Deprecated
    public static QFilter matchMultiValue(String[] values, String ... properties) {
        return new QFilter(MATCH_MULTI_VALUE_PROPERTIES_SOLT, "match", QMatches.encodeMatch(new Match(values, properties)));
    }

    public static boolean isFtlike(QFilter matchFilter) {
        return !matchFilter.isExpressValue() && "ftlike".equals(matchFilter.getCP().toLowerCase(Locale.ENGLISH));
    }

    public static String[] getMatchProperties(QFilter matchFilter) {
        return QMatches.decode((String)String.valueOf((Object)matchFilter.getValue())).properties;
    }

    public static boolean isMultiPropertiesMatch(QFilter matchFilter) {
        if (QMatches.isFtlike(matchFilter) && QMatches.isMatchSolt(matchFilter.getProperty())) {
            Match m = QMatches.decode(String.valueOf(matchFilter.getValue()));
            return m.properties != null && m.properties.length > 1;
        }
        return false;
    }

    public static Object[] queryPropertyValueByPKs(String entityName, String propertyName, Object[] pks, QContext ctx) {
        return QFullTextQuery.db(ctx.getEntityTypeCache()).queryPropertyValueByPKs(entityName, propertyName, pks);
    }

    public static QParameter toQParameter(QContext ctx, String rootObjName, Object matchFilterPropertyExpressInfo, QFilter matchFilter) {
        boolean isMatchSolt = QMatches.isMatchSolt(matchFilter.getProperty());
        if (matchFilterPropertyExpressInfo == null && !isMatchSolt) {
            throw new RuntimeException(BosRes.get((String)"bos-ormengine", (String)"QMatches_0", (String)"Proprety is incorrect.", (Object[])new Object[]{null}));
        }
        rootObjName = rootObjName.toLowerCase(Locale.ENGLISH);
        Match m = isMatchSolt ? QMatches.decode(String.valueOf(matchFilter.getOriginValue())) : new Match(new String[]{String.valueOf(matchFilter.getOriginValue())}, new String[]{matchFilter.getProperty()});
        QFullTextQuery db_fq = QFullTextQuery.db(ctx.getEntityTypeCache());
        HashMap<String, HashSet<String>> objectPropertyMap = new HashMap<String, HashSet<String>>();
        for (String p : m.properties) {
            String property;
            String fullObjectName;
            int pos = p.lastIndexOf(46);
            if (pos == -1) {
                fullObjectName = rootObjName;
                property = p;
            } else {
                fullObjectName = rootObjName + '.' + p.substring(0, pos).toLowerCase(Locale.ENGLISH);
                property = p.substring(pos + 1);
            }
            HashSet<String> ps = (HashSet<String>)objectPropertyMap.get(fullObjectName);
            if (ps == null) {
                ps = new HashSet<String>();
                objectPropertyMap.put(fullObjectName, ps);
            }
            ps.add(property.toLowerCase());
        }
        boolean isMultiValue = QMatches.isMultiValueMatchSolt(matchFilter.getProperty());
        QFilter ret = null;
        for (Map.Entry entry : objectPropertyMap.entrySet()) {
            QFilter f = QMatches.createQFilter(ctx, rootObjName, (String)entry.getKey(), (Set)entry.getValue(), m.values, db_fq, isMultiValue, matchFilter);
            ret = ret == null ? f : ret.or(f);
        }
        if (ret == null) {
            throw new IllegalArgumentException("QFilter cannot be null: " + matchFilter);
        }
        QParameter qp = ret.toQParameter(ctx);
        qp.setMatchTransferQFilter(ret);
        return qp;
    }

    private static QFilter createQFilter(QContext ctx, String rootObjName, String fullObjectName, Set<String> properties, String[] values, QFullTextQuery dbq, boolean isMultiValue, QFilter matchFilter) {
        boolean isOriginFilter;
        String entityName = QMatches.getEntityName(ctx, fullObjectName);
        boolean fullTextOrmEnable = QFullTextQuery.isFullTextEnable();
        boolean fullTextCustSyncEnable = FullTextFactory.getFullTextCustSyncQuery().isConfigFullText(entityName);
        boolean dtsQueryEnable = DataSyncAgent.isQueryEnable((String)entityName);
        String qsInfoLog = System.getProperty("quicksearch.log", "info");
        StringBuilder builder = new StringBuilder();
        HashSet<String> esFields = new HashSet<String>(2);
        boolean isESSearch = QMatches.recordIsESLog(properties, entityName, dtsQueryEnable, fullTextOrmEnable, fullTextCustSyncEnable, builder, esFields);
        if (!isESSearch) {
            logger.info(builder.toString());
        }
        if (isOriginFilter = QMatches.recordIsOriginFilterLog(qsInfoLog, isESSearch, fullTextCustSyncEnable, false)) {
            return QMatches.returnOriginQFilter(ctx, fullObjectName, matchFilter, rootObjName, properties, values, isMultiValue, null);
        }
        EntityItem ei = ctx.getEntityItem(fullObjectName);
        HashSet<Object> idSet = new HashSet();
        boolean fullTextOrmDataReady = fullTextOrmEnable && ei.entityType.isFullIndexDataSynced();
        Lang lang = ctx.getORMHint().getLang();
        if (!(fullTextOrmDataReady || fullTextCustSyncEnable || isESSearch)) {
            idSet = QMatches.builderQFilterFromDBField(properties, ei, isMultiValue, values, lang, entityName, matchFilter, ctx, dbq);
            return QMatches.buildReturnQFilter(fullObjectName, rootObjName, idSet);
        }
        if (properties.size() != esFields.size()) {
            QFilter esQFilter = null;
            if (esFields != null && esFields.size() > 0) {
                Set<Object> esIdSet = QMatches.builderQFilterFromEsField(esFields, ei, isMultiValue, values, lang, entityName, fullTextCustSyncEnable, dtsQueryEnable);
                idSet.addAll(esIdSet);
                esQFilter = QMatches.buildReturnQFilter(fullObjectName, rootObjName, idSet);
            }
            QFilter dbQFilter = QMatches.returnOriginQFilter(ctx, fullObjectName, matchFilter, rootObjName, properties, values, isMultiValue, esFields);
            return esQFilter == null ? dbQFilter : dbQFilter.or(esQFilter);
        }
        idSet = QMatches.builderQFilterFromEsField(properties, ei, isMultiValue, values, lang, entityName, fullTextCustSyncEnable, dtsQueryEnable);
        return QMatches.buildReturnQFilter(fullObjectName, rootObjName, idSet);
    }

    private static QFilter buildReturnQFilter(String fullObjectName, String rootObjName, Set<Object> idSet) {
        if (fullObjectName.startsWith(rootObjName + ".")) {
            return new QFilter(fullObjectName.substring((rootObjName + ".").length()), "in", idSet);
        }
        return new QFilter("id", "in", idSet);
    }

    private static Set<Object> builderQFilterFromEsField(Set<String> properties, EntityItem ei, boolean isMultiValue, String[] values, Lang lang, String entityName, boolean fullTextCustSyncEnable, boolean dtsQueryEnable) {
        HashSet<Object> idSet;
        block11: {
            String[] ids;
            FTFilter combileFilter = null;
            idSet = new HashSet<Object>(2);
            boolean isIgnoreCase = ORMUtil.isIgnoreCase(entityName, true);
            for (String property : properties) {
                IDataEntityProperty peropertyType = ei.getPropertyItem(property).getPropertyType();
                boolean isLangProperty = ORMConfiguration.isMultiLangPropertyType(peropertyType);
                if (isMultiValue) {
                    for (String value : values) {
                        String[] andVS = QMatches.splitMultiValue(value);
                        andVS = QMatches.toLowerCase(andVS, isIgnoreCase);
                        combileFilter = QMatches.add2Filter(andVS, combileFilter, property, peropertyType, isLangProperty, false, lang, ei);
                    }
                    continue;
                }
                values = QMatches.toLowerCase(values, isIgnoreCase);
                combileFilter = QMatches.add2Filter(values, combileFilter, property, peropertyType, isLangProperty, true, lang, ei);
            }
            if (combileFilter == null) break block11;
            if (fullTextCustSyncEnable) {
                ids = FullTextFactory.getFullTextCustSyncQuery().query(entityName, combileFilter);
            } else if (dtsQueryEnable) {
                ids = QMatches.getAllIdFromES(entityName, combileFilter);
            } else {
                FullTextQuery fq = QFullTextQuery.ft();
                ids = fq.query(entityName, combileFilter);
            }
            if (ei.entityType.getPrimaryKey().getPropertyType() != String.class) {
                for (String id : ids) {
                    idSet.add(Long.valueOf(id));
                }
            } else {
                for (String id : ids) {
                    idSet.add(id);
                }
            }
        }
        return idSet;
    }

    private static Set<Object> builderQFilterFromDBField(Set<String> properties, EntityItem ei, boolean isMultiValue, String[] values, Lang lang, String entityName, QFilter matchFilter, QContext ctx, QFullTextQuery dbq) {
        HashSet<Object> idSet = new HashSet<Object>(2);
        for (String property : properties) {
            IDataEntityType dt;
            IDataEntityProperty peropertyType = ei.getPropertyItem(property).getPropertyType();
            boolean isLangProperty = ORMConfiguration.isMultiLangPropertyType(peropertyType);
            try {
                dt = ORMConfiguration.innerGetDataEntityType(entityName, ctx.getEntityTypeCache());
            }
            catch (Exception e) {
                logger.error("get entityType error", (Throwable)e);
                dt = ei.entityType;
            }
            Object[] ids = isLangProperty ? dbq.queryLang(dt, property, lang, values, isMultiValue, false, matchFilter) : dbq.queryNormal(dt, property, values, isMultiValue, false, matchFilter);
            for (Object id : ids) {
                idSet.add(id);
            }
        }
        return idSet;
    }

    private static boolean hasEsFields(Set<String> properties, String entityName, StringBuilder build, Set<String> esFields) {
        String fields = DataSyncConfigCache.get().getFieldsByEntityName(entityName, "quicksearch");
        HashSet<String> fieldSet = new HashSet<String>();
        if (fields == null || "".equals(fields)) {
            for (String field : properties) {
                build.append(field);
                build.append(",");
            }
            return false;
        }
        for (String field : fields.split(",")) {
            if (field == null || "".equals(field)) continue;
            fieldSet.add(field);
        }
        boolean containsAll = true;
        for (String field : properties) {
            if (!fieldSet.contains(field)) {
                build.append(field);
                build.append(",");
                containsAll = false;
                continue;
            }
            esFields.add(field);
        }
        return containsAll;
    }

    private static String getEntityName(QContext ctx, String fullObjectName) {
        String entityName;
        String[] segs = fullObjectName.split("\\.");
        if (segs.length == 0) {
            entityName = segs[0];
        } else {
            String aloneFullObjectName = fullObjectName;
            EntityItem ei = ctx.getEntityItem(aloneFullObjectName);
            if (ORMConfiguration.isEntryEntityType(ei.entityType)) {
                do {
                    aloneFullObjectName = aloneFullObjectName.substring(0, aloneFullObjectName.lastIndexOf(46));
                    ei = ctx.getEntityItem(aloneFullObjectName);
                } while (ORMConfiguration.isEntryEntityType(ei.entityType));
                entityName = ei.entityType.getName() + fullObjectName.substring(aloneFullObjectName.length());
            } else {
                entityName = ORMConfiguration.isBasedata(ei.entityType) ? ei.entityType.getName() : ei.getFullObjectName();
            }
        }
        return entityName;
    }

    private static FTFilter add2Filter(String[] values, FTFilter combileFilter, String property, IDataEntityProperty peropertyType, boolean isLangProperty, boolean valueOR, Lang lang, EntityItem ei) {
        FTValue ftValue = isLangProperty ? FTValue.lang((Lang)lang, (String[])values) : FTValue.normal((FTDataType)QMatches.toFTDataType(peropertyType), (Object[])Arrays.asList(values).toArray());
        if (valueOR) {
            ftValue.setOr();
        }
        FTFilter ftFilter = QMatches.buildGLFieldFTFilter(property, isLangProperty, ftValue, lang, ei);
        combileFilter = combileFilter == null ? ftFilter : combileFilter.or(ftFilter);
        ArrayList<String> pyValueList = null;
        for (String value : values) {
            if (!QMatches.mayBePinyin(value)) continue;
            if (pyValueList == null) {
                pyValueList = new ArrayList<String>();
            }
            pyValueList.add(value);
        }
        if (pyValueList != null) {
            ftValue = FTValue.pinyin((String[])pyValueList.toArray(new String[pyValueList.size()]));
            if (valueOR) {
                ftValue.setOr();
            }
            combileFilter.or(new FTFilter(property, FTCompare.LIKE, ftValue));
        }
        return combileFilter;
    }

    private static FTFilter buildGLFieldFTFilter(String property, boolean isLangProperty, FTValue ftValue, Lang lang, EntityItem ei) {
        if (isLangProperty && QMatches.isGLField(ei, property)) {
            FTFilter multiLang = new FTFilter(property, FTCompare.LIKE, ftValue).or(new FTFilter(property, FTCompare.ISNULL, FTValue.lang((Lang)lang, null)).or(new FTFilter(property, FTCompare.EQ, FTValue.lang((Lang)lang, (String[])new String[]{" "}))).or(new FTFilter(property, FTCompare.EQ, FTValue.lang((Lang)lang, (String[])new String[]{""}))).and(new FTFilter(property + "_###GL", FTCompare.LIKE, FTValue.normal((FTDataType)ftValue.getDataType(), (Object[])ftValue.getValues()))));
            return multiLang;
        }
        return new FTFilter(property, FTCompare.LIKE, ftValue);
    }

    private static boolean isGLField(EntityItem ei, String propertyName) {
        IDataEntityProperty propertyType;
        ISimpleProperty mainProperty;
        return ei != null && ei.entityType != null && (mainProperty = (ISimpleProperty)(propertyType = (IDataEntityProperty)ei.entityType.getProperties().get((Object)propertyName))) != null && !mainProperty.isDbIgnore() && !propertyType.isDbIgnore();
    }

    private static QFilter createOriginFilter(String rootObjName, String fullObjectName, Set<String> properties, String[] values, boolean isMultiValue, IDataEntityType dataEntityType, QFilter matchFilter, Set<String> esFields) {
        QFilter ret = null;
        for (String property : properties) {
            if (esFields != null && esFields.size() > 0 && esFields.contains(property)) continue;
            String cp = ORMUtil.getLikeCP(dataEntityType);
            for (String value : values) {
                QFilter f;
                String objectProperty = rootObjName.equals(fullObjectName) ? property : fullObjectName.substring(rootObjName.length() + 1) + '.' + property;
                if (isMultiValue) {
                    String[] andVS = QMatches.splitMultiValue(value);
                    QFilter f2 = null;
                    for (String v : andVS) {
                        QFilter ff;
                        if (ORMUtil.isFtlikeStartWith(matchFilter.getQFilterHint())) {
                            ff = new QFilter(objectProperty, cp, (Object)v, QFilterHint.STARTWITH);
                        } else if (ORMUtil.isFtlikeContains(matchFilter.getQFilterHint())) {
                            ff = new QFilter(objectProperty, cp, (Object)v, QFilterHint.CONTAINS);
                        } else {
                            v = ORMUtil.isEffective(dataEntityType) ? "%" + v + "%" : QMatches.appendWildcard(v);
                            ff = new QFilter(objectProperty, cp, v);
                        }
                        f2 = f2 == null ? ff : f2.and(ff);
                    }
                    ret = ret == null ? f2 : ret.or(f2);
                    continue;
                }
                if (ORMUtil.isFtlikeStartWith(matchFilter.getQFilterHint())) {
                    f = new QFilter(objectProperty, cp, (Object)value, QFilterHint.STARTWITH);
                } else if (ORMUtil.isFtlikeContains(matchFilter.getQFilterHint())) {
                    f = new QFilter(objectProperty, cp, (Object)value, QFilterHint.CONTAINS);
                } else {
                    value = ORMUtil.isEffective(dataEntityType) ? "%" + value + "%" : QMatches.appendWildcard(value);
                    f = new QFilter(objectProperty, cp, value);
                }
                ret = ret == null ? f : ret.or(f);
            }
        }
        return ret;
    }

    private static boolean mayBePinyin(String value) {
        for (char ch : value.toCharArray()) {
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') continue;
            return false;
        }
        return true;
    }

    private static FTDataType toFTDataType(IDataEntityProperty peropertyType) {
        Class cls = peropertyType.getPropertyType();
        if (cls == String.class || cls == ILocaleString.class) {
            return FTDataType.STRING;
        }
        if (cls == Long.class || cls == Long.TYPE) {
            return FTDataType.LONG;
        }
        if (cls == Integer.class || cls == Integer.TYPE) {
            return FTDataType.LONG;
        }
        if (Number.class.isAssignableFrom(cls) || cls == Float.TYPE || cls == Double.TYPE) {
            return FTDataType.FLOAT;
        }
        if (Date.class.isAssignableFrom(cls)) {
            return FTDataType.DATE;
        }
        return FTDataType.STRING;
    }

    private static String encodeMatch(Match m) {
        int i;
        StringBuilder sb = new StringBuilder(64);
        int n = m.properties.length;
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(m.properties[i]);
        }
        sb.append('#');
        n = m.values.length;
        for (i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append('\b');
            }
            sb.append(m.values[i]);
        }
        return sb.toString();
    }

    public static String _encodeMatch(Match m) {
        return QMatches.encodeMatch(m);
    }

    private static boolean isMatchSolt(String propertySolt) {
        return MATCH_SINGLE_VALUE_PROPERTIES_SOLT.equals(propertySolt) || MATCH_MULTI_VALUE_PROPERTIES_SOLT.equals(propertySolt);
    }

    private static boolean isMultiValueMatchSolt(String propertySolt) {
        return MATCH_MULTI_VALUE_PROPERTIES_SOLT.equals(propertySolt);
    }

    public static boolean __isMultiValueMatchSolt(String propertySolt) {
        return QMatches.isMultiValueMatchSolt(propertySolt);
    }

    public static boolean _isMatchSolt(String propertySolt) {
        return QMatches.isMatchSolt(propertySolt);
    }

    private static Match decode(String s) {
        int p = s.indexOf(35);
        String[] properties = s.substring(0, p).split(String.valueOf(','));
        String[] values = s.substring(p + 1).split(String.valueOf('\b'));
        return new Match(values, properties);
    }

    public static Match __decode(String s) {
        return QMatches.decode(s);
    }

    public static Match __decode(QFilter qFilter) {
        String property = qFilter.getProperty();
        String value = String.valueOf(qFilter.getOriginValue());
        if (QMatches._isMatchSolt(property)) {
            return QMatches.decode(value);
        }
        return new Match(new String[]{value}, new String[]{qFilter.getProperty()});
    }

    public static boolean recordIsESLog(Set<String> properties, String entityName, boolean dtsQueryEnable, boolean fullTextOrmEnable, boolean fullTextCustSyncEnable, StringBuilder builder, Set<String> esFields) {
        Boolean quickSearchFromES = ORMUtil.isQuickSearchFromES();
        builder.append("quicksearch-query not query from es");
        if (quickSearchFromES == null) {
            boolean isEsQuery = ESAdapterContext.isEsQuery();
            if (!isEsQuery) {
                builder.append(":quicksearch.enable=false");
                return false;
            }
            String tenantId = RequestContext.get().getTenantId();
            if (CollectionUtils.isEmpty(TENANTIDS) || !TENANTIDS.contains(tenantId)) {
                builder.append(" : the current tenant not open quick search,you must config quicksearch.tenantids");
                return false;
            }
        } else if (!quickSearchFromES.booleanValue()) {
            builder.append(" : System Paramter quicksearch_enable=false.");
            return false;
        }
        if (!dtsQueryEnable) {
            QMatches.reocrdDtsQueryEnable(builder, entityName);
            return false;
        }
        StringBuilder build = new StringBuilder();
        boolean contaisFields = QMatches.hasEsFields(properties, entityName, build, esFields);
        if (!contaisFields) {
            builder.append(":some properties not sync to es ->").append((CharSequence)build).append(" ; entity->").append(entityName);
        }
        if (esFields == null || esFields.size() == 0) {
            return false;
        }
        if (!fullTextOrmEnable) {
            QMatches.recordEnableFT(builder);
            return false;
        }
        builder.setLength(0);
        if (fullTextCustSyncEnable) {
            builder.append("quicksearch-query from self define sync project");
        } else {
            builder.append("quicksearch-query from es").append(",entity->").append(entityName);
        }
        return true;
    }

    private static void recordEnableFT(StringBuilder builder) {
        String configValue = System.getProperty("elasticsearch.server.quicksearch");
        if (StringUtils.isEmpty((String)configValue)) {
            builder.append(":elasticsearch.server.quicksearch is empty");
        } else {
            Properties prop = new Properties();
            StringReader reader = new StringReader(configValue);
            try {
                prop.load(reader);
            }
            catch (IOException e) {
                logger.error("key:elasticsearch.server.quicksearchvalue:" + configValue + "," + e.getMessage());
            }
            String enableStr = prop.getProperty("enable");
            if (StringUtils.isEmpty((String)enableStr)) {
                enableStr = "true";
            }
            if (!"true".equals(System.getProperty("ft.enable", "true"))) {
                builder.append(":ft.enable = false");
                return;
            }
            if (Boolean.parseBoolean(enableStr)) {
                builder.append(": elasticsearch.server.quicksearch 's property enable =false");
            }
        }
    }

    private static void reocrdDtsQueryEnable(StringBuilder builder, String entityName) {
        if (!Boolean.parseBoolean(System.getProperty("dts.sync.enable", "true"))) {
            builder.append(": dts.sync.enable = false");
            return;
        }
        if (!Boolean.getBoolean("dts.sync.allAccount.enable") && !DtsAccountPower.isAccountDtsEnable()) {
            builder.append(": dts.sync.allAccount.enable = false && current account isdtsenable=false");
            return;
        }
        if (!Boolean.parseBoolean(System.getProperty("dts.query.enable", "true"))) {
            builder.append(": dts.query.enable = false");
            return;
        }
        builder.append(": the entity [").append(entityName).append("] has not config data sync ");
    }

    private static boolean recordIsOriginFilterLog(String qsInfoLog, boolean isESSearch, boolean fullTextCustomSyncEnable, boolean haveDbMatchProperty) {
        boolean isOriginQFilter = !isESSearch && !fullTextCustomSyncEnable && !haveDbMatchProperty;
        return isOriginQFilter;
    }

    private static String[] convertStringArrayToLowerCase(String[] originValues) {
        if (originValues == null || originValues.length == 0) {
            return originValues;
        }
        String[] lowerCase = new String[originValues.length];
        for (int i = 0; i < originValues.length; ++i) {
            lowerCase[i] = originValues[i] == null ? originValues[i] : originValues[i].toLowerCase(Locale.ENGLISH);
        }
        return lowerCase;
    }

    private static QFilter returnOriginQFilter(QContext ctx, String fullObjectName, QFilter matchFilter, String rootObjName, Set<String> properties, String[] values, boolean isMultiValue, Set<String> esFields) {
        IDataEntityType dt;
        EntityItem entityItem = ctx.getEntityItem(fullObjectName);
        if (entityItem != null) {
            dt = entityItem.entityType;
            if (dt == null) {
                dt = ORMConfiguration.innerGetDataEntityType(fullObjectName, ctx.getEntityTypeCache());
            }
        } else {
            dt = ORMConfiguration.innerGetDataEntityType(fullObjectName, ctx.getEntityTypeCache());
        }
        if (ORMUtil.isContains(matchFilter.getQFilterHint())) {
            return matchFilter.__copy(false);
        }
        return QMatches.createOriginFilter(rootObjName, fullObjectName, properties, values, isMultiValue, dt, matchFilter, esFields);
    }

    private static String[] getAllIdFromES(String entityName, FTFilter combileFilter) {
        FullTextQuery fq = DtsQueryFactory.getFullTextQuery((String)entityName);
        int pageSize = CommonUtil.getMaxMatchSize();
        ArrayList<String> esIds = new ArrayList<String>(5000);
        String storageType = System.getProperty("fulltext.storagetype", "highlevel");
        String tenantId = RequestContext.get().getTenantId();
        int pageNo = 1;
        if (ORMConfig.QUICKSEARCH_QUERYALL.getBoolean(tenantId)) {
            int rowSize;
            if (ORMConfig.SEARCH_AFTER_ENABLE.getBoolean() && storageType.equals("highlevel")) {
                try {
                    String[] sortFiles = new String[]{"pkid.keyword"};
                    List rowDatas = fq.searchAfter(entityName, "pkid", combileFilter, sortFiles, pageSize, null);
                    while (!rowDatas.isEmpty()) {
                        for (FTRowData rowData : rowDatas) {
                            esIds.add(rowData.getPkId());
                        }
                        if (esIds.size() > HugeInConfig.inMaxSize()) {
                            throw new ORMException(ORMException.excessiveDataFromEs, "The data rows queried from es exceed the maximum number of in parameters");
                        }
                        Object[] sortValues = ((FTRowData)rowDatas.get(rowDatas.size() - 1)).getSortValues();
                        rowDatas = fq.searchAfter(entityName, "pkid", combileFilter, sortFiles, pageSize, sortValues);
                    }
                    return esIds.toArray(new String[0]);
                }
                catch (ORMException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.error("quicksearch use search after error: ", (Throwable)e);
                    esIds = new ArrayList(5000);
                }
            }
            do {
                List rowDatas = fq.search(entityName, "pkid", combileFilter, pageNo, pageSize);
                for (FTRowData rowData : rowDatas) {
                    esIds.add(rowData.getPkId());
                }
                if (esIds.size() > HugeInConfig.inMaxSize()) {
                    throw new ORMException(ORMException.excessiveDataFromEs, "The data rows queried from es exceed the maximum number of in parameters");
                }
                rowSize = rowDatas.size();
                ++pageNo;
            } while (rowSize >= pageSize);
        } else {
            List rowDatas = fq.search(entityName, "pkid", combileFilter, pageNo, pageSize);
            for (FTRowData rowData : rowDatas) {
                esIds.add(rowData.getPkId());
            }
        }
        return esIds.toArray(new String[0]);
    }

    private static String[] toLowerCase(String[] andVS, boolean isIgnoreCase) {
        if (isIgnoreCase) {
            for (int i = 0; i < andVS.length; ++i) {
                andVS[i] = andVS[i].toLowerCase(Locale.ENGLISH);
            }
        }
        return andVS;
    }

    public static boolean isFromEs(QContext ctx, String fullObjectName, Set<String> properties) {
        Boolean quickSearchFromES = ORMUtil.isQuickSearchFromES();
        if (quickSearchFromES == null) {
            boolean isEsQuery = ESAdapterContext.isEsQuery();
            if (!isEsQuery) {
                return false;
            }
            String tenantId = RequestContext.get().getTenantId();
            if (CollectionUtils.isEmpty(TENANTIDS) || !TENANTIDS.contains(tenantId)) {
                return false;
            }
        } else if (!quickSearchFromES.booleanValue()) {
            return false;
        }
        String tenantId = RequestContext.get().getTenantId();
        if (CollectionUtils.isEmpty(TENANTIDS) || !TENANTIDS.contains(tenantId)) {
            return false;
        }
        String entityName = QMatches.getEntityName(ctx, fullObjectName);
        boolean fullTextOrmEnable = QFullTextQuery.isFullTextEnable();
        boolean dtsQueryEnable = DataSyncAgent.isQueryEnable((String)entityName);
        if (!dtsQueryEnable) {
            return false;
        }
        StringBuilder builder = new StringBuilder();
        HashSet<String> esFields = new HashSet<String>();
        boolean containsAllFields = QMatches.hasEsFields(properties, entityName, builder, esFields);
        if (!containsAllFields) {
            return false;
        }
        if (esFields == null || esFields.size() == 0) {
            return false;
        }
        return fullTextOrmEnable;
    }

    static {
        try {
            ConfigurationUtil.observeString((String)"quicksearch.tenantids", null, b -> {
                if (StringUtils.isNotEmpty((String)b)) {
                    String[] tenantIds;
                    if (TENANTIDS == null) {
                        TENANTIDS = new HashSet<String>();
                    }
                    for (String id : tenantIds = b.split(",")) {
                        if (!StringUtils.isNotEmpty((String)id)) continue;
                        TENANTIDS.add(id);
                    }
                }
            });
        }
        catch (Throwable e) {
            logger.error("init quicksearch.tenantids error", e);
        }
    }

    public static class Match {
        String[] values;
        String[] properties;

        public Match(String[] values, String[] properties) {
            this.values = values;
            this.properties = properties;
        }

        public String[] getValues() {
            return this.values;
        }

        public String[] getProperties() {
            return this.properties;
        }
    }
}

