/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.datatype.UnknownType;
import kd.bos.algo.util.bitset.BitSetFactory;
import kd.bos.algo.util.bitset.LongBitSet;
import kd.bos.algo.util.trie.TrieTree;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DataSetDataType;
import kd.bos.orm.ORMHint;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.dataentity.AggregateFuncs;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMOptimization;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.SqlTreeNode;
import kd.bos.orm.query.multi.JoinTableInfo;
import kd.bos.orm.query.multi.LeftDataSetIterator;
import kd.bos.orm.query.multi.MultiQueryBuilder;
import kd.bos.orm.query.multi.MultiQueryParameter;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.multi.PropertySegExpress;
import kd.bos.orm.query.multi.QueryUtils;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.orm.query.optimize.QueryOptimizater;
import kd.bos.orm.query.optimize.QueryTreeNode;
import kd.bos.orm.query.optimize.QueryTreeNodeVisitor;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import org.apache.log4j.Logger;

public class MultiQuery {
    private final SingleQuery[] queries;
    private final PropertyField[] selectFields;
    private PropertyField[] returnFields = null;
    private final ORMOptimization optimization;
    private final QContext allCtx;
    private boolean queryWithTop;
    private static int max_sql_len = Integer.parseInt(System.getProperty("ksql.max_length", "2097152"));
    private static final String DISTINCT = " DISTINCT ";
    private Distinctable distinctable;
    private boolean shouldSelectPK;
    private static Logger logger = Logger.getLogger(MultiQuery.class);

    public static MultiQuery create(DBRoute dbRoute, IDataEntityType entityType, String selectFields, boolean shouldSelectPK, QFilter[] filters, String groupBys, QFilter[] havings, String orderBys, int top, int start, int limit, Map<String, IDataEntityType> entityTypeCache, ORMHint ormHint, ORMOptimization optimization, Distinctable distinctable) {
        MultiQueryParameter mp = new MultiQueryParameter(dbRoute, entityType, selectFields, shouldSelectPK, filters, groupBys, havings, orderBys, top, start, limit, entityTypeCache, ormHint, optimization, distinctable);
        MultiQuery multiQuery = new MultiQueryBuilder(mp).build();
        multiQuery.distinctable = distinctable;
        return multiQuery;
    }

    MultiQuery(SingleQuery[] queries, PropertyField[] selectFields, ORMOptimization optimization, QContext allCtx) {
        this.queries = queries;
        this.selectFields = selectFields;
        this.optimization = optimization;
        this.allCtx = allCtx;
    }

    MultiQuery(SingleQuery[] queries, PropertyField[] selectFields, PropertyField[] returnFeilds, ORMOptimization optimization, QContext allCtx) {
        this.queries = queries;
        this.selectFields = selectFields;
        this.returnFields = returnFeilds;
        this.optimization = optimization;
        this.allCtx = allCtx;
    }

    MultiQuery(SingleQuery[] queries, PropertyField[] selectFields, PropertyField[] returnFeilds, ORMOptimization optimization, QContext allCtx, boolean shouldSelectPk) {
        this.queries = queries;
        this.selectFields = selectFields;
        this.returnFields = returnFeilds;
        this.optimization = optimization;
        this.allCtx = allCtx;
        this.shouldSelectPK = shouldSelectPk;
    }

    public SingleQuery[] getQueries() {
        return this.queries;
    }

    public boolean isQueryWithTop() {
        return this.queryWithTop;
    }

    public RowMeta genRowMeta() {
        Field[] fs = new Field[this.selectFields.length];
        int i = 0;
        for (PropertyField f : this.selectFields) {
            IDataEntityProperty dp = f.getPeropertyType();
            String name = f.getAlias();
            if (dp instanceof IComplexProperty) {
                dp = ((IComplexProperty)dp).getComplexType().getPrimaryKey();
            }
            UnknownType dt = dp == null ? DateType.UnknownType : DataSetDataType.getDataType((Class)dp.getPropertyType());
            fs[i++] = new Field(name, (DataType)dt);
        }
        return new RowMeta(fs);
    }

    public int queryForCount(String algoKey, boolean customSelectFields, int top, int scene, SingleQuery query) {
        return this.getCount(algoKey, customSelectFields, top, null, scene, query);
    }

    public int queryForCount(String algoKey, boolean customSelectFields, int top, QFilter[] filters, int scene, SingleQuery query) {
        return this.getCount(algoKey, customSelectFields, top, filters, scene, query);
    }

    private int getCount(String algoKey, boolean customSelectFields, int top, QFilter[] filters, int scene, SingleQuery query) {
        if (scene == 1) {
            if (customSelectFields) {
                SingleQuery.QueryParameter qp = this.queries[0].getQueryParameter();
                String sql = "select count(1) c from(" + qp.getSql() + ") C";
                try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)this.queries[0].getDBRoute(), (String)sql, (Object[])qp.getParams());){
                    int n = ((Row)ds.iterator().next()).getInteger(0);
                    return n;
                }
            }
            this.resetQuery();
            return this.getCountForSingleQuery(algoKey, this.queries[0], top, filters);
        }
        if (scene == 2) {
            return this.getCountFromSingleQuery(algoKey, query, top, filters);
        }
        return this.getCount0(algoKey, top, filters);
    }

    private void resetQuery() {
        try {
            PropertyField[] fields = this.selectFields;
            PropertyField[] selectFields = this.queries[0].getSelectFields();
            if (fields != null && selectFields != null && fields.length != selectFields.length) {
                SingleQuery query;
                StringBuilder countSelectName = new StringBuilder();
                for (int i = 0; i < fields.length; ++i) {
                    countSelectName.append(fields[i].getName());
                    if (i == fields.length - 1) continue;
                    countSelectName.append(",");
                }
                this.queries[0] = query = this.queries[0].optRebuildForCount(countSelectName.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private int getCountForSingleQuery(String algoKey, SingleQuery query, int top, QFilter[] filters) {
        if (query.getSelectFields().length != this.returnFields.length) {
            query = query.optRebuildFields(this.returnFields);
        }
        if (!CollectionUtils.isEmpty(query.getSubQueryNodes())) {
            query = QueryUtils.rebuildQuery(algoKey, query);
        }
        SingleQuery.QueryParameter qp = query.getQueryParameter();
        String qpSql = qp.getSql().trim();
        boolean containsDistinct = this.containsSomeKeyword(qpSql.toUpperCase(), DISTINCT);
        boolean needDistinct = false;
        if (this.distinctable != null) {
            needDistinct = ORMUtil.needDistinct(query.getSelectFields(), this.allCtx, filters);
        }
        qpSql = this.addDistinctTop(qpSql, containsDistinct, needDistinct, top);
        String sql = "select count(1) from ( " + qpSql + " ) C";
        if (sql.length() > max_sql_len || qp.getParams() != null && qp.getParams().length > ORMUtil.toTempTableSize(this.allCtx.getORMHint())) {
            return this.getCountTraditional(algoKey, needDistinct, query, top);
        }
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)this.queries[0].getDBRoute(), (String)sql, (Object[])qp.getParams());){
            int n = ((Row)ds.iterator().next()).getInteger(0);
            return n;
        }
    }

    private int getCountFromSingleQuery(String algoKey, SingleQuery query, int top, QFilter[] filters) {
        query.removeUselessField(true, true);
        SingleQuery.QueryParameter qp = query.getQueryParameter();
        String qpSql = qp.getSql().trim();
        boolean containsDistinct = this.containsSomeKeyword(qpSql.toUpperCase(), DISTINCT);
        boolean needDistinct = false;
        if (this.distinctable != null) {
            needDistinct = ORMUtil.needDistinct(query.getSelectFields(), this.allCtx, filters);
        }
        qpSql = this.addDistinctTop(qpSql, containsDistinct, needDistinct, top);
        String sql = "select count(1) from ( " + qpSql + " ) C";
        if (sql.length() > max_sql_len || qp.getParams() != null && qp.getParams().length > ORMUtil.toTempTableSize(this.allCtx.getORMHint())) {
            return this.getCountTraditional(algoKey, needDistinct, query, top);
        }
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)this.queries[0].getDBRoute(), (String)sql, (Object[])qp.getParams());){
            int n = ((Row)ds.iterator().next()).getInteger(0);
            return n;
        }
    }

    private int getCountTraditional(String algoKey, boolean distinct, SingleQuery query, int top) {
        if (this.allLevelSingle(this.queries[0])) {
            return this.getCountForAllLevelSingle(algoKey, distinct, query, top);
        }
        if (!CollectionUtils.isEmpty(query.getSubQueryNodes())) {
            query = QueryUtils.rebuildQuery(algoKey, query);
        }
        return this.getCountSingle(query, algoKey, distinct);
    }

    public Object[] queryForAggregate(String algoKey, AggregateFuncs aggregateFuncs, QFilter[] filters) {
        Object[] result;
        String[] funcs = aggregateFuncs.getFuncs();
        String[] aliasFields = aggregateFuncs.getAliasFields();
        try (DataSet ds = this.query(algoKey);){
            if (this.queries[0].getAllCtx().isCrossAggregateIntoSql()) {
                result = new Object[funcs.length];
                Row row = (Row)ds.iterator().next();
                for (int i = 0; i < funcs.length; ++i) {
                    result[i] = row.get(i);
                }
            } else {
                result = this.aggregateByDataSet(funcs, aggregateFuncs.getFields(), aliasFields, ds, filters);
            }
        }
        return result;
    }

    public DataSet queryForAggregate(String algoKey, AggregateFuncs aggregateFuncs, String[] groupbyFields) {
        try (DataSet ds = this.query(algoKey);){
            DataSet dataSet = this.aggregateByDataSet(aggregateFuncs, ds, groupbyFields);
            return dataSet;
        }
    }

    public DataSet query(String algoKey) {
        return this.getDataSet(algoKey, null, null);
    }

    public DataSet query(String algoKey, QFilter[] filters, String orderBys) {
        return this.getDataSet(algoKey, filters, orderBys);
    }

    private DataSet getDataSet(String algoKey, QFilter[] filters, String orderBys) {
        QueryOptimizater opt = new QueryOptimizater(this.optimization, this.selectFields, this.allCtx);
        DataSet root = opt.query(algoKey, this.queries);
        if (this.allCtx.isCrossAggregateIntoSql()) {
            return root;
        }
        this.queryWithTop = opt.isQueryRootWithTop();
        RowMeta rm = root.getRowMeta();
        if (!this.shouldSelectPK && this.returnFields != null) {
            boolean reSelect = rm.getFieldCount() != this.returnFields.length;
            return this.buildReturnDataSet(reSelect, filters, orderBys, root, this.returnFields);
        }
        boolean reSelect = rm.getFieldCount() != this.selectFields.length;
        return this.buildReturnDataSet(reSelect, filters, orderBys, root, this.selectFields);
    }

    private DataSet buildReturnDataSet(boolean reSelect, QFilter[] filters, String orderBys, DataSet root, PropertyField[] fields) {
        RowMeta rm = root.getRowMeta();
        if (!reSelect) {
            for (int i = 0; i < fields.length; ++i) {
                if (rm.getField(i).getAlias().equalsIgnoreCase(fields[i].getAlias())) continue;
                reSelect = true;
                break;
            }
        }
        if (this.distinctable == null) {
            if (reSelect) {
                String[] alias = new String[fields.length];
                for (int i = 0; i < alias.length; ++i) {
                    alias[i] = fields[i].getAlias();
                }
                root = root.select(alias);
            }
            return this.rebuilDataSet(root, fields);
        }
        boolean needDistinct = false;
        boolean containsSomeKeyword = this.containsSomeKeyword(this.queries[0].getSql(), DISTINCT);
        if (!containsSomeKeyword) {
            needDistinct = ORMUtil.needDistinct(fields, this.allCtx, filters);
        }
        if (reSelect) {
            String[] alias = new String[fields.length];
            for (int i = 0; i < alias.length; ++i) {
                alias[i] = fields[i].getAlias();
            }
            if (containsSomeKeyword) {
                needDistinct = ORMUtil.needDistinct(fields, this.allCtx, filters);
            }
            root = needDistinct && this.needOrderBy(orderBys, alias) ? root.select(needDistinct, alias).orderBy(orderBys.split(",")) : root.select(needDistinct, alias);
        } else if (needDistinct) {
            String[] fieldNames = root.getRowMeta().getFieldNames();
            root = this.needOrderBy(orderBys, fieldNames) ? root.distinct().orderBy(orderBys.split(",")) : root.distinct();
        }
        return this.rebuilDataSet(root, fields);
    }

    public SqlTreeNode getQuerySql() {
        return SqlTreeNode.create(this.queries);
    }

    public int getMaxQueryJoinTableCount() {
        QueryOptimizater opt = new QueryOptimizater(this.optimization, this.selectFields, this.allCtx);
        QueryTreeNode treeNode = opt.getOptimalQueryTreeNode(this.queries);
        MaxCountVisitor v = new MaxCountVisitor();
        treeNode.accept(v);
        return v.maxCount;
    }

    public String toString() {
        return Arrays.toString(this.queries);
    }

    private Object[] aggregateByDataSet(String[] funcs, String[] fields, String[] aliasFields, DataSet ds, QFilter[] filters) {
        int len = funcs.length;
        HashMap<String, LongBitSet> longBitSetMap = new HashMap<String, LongBitSet>(len);
        HashMap<String, TrieTree> trieTreeMap = new HashMap<String, TrieTree>(len);
        String[] ids = ORMUtil.getIds(fields);
        Map<String, List<Integer>> groupIdFieldIndex = this.groupIdField(fields);
        Map<String, Boolean> groupIdFieldNeedDistinct = this.groupIdFieldNeedDistinct(this.selectFields, this.allCtx, filters, groupIdFieldIndex.keySet());
        Iterator iterator = ds.iterator();
        Object[] result = this.aggregateByDistinctFirst(longBitSetMap, trieTreeMap, ds.getRowMeta(), iterator, ids, groupIdFieldIndex, funcs, fields, aliasFields, groupIdFieldNeedDistinct);
        return this.aggregateByOrder(result, longBitSetMap, trieTreeMap, ds.getRowMeta(), iterator, ids, groupIdFieldIndex, funcs, fields, aliasFields, groupIdFieldNeedDistinct);
    }

    private DataSet aggregateByDataSet(AggregateFuncs aggregateFuncs, DataSet ds, String[] groupbyFields) {
        DataSet orderDataset = ds.orderBy(groupbyFields);
        String[] ids = ORMUtil.getIds(aggregateFuncs.getFields());
        Map<String, List<Integer>> groupIdFieldIndex = this.groupIdField(aggregateFuncs.getFields());
        HashMap keyMap = new HashMap(1);
        StringBuilder keyBuilder = new StringBuilder();
        DataSetBuilder dataSetBuilder = Algo.create((String)"aggregate_group").createDataSetBuilder(this.createAggregateRowMeta(aggregateFuncs, groupbyFields, ds.getRowMeta()));
        Object[] result = null;
        String[] funcs = aggregateFuncs.getFuncs();
        RowMeta rowMeta = ds.getRowMeta();
        String[] aliasFields = aggregateFuncs.getAliasFields();
        while (orderDataset.hasNext()) {
            int i;
            Row row = orderDataset.next();
            for (String field : groupbyFields) {
                keyBuilder.append(row.get(field)).append("_");
            }
            String groupKey = keyBuilder.toString();
            HashMap groupKeyMap = (HashMap)keyMap.get(keyBuilder.toString());
            if (groupKeyMap == null) {
                if (result != null) {
                    dataSetBuilder.append(result);
                }
                keyMap.clear();
                result = new Object[funcs.length + groupbyFields.length];
                groupKeyMap = new HashMap();
                keyMap.put(groupKey, groupKeyMap);
            }
            HashSet<String> idSet = new HashSet<String>(ids.length);
            for (i = 0; i < ids.length; ++i) {
                Field field;
                if (idSet.contains(ids[i])) continue;
                HashSet<String> idKeys = (HashSet<String>)groupKeyMap.get(ids[i]);
                if (idKeys == null) {
                    idKeys = new HashSet<String>(2);
                    groupKeyMap.put(ids[i], idKeys);
                }
                Object value = (field = rowMeta.getField(ids[i], false)) == null ? row.get(aliasFields[i]) : row.get(ids[i]);
                String groupKeyId = groupKey + value;
                idSet.add(ids[i]);
                if (!idKeys.add(groupKeyId)) continue;
                List<Integer> fieldIndex = groupIdFieldIndex.get(ids[i]);
                for (Integer index : fieldIndex) {
                    String func = funcs[index];
                    Object fieldValue = row.get(aliasFields[index]);
                    if ("sum".equalsIgnoreCase(func)) {
                        this.sumFunc(result, index, fieldValue);
                        continue;
                    }
                    if (!"count".equalsIgnoreCase(func)) continue;
                    this.countFunc(result, index, fieldValue);
                }
            }
            for (i = 0; i < groupbyFields.length; ++i) {
                result[funcs.length + i] = row.get(groupbyFields[i]);
            }
            keyBuilder.setLength(0);
        }
        if (result != null) {
            dataSetBuilder.append(result);
        }
        return dataSetBuilder.build();
    }

    private void sumFunc(Object[] result, int index, Object fieldValue) {
        if (fieldValue != null) {
            result[index] = result[index] == null ? new BigDecimal(fieldValue.toString()) : new BigDecimal(fieldValue.toString()).add((BigDecimal)result[index]);
        }
    }

    private void countFunc(Object[] result, int index, Object fieldValue) {
        if (fieldValue != null) {
            if (result[index] == null) {
                result[index] = 0;
            }
            result[index] = (Integer)result[index] + 1;
        }
    }

    private boolean idExists(Map<String, Object> lastRowIds, boolean compareAndSet, Map<String, LongBitSet> longBitSetMap, Map<String, TrieTree> trieTreeMap, String field, Object value) {
        Object id;
        int dotIndex = field.lastIndexOf(".");
        String key = dotIndex == -1 ? "id" : field.substring(0, dotIndex) + ".id";
        if (value instanceof String) {
            TrieTree trieTree = trieTreeMap.get(key);
            if (trieTree == null) {
                trieTree = new TrieTree();
                trieTreeMap.put(key, trieTree);
                if (compareAndSet) {
                    trieTree.insert((String)value);
                }
                return false;
            }
            if (trieTree.search((String)value)) {
                return true;
            }
            if (compareAndSet) {
                trieTree.insert((String)value);
                return false;
            }
        } else {
            long id2;
            LongBitSet bitSet = longBitSetMap.get(key);
            String idValue = value == null ? "" : String.valueOf(value);
            long l = id2 = StringUtils.isEmpty((String)idValue) ? 0L : Long.parseLong(idValue);
            if (bitSet == null && compareAndSet) {
                bitSet = BitSetFactory.createLong();
                longBitSetMap.put(key, bitSet);
                bitSet.set(id2);
                return false;
            }
            if (bitSet != null && bitSet.get(id2)) {
                return true;
            }
            if (compareAndSet) {
                bitSet.set(id2);
                return false;
            }
        }
        if ((id = lastRowIds.get(key)) == null) {
            lastRowIds.put(key, value);
            return false;
        }
        if (id.equals(value)) {
            return true;
        }
        lastRowIds.put(key, value);
        return false;
    }

    private int getCount0(String algoKey, int top, QFilter[] filters) {
        boolean hasTop = top != -1;
        int count = 0;
        try (DataSet ds = this.query(algoKey, filters, null);){
            for (Row row : ds) {
                if (!hasTop || ++count < top) continue;
                int n = count;
                return n;
            }
        }
        return count;
    }

    private boolean needOrderBy(String orderBys, String[] fieldsNames) {
        if (!StringUtils.isEmpty((String)orderBys)) {
            String[] orderbyArray = orderBys.split(",");
            return this.containsOrderBy(orderbyArray, fieldsNames);
        }
        return false;
    }

    private boolean containsOrderBy(String[] orderbyArray, String[] fieldsNames) {
        HashSet<String> names = new HashSet<String>(16);
        for (String name : fieldsNames) {
            names.add(name);
        }
        for (String orderBy : orderbyArray) {
            if (names.contains(orderBy.split(" ")[0])) continue;
            return false;
        }
        return true;
    }

    private boolean allLevelSingle(SingleQuery query) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        PropertyField[] selectFields = query.getSelectFields();
        if (selectFields == null || selectFields.length <= 0) {
            return true;
        }
        for (PropertyField field : selectFields) {
            String alias = field.getAlias();
            int index = alias.lastIndexOf(".");
            if (index > 0) {
                String prefix = alias.substring(0, index);
                Integer entryCount = (Integer)map.get(prefix);
                if (entryCount == null) {
                    map.put(prefix, 1);
                    continue;
                }
                return false;
            }
            Integer root = (Integer)map.get("root");
            if (root == null) {
                map.put("root", 1);
                continue;
            }
            return false;
        }
        return true;
    }

    private int getCountForAllLevelSingle(String algoKey, boolean distinct, SingleQuery query, int top) {
        PropertyField[] selectFields = query.getSelectFields();
        List<QueryTreeNode> subQueryNodes = query.getSubQueryNodes();
        if (selectFields != null && selectFields.length > 1) {
            String countSelectField = this.getCountSelectField(query, distinct);
            SingleQuery newQuery = query.optRebuildForCount(countSelectField);
            if (!CollectionUtils.isEmpty(subQueryNodes)) {
                newQuery.addSubQueryNodes(subQueryNodes);
                newQuery = QueryUtils.rebuildQuery(algoKey, newQuery);
            }
            return this.getCountSingle(newQuery, algoKey, distinct);
        }
        if (top > 0) {
            return this.handleTopCount(algoKey, query, top, new QFilter[]{query.getWhereFilter()});
        }
        String countSelectField = this.getCountSelectField(query, distinct);
        SingleQuery newQuery = query.optRebuildForCount(countSelectField);
        if (!CollectionUtils.isEmpty(subQueryNodes)) {
            newQuery.addSubQueryNodes(subQueryNodes);
            newQuery = QueryUtils.rebuildQuery(algoKey, newQuery);
        }
        try (DataSet ds = newQuery.query(algoKey, true);){
            int n = ((Row)ds.iterator().next()).getInteger(0);
            return n;
        }
    }

    private String getCountSelectField(SingleQuery query, boolean distinct) {
        PropertySegExpress pei;
        PropertyField[] selectFields = query.getSelectFields();
        if (selectFields == null || selectFields.length <= 0) {
            return "count(1) c";
        }
        if (selectFields.length == 1 && query.getQueryObjectCount() == 1 && (pei = selectFields[0].getPropertySegExpress()) != null && pei.isProperty()) {
            IDataEntityType entityType = selectFields[0].getEntityType();
            String p = selectFields[0].getPropertyItem().getPropertyName();
            if (entityType.getParent() == null && entityType.getPrimaryKey().getName().equalsIgnoreCase(p)) {
                return "count(" + p + ") c";
            }
        }
        if (selectFields.length == 1) {
            PropertyField selectField = selectFields[0];
            String name = selectField.getName();
            String alias = selectField.getAlias();
            if ("0".equals(name) && "c".equalsIgnoreCase(alias)) {
                return "count(1) c";
            }
            if (distinct) {
                return "count( distinct " + selectField.getAlias() + ") c";
            }
            return "count(" + selectField.getAlias() + ") c";
        }
        StringBuilder countField = new StringBuilder();
        for (int i = 0; i < selectFields.length; ++i) {
            countField.append(selectFields[i].getAlias());
            if (i >= selectFields.length - 1) continue;
            countField.append(",");
        }
        return countField.toString();
    }

    private int getCountSingle(SingleQuery query, String algoKey, boolean distinct) {
        try (DataSet ds = query.query(algoKey, true);){
            DataSet distinctDataSet = distinct ? ds.distinct() : ds;
            Iterator iterator = distinctDataSet.iterator();
            int count = 0;
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
            int n = count;
            return n;
        }
    }

    private String addDistinctTop(String qpSql, boolean containsDistinct, boolean needDistinct, int top) {
        if (!containsDistinct) {
            if (needDistinct) {
                qpSql = top > 0 ? "SELECT DISTINCT TOP " + top + qpSql.substring("SELECT".length()) : "SELECT DISTINCT " + qpSql.substring("SELECT".length());
            } else if (top > 0) {
                qpSql = "SELECT TOP " + top + qpSql.substring("SELECT".length());
            }
        } else if (top > 0) {
            qpSql = "SELECT DISTINCT TOP " + top + qpSql.substring("SELECT DISTINCT".length());
        }
        return qpSql;
    }

    private boolean containsSomeKeyword(String sql, String keyword) {
        int fromIndex;
        int selectIndex;
        String queryString = (sql = sql.toUpperCase()).substring(selectIndex = sql.indexOf("SELECT"), fromIndex = sql.indexOf("FROM"));
        return queryString.contains(keyword);
    }

    private String[] orderIds(String[] idField, RowMeta rowMeta) {
        HashSet<String> primaryKeys = new HashSet<String>(2);
        HashSet<String> rowMetaFields = new HashSet<String>(2);
        ArrayList<PropertyField> idFieldList = new ArrayList<PropertyField>();
        ArrayList<PropertyField> entryFieldList = new ArrayList<PropertyField>();
        ArrayList<PropertyField> subentryFieldList = new ArrayList<PropertyField>();
        HashMap<String, PropertyField> fieldMap = new HashMap<String, PropertyField>(this.selectFields.length);
        HashSet<String> idSet = new HashSet<String>(2);
        try {
            for (PropertyField propertyField : this.selectFields) {
                fieldMap.put(propertyField.getAlias(), propertyField);
            }
            for (PropertyField propertyField : rowMeta.getFields()) {
                ISimpleProperty simpleProperty;
                String alias = propertyField.getAlias();
                rowMetaFields.add(alias);
                PropertyField propertyField2 = (PropertyField)fieldMap.get(alias);
                if (propertyField2 == null || propertyField2.getPeropertyType() == null || !(propertyField2.getPeropertyType() instanceof ISimpleProperty) || !(simpleProperty = (ISimpleProperty)propertyField2.getPeropertyType()).isPrimaryKey()) continue;
                primaryKeys.add(propertyField.getAlias());
                String fullObjectName = propertyField2.getFullObjectName();
                if (fullObjectName.lastIndexOf(".") == -1) {
                    idFieldList.add(propertyField2);
                    continue;
                }
                if (ORMConfiguration.isSubEntityType(propertyField2.getEntityType())) {
                    subentryFieldList.add(propertyField2);
                    continue;
                }
                if (!ORMConfiguration.isEntryEntityType(propertyField2.getEntityType())) continue;
                entryFieldList.add(propertyField2);
            }
            if (primaryKeys.size() > 0) {
                for (PropertyField id : idFieldList) {
                    idSet.add(id.getAlias());
                }
                for (PropertyField id : entryFieldList) {
                    idSet.add(id.getAlias());
                }
                for (PropertyField id : subentryFieldList) {
                    idSet.add(id.getAlias());
                }
                return idSet.toArray(new String[idSet.size()]);
            }
        }
        catch (Exception e) {
            logger.error((Object)"parse orderby field error", (Throwable)e);
        }
        idSet.clear();
        HashSet<String> entryIdSet = new HashSet<String>(2);
        HashSet<String> subentryIdSet = new HashSet<String>(2);
        for (String id : idField) {
            if (!rowMetaFields.contains(id)) continue;
            if ("id".equalsIgnoreCase(id)) {
                idSet.add(id);
                continue;
            }
            if (id.indexOf(".") != id.lastIndexOf(".")) {
                subentryIdSet.add(id);
                continue;
            }
            entryIdSet.add(id);
        }
        if (!entryIdSet.isEmpty()) {
            idSet.addAll(entryIdSet);
        }
        if (subentryIdSet.isEmpty()) {
            idSet.addAll(subentryIdSet);
        }
        return idSet.toArray(new String[idSet.size()]);
    }

    private Object[] aggregateByDistinctFirst(Map<String, LongBitSet> longBitSetMap, Map<String, TrieTree> trieTreeMap, RowMeta rowMeta, Iterator<Row> rowIterator, String[] ids, Map<String, List<Integer>> groupIdFieldIndex, String[] funcs, String[] fields, String[] aliasFields, Map<String, Boolean> groupIdFieldNeedDistinct) {
        Object[] result = new Object[funcs.length];
        int rowCount = 0;
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            this.calculate(null, true, result, row, longBitSetMap, trieTreeMap, rowMeta, ids, groupIdFieldIndex, funcs, fields, aliasFields, groupIdFieldNeedDistinct);
            ++rowCount;
            if (!(!longBitSetMap.isEmpty() && !trieTreeMap.isEmpty() ? rowCount > ORMConfig.AGGREGATE_STRINGPRIMARY_MAXSIZE.getInt() : (!longBitSetMap.isEmpty() ? rowCount > ORMConfig.AGGREGATE_LONGPRIMARY_MAXSIZE.getInt() : !trieTreeMap.isEmpty() && rowCount > ORMConfig.AGGREGATE_STRINGPRIMARY_MAXSIZE.getInt()))) continue;
            break;
        }
        return result;
    }

    private Object[] aggregateByOrder(Object[] result, Map<String, LongBitSet> longBitSetMap, Map<String, TrieTree> trieTreeMap, RowMeta rowMeta, Iterator<Row> rowIterator, String[] ids, Map<String, List<Integer>> groupIdFieldIndex, String[] funcs, String[] fields, String[] aliasFields, Map<String, Boolean> groupIdFieldNeedDistinct) {
        if (rowIterator.hasNext()) {
            DataSet newDataSet = Algo.create((String)"test").createDataSet((Iterator)new LeftDataSetIterator(rowIterator), rowMeta);
            Set<String> idKeys = groupIdFieldIndex.keySet();
            String[] orderBy = this.orderIds(idKeys.toArray(new String[idKeys.size()]), rowMeta);
            newDataSet = newDataSet.orderBy(orderBy);
            HashMap<String, Object> lastRowIds = new HashMap<String, Object>();
            while (newDataSet.hasNext()) {
                Row row = newDataSet.next();
                this.calculate(lastRowIds, false, result, row, longBitSetMap, trieTreeMap, rowMeta, ids, groupIdFieldIndex, funcs, fields, aliasFields, groupIdFieldNeedDistinct);
            }
        }
        return result;
    }

    public void calculate(Map<String, Object> lastRowIds, boolean compareAndSet, Object[] result, Row row, Map<String, LongBitSet> longBitSetMap, Map<String, TrieTree> trieTreeMap, RowMeta rowMeta, String[] ids, Map<String, List<Integer>> groupIdFieldIndex, String[] funcs, String[] fields, String[] aliasFields, Map<String, Boolean> groupIdFieldNeedDistinct) {
        Iterator<Map.Entry<String, List<Integer>>> iterator = groupIdFieldIndex.entrySet().iterator();
        int fieldCount = rowMeta.getFieldCount();
        while (iterator.hasNext()) {
            Map.Entry<String, List<Integer>> next = iterator.next();
            List<Integer> fieldIndex = next.getValue();
            String id = next.getKey();
            int count = 0;
            boolean firstFieldIdExists = false;
            for (Integer index : fieldIndex) {
                Object idValue;
                String func = funcs[index];
                Object fieldValue = row.get(aliasFields[index]);
                String existField = fields[index];
                if (fieldCount == 1) {
                    idValue = fieldValue;
                } else {
                    Field field = rowMeta.getField(ids[index], false);
                    if (field == null) {
                        idValue = row.get(aliasFields[index]);
                        existField = aliasFields[index];
                    } else {
                        idValue = row.get(ids[index]);
                    }
                }
                Boolean needDistinct = groupIdFieldNeedDistinct.get(id);
                if (needDistinct == null || needDistinct.booleanValue()) {
                    if (count == 0) {
                        firstFieldIdExists = compareAndSet ? this.idExists(null, true, longBitSetMap, trieTreeMap, existField, idValue) : this.idExists(lastRowIds, false, longBitSetMap, trieTreeMap, existField, idValue);
                    }
                } else {
                    firstFieldIdExists = false;
                }
                if ("sum".equalsIgnoreCase(func) && !firstFieldIdExists) {
                    this.sumFunc(result, index, fieldValue);
                } else if ("count".equalsIgnoreCase(func) && !firstFieldIdExists) {
                    this.countFunc(result, index, fieldValue);
                }
                ++count;
            }
        }
    }

    private Map<String, List<Integer>> groupIdField(String[] fields) {
        HashMap<String, List<Integer>> groupFieldIndex = new HashMap<String, List<Integer>>();
        for (int i = 0; i < fields.length; ++i) {
            int dotIndex = fields[i].lastIndexOf(".");
            String key = dotIndex != -1 ? fields[i].substring(0, dotIndex) + ".id" : "id";
            ArrayList<Integer> fieldList = (ArrayList<Integer>)groupFieldIndex.get(key);
            if (fieldList == null) {
                fieldList = new ArrayList<Integer>();
                groupFieldIndex.put(key, fieldList);
            }
            fieldList.add(i);
        }
        return groupFieldIndex;
    }

    public Object[] aggregateBySql(boolean shouldMerge, String algoKey, AggregateFuncs aggregateFuncs, QFilter[] filters) {
        SingleQuery singleQuery;
        if (shouldMerge) {
            QueryTreeNode root = QueryTreeNode.create(this.queries);
            QueryUtils.tryMergeQuery(root, this.allCtx, this.optimization.isReduceUnnessesaryJoin());
            singleQuery = root.getQuery();
        } else {
            singleQuery = this.queries[0];
        }
        return ORMUtil.aggregateBySql(algoKey, singleQuery, aggregateFuncs, filters);
    }

    private RowMeta createAggregateRowMeta(AggregateFuncs aggregateFuncs, String[] groupbyFields, RowMeta meta) {
        int i;
        String[] funcs = aggregateFuncs.getFuncs();
        String[] aliasFields = aggregateFuncs.getAliasFields();
        String[] customerAlias = aggregateFuncs.getCustomerAlias();
        Field[] fields = new Field[funcs.length + groupbyFields.length];
        for (i = 0; i < funcs.length; ++i) {
            Field field;
            Object dataType = funcs[i].trim().toLowerCase(Locale.ENGLISH).startsWith("sum") ? DataType.BigDecimalType : DataType.IntegerType;
            fields[i] = field = new Field(customerAlias[i] == null ? aliasFields[i] : customerAlias[i], (DataType)dataType);
        }
        for (i = 0; i < groupbyFields.length; ++i) {
            fields[funcs.length + i] = meta.getField(groupbyFields[i]);
        }
        return new RowMeta(fields);
    }

    /*
     * Exception decompiling
     */
    private int handleTopCount(String algoKey, SingleQuery query, int top, QFilter[] filters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DataSet rebuilDataSet(DataSet origionDataSet, PropertyField[] origionFields) {
        RowMeta newRowMeta;
        try {
            newRowMeta = this.rebuildRowMetaForNullable(origionDataSet.getRowMeta(), origionFields);
        }
        catch (Exception e) {
            logger.warn((Object)("rebuild rowmeta error:" + e.getMessage()), (Throwable)e);
            return origionDataSet;
        }
        if (newRowMeta == null) {
            return origionDataSet;
        }
        return new RebuildNullableDataSet(origionDataSet, newRowMeta);
    }

    private RowMeta rebuildRowMetaForNullable(RowMeta dataSetRowMeta, PropertyField[] origionFields) {
        HashMap<String, PropertyField> fieldAliasMap = new HashMap<String, PropertyField>(origionFields.length);
        for (PropertyField origionField : origionFields) {
            fieldAliasMap.put(origionField.getAlias(), origionField);
        }
        Field[] dataSetFields = dataSetRowMeta.getFields();
        Field[] newFields = new Field[dataSetFields.length];
        int count = 0;
        boolean needRebuild = false;
        for (Field dataSetField : dataSetFields) {
            PropertyField field = (PropertyField)fieldAliasMap.get(dataSetField.getAlias());
            boolean isNullable = field != null && field.getPeropertyType() != null ? field.getPeropertyType().isEnableNull() : false;
            newFields[count++] = new Field(dataSetField.getName(), dataSetField.getAlias(), dataSetField.getDataType(), isNullable);
            if (dataSetField.isNullable() == isNullable) continue;
            needRebuild = true;
        }
        if (needRebuild) {
            return new RowMeta(newFields);
        }
        return null;
    }

    private Map<String, Boolean> groupIdFieldNeedDistinct(PropertyField[] selectFields, QContext allCtx, QFilter[] filters, Set<String> ids) {
        HashMap<String, Boolean> distinctMap = new HashMap<String, Boolean>(ids.size());
        String rootObjName = allCtx.getMainEntityItem().getFullObjectName().toLowerCase(Locale.ENGLISH);
        block0: for (String field : ids) {
            String fieldLowerCase = field.toLowerCase(Locale.ENGLISH);
            for (PropertyField selectField : selectFields) {
                if (!fieldLowerCase.equals(selectField.getAlias().toLowerCase(Locale.ENGLISH)) && !(rootObjName + "." + fieldLowerCase).equals(selectField.getFullName().toLowerCase(Locale.ENGLISH))) continue;
                boolean b = ORMUtil.needDistinct(new PropertyField[]{selectField}, allCtx, filters);
                if (!b) {
                    b = this.needDistinctWithJoinEntry(field, ids);
                }
                distinctMap.put(field, b);
                continue block0;
            }
        }
        return distinctMap;
    }

    private boolean needDistinctWithJoinEntry(String field, Set<String> ids) {
        try {
            if ("id".equals(field)) {
                return ids.size() > 1;
            }
            int fieldLastDot = field.lastIndexOf(46);
            String fieldSubString = field.substring(0, fieldLastDot);
            for (String id : ids) {
                if (id.length() <= field.length() || !id.startsWith(fieldSubString + ".")) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("needDistinctWithJoinEntry occured an error: " + e.getMessage()));
        }
        return false;
    }

    private static class RebuildNullableDataSet
    extends AbstractDataSet {
        private DataSet origionDataSet;
        private RowMeta newRowMeta;

        public RebuildNullableDataSet(DataSet dataSet, RowMeta newRowMeta) {
            super("RebuildNullableDataSet", (AbstractDataSet)dataSet);
            this.origionDataSet = dataSet;
            this.newRowMeta = newRowMeta;
        }

        protected RowMeta createTargetRowMeta() {
            return this.newRowMeta;
        }

        protected InnerRowIterator createIterator() {
            return ((AbstractDataSet)this.origionDataSet).innerIterator();
        }

        public void realClose() {
            if (this.origionDataSet != null) {
                this.origionDataSet.close();
            }
        }
    }

    private static class MaxCountVisitor
    implements QueryTreeNodeVisitor {
        int maxCount;

        private MaxCountVisitor() {
        }

        @Override
        public void visit(QueryTreeNode node) {
            List<JoinTableInfo> joinTableInfoList = node.getQuery().getCtx().getJoinTableList();
            if (joinTableInfoList != null && joinTableInfoList.size() > this.maxCount) {
                this.maxCount = joinTableInfoList.size();
            }
            for (QueryTreeNode child : node.getChildren()) {
                child.accept(this);
            }
        }
    }
}

