/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import kd.bos.bundle.BosRes;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.db.DBRoute;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.db.privacy.model.DBPrivacyDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.EntityItemProperty;
import kd.bos.orm.query.EntityNotExistsException;
import kd.bos.orm.query.MergeDBBeacon;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterUtil;
import kd.bos.orm.query.QFilterValue;
import kd.bos.orm.query.crossdb.CrossDBORQuery;
import kd.bos.orm.query.crossdb.TenantAccountCrossDBRuntime;
import kd.bos.orm.query.crud.read.SelectFieldBuilder;
import kd.bos.orm.query.multi.GroupByInfo;
import kd.bos.orm.query.multi.MultiQuery;
import kd.bos.orm.query.multi.MultiQueryParameter;
import kd.bos.orm.query.multi.OrderByInfo;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.multi.QFilterDecryptTransFunction;
import kd.bos.orm.query.multi.QFilterFtlikeTransFunction;
import kd.bos.orm.query.multi.QFilterGLanEqualAndLikeTransFunction;
import kd.bos.orm.query.multi.QFilterJoinSQLTransFunction;
import kd.bos.orm.query.multi.QFilterMulBasedataPropTransFunction;
import kd.bos.orm.query.multi.QFilterMultiTypeBasedataFunction;
import kd.bos.orm.query.multi.QFilterNotEqualTransFunction;
import kd.bos.orm.query.multi.QFilterPrivacyPropTransFunction;
import kd.bos.orm.query.multi.QFilterValueConverterFunction;
import kd.bos.orm.query.multi.QueryUtils;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.orm.query.optimize.JoinDBTodo;
import kd.bos.orm.query.optimize.QueryTreeNode;
import kd.bos.orm.query.oql.g.expr.SelectFields;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;

class MultiQueryBuilder {
    private Map<String, EntityTypeItem> entityTypeMap = new HashMap<String, EntityTypeItem>();
    private MultiQueryParameter mp;
    private static final Log logger = LogFactory.getLog(MultiQueryBuilder.class);

    MultiQueryBuilder(MultiQueryParameter mp) {
        this.mp = mp;
        if (mp.selectFields == null || mp.selectFields.trim().length() == 0) {
            mp.selectFields = new SelectFieldBuilder(mp.entityType.getName().toLowerCase(), mp.entityTypeCache).buildSelectFields(true);
        }
        this.entityTypeMap.put(mp.entityType.getName().toLowerCase(), new EntityTypeItem(mp.entityType, null));
    }

    /*
     * WARNING - void declaration
     */
    MultiQuery build() {
        List<PropertyField> plist;
        QueryFieldInfo queryFieldInfo = this.parseQueryFieldInfo();
        final String rootObjName = this.mp.entityType.getName().toLowerCase();
        List<OrderByInfo> allOrderByList = OrderByInfo.getOrderByList(this.mp.orderBys, rootObjName);
        List<GroupByInfo> allGroupByList = GroupByInfo.getGroupByList(this.mp.groupBys, rootObjName);
        MergeDBBeacon.markAboutHandleAllFilterAndOrderAndGroupBy();
        QContext allCtx = new QContext(this.mp.entityType, rootObjName, queryFieldInfo.innerSelectFields, this.mp.entityTypeCache, this.mp.ormHint, this.mp.distinctable, true, new HashMap<String, String>(), null);
        this.transFilter(rootObjName, allCtx);
        Map<String, List<PropertyField>> selectObjMap = allCtx.getSelectObjectMap();
        this.handlCrossDBOR(allCtx, rootObjName);
        Map<String, QFilter> allJoinFilterMap = this.createObjFilterMap(this.mp.joinFilters, rootObjName, allCtx, true);
        Map<String, QFilter> allWhereFilterMap = this.createObjFilterMap(this.mp.whereFilters, rootObjName, allCtx, false);
        this.setInnerJoin(allCtx, allWhereFilterMap, allJoinFilterMap);
        this.generateINNER(allCtx, rootObjName, selectObjMap, allWhereFilterMap);
        Map<String, QFilter> allHavingFilterMap = this.createObjFilterMap(this.mp.havings, rootObjName, allCtx, false);
        allCtx.getOrderBy(allOrderByList.toArray(new OrderByInfo[allOrderByList.size()]));
        allCtx.getGroupBy(allGroupByList.toArray(new GroupByInfo[allGroupByList.size()]));
        String aliasRootPrefix = rootObjName.toLowerCase() + ".";
        ArrayList<SingleQuery> allQuery = new ArrayList<SingleQuery>(4);
        ArrayList<PropertyField> shouldSelectPKList = new ArrayList<PropertyField>();
        HashSet<String> entryObjectSet = new HashSet<String>();
        Iterator<String> iterator = new ArrayList<String>(selectObjMap.keySet()).iterator();
        while (iterator.hasNext()) {
            String string;
            void var16_20;
            int n;
            String string2;
            String string3 = string2 = iterator.next();
            while ((n = var16_20.lastIndexOf(46)) != -1 && this.checkFault(selectObjMap, string = var16_20.substring(0, n))) {
                this.getAndSetSharedProperties(selectObjMap, string, entryObjectSet, allCtx);
            }
        }
        HashMap<String, String> parentObjNameMap = new HashMap<String, String>();
        for (String string : new ArrayList<String>(selectObjMap.keySet())) {
            if (entryObjectSet.contains(string) || string.equals(rootObjName)) continue;
            EntityItem entityItem = allCtx.getEntityItem(string);
            String parentObjName = entityItem.joinProperty.getParentEntityItem().getFullObjectName();
            parentObjNameMap.put(string, parentObjName);
            plist = this.getAndSetSharedProperties(selectObjMap, parentObjName, entryObjectSet, allCtx);
            String withoutRootSubObjName = string;
            if (withoutRootSubObjName.startsWith(rootObjName)) {
                withoutRootSubObjName = withoutRootSubObjName.substring(rootObjName.length() + 1);
            }
            if (entityItem.joinProperty.isIJoinProperty()) {
                shouldSelectPKList.add(this.addQueryPrimaryKey(string, withoutRootSubObjName, entityItem.joinProperty.getSubJoinPropertyType().getName(), true, plist, allCtx));
                shouldSelectPKList.add(this.addQueryPrimaryKey(parentObjName, withoutRootSubObjName, entityItem.joinProperty.getParentJoinPropertyType().getName(), true, plist, allCtx));
                continue;
            }
            shouldSelectPKList.add(this.addQueryPrimaryKey(parentObjName, withoutRootSubObjName, entityItem.joinProperty.getParentOriginProperty().getName(), true, plist, allCtx));
        }
        for (Map.Entry<String, List<PropertyField>> entry : new ArrayList<Map.Entry<String, List<PropertyField>>>(selectObjMap.entrySet())) {
            void var15_19;
            PropertyField[] properties;
            String objName = entry.getKey();
            if (entryObjectSet.contains(objName)) continue;
            plist = entry.getValue();
            if (!objName.equals(rootObjName)) {
                void var21_41;
                boolean bl = false;
                EntityItem ei = allCtx.getEntityItem(objName);
                if (ORMConfiguration.isMulBasedata(ei.entityType)) {
                    PropertyField pkid;
                    PropertyField propertyField = this.addFid(objName, "", ei.entityType.getParent().getPrimaryKey().getAlias(), !this.mp.shouldSelectPK, plist, allCtx);
                    if (this.mp.shouldSelectPK && (pkid = this.addQueryPrimaryKey(objName, "", ei.entityType.getPrimaryKey().getName().toLowerCase(), !this.mp.shouldSelectPK, plist, allCtx)) != null && !this.containsField(plist.toArray(new PropertyField[plist.size()]), pkid)) {
                        this.replaceAlias(pkid, rootObjName, objName, allWhereFilterMap);
                        shouldSelectPKList.add(pkid);
                    }
                } else {
                    PropertyField propertyField = this.addQueryPrimaryKey(objName, "", ei.entityType.getPrimaryKey().getName().toLowerCase(), !this.mp.shouldSelectPK, plist, allCtx);
                }
                this.replaceAlias((PropertyField)var21_41, rootObjName, objName, allWhereFilterMap);
                shouldSelectPKList.add((PropertyField)var21_41);
            } else {
                boolean bl = true;
            }
            for (PropertyField propertyField : properties = plist.toArray(new PropertyField[plist.size()])) {
                if (!propertyField.getAlias().toLowerCase(Locale.ENGLISH).startsWith(aliasRootPrefix)) continue;
                propertyField.setAlias(propertyField.getAlias().substring(aliasRootPrefix.length()));
            }
            EntityTypeItem entityTypeItem = this.getEntityType(objName, true);
            if (entityTypeItem.parentFK != null) {
                String string;
                int dot;
                boolean useAlias = false;
                String parentObjName = (String)parentObjNameMap.get(objName);
                if (parentObjName == null) {
                    parentObjName = objName.substring(0, objName.lastIndexOf(46));
                }
                for (PropertyField p : selectObjMap.get(parentObjName)) {
                    if (!entityTypeItem.parentFK.equalsIgnoreCase(p.getName())) continue;
                    useAlias = true;
                    entityTypeItem.parentFK = p.getAlias();
                    int dot2 = entityTypeItem.parentFK.indexOf(46);
                    if (dot2 == -1 || !p.getAlias().equals(p.getFullName())) break;
                    entityTypeItem.parentFK = p.getPropertyItem().getPropertyName();
                    break;
                }
                if (!useAlias && (dot = (string = ORMUtil.getFullObjNameWithoutRoot(objName)).lastIndexOf(46)) != -1) {
                    entityTypeItem.parentFK = string.substring(0, dot + 1) + entityTypeItem.parentFK;
                }
            }
            SingleQuery subQuery = new SingleQuery(this.mp.dbRoute, entityTypeItem.parentFK, entityTypeItem.type, objName, properties, allCtx.getPerformJoinFieldList(objName), allJoinFilterMap, allWhereFilterMap, allOrderByList, allGroupByList, allHavingFilterMap, var15_19 != false ? this.mp.top : -1, this.mp.start, this.mp.limit, allCtx, false, false, true, this.mp.shouldSelectPK);
            subQuery.setWithUserOriginFilter(subQuery.withWhereFilter());
            allQuery.add(subQuery);
            this.generateSubMultiQuery(subQuery, allCtx);
        }
        Collections.sort(allQuery, new Comparator<SingleQuery>(){

            @Override
            public int compare(SingleQuery o1, SingleQuery o2) {
                String n1 = o1.getFullObjName();
                if (n1.equals(rootObjName)) {
                    return -1;
                }
                String n2 = o2.getFullObjName();
                if (n2.equals(rootObjName)) {
                    return 1;
                }
                return n1.compareTo(n2);
            }
        });
        if (this.mp.shouldSelectPK) {
            ArrayList<PropertyField> arrayList = new ArrayList<PropertyField>(Arrays.asList(queryFieldInfo.userSelectFields));
            for (PropertyField pf : shouldSelectPKList) {
                if (pf == null) continue;
                boolean exists = false;
                for (PropertyField propertyField : arrayList) {
                    if (!propertyField.isSameWith(pf) && !this.isMultiTypePropertyAndAliasSame(propertyField, pf, rootObjName, allCtx)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                arrayList.add(pf);
            }
            List<PropertyField> list = this.addMultiSelectPkid(selectObjMap, allCtx);
            if (list != null && list.size() > 0) {
                arrayList.addAll(list);
            }
            if (arrayList.size() > queryFieldInfo.userSelectFields.length) {
                queryFieldInfo.userSelectFields = arrayList.toArray(new PropertyField[arrayList.size()]);
            }
            this.resestReturnSelectFields(shouldSelectPKList, queryFieldInfo, selectObjMap, allCtx);
        }
        MultiQuery multiQuery = new MultiQuery(allQuery.toArray(new SingleQuery[allQuery.size()]), queryFieldInfo.userSelectFields, queryFieldInfo.returnSelectFields, this.mp.optimization, allCtx, this.mp.shouldSelectPK);
        return multiQuery;
    }

    private void resestReturnSelectFields(List<PropertyField> shouldSelectPKList, QueryFieldInfo queryFieldInfo, Map<String, List<PropertyField>> selectObjMap, QContext allctx) {
        ArrayList<PropertyField> buf1 = new ArrayList<PropertyField>(Arrays.asList(queryFieldInfo.returnSelectFields));
        for (PropertyField pf : shouldSelectPKList) {
            if (pf == null) continue;
            boolean exists = false;
            for (PropertyField useSelectField : buf1) {
                if (!useSelectField.isSameWith(pf)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            buf1.add(pf);
        }
        if (buf1.size() > queryFieldInfo.returnSelectFields.length) {
            queryFieldInfo.returnSelectFields = buf1.toArray(new PropertyField[buf1.size()]);
        }
    }

    private boolean checkFault(Map<String, List<PropertyField>> selectObjMap, String objName) {
        boolean hasFault = false;
        if (objName.contains(".")) {
            String[] parentNames = objName.split("\\.");
            String parentName = null;
            for (int i = 0; i < parentNames.length; ++i) {
                if (selectObjMap.containsKey(parentName = parentName == null ? objName : parentName.substring(0, parentName.lastIndexOf(".")))) continue;
                hasFault = true;
                break;
            }
        }
        return hasFault;
    }

    private List<PropertyField> getAndSetSharedProperties(Map<String, List<PropertyField>> selectObjMap, String objName, Set<String> entryObjectSet, QContext ctx) {
        String mainObjName = objName;
        HashSet<String> pathObjSet = new HashSet<String>(2);
        pathObjSet.add(objName);
        while (true) {
            EntityItem ei = ctx.getEntityItem(mainObjName);
            if (!ORMConfiguration.isEntryEntityType(ei.entityType)) break;
            entryObjectSet.add(mainObjName);
            mainObjName = ORMUtil.getParentObjectName(mainObjName);
            pathObjSet.add(mainObjName);
        }
        List<PropertyField> pfList = selectObjMap.get(mainObjName);
        if (pfList == null) {
            pfList = new ArrayList<PropertyField>();
        }
        for (String obj : pathObjSet) {
            selectObjMap.put(obj, pfList);
        }
        return pfList;
    }

    private void transFilter(String rootObjName, QContext allCtx) {
        QFilter[][] allFilters = new QFilter[][]{this.mp.joinFilters, this.mp.whereFilters, this.mp.havings};
        QFilterValueConverterFunction converterFunction = new QFilterValueConverterFunction(rootObjName, allCtx);
        for (QFilter[] filters : allFilters) {
            this.doTransFilter(filters, converterFunction);
        }
        QFilterJoinSQLTransFunction sqltf = new QFilterJoinSQLTransFunction();
        for (QFilter[] filters : allFilters) {
            this.doTransFilter(filters, sqltf);
        }
        QFilterMulBasedataPropTransFunction bptf = new QFilterMulBasedataPropTransFunction(rootObjName, allCtx);
        for (QFilter[] filters : allFilters) {
            this.doTransFilter(filters, bptf);
        }
        QFilterDecryptTransFunction decrypttf = new QFilterDecryptTransFunction(rootObjName, allCtx);
        for (QFilter[] filters : allFilters) {
            this.doTransFilter(filters, decrypttf);
        }
        QFilterPrivacyPropTransFunction privacytf = new QFilterPrivacyPropTransFunction(rootObjName, allCtx);
        for (QFilter[] filters : allFilters) {
            this.doTransFilter(filters, privacytf);
        }
        QFilterMultiTypeBasedataFunction multiType = new QFilterMultiTypeBasedataFunction(this.mp, allCtx);
        for (QFilter[] filters : allFilters) {
            this.doTransFilter(filters, multiType);
        }
        QFilterFtlikeTransFunction ftlikeTrans = new QFilterFtlikeTransFunction(rootObjName, allCtx);
        for (QFilter[] filters : allFilters) {
            this.doTransFilter(filters, ftlikeTrans);
        }
        QFilterNotEqualTransFunction notEqualTransFunction = new QFilterNotEqualTransFunction(rootObjName, allCtx);
        for (QFilter[] filters : allFilters) {
            this.doTransFilter(filters, notEqualTransFunction);
        }
        QFilterGLanEqualAndLikeTransFunction qFilterGLanEqualAndLikeTransFunction = new QFilterGLanEqualAndLikeTransFunction(rootObjName, allCtx);
        for (QFilter[] filters : allFilters) {
            this.doTransFilter(filters, qFilterGLanEqualAndLikeTransFunction);
        }
        HashSet<String> cannotUpObjectName = new HashSet<String>();
        HashMap<QFilter, String> objectSingleFilterSet = new HashMap<QFilter, String>();
        ArrayList<QFilter> fs = new ArrayList<QFilter>(4);
        for (QFilter[] filters : allFilters) {
            if (filters == null) continue;
            for (QFilter farray : filters) {
                fs.clear();
                fs.add(farray);
                for (QFilter.QFilterNest f : farray.getNests(true)) {
                    fs.add(f.getFilter());
                }
                for (QFilter filter : fs) {
                    String ep = filter.getProperty();
                    int pos = ep.lastIndexOf(46);
                    if (pos == -1) continue;
                    String fullEntityName = rootObjName + "." + ep.substring(0, pos).toLowerCase();
                    EntityItem ei = null;
                    try {
                        ei = allCtx.getEntityItem(fullEntityName);
                    }
                    catch (Exception e) {
                        logger.error(fullEntityName + ", MultiQueryBuilder.transFilter getEntityItem occur an error: " + e.getMessage());
                    }
                    if (ei == null) continue;
                    String propertyName = ep.substring(pos + 1).toLowerCase(Locale.ENGLISH);
                    boolean canBeUpped = false;
                    if (!(filter.isJoinFilter() || ORMConfiguration.isEntryEntityType(ei.entityType) || ORMConfiguration.isMulBasedata(ei.entityType) || cannotUpObjectName.contains(fullEntityName))) {
                        PropertyField pf;
                        if (filter.isExpressValue() && ((pf = filter.__getParsedExpressValue(allCtx)) == null || !pf.isExpress())) {
                            cannotUpObjectName.add(fullEntityName);
                            continue;
                        }
                        if (propertyName.equalsIgnoreCase(ei.joinProperty.getSubJoinPropertyType().getName())) {
                            canBeUpped = true;
                            objectSingleFilterSet.put(filter, fullEntityName);
                        }
                    }
                    if (canBeUpped) continue;
                    cannotUpObjectName.add(fullEntityName);
                }
            }
        }
        for (Map.Entry entry : objectSingleFilterSet.entrySet()) {
            String fullEntityName = (String)entry.getValue();
            if (cannotUpObjectName.contains(fullEntityName)) continue;
            QFilter filter = (QFilter)entry.getKey();
            filter.__setProperty(fullEntityName.substring(rootObjName.length() + 1));
        }
    }

    private void doTransFilter(QFilter[] filters, Function<QFilter, QFilter> tf) {
        if (filters != null) {
            int n = filters.length;
            for (int i = 0; i < n; ++i) {
                filters[i] = filters[i].trans(tf);
            }
        }
    }

    private Map<String, QFilter> createObjFilterMap(QFilter[] filters, String rootObjName, QContext ctx, boolean isJoinFilters) {
        HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>();
        if (filters != null && filters.length > 0) {
            for (QFilter filter : filters) {
                QFilter mergedFilter;
                String objName;
                filter.toQParameter(ctx);
                if (isJoinFilters) {
                    objName = filter.getJoinEntityPath().toLowerCase();
                    String tryFullObjName = rootObjName + "." + objName;
                    if (ctx.getEntityItem(tryFullObjName) != null) {
                        objName = tryFullObjName;
                    }
                } else {
                    TreeSet<String> objNameSet = new TreeSet<String>();
                    for (PropertyField pf : filter.__getParsedPropertyFields()) {
                        if (pf == null) continue;
                        objNameSet.add(pf.getFullObjectName());
                    }
                    objName = objNameSet.isEmpty() ? rootObjName : (objNameSet.size() == 1 ? (String)objNameSet.iterator().next() : (String)objNameSet.iterator().next());
                }
                if (!filter.isJoinFilter()) {
                    objName = this.resetNameIfEntry(ctx, objName);
                }
                mergedFilter = (mergedFilter = (QFilter)filterMap.get(objName)) == null ? filter : mergedFilter.and(filter);
                filterMap.put(objName, mergedFilter);
            }
        }
        return filterMap;
    }

    private String resetNameIfEntry(QContext ctx, String objName) {
        EntityItem upEntityItem;
        int index;
        EntityItem entityItem = ctx.getEntityItem(objName);
        if (entityItem == null || entityItem.entityType == null) {
            return objName;
        }
        boolean isEntry = ORMConfiguration.isEntryEntityType(entityItem.entityType);
        while (isEntry && (index = objName.lastIndexOf(".")) > 0 && (upEntityItem = ctx.getEntityItem(objName = objName.substring(0, index))) != null && upEntityItem.entityType != null && (isEntry = ORMConfiguration.isEntryEntityType(upEntityItem.entityType))) {
        }
        return objName;
    }

    private QueryFieldInfo parseQueryFieldInfo() {
        List<PropertyField> pfs;
        this.mp.selectFields = this.preHandle(this.mp.selectFields, this.getAllFilters());
        String rootObjName = this.mp.entityType.getName().toLowerCase();
        QueryFieldInfo ret = new QueryFieldInfo();
        try {
            pfs = SelectFields.parseFrom(this.mp.selectFields).createPropertyFields(rootObjName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(rootObjName + " select field error: " + this.mp.selectFields, e);
        }
        ArrayList<String> newFields = new ArrayList<String>();
        for (PropertyField field : new ArrayList<PropertyField>(pfs)) {
            if (!"*".equals(field.getName())) continue;
            String aliasPrefix = field.getAlias();
            if (aliasPrefix.indexOf(42) != -1) {
                aliasPrefix = null;
            }
            EntityTypeItem eti = this.getEntityType(field.getFullObjectName(), true);
            String addedObjPrefix = field.getFullObjectName().length() == 0 ? rootObjName + "." : rootObjName + "." + field.getFullObjectName().toLowerCase() + ".";
            DataEntityPropertyCollection ps = eti.type.getProperties();
            this.collectAutoSelectFields(addedObjPrefix, aliasPrefix, ps, newFields);
            pfs.remove(field);
        }
        for (String newField : newFields) {
            PropertyField pf = new PropertyField(newField.trim());
            pfs.add(pf);
        }
        ret.returnSelectFields = pfs.toArray(new PropertyField[pfs.size()]);
        this.addPkToPrivacy(pfs, rootObjName);
        ret.innerSelectFields = pfs.toArray(new PropertyField[pfs.size()]);
        ret.userSelectFields = pfs.toArray(new PropertyField[pfs.size()]);
        return ret;
    }

    private void collectAutoSelectFields(String addedObjPrefix, String aliasPrefix, DataEntityPropertyCollection ps, List<String> newFields) {
        int n = ps.size();
        for (int j = 0; j < n; ++j) {
            String name;
            IDataEntityProperty dp = (IDataEntityProperty)ps.get(j);
            if (dp instanceof ICollectionProperty) {
                if (!(dp instanceof DynamicLocaleProperty)) continue;
                DataEntityPropertyCollection localePs = ((DynamicLocaleProperty)dp).getDynamicCollectionItemPropertyType().getProperties();
                DataEntityPropertyCollection selectPs = new DataEntityPropertyCollection(new ArrayList(localePs.size() - 2), localePs.getParent(), true);
                for (IDataEntityProperty p : localePs) {
                    String name2 = p.getName().toLowerCase();
                    if (name2.equals("pkid") || name2.equals("localeid")) continue;
                    selectPs.add((Object)p);
                }
                this.collectAutoSelectFields(addedObjPrefix, aliasPrefix, selectPs, newFields);
                continue;
            }
            if (dp instanceof IComplexProperty || ORMUtil.isDbIgnore(dp) || (name = dp.getName().toLowerCase()).endsWith("_id") && ps.containsKey((Object)name.substring(0, name.length() - 3))) continue;
            String added = addedObjPrefix + dp.getName();
            if (aliasPrefix != null && aliasPrefix.length() > 0) {
                added = added + " " + aliasPrefix + dp.getName();
            }
            if (newFields.indexOf(added) != -1) continue;
            newFields.add(added);
        }
    }

    private PropertyField addQueryPrimaryKey(String objName, String withoutRootObjName, String propertyName, boolean asInnerPK, List<PropertyField> ps, QContext ctx) {
        String alias;
        if (asInnerPK) {
            String suffix = withoutRootObjName.length() == 0 ? propertyName : withoutRootObjName.replace('.', '_');
            alias = "INNER_" + suffix;
        } else {
            alias = null;
        }
        PropertyField sf = new PropertyField(objName, propertyName, alias);
        boolean exist = false;
        for (PropertyField p : ps) {
            if (!p.isSameWith(sf)) continue;
            exist = true;
        }
        if (!exist) {
            sf = ctx.addSelectField(sf);
            return asInnerPK ? null : sf;
        }
        return null;
    }

    private PropertyField addFid(String objName, String withoutRootObjName, String propertyName, boolean asInnerPK, List<PropertyField> ps, QContext ctx) {
        String alias;
        if (asInnerPK) {
            String suffix = withoutRootObjName.length() == 0 ? propertyName : withoutRootObjName.replace('.', '_');
            alias = "INNER_" + suffix;
        } else {
            alias = null;
        }
        PropertyField sf = new PropertyField(objName, propertyName, alias);
        boolean exist = false;
        for (PropertyField p : ps) {
            if (!p.isSameWith(sf)) continue;
            exist = true;
        }
        if (!exist) {
            sf = ctx.addSelectField(sf);
            return asInnerPK ? null : sf;
        }
        return null;
    }

    private EntityTypeItem getEntityType(String objName, boolean onlyAtCache) {
        EntityTypeItem typeItem;
        if (objName.length() == 0) {
            objName = this.mp.entityType.getName();
        }
        if ((typeItem = this.entityTypeMap.get(objName = objName.toLowerCase())) == null) {
            String subObj;
            String parentObjName;
            int pos = objName.lastIndexOf(46);
            if (pos != -1) {
                parentObjName = objName.substring(0, pos);
                subObj = objName.substring(pos + 1);
            } else {
                parentObjName = this.mp.entityType.getName().toLowerCase();
                subObj = objName;
            }
            IDataEntityType parentType = this.getEntityType(parentObjName, onlyAtCache).type;
            IDataEntityProperty fk = this.getProperty(parentType, subObj);
            if (fk instanceof ICollectionProperty) {
                IDataEntityType type = ((ICollectionProperty)fk).getItemType();
                typeItem = new EntityTypeItem(type, subObj);
                this.entityTypeMap.put(objName, typeItem);
            } else if (fk instanceof IComplexProperty) {
                IDataEntityType type = onlyAtCache || "kd.bos.entity.property.FlexProp".equalsIgnoreCase(fk.getClass().getName()) ? ORMConfiguration.innerGetBaseDataEntityType((IComplexProperty)fk, this.mp.entityTypeCache) : ORMConfiguration.innerGetDataEntityType(objName, this.mp.entityTypeCache);
                typeItem = new EntityTypeItem(type, subObj);
                this.entityTypeMap.put(objName, typeItem);
            } else {
                try {
                    IDataEntityType type = ORMConfiguration.innerGetDataEntityType(subObj, this.mp.entityTypeCache);
                    typeItem = new EntityTypeItem(type, subObj);
                    this.entityTypeMap.put(objName, typeItem);
                }
                catch (EntityNotExistsException e) {
                    throw new RuntimeException(BosRes.get((String)"bos-ormengine", (String)"MultiQueryBuilder_0", (String)"Entity %1$s's property %2$s is not exists;Or the property's db field is not configured.", (Object[])new Object[]{parentType.getName(), subObj}), e);
                }
            }
        }
        return typeItem;
    }

    private IDataEntityProperty getProperty(IDataEntityType type, String property) {
        IDataEntityProperty ret = (IDataEntityProperty)type.getProperties().get((Object)property);
        if (ret == null) {
            property = property.toLowerCase(Locale.ENGLISH);
            DataEntityPropertyCollection cc = type.getProperties();
            int n = cc.size();
            for (int i = 0; i < n; ++i) {
                IDataEntityProperty p = (IDataEntityProperty)cc.get(i);
                String name = p.getName().toLowerCase(Locale.ENGLISH);
                if (!property.equals(name)) continue;
                return p;
            }
        }
        return ret;
    }

    public String toString() {
        return this.mp.entityType + ", " + this.mp.selectFields + ", " + Arrays.toString(this.mp.whereFilters);
    }

    private List<DBConfig> getParentSharings(SingleQuery parentQuery, SingleQuery subQuery) {
        ArrayList<DBConfig> parentSharing = new ArrayList<DBConfig>();
        RequestContext rc = RequestContext.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        Set<String> parentTables = parentQuery.getTables(true, true, true, true);
        Set<String> subTables = subQuery.getTables(true, true, true, true);
        Set parentDBConfigSet = DataSourceFactory.getDBConfigs((String)tenantId, (String)parentQuery.getDBRoute().getRouteKey(), (String)accountId, (String[])parentTables.toArray(new String[parentTables.size()]));
        Set subDBConfigSet = DataSourceFactory.getDBConfigs((String)tenantId, (String)subQuery.getDBRoute().getRouteKey(), (String)accountId, (String[])subTables.toArray(new String[subTables.size()]));
        block0: for (DBConfig parentConf : parentDBConfigSet) {
            for (DBConfig conf : subDBConfigSet) {
                if (!parentConf.canSharing(conf)) continue;
                parentSharing.add(parentConf);
                continue block0;
            }
        }
        return parentSharing;
    }

    private void generateINNER(QContext allCtx, String rootObjectName, Map<String, List<PropertyField>> selectObjMap, Map<String, QFilter> allWhereFilterMap) {
        HashMap<String, List<PropertyField>> newSelectObjMap = new HashMap<String, List<PropertyField>>();
        newSelectObjMap.putAll(selectObjMap);
        newSelectObjMap.keySet().stream().forEach(objName -> {
            QFilter filter = (QFilter)allWhereFilterMap.get(objName);
            if (filter != null && ("not exists".equalsIgnoreCase(filter.getCP()) || "exists".equalsIgnoreCase(filter.getCP()))) {
                IDataEntityProperty propertyType;
                EntityItemProperty propertyItem;
                EntityItem entityItem;
                ArrayList<PropertyField> propertyFields = (ArrayList<PropertyField>)selectObjMap.get(objName);
                if (CollectionUtils.isEmpty(propertyFields)) {
                    propertyFields = new ArrayList<PropertyField>();
                }
                int index = filter.getProperty().lastIndexOf(".");
                String fieldProperty = filter.getProperty();
                if (index != -1) {
                    objName = rootObjectName + "." + filter.getProperty().substring(0, index);
                    entityItem = allCtx.getEntityItem((String)objName);
                    fieldProperty = filter.getProperty().substring(index + 1);
                    propertyItem = entityItem.getPropertyItem(fieldProperty);
                    propertyType = propertyItem.getPropertyType();
                } else {
                    entityItem = allCtx.getEntityItem((String)objName);
                    propertyItem = entityItem.getPropertyItem(fieldProperty);
                    propertyType = propertyItem.getPropertyType();
                }
                if (!"kd.bos.entity.property.EntryProp".equals(propertyType.getClass().getName()) && !"kd.bos.entity.property.MulBasedataProp".equals(propertyType.getClass().getName())) {
                    PropertyField field = new PropertyField((String)objName, fieldProperty, "INNER_" + filter.getProperty());
                    field.setEntityAlias(entityItem.getFullObjectName());
                    field.setEntityType(entityItem.entityType);
                    field.setPropertyItem(propertyItem);
                    field.setPeropertyType(propertyItem.getPropertyType());
                    propertyFields.add(field);
                    selectObjMap.put((String)objName, (List<PropertyField>)propertyFields);
                }
            }
        });
    }

    private void generateSubMultiQuery(SingleQuery parentQuery, QContext allCtx) {
        SingleQuery.QueryParameter queryParameter = parentQuery.getQueryParameter();
        QFilter filter = queryParameter.genQueryParameterWhereQFilter;
        if (queryParameter.genQueryParameterWhereQFilter != null) {
            QFilter existsFilter;
            String fkProperty;
            QFilter subFilter;
            String cp = filter.getCP();
            Object value = filter.getValue();
            if (("exists".equals(cp) || "not exists".equals(cp)) && value instanceof QFilterValue) {
                subFilter = ((QFilterValue)value).getValue();
                fkProperty = filter.getProperty();
                existsFilter = filter;
                this.addSubQueryNode(allCtx, fkProperty, subFilter, parentQuery, existsFilter);
            }
            List<QFilter.QFilterNest> nests = filter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                cp = nest.getFilter().getCP();
                value = nest.getFilter().getValue();
                if (!cp.equalsIgnoreCase("not exists") && !cp.equalsIgnoreCase("exists") || !(value instanceof QFilterValue)) continue;
                fkProperty = nest.getFilter().getProperty();
                existsFilter = nest.getFilter();
                subFilter = ((QFilterValue)value).getValue();
                this.addSubQueryNode(allCtx, fkProperty, subFilter, parentQuery, existsFilter);
            }
        }
    }

    private void addSubQueryNode(QContext allCtx, String fkProperty, QFilter subFilter, SingleQuery parentQuery, QFilter existsFilter) {
        String rootFullObjectName = allCtx.getMainEntityItem().getFullObjectName();
        String value = allCtx.getSimpleEntityAliasMap().get(rootFullObjectName) + ".";
        IDataEntityProperty propertyType = null;
        int dotIndex = fkProperty.lastIndexOf(".");
        if (dotIndex != -1) {
            String fkFullObjectName = rootFullObjectName + "." + fkProperty.substring(0, dotIndex);
            propertyType = allCtx.getEntityItem(fkFullObjectName).getPropertyItem(fkProperty.substring(dotIndex + 1)).getPropertyType();
            PropertyField field = existsFilter.__getParsedProperty(allCtx);
            if (propertyType != null && ORMConfiguration.isMultiLangPropertyType(propertyType) && (!ORMConfiguration.useSingleLang() || field != null && !field.isGLField())) {
                fkFullObjectName = fkFullObjectName + "_l";
            } else if (propertyType != null && StringUtils.isNotEmpty((String)propertyType.getTableGroup())) {
                fkFullObjectName = fkFullObjectName + "_" + propertyType.getTableGroup().toLowerCase();
            }
            value = allCtx.getSimpleEntityAliasMap().get(fkFullObjectName) + ".";
        } else {
            PropertyField field = existsFilter.__getParsedProperty(allCtx);
            propertyType = allCtx.getEntityItem(rootFullObjectName).getPropertyItem(fkProperty).getPropertyType();
            if (propertyType != null && ORMConfiguration.isMultiLangPropertyType(propertyType) && (!ORMConfiguration.useSingleLang() || field != null && !field.isGLField())) {
                value = allCtx.getSimpleEntityAliasMap().get(rootFullObjectName + "_l") + ".";
            } else if (propertyType != null && StringUtils.isNotEmpty((String)propertyType.getTableGroup())) {
                value = allCtx.getSimpleEntityAliasMap().get(rootFullObjectName + "_" + propertyType.getTableGroup().toLowerCase()) + ".";
            }
        }
        if (propertyType == null) {
            return;
        }
        value = propertyType.getClass() != null && "kd.bos.entity.property.MulBasedataProp".equals(propertyType.getClass().getName()) ? (propertyType.getParent() != null && ORMConfiguration.isSubEntityType(propertyType.getParent()) ? value + "fdetailid" : (propertyType.getParent() != null && ORMConfiguration.isEntryEntityType(propertyType.getParent()) ? value + "fentryid" : value + "fid")) : value + propertyType.getAlias();
        HashMap<String, IDataEntityType> entityTypeCache = new HashMap<String, IDataEntityType>();
        IDataEntityType dt = this.getIDataEntityType(propertyType, allCtx, entityTypeCache);
        if (dt == null) {
            throw new IllegalArgumentException("the fkproperty's entity is not exists!");
        }
        DBRoute dbRoute = new DBRoute(dt.getDBRouteKey());
        String selectFields = "id";
        String property = "id";
        if (propertyType instanceof DynamicSimpleProperty) {
            if ("kd.bos.entity.property.MuliLangTextProp".equals(propertyType.getClass().getName())) {
                value = allCtx.getSimpleEntityAliasMap().get(rootFullObjectName + "_l") + "." + propertyType.getAlias();
                property = fkProperty;
            }
        } else if ("kd.bos.entity.EntryType".equals(dt.getClass().getName()) || "kd.bos.entity.SubEntryType".equals(dt.getClass().getName())) {
            List<QFilter.QFilterNest> nests;
            selectFields = dt.getName() + ".id";
            String fullObjectName = dt.getName();
            dt = dt.getParent();
            while (dt != null) {
                selectFields = dt.getName() + "." + selectFields;
                fullObjectName = dt.getName() + "." + fullObjectName;
                IDataEntityType currentParent = dt.getParent();
                if (currentParent == null) break;
                dt = currentParent;
            }
            if (!"1".equals(subFilter.getProperty()) && !subFilter.getProperty().startsWith(fullObjectName + ".")) {
                String filterProperty = fullObjectName + "." + subFilter.getProperty();
                subFilter.__setProperty(filterProperty);
            }
            if (!CollectionUtils.isEmpty(nests = subFilter.getNests(true))) {
                for (QFilter.QFilterNest nest : nests) {
                    SingleQuery[] nestFilter = nest.getFilter();
                    String nestPropety = nestFilter.getProperty();
                    if (!nestPropety.startsWith(fullObjectName + ".")) {
                        nestPropety = fullObjectName + "." + nestPropety;
                    }
                    nestFilter.__setProperty(nestPropety);
                }
            }
            value = allCtx.getSimpleEntityAliasMap().get(rootFullObjectName) + "." + dt.getPrimaryKey().getAlias();
        }
        QFilter and = new QFilter(property, "=", value);
        and.setExistsFilter(true);
        and.and(subFilter);
        MultiQuery multiQuery = MultiQuery.create(dbRoute, dt, selectFields, false, and.toArray(), null, null, null, -1, this.mp.start, this.mp.limit, this.mp.entityTypeCache, this.mp.ormHint, this.mp.optimization, null);
        SingleQuery[] queries = multiQuery.getQueries();
        boolean sameDB = this.isSameDB(multiQuery, parentQuery);
        if (!sameDB) {
            multiQuery = MultiQuery.create(dbRoute, dt, "id", false, subFilter.toArray(), null, null, null, -1, this.mp.start, this.mp.limit, this.mp.entityTypeCache, this.mp.ormHint, this.mp.optimization, null);
            for (SingleQuery query : queries = multiQuery.getQueries()) {
                query.setExistsSubquery(true);
                query.setExistsQFilter(existsFilter);
            }
        }
        QueryTreeNode root = QueryTreeNode.create(queries);
        this.joinInSameDatabase(root);
        if (!sameDB) {
            if (root != null) {
                parentQuery.addSubQueryNode(root);
            }
        } else {
            QueryUtils.replayceTalbAilas(parentQuery.getCtx().getSimpleEntityAliasMap(), root.getQuery());
            QFilter filter = parentQuery.getAllWhereFilterMap().get(parentQuery.getFullObjName());
            if (filter == null) {
                return;
            }
            QFilter exsitFilterValue = ((QFilterValue)existsFilter.getValue()).getValue();
            Object filterValue = filter.getValue();
            String cp = filter.getCP().toLowerCase(Locale.ENGLISH);
            if (filter != null && ("exists".equals(cp) || "not exists".equals(cp)) && filter.getProperty().equals(existsFilter.getProperty()) && ((QFilterValue)filterValue).getValue().getProperty().equals(exsitFilterValue.getProperty()) && ((QFilterValue)filterValue).getValue().getCP().equals(exsitFilterValue.getCP()) && ((QFilterValue)filterValue).getValue().getValue().equals(exsitFilterValue.getValue())) {
                filter.setSubQueryNode(root);
                filter.setParseExistsValue(true);
            }
            List<QFilter.QFilterNest> nests = filter.getNests(true);
            for (QFilter.QFilterNest nest : nests) {
                QFilter nestFilter = nest.getFilter();
                cp = nestFilter.getCP();
                filterValue = nestFilter.getValue();
                if (nestFilter == null || !"exists".equals(cp) && !"not exists".equals(cp) || !nestFilter.getProperty().equals(existsFilter.getProperty()) || !((QFilterValue)filterValue).getValue().getProperty().equals(exsitFilterValue.getProperty()) || !((QFilterValue)filterValue).getValue().getCP().equals(exsitFilterValue.getCP()) || !((QFilterValue)filterValue).getValue().getValue().equals(exsitFilterValue.getValue())) continue;
                nestFilter.setSubQueryNode(root);
                nestFilter.setParseExistsValue(true);
            }
            existsFilter.setSubQueryNode(root);
            existsFilter.setParseExistsValue(true);
        }
    }

    private IDataEntityType getIDataEntityType(IDataEntityProperty next, QContext allCtx, Map<String, IDataEntityType> entityTypeCache) {
        if (next instanceof DynamicComplexProperty) {
            DynamicComplexProperty complexProperty = (DynamicComplexProperty)next;
            String entityName = complexProperty.getDynamicComplexPropertyType().getName();
            return ORMConfiguration.innerGetDataEntityType(entityName, entityTypeCache);
        }
        if (next instanceof DynamicCollectionProperty) {
            DynamicCollectionProperty collectionProperty = (DynamicCollectionProperty)next;
            String objName = collectionProperty.getName();
            for (IDataEntityType parentType = collectionProperty.getParent(); parentType != null; parentType = parentType.getParent()) {
                objName = parentType.getName() + "." + objName;
            }
            return allCtx.getEntityItem((String)objName).entityType;
        }
        return next.getParent();
    }

    private void joinInSameDatabase(QueryTreeNode root) {
        if (!this.mp.optimization.isJoinInSameDatabase() || root.isLeaf()) {
            return;
        }
        List<QueryTreeNode> children = root.getChildren();
        int n = children.size();
        for (int i = 0; i < n; ++i) {
            QueryTreeNode child = children.get(i);
            this.joinInSameDatabase(child);
            SingleQuery parentQuery = root.getQuery();
            SingleQuery query = child.getQuery();
            JoinDBTodo.test();
            List<DBConfig> parentSharing = this.getParentSharings(parentQuery, query);
            if (parentSharing.isEmpty()) {
                String crossDBTable;
                String crossToRouteKey = parentQuery.getDBRoute().getRouteKey();
                String table = query.getDataEntityType().getAlias().toLowerCase();
                if (!table.equals(crossDBTable = TenantAccountCrossDBRuntime.getCrossDBTable(query.getDataEntityType().getDBRouteKey(), table, crossToRouteKey, query.withCrossDBObjectOrFilter() || parentQuery.withCrossDBObjectOrFilter()))) {
                    parentSharing.addAll(parentQuery.getDBConfigSet());
                }
            }
            if (parentSharing.isEmpty()) continue;
            child.removeFromParent();
            root.setQuery(parentQuery.optMerge(query));
            parentQuery.setDBConfigSet(new HashSet<DBConfig>(parentSharing));
            --i;
            --n;
            List<QueryTreeNode> addChildren = child.getChildren();
            if (addChildren.size() <= 0) continue;
            for (QueryTreeNode subNode : addChildren) {
                subNode.addToParent(root);
            }
            n += addChildren.size();
        }
    }

    private boolean isSameDB(MultiQuery multiQuery, SingleQuery parentQuery) {
        SingleQuery[] queries = multiQuery.getQueries();
        boolean sameDB = true;
        for (SingleQuery query : queries) {
            query.setExistsSubquery(true);
            List<DBConfig> parentSharings = this.getParentSharings(query, parentQuery);
            if (!parentSharings.isEmpty()) continue;
            sameDB = false;
        }
        return sameDB;
    }

    private void handlCrossDBOR(QContext allCtx, String rootObjectName) {
        if (this.mp.whereFilters != null && this.mp.whereFilters.length > 0) {
            for (QFilter filter : this.mp.whereFilters) {
                CrossDBORQuery.tranferFilterForCrossDBOR(allCtx, rootObjectName, filter);
            }
        }
    }

    private String preHandle(String selectFields, List<QFilter> filters) {
        if (StringUtils.isEmpty((String)selectFields)) {
            return selectFields;
        }
        if (CollectionUtils.isEmpty(filters)) {
            return selectFields;
        }
        String joinProperty = null;
        String baseDataName = null;
        boolean multiDataQuery = false;
        for (QFilter filter : filters) {
            Object value;
            if (filter == null || !((value = filter.getValue()) instanceof MultiBaseDataFilterValue)) continue;
            MultiBaseDataFilterValue multi = (MultiBaseDataFilterValue)value;
            joinProperty = multi.getJoinProperty();
            baseDataName = multi.getBaseDataName();
            if (filter.getProperty().equalsIgnoreCase(joinProperty)) continue;
            multiDataQuery = true;
            break;
        }
        if (!multiDataQuery) {
            return selectFields;
        }
        String[] fields = selectFields.split(",");
        StringBuilder builder = new StringBuilder();
        boolean existsPKField = false;
        for (int i = 0; i < fields.length; ++i) {
            String fieldBak = fields[i];
            if (fields[i].startsWith(joinProperty + ".")) {
                String columnName;
                String[] columnAlias = fields[i].trim().split(" ");
                if (columnAlias.length > 1) {
                    columnName = columnAlias[0].replaceAll(joinProperty + "\\.", baseDataName + ".");
                    fields[i] = columnName + " as " + columnAlias[columnAlias.length - 1];
                } else {
                    columnName = fields[i].replaceAll(joinProperty + "\\.", baseDataName + ".");
                    fields[i] = columnName + " as " + fields[i];
                }
            }
            if (fieldBak.startsWith(joinProperty + ".id")) {
                existsPKField = true;
            }
            builder.append(fields[i]);
            if (i >= fields.length - 1) continue;
            builder.append(",");
        }
        if (!existsPKField && this.mp.shouldSelectPK) {
            builder.append(",").append(baseDataName).append(".id as ").append(joinProperty).append(".id");
        }
        return builder.toString();
    }

    private List<QFilter> getAllFilters() {
        ArrayList<QFilter> filtes = new ArrayList<QFilter>();
        this.getFilters(this.mp.whereFilters, filtes);
        this.getFilters(this.mp.joinFilters, filtes);
        this.getFilters(this.mp.havings, filtes);
        return filtes;
    }

    private void getFilters(QFilter[] filterArray, List<QFilter> filtes) {
        if (filterArray == null || filterArray.length == 0) {
            return;
        }
        for (QFilter filter : filterArray) {
            if (filter == null) continue;
            filtes.add(filter);
            List<QFilter.QFilterNest> nests = filter.getNests(true);
            if (CollectionUtils.isEmpty(nests)) continue;
            for (QFilter.QFilterNest nest : nests) {
                filtes.add(nest.getFilter());
            }
        }
    }

    private void setInnerJoin(QContext allContext, Map<String, QFilter> allWhereFilterMap, Map<String, QFilter> allJoinFilterMap) {
        if (!ORMUtil.useInnerJoin(allContext.getORMHint())) {
            return;
        }
        HashMap<String, EntityItem> innerJoinEntity = new HashMap<String, EntityItem>();
        String rootName = allContext.getMainEntityItem().getFullObjectName();
        boolean allAndFilter = this.tranferLeftJoinToInnerJoin(allWhereFilterMap, rootName, allContext, innerJoinEntity);
        this.appendConditionAfterInnerJoin(allJoinFilterMap, allWhereFilterMap, allAndFilter, allContext, rootName, innerJoinEntity);
    }

    private boolean tranferLeftJoinToInnerJoin(Map<String, QFilter> allWhereFilterMap, String rootName, QContext allContext, Map<String, EntityItem> innerJoinEntity) {
        boolean allAndFilter = this.allAndNoNullCondition(allWhereFilterMap);
        if (allAndFilter) {
            for (Map.Entry<String, QFilter> entry : allWhereFilterMap.entrySet()) {
                QFilter filter = entry.getValue();
                if (!this.shouldTransfer(filter)) continue;
                this.addInnerJoinEntity(filter, rootName, allContext, innerJoinEntity);
                List<QFilter.QFilterNest> nests = filter.getNests(true);
                for (QFilter.QFilterNest nest : nests) {
                    if (!this.shouldTransfer(nest.getFilter())) continue;
                    this.addInnerJoinEntity(nest.getFilter(), rootName, allContext, innerJoinEntity);
                }
            }
        }
        return allAndFilter;
    }

    private boolean allAndNoNullCondition(Map<String, QFilter> allWhereFilterMap) {
        boolean allAnd = !allWhereFilterMap.isEmpty();
        boolean nonNullCondtion = !allWhereFilterMap.isEmpty();
        for (QFilter filter : allWhereFilterMap.values()) {
            List<QFilter.QFilterNest> nests;
            if (filter == null) continue;
            if (this.isNullValue(filter)) {
                nonNullCondtion = false;
            }
            if (CollectionUtils.isEmpty(nests = filter.getNests(true))) continue;
            for (QFilter.QFilterNest nest : nests) {
                QFilter nestFilter = nest.getFilter();
                if (nestFilter == null) continue;
                if (!nest.isAnd()) {
                    allAnd = false;
                }
                if (!this.isNullValue(nestFilter)) continue;
                nonNullCondtion = false;
            }
        }
        return allAnd && nonNullCondtion;
    }

    private boolean isNullValue(QFilter filter) {
        Object value = filter.getValue();
        boolean selfNull = false;
        if (value instanceof QEmptyValue) {
            selfNull = true;
        } else if ("is null".equals(filter.getCP())) {
            selfNull = true;
        } else if ("=".equals(filter.getCP()) && value == null) {
            selfNull = true;
        }
        return selfNull;
    }

    private void appendConditionAfterInnerJoin(Map<String, QFilter> allJoinFilterMap, Map<String, QFilter> allWhereFilterMap, boolean allAndFilter, QContext allContext, String rootName, Map<String, EntityItem> innerJoinEntity) {
        if (allWhereFilterMap != null && !allWhereFilterMap.isEmpty() && allAndFilter) {
            allContext.setAllAndQFilter(true);
            for (Map.Entry<String, QFilter> entry : allWhereFilterMap.entrySet()) {
                QFilter filter = entry.getValue();
                if (!this.shouldTransfer(filter)) continue;
                this.transferJoinCondition(allContext, filter, rootName, innerJoinEntity, allJoinFilterMap);
                List<QFilter.QFilterNest> nests = filter.getNests(true);
                if (CollectionUtils.isEmpty(nests)) continue;
                for (QFilter.QFilterNest nest : nests) {
                    QFilter nestFilter = nest.getFilter();
                    if (!this.shouldTransfer(nestFilter)) continue;
                    this.transferJoinCondition(allContext, nestFilter, rootName, innerJoinEntity, allJoinFilterMap);
                }
            }
        }
    }

    private void transferJoinCondition(QContext allContext, QFilter filter, String rootName, Map<String, EntityItem> innerJoinEntity, Map<String, QFilter> allJoinFilterMap) {
        int valueSize;
        String property = filter.getProperty();
        if ("1".equals(property)) {
            return;
        }
        String cp = filter.getCP();
        if (("in".equalsIgnoreCase(cp) || "not in".equalsIgnoreCase(cp)) && (valueSize = ORMUtil.getValueSize(filter.getValue())) > ORMConfig.INNER_JOIN_IN_SIZE.getInt()) {
            return;
        }
        int dotIndex = property.lastIndexOf(".");
        String fullObjectName = dotIndex > 0 ? rootName + "." + property.substring(0, dotIndex) : rootName;
        PropertyField field = filter.__getParsedProperty(allContext);
        if (field.isExpress() || filter.isExpressValue()) {
            return;
        }
        IDataEntityProperty propertyType = this.getPropertyType(field, filter, allContext, rootName, fullObjectName);
        if (propertyType == null) {
            return;
        }
        if (!(propertyType == null || !ORMConfiguration.isMultiLangPropertyType(propertyType) || ORMConfiguration.useSingleLang() && field.isGLField())) {
            EntityItem entityItem = innerJoinEntity.get(fullObjectName = fullObjectName + "_L");
            if (entityItem != null) {
                this.addInnerJoinCondition(allJoinFilterMap, fullObjectName, filter, fullObjectName, fullObjectName + ".id", allContext);
            }
        } else {
            EntityItem entityItem;
            String tableGroup;
            String string = tableGroup = propertyType == null ? "" : propertyType.getTableGroup();
            if (tableGroup != null && tableGroup.length() > 0) {
                EntityItem entityItem2 = innerJoinEntity.get(fullObjectName = fullObjectName + "_" + tableGroup);
                if (entityItem2 != null) {
                    this.addInnerJoinCondition(allJoinFilterMap, fullObjectName, filter, rootName + ".id", fullObjectName + ".id", allContext);
                }
            } else if (dotIndex > 0) {
                if (propertyType != null && propertyType.getParent() != null && ORMConfiguration.isSubEntityType(propertyType.getParent())) {
                    fullObjectName = this.getFullObjectName(propertyType.getParent());
                    EntityItem entityItem3 = innerJoinEntity.get(fullObjectName);
                    if (entityItem3 != null) {
                        this.addInnerJoinCondition(allJoinFilterMap, fullObjectName, filter, fullObjectName, fullObjectName + ".id", allContext);
                    }
                } else {
                    int dotIndex1 = fullObjectName.lastIndexOf(".");
                    boolean sameDB = dotIndex1 > 0 && this.isSameDB(this.getDBConfigs(fullObjectName.substring(0, dotIndex1), allContext), this.getDBConfigs(fullObjectName, allContext));
                    EntityItem entityItem4 = innerJoinEntity.get(fullObjectName);
                    if (entityItem4 == null) {
                        if (dotIndex1 == -1) {
                            return;
                        }
                        String newFullObjectName = fullObjectName.substring(fullObjectName.indexOf(46) + 1);
                        entityItem4 = innerJoinEntity.get(newFullObjectName);
                        if (entityItem4 == null) {
                            return;
                        }
                        fullObjectName = newFullObjectName;
                    }
                    if (sameDB) {
                        String joinProperty = property.substring(0, dotIndex);
                        this.addInnerJoinCondition(allJoinFilterMap, fullObjectName, filter, joinProperty, joinProperty + ".id", allContext);
                    }
                }
            } else if (propertyType != null && propertyType.getParent() != null && ORMConfiguration.isEntryEntityType(propertyType.getParent()) && (entityItem = innerJoinEntity.get(fullObjectName = this.getFullObjectName(propertyType.getParent()))) != null) {
                this.addInnerJoinCondition(allJoinFilterMap, fullObjectName, filter, fullObjectName, fullObjectName + ".id", allContext);
            }
        }
    }

    private void addInnerJoinEntity(QFilter filter, String rootName, QContext allContext, Map<String, EntityItem> innerJoinEntity) {
        IDataEntityProperty propertyType;
        String fullObjectName;
        if ("1".equals(filter.getProperty())) {
            return;
        }
        PropertyField field = filter.__getParsedProperty(allContext);
        int dotIndex = filter.getProperty().lastIndexOf(".");
        String string = fullObjectName = dotIndex > 0 ? rootName + "." + filter.getProperty().substring(0, dotIndex) : rootName;
        if (field.isExpress() || filter.isExpressValue()) {
            if (field.getPropertySegExpress().getFullPropertyNames().size() > 1) {
                return;
            }
            fullObjectName = field.getFullObjectName();
            if (StringUtils.isEmpty((String)fullObjectName)) {
                return;
            }
        }
        if ((propertyType = this.getPropertyType(field, filter, allContext, rootName, fullObjectName)) == null) {
            return;
        }
        EntityItem entityItem = allContext.getEntityItem(fullObjectName);
        if (entityItem == null) {
            int dotIndex2 = fullObjectName.indexOf(46);
            if (dotIndex2 == -1) {
                return;
            }
            String newFullObjectName = fullObjectName.substring(dotIndex2 + 1);
            field.setFullObjectName(newFullObjectName);
            entityItem = allContext.getEntityItem(newFullObjectName);
            if (entityItem == null) {
                logger.warn("The bill [" + rootName + "] has no field [" + filter.getProperty() + "],please correct it!");
                return;
            }
        }
        if (!(propertyType == null || !ORMConfiguration.isMultiLangPropertyType(propertyType) || ORMConfiguration.useSingleLang() && field.isGLField())) {
            allContext.addInnerJoinEntityItem(entityItem);
            allContext.addInnerJoinEntityItem(entityItem.getFullObjectName() + "_L", entityItem);
            innerJoinEntity.put(entityItem.getFullObjectName() + "_L", entityItem);
        } else {
            String tableGroup;
            String string2 = tableGroup = propertyType == null ? "" : propertyType.getTableGroup();
            if (tableGroup != null && tableGroup.length() > 0) {
                allContext.addInnerJoinEntityItem(entityItem);
                allContext.addInnerJoinEntityItem(entityItem.getFullObjectName() + "_" + tableGroup, entityItem);
                innerJoinEntity.put(entityItem.getFullObjectName() + "_" + tableGroup, entityItem);
            } else if (dotIndex > 0) {
                if (propertyType != null && propertyType.getParent() != null && ORMConfiguration.isSubEntityType(propertyType.getParent())) {
                    fullObjectName = this.getFullObjectName(propertyType.getParent());
                    EntityItem newEnntityItem = innerJoinEntity.get(fullObjectName);
                    if (newEnntityItem == null) {
                        newEnntityItem = allContext.getEntityItem(fullObjectName);
                    }
                    allContext.addInnerJoinEntityItem(newEnntityItem);
                    allContext.addInnerJoinEntityItem(newEnntityItem.getFullObjectName(), newEnntityItem);
                    innerJoinEntity.put(newEnntityItem.getFullObjectName(), newEnntityItem);
                } else {
                    int dotIndex1 = fullObjectName.lastIndexOf(".");
                    if (dotIndex1 > 0 && this.isSameDB(this.getDBConfigs(fullObjectName.substring(0, dotIndex1), allContext), this.getDBConfigs(fullObjectName, allContext))) {
                        allContext.addInnerJoinEntityItem(entityItem);
                        allContext.addInnerJoinEntityItem(entityItem.getFullObjectName(), entityItem);
                        innerJoinEntity.put(entityItem.getFullObjectName(), entityItem);
                    }
                }
            } else if (propertyType != null && propertyType.getParent() != null && ORMConfiguration.isEntryEntityType(propertyType.getParent())) {
                fullObjectName = this.getFullObjectName(propertyType.getParent());
                EntityItem newEntity = innerJoinEntity.get(fullObjectName);
                if (newEntity == null) {
                    newEntity = allContext.getEntityItem(fullObjectName);
                }
                allContext.addInnerJoinEntityItem(newEntity);
                allContext.addInnerJoinEntityItem(newEntity.getFullObjectName(), newEntity);
                innerJoinEntity.put(newEntity.getFullObjectName(), newEntity);
            }
        }
    }

    private Set<DBConfig> getDBConfigs(String fullObjectName, QContext ctx) {
        RequestContext rc = RequestContext.get();
        String tenantId = rc.getTenantId();
        String accountId = rc.getAccountId();
        EntityItem entityItem = ctx.getEntityItem(fullObjectName);
        if (entityItem == null || entityItem.entityType == null) {
            return new HashSet<DBConfig>();
        }
        IDataEntityType dt = entityItem.entityType;
        String talbe = dt.getAlias();
        DBRoute dbRoute = new DBRoute(dt.getDBRouteKey());
        return DataSourceFactory.getDBConfigs((String)tenantId, (String)dbRoute.getRouteKey(), (String)accountId, (String[])new String[]{talbe});
    }

    private boolean isSameDB(Set<DBConfig> dbConfigs, Set<DBConfig> propertyConfigs) {
        for (DBConfig config : dbConfigs) {
            for (DBConfig innerConfig : propertyConfigs) {
                if (config.canSharing(innerConfig)) continue;
                return false;
            }
        }
        return true;
    }

    private IDataEntityProperty getPropertyType(PropertyField field, QFilter filter, QContext allContext, String rootName, String fullObjectName) {
        IDataEntityProperty propertyType = null;
        if (field != null && field.getPeropertyType() != null) {
            propertyType = field.getPeropertyType();
        } else {
            field = SelectFields.parseFrom(filter.getProperty()).createPropertyFields(rootName).get(0);
            propertyType = field.getPeropertyType();
            if (propertyType == null) {
                EntityItem entityItem = allContext.getEntityItem(fullObjectName);
                if (entityItem == null) {
                    logger.warn("The bill [" + rootName + "] has no field [" + filter.getProperty() + "],please correct it!");
                    return null;
                }
                String propertyName = "";
                if (field.isExpress() || filter.isExpressValue()) {
                    List<String> fullPropertyNames = field.getPropertySegExpress().getFullPropertyNames();
                    if (CollectionUtils.isEmpty(fullPropertyNames)) {
                        return propertyType;
                    }
                    propertyName = fullPropertyNames.get(0);
                } else {
                    propertyName = filter.getProperty();
                }
                int index = propertyName.lastIndexOf(".");
                propertyType = index == -1 ? entityItem.getPropertyItem(propertyName).getPropertyType() : entityItem.getPropertyItem(propertyName.substring(index + 1)).getPropertyType();
            }
        }
        return propertyType;
    }

    private void addInnerJoinCondition(Map<String, QFilter> allJoinFilterMap, String fullObjectName, QFilter filter, String property, String joinProperty, QContext allCtx) {
        int valueSize;
        String lowerCaseFullObjectName = fullObjectName.toLowerCase();
        QFilter joinFilter = allJoinFilterMap.get(lowerCaseFullObjectName);
        QFilter newFilter = filter.__copy(false);
        if (("not in".equals(newFilter.getCP()) || "in".equals(newFilter.getCP())) && (valueSize = QFilterUtil.getValueSize(newFilter.getValue())) >= ORMUtil.toTempTableSize(allCtx.getORMHint())) {
            return;
        }
        if (joinFilter != null) {
            joinFilter.and(newFilter);
        } else {
            joinFilter = QFilter.join(property, joinProperty, newFilter);
        }
        allJoinFilterMap.put(lowerCaseFullObjectName, joinFilter);
        filter.maskCurrent();
    }

    private void replaceAlias(PropertyField propertyField, String rootObjName, String objName, Map<String, QFilter> allWhereFilterMap) {
        List<String> realFullObjectName;
        if (propertyField != null && !objName.startsWith(rootObjName) && !CollectionUtils.isEmpty(realFullObjectName = this.getRealFullObjectName(objName, allWhereFilterMap))) {
            String alias = propertyField.getAlias();
            if (realFullObjectName.size() > 1 && StringUtils.isNotEmpty((String)realFullObjectName.get(0)) && StringUtils.isNotEmpty((String)realFullObjectName.get(1))) {
                alias = alias.replace(realFullObjectName.get(0), realFullObjectName.get(1));
                propertyField.setAlias(alias);
            }
        }
    }

    private List<String> getRealFullObjectName(String objName, Map<String, QFilter> allWhereFilterMap) {
        if (allWhereFilterMap != null && !allWhereFilterMap.isEmpty()) {
            for (QFilter next : allWhereFilterMap.values()) {
                List<String> baseDataList = this.getBaseDataName(next, objName);
                if (!CollectionUtils.isEmpty(baseDataList)) {
                    return baseDataList;
                }
                List<QFilter.QFilterNest> nests = next.getNests(true);
                if (CollectionUtils.isEmpty(nests)) continue;
                for (QFilter.QFilterNest nest : nests) {
                    List<String> nestBaseDataList = this.getBaseDataName(nest.getFilter(), objName);
                    if (CollectionUtils.isEmpty(nestBaseDataList)) continue;
                    return nestBaseDataList;
                }
            }
        }
        return null;
    }

    private List<String> getBaseDataName(QFilter filter, String objName) {
        MultiBaseDataFilterValue filterValue;
        String baseDataName;
        if (filter == null) {
            return null;
        }
        Object nestValue = filter.getValue();
        if (nestValue instanceof MultiBaseDataFilterValue && objName.startsWith(baseDataName = (filterValue = (MultiBaseDataFilterValue)nestValue).getBaseDataName())) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(filterValue.getBaseDataName());
            list.add(filterValue.getJoinProperty());
            return list;
        }
        return null;
    }

    private boolean shouldTransfer(QFilter filter) {
        boolean condition = filter != null && !(filter.getValue() instanceof MultiBaseDataFilterValue) && !(filter.getValue() instanceof QFilterValue) && !filter.isExistsFilter();
        boolean condition2 = filter != null && !filter.getCP().equalsIgnoreCase("!=") && !filter.getCP().equalsIgnoreCase("<>") && !filter.getCP().equalsIgnoreCase("not in") && !filter.getCP().equalsIgnoreCase("not like");
        return condition && condition2;
    }

    private void addPkToPrivacy(List<PropertyField> pfs, String rootObjName) {
        try {
            if (!PrivacyDataCenterManager.isEnable()) {
                return;
            }
            HashMap<String, Boolean> isExistIdFieldMap = new HashMap<String, Boolean>(2);
            HashMap<String, String> allFields = new HashMap<String, String>();
            ArrayList<DBPrivacyDataModel> params = new ArrayList<DBPrivacyDataModel>();
            for (PropertyField propertyField : new ArrayList<PropertyField>(pfs)) {
                String fullObjectName = propertyField.getFullObjectName();
                if (!Boolean.TRUE.equals(isExistIdFieldMap.get(fullObjectName))) {
                    String name = propertyField.getName();
                    isExistIdFieldMap.put(fullObjectName, "id".equalsIgnoreCase(name));
                }
                String tableName = this.getTableName(propertyField);
                String fieldName = this.getFieldName(propertyField);
                if (!StringUtils.isNotEmpty((String)fieldName) || !StringUtils.isNotEmpty((String)tableName)) continue;
                DBPrivacyDataModel model = new DBPrivacyDataModel();
                model.setTableName(tableName);
                model.setFiledName(fieldName);
                params.add(model);
                allFields.put(tableName + "#" + fieldName, fullObjectName);
            }
            List encryptFields = PrivacyDataCenterManager.getQueryService().isEncryptField(params, 0);
            if (CollectionUtils.isEmpty(encryptFields)) {
                return;
            }
            if (ORMUtil.isHasAggregate(pfs)) {
                throw new IllegalArgumentException("the privacy center doesn't support aggregate function ");
            }
            for (DBPrivacyDataModel model : encryptFields) {
                String fullObjectName = (String)allFields.get(model.getTableName() + "#" + model.getFiledName());
                if (Boolean.TRUE.equals(isExistIdFieldMap.get(fullObjectName))) continue;
                PropertyField pf = new PropertyField(fullObjectName + ".id");
                pfs.add(pf);
                isExistIdFieldMap.put(fullObjectName, true);
            }
            if (!Boolean.TRUE.equals(isExistIdFieldMap.get(rootObjName))) {
                PropertyField propertyField = new PropertyField(rootObjName + ".id");
                pfs.add(propertyField);
                isExistIdFieldMap.put(rootObjName, true);
            }
        }
        catch (Exception e) {
            logger.error("addPkToPrivacy error", (Throwable)e);
        }
    }

    private String getTableName(PropertyField property) {
        String tableGroup;
        String fullObjectName = property.getFullObjectName();
        EntityTypeItem eti = this.getEntityType(fullObjectName, false);
        IDataEntityType entityType = eti.type;
        String tableName = entityType.getAlias();
        IDataEntityProperty propertyType = this.getProperty(entityType, property.getName());
        if (propertyType != null && (tableGroup = propertyType.getTableGroup()) != null && tableGroup.length() > 0) {
            tableName = tableName + "_" + tableGroup;
        }
        return tableName;
    }

    private String getFieldName(PropertyField propertyField) {
        String fullObjectName = propertyField.getFullObjectName();
        EntityTypeItem eti = this.getEntityType(fullObjectName, false);
        IDataEntityType entityType = eti.type;
        IDataEntityProperty propertyType = this.getProperty(entityType, propertyField.getName());
        if (propertyType != null) {
            return propertyType.getAlias();
        }
        return null;
    }

    private List<PropertyField> addMultiSelectPkid(Map<String, List<PropertyField>> selectObjMap, QContext allctx) {
        ArrayList<PropertyField> fields = new ArrayList<PropertyField>();
        for (Map.Entry<String, List<PropertyField>> entry : new ArrayList<Map.Entry<String, List<PropertyField>>>(selectObjMap.entrySet())) {
            List<PropertyField> plist = entry.getValue();
            for (PropertyField field : plist) {
                String alias = field.getAlias();
                if (alias != null) {
                    alias = alias.toLowerCase(Locale.ENGLISH);
                }
                if (field.getEntityType() == null || !ORMConfiguration.isMulBasedata(field.getEntityType()) || alias == null || !alias.endsWith(".pkid") && !alias.endsWith(".fpkid") || this.containsField(allctx.getUserSelectFields(), field)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    private boolean containsField(PropertyField[] userSelectFields, PropertyField propertyField) {
        for (PropertyField field : userSelectFields) {
            if (!field.isSameWith(propertyField)) continue;
            return true;
        }
        return false;
    }

    private String getFullObjectName(IDataEntityType type) {
        String fullObjectName = "";
        do {
            String name = type.getName();
            fullObjectName = fullObjectName == null || fullObjectName.length() == 0 ? name : name + "." + fullObjectName;
        } while ((type = type.getParent()) != null);
        return fullObjectName;
    }

    private boolean isMultiTypePropertyAndAliasSame(PropertyField field1, PropertyField field2, String rootName, QContext allCtx) {
        if (!ORMConfig.QUICKSEARCH_MULTYPE.getBoolean(RequestContext.get().getTenantId())) {
            return false;
        }
        try {
            String fullObjectName2;
            int index2;
            EntityItemProperty propertyItem;
            String fullObjectName1 = field1.getFullObjectName();
            int index1 = fullObjectName1.lastIndexOf(".");
            if (index1 == -1) {
                propertyItem = allCtx.getEntityItem(rootName).getPropertyItem(field1.getName());
                if (propertyItem == null) {
                    return false;
                }
                if (propertyItem.getPropertyType().getClass().getName().equals("kd.bos.entity.property.ItemClassProp") && field1.getAlias().equals(field2.getAlias())) {
                    return true;
                }
            } else {
                propertyItem = allCtx.getEntityItem(fullObjectName1.substring(0, index1)).getPropertyItem(fullObjectName1.substring(index1 + 1));
                if (propertyItem == null) {
                    return false;
                }
                if (propertyItem.getPropertyType().getClass().getName().equals("kd.bos.entity.property.ItemClassProp") && field1.getAlias().equals(field2.getAlias())) {
                    return true;
                }
            }
            if ((index2 = (fullObjectName2 = field2.getFullObjectName()).lastIndexOf(".")) == -1) {
                EntityItemProperty propertyItem2 = allCtx.getEntityItem(rootName).getPropertyItem(field2.getName());
                if (propertyItem2 == null) {
                    return false;
                }
                if (propertyItem2.getPropertyType().getClass().getName().equals("kd.bos.entity.property.ItemClassProp") && field1.getAlias().equals(field2.getAlias())) {
                    return true;
                }
            } else {
                EntityItemProperty propertyItem3 = allCtx.getEntityItem(fullObjectName2.substring(0, index2)).getPropertyItem(fullObjectName2.substring(index2 + 1));
                if (propertyItem3 == null) {
                    return false;
                }
                if (propertyItem3.getPropertyType().getClass().getName().equals("kd.bos.entity.property.ItemClassProp") && field1.getAlias().equals(field2.getAlias())) {
                    return true;
                }
            }
        }
        catch (Throwable e) {
            logger.error("parase multitype error", e);
        }
        return false;
    }

    private static class QueryFieldInfo {
        PropertyField[] innerSelectFields;
        PropertyField[] userSelectFields;
        PropertyField[] returnSelectFields;

        private QueryFieldInfo() {
        }
    }

    private static class EntityTypeItem {
        private String parentFK;
        private IDataEntityType type;

        private EntityTypeItem(IDataEntityType type, String parentFK) {
            this.parentFK = parentFK;
            this.type = type;
        }
    }
}

