/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;
import kd.bos.bundle.BosRes;
import kd.bos.dataentity.exception.ORMArgInvalidException;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.db.QueryMeta;
import kd.bos.exception.BosErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.multi.FieldEncrypt;

public class QFilterDecryptTransFunction
implements Function<QFilter, QFilter> {
    private String rootObjName;
    private QContext ctx;
    private Log logger = LogFactory.getLog(QFilterDecryptTransFunction.class);

    public QFilterDecryptTransFunction(String rootObjName, QContext ctx) {
        this.ctx = ctx;
        this.rootObjName = rootObjName;
    }

    @Override
    public QFilter apply(QFilter filter) {
        if (!filter.isExpressValue()) {
            String obj;
            String p = filter.getProperty();
            int dot = p.lastIndexOf(46);
            if (dot == -1) {
                obj = this.rootObjName;
            } else {
                obj = this.rootObjName + '.' + p.substring(0, dot);
                p = p.substring(dot + 1);
            }
            EntityItem ei = null;
            try {
                ei = this.ctx.getEntityItem(obj);
            }
            catch (Exception e) {
                this.logger.error(obj + ", QFilterDecryptTransFunction.apply getEntityItem occur an error: " + e.getMessage());
            }
            if (ei == null) {
                return filter;
            }
            IDataEntityProperty dp = (IDataEntityProperty)ei.entityType.getProperties().get((Object)p);
            if (dp instanceof ISimpleProperty && ((ISimpleProperty)dp).isEncrypt()) {
                String cp = filter.getCP();
                QueryMeta.Converter cc = FieldEncrypt.get((ISimpleProperty)dp);
                if (this.isDateProp((ISimpleProperty)dp) && !"=".equals(cp) && !"!=".equals(cp) && !"<>".equals(cp)) {
                    throw new ORMArgInvalidException(BosErrorCode.filterSqlBuilder.getMessage(), BosRes.get((String)"bos-ormengine", (String)"QFilterDecryptTransFunction_0", (String)"\u52a0\u5bc6\u65e5\u671f\u7c7b\u578b\u5b57\u6bb5\u4ec5\u652f\u6301 \u7b49\u4e8e/\u4e0d\u7b49\u4e8e \u5339\u914d", (Object[])new Object[0]));
                }
                if (cp.equals("=") || "<>".equals(cp) || "!=".equals(cp)) {
                    filter.__setProperty("to_char(" + filter.getProperty() + ")");
                    Object value = cc.convert(filter.getValue());
                    filter.__setValue(value);
                } else if (cp.equalsIgnoreCase("in") || cp.equalsIgnoreCase("not in")) {
                    Object values = filter.getValue();
                    ArrayList<Object> valueList = new ArrayList<Object>();
                    if (values.getClass().isArray()) {
                        Object[] valueArray;
                        for (Object value : valueArray = (Object[])values) {
                            valueList.add(cc.convert(value));
                        }
                    } else if (values instanceof Iterable) {
                        Iterable iterableValue = (Iterable)values;
                        Iterator iterator = iterableValue.iterator();
                        while (iterator.hasNext()) {
                            valueList.add(cc.convert(iterator.next()));
                        }
                    } else {
                        valueList.add(cc.convert(values));
                    }
                    filter.__setProperty("to_char(" + filter.getProperty() + ")");
                    filter.__setValue(valueList);
                }
            }
        }
        return filter;
    }

    private boolean isDateProp(ISimpleProperty dp) {
        return dp.getDbType() == 91 || dp.getDbType() == 93;
    }
}

