/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.query.fulltext.QMatches;

public class QFilterFtlikeTransFunction
implements Function<QFilter, QFilter> {
    private String rootObjName;
    private QContext ctx;
    private static final Log logger = LogFactory.getLog(QFilterFtlikeTransFunction.class);

    public QFilterFtlikeTransFunction(String rootObjName, QContext ctx) {
        this.ctx = ctx;
        this.rootObjName = rootObjName;
    }

    @Override
    public QFilter apply(QFilter filter) {
        String cp = filter.getCP();
        if (!("ftlike".equals(cp) || "match".equals(cp) || ORMUtil.isContains(filter.getQFilterHint()))) {
            return filter;
        }
        if (filter.getValue() instanceof MultiBaseDataFilterValue) {
            String newCP;
            MultiBaseDataFilterValue value = (MultiBaseDataFilterValue)filter.getValue();
            String baseDataFullObjName = value.getBaseDataName();
            String joinProperty = value.getJoinProperty();
            String filterProperty = filter.getProperty();
            String multiTypeValue = value.getValue().toString();
            if (!"ftlike".equals(cp) && !"match".equals(cp)) {
                newCP = cp;
            } else {
                IDataEntityType dt;
                EntityItem entityItem = this.ctx.getEntityItem(baseDataFullObjName);
                if (entityItem != null) {
                    dt = entityItem.entityType;
                    if (dt == null) {
                        dt = ORMConfiguration.innerGetDataEntityType(baseDataFullObjName, this.ctx.getEntityTypeCache());
                    }
                } else {
                    dt = ORMConfiguration.innerGetDataEntityType(baseDataFullObjName, this.ctx.getEntityTypeCache());
                }
                newCP = ORMUtil.getLikeCP(dt);
            }
            if (ORMConfig.QUICKSEARCH_MULTYPE.getBoolean(RequestContext.get().getTenantId())) {
                String realProperty = filterProperty.substring(filterProperty.lastIndexOf(".") + 1);
                QFilter copyQFilter = filter.copy();
                try {
                    HashSet<String> properties = new HashSet<String>(2);
                    properties.add(realProperty);
                    String fullObjectName = filterProperty.substring(0, filterProperty.lastIndexOf("."));
                    if (realProperty.length() != 0 && QMatches.isFromEs(this.ctx, fullObjectName, properties)) {
                        if (filterProperty.startsWith(baseDataFullObjName + ".")) {
                            copyQFilter.__setProperty(filterProperty.substring((baseDataFullObjName + ".").length()));
                        }
                        copyQFilter.__setValue(multiTypeValue);
                        return this.buildQFilter(copyQFilter, fullObjectName, true, joinProperty, baseDataFullObjName);
                    }
                }
                catch (Exception e) {
                    logger.error("Query from es error,continue to query from DB.", (Throwable)e);
                }
            }
            QFilterHint qFilterHint = filter.getQFilterHint();
            filter.__setCP(newCP);
            if (qFilterHint.equals(QFilterHint.FTLIKE_CONTAINS) || qFilterHint.equals(QFilterHint.CONTAINS)) {
                filter.setQFilterHint(QFilterHint.CONTAINS);
            } else if (qFilterHint.equals(QFilterHint.FTLIKE_STARTWITH) || qFilterHint.equals(QFilterHint.STARTWITH)) {
                filter.setQFilterHint(QFilterHint.STARTWITH);
            } else {
                filter.setQFilterHint(QFilterHint.ENDWITH);
            }
            return filter;
        }
        return this.buildQFilter(filter, this.rootObjName, false, null, null);
    }

    private QFilter buildQFilter(QFilter filter, String rootName, boolean isMultiType, String joinProperty, String basedataName) {
        QParameter qParameter = QMatches.toQParameter(this.ctx, rootName, new Object(), filter);
        QFilter newQFilter = qParameter.getMatchTransferQFilter();
        filter.maskCurrent();
        if (ORMUtil.isFuzzyQuery(newQFilter.getQFilterHint())) {
            filter.__setProperty(newQFilter.getProperty());
            filter.__setCP(newQFilter.getCP());
            filter.__setValue(newQFilter.getOriginValue());
            filter.setQFilterHint(newQFilter.getQFilterHint());
        } else {
            filter.__setValue(newQFilter.getValue());
            filter.__setCP(newQFilter.getCP());
            if (isMultiType) {
                String newQFilterProperty = newQFilter.getProperty();
                IDataEntityProperty peropertyType = newQFilter.__getParsedProperty(this.ctx).getPeropertyType();
                if (newQFilterProperty.indexOf(".") == -1 && peropertyType instanceof ISimpleProperty && ((ISimpleProperty)peropertyType).isPrimaryKey()) {
                    filter.__setProperty(joinProperty);
                } else {
                    filter.__setProperty(basedataName + "." + newQFilterProperty);
                    MultiBaseDataFilterValue mulValue = new MultiBaseDataFilterValue(basedataName, joinProperty, newQFilter.getValue());
                    filter.__setValue(mulValue);
                }
            } else {
                filter.__setProperty(newQFilter.getProperty());
            }
        }
        List<QFilter.QFilterNest> nests = newQFilter.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            if (nest.isAnd()) {
                filter.and(nest.getFilter());
                continue;
            }
            filter.or(nest.getFilter());
        }
        return filter;
    }
}

