/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.bos.orm.query.privacy.PrivacyDataQuery;

public class QFilterGLanEqualAndLikeTransFunction
implements Function<QFilter, QFilter> {
    private final String rootObjName;
    private final QContext ctx;
    private static final Class<?> entryProp;
    private static final Log logger;

    public QFilterGLanEqualAndLikeTransFunction(String rootObjName, QContext ctx) {
        this.rootObjName = rootObjName;
        this.ctx = ctx;
    }

    @Override
    public QFilter apply(QFilter filter) {
        String tenantId = RequestContext.get().getTenantId();
        if (filter == null || !ORMConfig.GLANG_TRANS_ENABLE.getBoolean(tenantId)) {
            return filter;
        }
        String property = filter.getProperty();
        int lastDotIndex = property.lastIndexOf(46);
        String propertyName = property;
        String fullObjectName = "";
        if (filter.getValue() instanceof MultiBaseDataFilterValue) {
            if (lastDotIndex != -1) {
                propertyName = property.substring(lastDotIndex + 1);
                fullObjectName = property.substring(0, lastDotIndex);
            } else {
                fullObjectName = property;
            }
        } else if (lastDotIndex != -1) {
            propertyName = property.substring(lastDotIndex + 1);
            fullObjectName = this.rootObjName + "." + property.substring(0, lastDotIndex);
        } else {
            fullObjectName = this.rootObjName;
        }
        EntityItem entityItem = this.ctx.getEntityItem(fullObjectName);
        MultiBaseDataFilterValue multiBaseDataFilterValue = null;
        if (filter.getValue() instanceof MultiBaseDataFilterValue) {
            multiBaseDataFilterValue = (MultiBaseDataFilterValue)filter.getValue();
            entityItem = this.ctx.getEntityItem(multiBaseDataFilterValue.getBaseDataName());
        }
        if (!this.needTrans(filter, propertyName, entityItem, this.rootObjName, property)) {
            return filter;
        }
        this.transfer(filter, fullObjectName, propertyName, entityItem, multiBaseDataFilterValue);
        return filter;
    }

    private void transfer(QFilter filter, String fullObjectName, String propertyName, EntityItem entityItem, MultiBaseDataFilterValue multiBaseDataFilterValue) {
        Object[] iDs = this.getIDs(filter, propertyName, entityItem, fullObjectName);
        if (iDs == null || iDs.length == 0) {
            return;
        }
        String newProperty = fullObjectName;
        if (filter.getValue() instanceof MultiBaseDataFilterValue) {
            newProperty = this.rootObjName + "." + newProperty;
        }
        if (newProperty.startsWith(this.rootObjName)) {
            newProperty = newProperty.equals(this.rootObjName) ? "id" : newProperty.substring(newProperty.indexOf(".") + 1) + ".id";
        }
        Object value = iDs;
        if (multiBaseDataFilterValue != null) {
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(iDs));
            value = new MultiBaseDataFilterValue(multiBaseDataFilterValue.getBaseDataName(), multiBaseDataFilterValue.getJoinProperty(), list);
        }
        filter.__setProperty(newProperty);
        filter.__setCP("in");
        filter.__setValue(value);
    }

    private Object[] getIDs(QFilter filter, String propertyName, EntityItem entityItem, String fullObjectName) {
        IDataEntityType dt = entityItem.entityType;
        IDataEntityProperty dp = (IDataEntityProperty)dt.getProperties().get((Object)propertyName);
        String field = dp.getAlias();
        if (entryProp.isAssignableFrom(dp.getClass())) {
            field = dp.getParent().getPrimaryKey().getAlias();
        }
        String selectField = dt.getPrimaryKey().getAlias();
        Class selectFieldType = dt.getPrimaryKey().getPropertyType();
        String mainTable = dt.getAlias();
        ICollectionProperty localeProperty = (ICollectionProperty)dt.getProperties().get((Object)"multilanguagetext");
        String localeField = ((IDataEntityProperty)localeProperty.getItemType().getProperties().get((Object)"localeid")).getAlias();
        String langTable = localeProperty.getItemType().getAlias();
        this.ctx.getgLanTransLanFullObjectNameSet().add(fullObjectName);
        StringBuilder sql = new StringBuilder(256);
        LinkedList<Object> plist = new LinkedList<Object>();
        String mainTableAlias = "A";
        String langTableAlias = "B";
        String mainTableWithAlias = mainTable + " " + mainTableAlias + " ";
        String langTableWithAlias = langTable + " " + langTableAlias + " ";
        String joinField = dt.getPrimaryKey().getAlias();
        sql.append("/*ORM*/ ").append("SELECT ").append(mainTableAlias).append('.').append(selectField).append(" FROM ").append(mainTableWithAlias).append("LEFT JOIN ").append(langTableWithAlias).append(" ON ").append(mainTableAlias).append(".").append(joinField).append('=').append(langTableAlias).append('.').append(joinField).append(" AND ").append(langTableAlias).append('.').append(localeField).append(" =? ").append("WHERE ").append("(");
        QFilterHint qFilterHint = filter.getQFilterHint();
        String cp = ORMUtil.isContains(qFilterHint) || ORMUtil.isStartWith(qFilterHint) || ORMUtil.isEndWith(qFilterHint) ? ORMUtil.getLikeCP(dt) : (ORMUtil.isNotContains(qFilterHint) && filter.getCP().equals("like") ? ORMUtil.getLikeCP(dt) : filter.getCP());
        String mainTableField = mainTableAlias + "." + field;
        String langTableFiled = langTableAlias + "." + field;
        String langField = String.format("%s %s ? OR ((%s IS NULL OR %s = '' OR %s = ' ') AND %s %s ?)", langTableFiled, cp, langTableFiled, langTableFiled, langTableFiled, mainTableField, cp);
        sql.append(langField);
        sql.append(" )");
        plist.add(this.ctx.getORMHint().getLang().toString());
        if (filter.getValue() instanceof MultiBaseDataFilterValue) {
            MultiBaseDataFilterValue multiBaseDataFilterValue = (MultiBaseDataFilterValue)filter.getValue();
            Object value = multiBaseDataFilterValue.getValue();
            plist.add(value);
            plist.add(value);
        } else {
            plist.add(filter.getOriginValue());
            plist.add(filter.getOriginValue());
        }
        if (ORMUtil.isContains(filter.getQFilterHint())) {
            for (int i = 1; i < plist.size(); ++i) {
                plist.set(i, ORMUtil.transferAndAppendPercent(filter.getQFilterHint(), String.valueOf(plist.get(i)), dt));
            }
        }
        DBRoute dbRoute = new DBRoute(dt.getDBRouteKey());
        return (Object[])DB.query((DBRoute)dbRoute, (String)sql.toString(), (Object[])plist.toArray(), rs -> QFilterGLanEqualAndLikeTransFunction.parseField(rs, selectFieldType != String.class));
    }

    private boolean needTrans(QFilter filter, String propertyName, EntityItem entityItem, String rootName, String property) {
        String cp = filter.getCP();
        if (!cp.equalsIgnoreCase("=") && !ORMUtil.isContains(filter.getQFilterHint())) {
            return false;
        }
        if ("1".equals(property) || filter.getValue() instanceof QEmptyValue) {
            return false;
        }
        if (filter.isJoinFilter() || filter.isJoinSQLFilter()) {
            return false;
        }
        if (filter.__getParsedProperty(this.ctx) != null && filter.__getParsedProperty(this.ctx).isExpress()) {
            return false;
        }
        boolean privacyProperty = PrivacyDataQuery.isPrivacyProperty(ORMUtil.getColumnName(this.ctx, rootName, property), ORMUtil.getTableName(this.ctx, rootName, property));
        if (filter.__getParsedProperty(this.ctx) == null || privacyProperty) {
            return false;
        }
        try {
            if (entityItem == null || entityItem.entityType == null) {
                logger.error(String.format("entityItem is null, property: %s", propertyName));
                return false;
            }
            if (!entityItem.entityType.getProperties().containsKey((Object)propertyName)) {
                logger.error(String.format("entityItem not contains property: %s", propertyName));
                return false;
            }
            if (!ORMConfiguration.isGLPropertyType(entityItem.entityType, propertyName)) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error("error occur when needtrans executed, e.getMessage: %s" + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private static Object[] parseField(ResultSet rs, boolean isNumber) throws Exception {
        HashSet<Object> list = new HashSet<Object>();
        if (isNumber) {
            while (rs.next()) {
                list.add(rs.getLong(1));
            }
        } else {
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        if (list.size() == 0) {
            return new Object[0];
        }
        Object[] ret = new Object[list.size()];
        int i = 0;
        for (Object e : list) {
            ret[i++] = e;
        }
        return ret;
    }

    static {
        logger = LogFactory.getLog(QFilterGLanEqualAndLikeTransFunction.class);
        try {
            entryProp = Class.forName("kd.bos.entity.property.EntryProp");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

