/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.util.function.Function;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QParameter;

public class QFilterJoinSQLTransFunction
implements Function<QFilter, QFilter> {
    @Override
    public QFilter apply(QFilter filter) {
        if (filter.isJoinSQLFilter()) {
            QParameter qp = new QParameter(filter.getProperty(), (Object[])filter.getValue());
            qp.setSQLBuilder((sql, ctx) -> {
                String joinEntity = filter.getJoinEntityPath();
                String joinEntityAlias = ctx.getSimpleEntityAlias(joinEntity);
                return this.replaceEntityNameAsAlias(sql, joinEntity.toLowerCase(), joinEntityAlias);
            });
            filter.__setSelfDefinedQParameter(qp);
        }
        return filter;
    }

    private String replaceEntityNameAsAlias(String sql, String entityName, String alias) {
        entityName = entityName + ".";
        alias = alias + ".";
        int entityNameLen = entityName.length();
        char[] lowerEntityName = entityName.toLowerCase().toCharArray();
        char[] upperEntityName = entityName.toUpperCase().toCharArray();
        StringBuilder ret = new StringBuilder(sql.length());
        StringBuilder segName = new StringBuilder(entityNameLen);
        boolean inQuote = false;
        int segI = 0;
        char[] chs = sql.toCharArray();
        boolean preIsLetterOrDigit = false;
        for (char ch : chs) {
            if (ch == '\'') {
                if (segI != 0) {
                    segI = 0;
                    ret.append((CharSequence)segName);
                    segName.setLength(0);
                }
                inQuote = !inQuote;
                ret.append(ch);
                preIsLetterOrDigit = false;
                continue;
            }
            if (inQuote || segI == 0 && preIsLetterOrDigit) {
                ret.append(ch);
            } else if (ch == lowerEntityName[segI] || ch == upperEntityName[segI]) {
                segName.append(ch);
                if (++segI == entityNameLen) {
                    ret.append(alias);
                    segName.setLength(0);
                    segI = 0;
                }
            } else {
                if (segI != 0) {
                    ret.append((CharSequence)segName);
                    segName.setLength(0);
                    segI = 0;
                }
                ret.append(ch);
            }
            preIsLetterOrDigit = Character.isLetterOrDigit(ch);
        }
        if (segName.length() > 0) {
            ret.append((CharSequence)segName);
        }
        return ret.toString();
    }
}

