/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.function.Function;
import kd.bos.bundle.BosRes;
import kd.bos.orm.ORMHint;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.EntityItemProperty;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.NoSuchPropertyException;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.multi.MultiQueryParameter;
import kd.bos.orm.util.StringUtils;

public class QFilterMultiTypeBasedataFunction
implements Function<QFilter, QFilter> {
    private MultiQueryParameter mp;
    private QContext ctx;
    private SimpleDateFormat dateSdf = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat dateTimeSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public QFilterMultiTypeBasedataFunction(MultiQueryParameter mp, QContext ctx) {
        this.mp = mp;
        this.ctx = ctx;
    }

    @Override
    public QFilter apply(QFilter filter) {
        if (filter == null) {
            return filter;
        }
        Object value = filter.getValue();
        if (value instanceof MultiBaseDataFilterValue) {
            QFilter[] newJoinFilters;
            String filterProperty = filter.getProperty();
            MultiBaseDataFilterValue multi = (MultiBaseDataFilterValue)value;
            String baseDataName = multi.getBaseDataName();
            if (StringUtils.isEmpty(baseDataName)) {
                throw new IllegalArgumentException("not declare basedtaname!");
            }
            String joinProperty = multi.getJoinProperty();
            if ("1".equalsIgnoreCase(filterProperty) && !"ftlike".equalsIgnoreCase(filter.getCP()) && !"match".equalsIgnoreCase(filter.getCP())) {
                if (multi.getValue() instanceof String) {
                    multi.setValue(Integer.parseInt((String)multi.getValue()));
                }
            } else {
                int index = joinProperty.length();
                if (filterProperty.equalsIgnoreCase(joinProperty)) {
                    Class propertyType = this.ctx.getEntityItem((String)multi.getBaseDataName()).entityType.getPrimaryKey().getPropertyType();
                    filter.__setValue(this.tranferValue(propertyType, multi.getValue()));
                    return filter;
                }
                filter.__setProperty(baseDataName + "" + filterProperty.substring(index));
                this.convertValue(multi, filterProperty, index);
            }
            QFilter join = QFilter.join(joinProperty, baseDataName + ".id", null, ORMHint.JoinHint.LEFT, true);
            int length = 1;
            if (this.mp.joinFilters != null) {
                length = this.mp.joinFilters.length + 1;
                newJoinFilters = new QFilter[length];
                for (int i = 0; i < this.mp.joinFilters.length; ++i) {
                    newJoinFilters[i] = this.mp.joinFilters[i];
                }
                newJoinFilters[length - 1] = join;
            } else {
                newJoinFilters = new QFilter[length];
                newJoinFilters[0] = join;
            }
            this.mp.joinFilters = newJoinFilters;
        }
        return filter;
    }

    private void convertValue(MultiBaseDataFilterValue multi, String filterProperty, int index) {
        EntityItem entityItem;
        String bdProperty = filterProperty.substring(index + 1);
        int dotIndex = bdProperty.lastIndexOf(".");
        String fullObjectName = multi.getBaseDataName();
        if (dotIndex != -1) {
            fullObjectName = fullObjectName + "." + bdProperty.substring(0, dotIndex);
            bdProperty = bdProperty.substring(dotIndex + 1);
        }
        if ((entityItem = this.ctx.getEntityItem(fullObjectName)) == null) {
            throw new NoSuchPropertyException(BosRes.get((String)"bos-ormengine", (String)"EntityItem_1", (String)"The entity {0} is not exists.", (Object[])new Object[]{fullObjectName}));
        }
        EntityItemProperty propertyItem = entityItem.getPropertyItem(bdProperty);
        if (propertyItem == null) {
            throw new NoSuchPropertyException(BosRes.get((String)"bos-ormengine", (String)"EntityItem_0", (String)"Entity %1$s's property %2$s is not exists;Or the property's db field is not configured.", (Object[])new Object[]{multi.getBaseDataName(), bdProperty}));
        }
        Class propertyType = propertyItem.getPropertyType().getPropertyType();
        Object value = multi.getValue();
        if (value == null) {
            return;
        }
        boolean isCollection = value instanceof Collection;
        if (isCollection) {
            Collection collection = (Collection)value;
            Iterator iterator = collection.iterator();
            ArrayList<Object> values = new ArrayList<Object>(collection.size());
            while (iterator.hasNext()) {
                values.add(this.tranferValue(propertyType, iterator.next()));
            }
            multi.setValue(values);
        } else if (value.getClass().isArray()) {
            Object[] values = (Object[])value;
            ArrayList<Object> convertValue = new ArrayList<Object>(values.length);
            for (Object objectValue : values) {
                convertValue.add(this.tranferValue(propertyType, objectValue));
            }
            multi.setValue(convertValue);
        } else {
            multi.setValue(this.tranferValue(propertyType, value));
        }
    }

    private Object tranferValue(Class<?> propertyType, Object value) {
        if (!(value instanceof String)) {
            return value;
        }
        if (propertyType == Long.class || propertyType == Long.TYPE) {
            return Long.parseLong((String)value);
        }
        if (propertyType == Integer.class || propertyType == Integer.TYPE) {
            return Integer.parseInt((String)value);
        }
        if (propertyType == Byte.class || propertyType == Byte.TYPE) {
            return Byte.parseByte((String)value);
        }
        if (propertyType == Short.class || propertyType == Short.TYPE) {
            return Short.parseShort((String)value);
        }
        if (propertyType == Double.class || propertyType == Double.TYPE) {
            return Double.parseDouble((String)value);
        }
        if (propertyType == Character.class || propertyType == Character.TYPE) {
            return Character.valueOf(((String)value).charAt(0));
        }
        if (propertyType == Boolean.class || propertyType == Boolean.TYPE) {
            return Boolean.parseBoolean((String)value);
        }
        if (propertyType == BigDecimal.class) {
            return new BigDecimal((String)value);
        }
        if (propertyType == Date.class || propertyType == Timestamp.class) {
            Date returnDate;
            String dateStr = (String)value;
            try {
                returnDate = dateStr.trim().length() == 10 ? this.dateSdf.parse(dateStr) : this.dateTimeSdf.parse(dateStr);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (propertyType == Timestamp.class) {
                return new Timestamp(returnDate.getTime());
            }
            return returnDate;
        }
        return value;
    }
}

