/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.multi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.db.DBRoute;
import kd.bos.db.datasource.DBConfig;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORMHint;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.config.ORMConstants;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMOptimization;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.MultiBaseDataFilterValue;
import kd.bos.orm.query.NotLikeHint;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.multi.MultiQuery;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.oql.g.expr.SelectFields;
import kd.bos.orm.util.CosmicDataTypeEnum;
import kd.bos.orm.util.ORMTuple;

public class QFilterNotEqualTransFunction
implements Function<QFilter, QFilter> {
    private String rootObjName;
    private QContext ctx;
    private static final Log logger = LogFactory.getLog(QFilterNotEqualTransFunction.class);

    public QFilterNotEqualTransFunction(String rootObjName, QContext ctx) {
        this.rootObjName = rootObjName;
        this.ctx = ctx;
    }

    @Override
    public QFilter apply(QFilter filter) {
        String cp = filter.getCP();
        ORMHint ormHint = this.ctx.getORMHint();
        String tenantId = RequestContext.get().getTenantId();
        if ("!=".equalsIgnoreCase(cp) || "<>".equalsIgnoreCase(cp) ? !ORMConfig.NOTEQUAL_ENABLE.getBoolean(tenantId) && !ormHint.isNotEqualTransEnable() : ("not in".equalsIgnoreCase(cp) ? !ORMConfig.NOTIN_ENABLE.getBoolean(tenantId) && !ormHint.isNotInTransEnable() : ("is not null".equalsIgnoreCase(cp) ? !ORMConfig.NOTNULL_ENABLE.getBoolean(tenantId) && !ormHint.isNotNullTransEnable() : "not like".equalsIgnoreCase(cp) && !ORMConfig.NOTLIKE_ENABLE.getBoolean(tenantId) && !ormHint.isNotLikeTransEnable()))) {
            return filter;
        }
        this.transfer(filter);
        List<QFilter.QFilterNest> nests = filter.getNests(true);
        if (nests != null && !nests.isEmpty()) {
            for (QFilter.QFilterNest nest : nests) {
                this.transfer(nest.getFilter());
            }
        }
        return filter;
    }

    private void transfer(QFilter filter) {
        if (filter == null) {
            return;
        }
        this.handlePrimaryKey(filter);
        HashMap<String, Set<DBConfig>> configs = new HashMap<String, Set<DBConfig>>();
        HashSet<String> allFullOjbectNames = new HashSet<String>();
        if (ORMUtil.isCpExpectedAndCrossDB(filter, configs, allFullOjbectNames, this.ctx, this.rootObjName)) {
            this.query(filter, configs);
        }
    }

    private void handlePrimaryKey(QFilter filter) {
        EntityItem entityItem;
        int dotIndex;
        PropertyField propertyField;
        if (!ORMConfig.NOTEQUAL_OPT_PRIMARYKEY.getBoolean()) {
            return;
        }
        if (filter.isJoinFilter() || filter.isJoinSQLFilter()) {
            return;
        }
        String cp1 = filter.getCP();
        if (!("not in".equalsIgnoreCase(cp1) || "<>".equalsIgnoreCase(cp1) || "!=".equalsIgnoreCase(cp1) || "not like".equalsIgnoreCase(cp1) || "is not null".equalsIgnoreCase(cp1))) {
            return;
        }
        try {
            propertyField = SelectFields.parseFrom(filter.getProperty()).createPropertyFields(this.rootObjName).get(0);
        }
        catch (Exception e) {
            logger.error("getFilterProperty error", (Throwable)e);
            propertyField = filter.__getParsedProperty(this.ctx);
        }
        String filterProperty = ORMUtil.getFullObjectName(this.rootObjName, propertyField);
        if (this.rootObjName.equals(filterProperty)) {
            filterProperty = filter.getProperty();
        }
        if ((dotIndex = filterProperty.lastIndexOf(".")) == -1) {
            return;
        }
        String fullObject = filterProperty.substring(0, dotIndex);
        if (fullObject.equalsIgnoreCase(this.rootObjName)) {
            return;
        }
        String newFullObjectName = fullObject;
        String prefix = this.rootObjName + ".";
        if (!newFullObjectName.startsWith(prefix)) {
            newFullObjectName = prefix + newFullObjectName;
        }
        if ((entityItem = this.ctx.getEntityItem(newFullObjectName)) == null) {
            return;
        }
        IDataEntityProperty propertyType = entityItem.getPropertyItem(filterProperty.substring(dotIndex + 1)).getPropertyType();
        if (propertyType instanceof ISimpleProperty) {
            ISimpleProperty simpleProperty = (ISimpleProperty)propertyType;
            String cp = filter.getCP();
            if (simpleProperty.isPrimaryKey() && propertyField != null && !propertyField.getPropertySegExpress().isExpress() && ("not in".equalsIgnoreCase(cp) || "<>".equalsIgnoreCase(cp) || "!=".equalsIgnoreCase(cp) || "not like".equalsIgnoreCase(cp) || "is not null".equalsIgnoreCase(cp))) {
                filter.__setProperty(fullObject);
            }
        }
    }

    private void query(QFilter filter, Map<String, Set<DBConfig>> configs) {
        QFilter filterBak = filter.copy();
        Object backupValue = filter.getValue();
        String backupCp = filter.getCP();
        QFilter newFilter = this.transCp(filter);
        ORMTuple<CosmicDataTypeEnum, String> ret = this.queryRecursionBySingleQuery(newFilter, configs);
        CosmicDataTypeEnum type = (CosmicDataTypeEnum)((Object)ret.t1);
        String newProperty = (String)ret.t2;
        boolean is1Equals1 = "!=".equalsIgnoreCase(newFilter.getCP()) && ORMConstants.ONE_INTEGER == newFilter.getValue() && "1".equalsIgnoreCase(newFilter.getProperty());
        filter.maskCurrent();
        if (!is1Equals1) {
            boolean isNotEqualEmpty;
            filter.__setCP("not in");
            filter.__setValue(newFilter.getValue());
            filter.__setProperty(newProperty);
            boolean bl = isNotEqualEmpty = filterBak.getCP().equals("!=") && filterBak.getValue().equals(QEmptyValue.value);
            if (type != CosmicDataTypeEnum.MULTIPLE_BASE_DATA && (backupCp.equalsIgnoreCase("is not null") || isNotEqualEmpty)) {
                filter.addFirstNest(new QFilter(newProperty, "!=", QEmptyValue.value), "AND");
            }
        } else {
            boolean isNotEqualEmpty;
            filter.__setCP("=");
            filter.__setValue(1);
            filter.__setProperty("1");
            String recursionProperty = "";
            if (filterBak.getValue() instanceof MultiBaseDataFilterValue) {
                MultiBaseDataFilterValue value = (MultiBaseDataFilterValue)filterBak.getValue();
                recursionProperty = value.getJoinProperty();
            } else {
                String filterProperty = ORMUtil.getFilterProperty(this.ctx, filterBak, this.rootObjName);
                int index = filterProperty.lastIndexOf(".");
                recursionProperty = filterProperty.substring(0, index);
            }
            EntityItem entityItem = this.ctx.getEntityItem(this.rootObjName + "." + recursionProperty);
            boolean isMulbasedata = entityItem != null && ORMConfiguration.isMulBasedata(entityItem.entityType);
            boolean bl = isNotEqualEmpty = filterBak.getCP().equals("!=") && filterBak.getValue().equals(QEmptyValue.value);
            if (!isMulbasedata && (backupCp.equalsIgnoreCase("is not null") || isNotEqualEmpty)) {
                filter.addFirstNest(new QFilter(recursionProperty, "!=", QEmptyValue.value), "AND");
            }
        }
        if (backupValue instanceof MultiBaseDataFilterValue) {
            MultiBaseDataFilterValue value = (MultiBaseDataFilterValue)backupValue;
            String joinProperty = value.getJoinProperty();
            String fullObjectName = ORMUtil.getFullObjectName(this.rootObjName, joinProperty);
            EntityItem entityItem = this.ctx.getEntityItem(fullObjectName);
            String property = joinProperty;
            int index = joinProperty.lastIndexOf(".");
            if (index != -1) {
                property = joinProperty.substring(index + 1);
            }
            this.setMultiTypeBaseDataType(property, entityItem, fullObjectName, filter, value);
        }
    }

    private QFilter transCp(QFilter filter) {
        QFilter newFilter = filter.__copy(false);
        String cp = filter.getCP();
        if ("!=".equalsIgnoreCase(cp) || "<>".equalsIgnoreCase(cp)) {
            newFilter.__setCP("=");
        } else if ("not in".equalsIgnoreCase(cp)) {
            newFilter.__setCP("in");
        } else if ("is not null".equalsIgnoreCase(cp)) {
            newFilter.__setCP("is null");
        } else {
            newFilter.__setCP("like");
            if (filter.getQFilterHint() != null && filter.getQFilterHint() instanceof NotLikeHint) {
                newFilter.setQFilterHint(((NotLikeHint)filter.getQFilterHint()).reverse());
            }
        }
        return newFilter;
    }

    private ORMTuple<CosmicDataTypeEnum, String> queryRecursionBySingleQuery(QFilter filter, Map<String, Set<DBConfig>> configs) {
        String recursionProperty;
        String entityName;
        String filterProperty = ORMUtil.getFilterProperty(this.ctx, filter, this.rootObjName);
        int index = filterProperty.lastIndexOf(".");
        if (index == -1) {
            return new ORMTuple<CosmicDataTypeEnum, String>(CosmicDataTypeEnum.BASIC, filterProperty);
        }
        String property = filterProperty.substring(index + 1);
        filter.__setProperty(property);
        String fullObjectName = null;
        if (filter.getValue() instanceof MultiBaseDataFilterValue) {
            MultiBaseDataFilterValue value = (MultiBaseDataFilterValue)filter.getValue();
            entityName = value.getBaseDataName();
            filter.__setValue(value.getValue());
            recursionProperty = value.getJoinProperty();
            fullObjectName = entityName;
        } else {
            fullObjectName = ORMUtil.getFullObjectName(this.rootObjName, filterProperty);
            entityName = this.getEntityName(fullObjectName);
            recursionProperty = filterProperty.substring(0, index);
            if (ORMConfig.NOTEQUAL_SAMEDBMERGE_ENABLE.getBoolean()) {
                int index11;
                while ((index11 = recursionProperty.lastIndexOf(".")) != -1) {
                    int index1 = fullObjectName.lastIndexOf(".");
                    String newFullObject = fullObjectName.substring(0, index1);
                    EntityItem entityItem = this.ctx.getEntityItem(newFullObject);
                    if (ORMConfiguration.isEntryEntityType(entityItem.entityType)) break;
                    HashSet<String> allFullOjbectNames = new HashSet<String>();
                    allFullOjbectNames.add(fullObjectName);
                    allFullOjbectNames.add(newFullObject);
                    HashMap<String, Set<DBConfig>> newConfigs = new HashMap<String, Set<DBConfig>>(2);
                    for (Map.Entry<String, Set<DBConfig>> entry : configs.entrySet()) {
                        String key = entry.getKey();
                        if (!allFullOjbectNames.contains(key)) continue;
                        newConfigs.put(key, entry.getValue());
                    }
                    if (ORMUtil.isExistsCrossDB(this.ctx, newFullObject, newConfigs, allFullOjbectNames)) break;
                    fullObjectName = newFullObject;
                    entityName = this.getEntityName(newFullObject);
                    int index2 = recursionProperty.lastIndexOf(".");
                    if (index2 == -1) continue;
                    property = recursionProperty.substring(index2 + 1) + "." + filter.getProperty();
                    recursionProperty = recursionProperty.substring(0, index2);
                    filter.__setProperty(property);
                }
            }
        }
        MultiQuery multiQuery = this.createMultiQuery(entityName, fullObjectName, filter);
        DataSet dataSet = multiQuery.query(this.getClass().getName());
        filter.maskCurrent();
        ArrayList<Object> ids = new ArrayList<Object>(16);
        while (dataSet.hasNext()) {
            ids.add(dataSet.next().get("id"));
        }
        if (ids.isEmpty()) {
            filter.__setProperty("1");
            filter.__setCP("!=");
            filter.__setValue(1);
            return new ORMTuple<CosmicDataTypeEnum, String>(CosmicDataTypeEnum.BASIC, "1");
        }
        filter.__setProperty(recursionProperty);
        filter.__setCP("in");
        filter.__setValue(ids);
        int index1 = recursionProperty.lastIndexOf(".");
        if (index1 == -1) {
            return new ORMTuple<CosmicDataTypeEnum, String>(CosmicDataTypeEnum.BASIC, recursionProperty);
        }
        String newFullObjectSuffix = recursionProperty.substring(0, index1);
        EntityItem entityItem = this.ctx.getEntityItem(this.rootObjName + "." + newFullObjectSuffix);
        if (entityItem == null) {
            throw new IllegalArgumentException(" the entity  " + newFullObjectSuffix + " not exists");
        }
        if (ORMConfiguration.isEntryEntityType(entityItem.entityType)) {
            return new ORMTuple<CosmicDataTypeEnum, String>(CosmicDataTypeEnum.ENTRY_OR_SUBENTRY, recursionProperty);
        }
        EntityItem mulBaseDataEntityItem = ORMUtil.getMulBaseDataEntityItem(entityItem);
        if (mulBaseDataEntityItem != null) {
            return new ORMTuple<CosmicDataTypeEnum, String>(CosmicDataTypeEnum.MULTIPLE_BASE_DATA, recursionProperty);
        }
        HashSet<String> allFullOjbectNames = new HashSet<String>();
        allFullOjbectNames.add(newFullObjectSuffix);
        allFullOjbectNames.add(this.rootObjName);
        if (ORMUtil.isExistsCrossDB(this.ctx, this.rootObjName, configs, allFullOjbectNames)) {
            return this.queryRecursionBySingleQuery(filter, configs);
        }
        return new ORMTuple<CosmicDataTypeEnum, String>(CosmicDataTypeEnum.UNKNOWN, recursionProperty);
    }

    private String getEntityName(String fullObjectName) {
        EntityItem entityItem = this.ctx.getEntityItem(fullObjectName);
        if (entityItem == null) {
            throw new IllegalArgumentException(" the entity  " + fullObjectName + " not exists");
        }
        return entityItem.entityType.getName();
    }

    private MultiQuery createMultiQuery(String entityName, String fullObjectName, QFilter filter) {
        IDataEntityType dt;
        if (!(filter.getValue() instanceof MultiBaseDataFilterValue)) {
            try {
                dt = this.ctx.getEntityItem((String)fullObjectName).entityType;
            }
            catch (Exception e) {
                logger.error("ger DataEntity error", (Throwable)e);
                dt = ORMConfiguration.innerGetDataEntityType(entityName, this.ctx.getEntityTypeCache());
            }
        } else {
            dt = ORMConfiguration.innerGetDataEntityType(entityName, this.ctx.getEntityTypeCache());
        }
        DBRoute dbRoute = new DBRoute(dt.getDBRouteKey());
        MultiQuery mq = MultiQuery.create(dbRoute, dt, "id", false, new QFilter[]{filter}, null, null, null, -1, 0, -1, this.ctx.getEntityTypeCache(), this.ctx.getORMHint(), new ORMOptimization(), null);
        return mq;
    }

    private void setMultiTypeBaseDataType(String property, EntityItem entityItem, String fullObjectName, QFilter filter, MultiBaseDataFilterValue value) {
        IDataEntityProperty propertyType = entityItem.getPropertyItem(property).getPropertyType();
        try {
            String typeName = ORMUtil.getFullTypeName(propertyType, fullObjectName, this.ctx);
            filter.addFirstNest(new QFilter(typeName, "=", value.getBaseDataName()), "AND");
        }
        catch (Exception e) {
            logger.error("get multitypebasedata type error", (Throwable)e);
        }
    }
}

