/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.optimize;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bdsync.BDSyncFactory;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.db.tx.JoinInSameDBStrategy;
import kd.bos.orm.query.JoinInSameDBStrategyCtrl;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.orm.query.optimize.BlinkingTurner;
import kd.bos.orm.query.optimize.JoinDBTodo;
import kd.bos.orm.query.optimize.QueryTreeNode;
import kd.bos.orm.query.optimize.QueryTreeNodeVisitor;

public class PrepareJoinDB {
    static DBConfig remainRW_DBConfig(Set<DBConfig> dbConfigSet) {
        for (DBConfig conf : new HashSet<DBConfig>(dbConfigSet)) {
            if (!conf.isReadOnly()) continue;
            dbConfigSet.remove(conf);
        }
        return dbConfigSet.iterator().next();
    }

    static String formatRouteKey(String routeKey) {
        return (routeKey == null ? "" : routeKey).toLowerCase();
    }

    public static List<DBConfig> getParentSharings(SingleQuery parentQuery, SingleQuery query) {
        Set<DBConfig> parentConfs = parentQuery.getDBConfigSet();
        Set<DBConfig> confs = query.getDBConfigSet();
        ArrayList<DBConfig> parentSharing = new ArrayList<DBConfig>();
        block0: for (DBConfig parentConf : parentConfs) {
            for (DBConfig conf : confs) {
                if (!parentConf.canSharing(conf)) continue;
                parentSharing.add(parentConf);
                continue block0;
            }
        }
        return parentSharing;
    }

    public static void prepare(QueryTreeNode root) {
        JoinInSameDBStrategy first = JoinInSameDBStrategyCtrl.first();
        if (first != JoinInSameDBStrategy.no_join) {
            PrepareJoinDB.prepareDB(root);
            if (first == JoinInSameDBStrategy.join_rw_first) {
                PrepareJoinDB.prepare_join_rw_first(root);
            } else {
                PrepareJoinDB.prepare_join_r_first(root);
            }
            JoinInSameDBStrategy second = JoinInSameDBStrategyCtrl.second();
            if (second != JoinInSameDBStrategy.no_join) {
                if (second == JoinInSameDBStrategy.join_rw_first) {
                    PrepareJoinDB.prepare_join_rw_first(root);
                } else {
                    PrepareJoinDB.prepare_join_r_first(root);
                }
            }
        }
    }

    private static void prepareDB(QueryTreeNode root) {
        RequestContext rc = RequestContext.get();
        final String tenantId = rc.getTenantId();
        final String accountId = rc.getAccountId();
        root.accept(new QueryTreeNodeVisitor(){

            @Override
            public void visit(QueryTreeNode node) {
                SingleQuery query = node.getQuery();
                boolean isBDSync = false;
                QueryTreeNode parentNode = node.getParent();
                DBRoute parentRoute = null;
                if (parentNode != null) {
                    parentRoute = parentNode.getQuery().getDBRoute();
                    String entityNumber = query.getDataEntityType().getName();
                    isBDSync = BDSyncFactory.getBDSync().isAvailable(entityNumber, parentRoute);
                }
                if (isBDSync) {
                    query.setDBRoute(parentRoute);
                    query.setDBConfigSet(parentNode.getQuery().getDBConfigSet());
                } else {
                    Set<String> tables = query.getTables(true, true, true, true);
                    Set dbConfigSet = DataSourceFactory.getDBConfigs((String)tenantId, (String)query.getDBRoute().getRouteKey(), (String)accountId, (String[])tables.toArray(new String[tables.size()]));
                    query.setDBConfigSet(dbConfigSet);
                }
                for (QueryTreeNode subNode : node.getChildren()) {
                    subNode.accept(this);
                }
            }
        });
    }

    private static void prepare_join_rw_first(QueryTreeNode root) {
        BlinkingTurner.turnDBRoute(root);
    }

    private static void prepare_join_r_first(QueryTreeNode root) {
        JoinDBTodo.test();
        root.accept(new QueryTreeNodeVisitor(){

            @Override
            public void visit(QueryTreeNode node) {
                if (node.getParent() != null) {
                    SingleQuery query;
                    SingleQuery parentQuery = node.getParent().getQuery();
                    List<DBConfig> parentSharing = PrepareJoinDB.getParentSharings(parentQuery, query = node.getQuery());
                    if (parentSharing.size() > 1) {
                        for (DBConfig conf : new ArrayList<DBConfig>(parentSharing)) {
                            if (conf.isReadOnly()) continue;
                            parentSharing.remove(conf);
                            break;
                        }
                    }
                    if (!parentSharing.isEmpty()) {
                        parentQuery.setDBConfigSet(new HashSet<DBConfig>(parentSharing));
                        query.setDBConfigSet(new HashSet<DBConfig>(parentSharing));
                        query.setDBRoute(query.getDBRoute().copy(parentQuery.getDBRoute().getRouteKey()));
                    }
                }
                for (QueryTreeNode subNode : node.getChildren()) {
                    subNode.accept(this);
                }
            }
        });
    }
}

