/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.optimize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.algo.DataSet;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.bundle.BosRes;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.PeekingDataSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.config.ORMConfig;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.multi.JoinTableInfo;
import kd.bos.orm.query.multi.OrderByInfo;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.multi.QueryUtils;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.orm.query.optimize.OptimizeOnCostDownDataSet;
import kd.bos.orm.query.optimize.OptimizeOnCostUpDataSet;
import kd.bos.orm.query.optimize.QueryOptimizater;
import kd.bos.orm.query.optimize.QueryTreeNode;
import kd.bos.orm.query.optimize.QueryTreeNodeVisitor;
import kd.bos.orm.util.StringUtils;

class QueryOptimizeMate {
    private QueryOptimizater qo;
    private static Log logger = LogFactory.getLog(QueryOptimizeMate.class);

    QueryOptimizeMate(QueryOptimizater qo) {
        this.qo = qo;
    }

    boolean withRoleOnPK(QueryTreeNode root) {
        if (!this.qo.opt.isRoleOnPK()) {
            return false;
        }
        final AtomicBoolean effectRole = new AtomicBoolean(false);
        QueryTreeNodeVisitor visitor = new QueryTreeNodeVisitor(){

            @Override
            public void visit(QueryTreeNode node) {
                SingleQuery query = node.getQuery();
                boolean effectOnMe = query.withWhereFilter();
                if (effectOnMe) {
                    Set filterPropertySet = QueryOptimizeMate.this.getFilterPropertySet(query.getFullObjName(), query.getWhereFilter());
                    String pkPropertyFieldName = query.getFullObjName().toLowerCase() + '.' + query.getDataEntityType().getPrimaryKey().getName().toLowerCase();
                    effectOnMe = filterPropertySet.contains(pkPropertyFieldName);
                }
                if (effectOnMe) {
                    node.setPkRoleOn(true);
                    if (!effectRole.get()) {
                        effectRole.set(true);
                    }
                } else {
                    for (QueryTreeNode child : node.getChildren()) {
                        child.accept(this);
                    }
                }
            }
        };
        root.accept(visitor);
        return effectRole.get();
    }

    boolean withRoleOnCost(QueryTreeNode root) {
        if (!this.qo.opt.isRoleOnCost()) {
            return false;
        }
        AtomicBoolean withRoleOnCost = new AtomicBoolean();
        if (root.canRoleOnCostIfRoot() && root.getQuery().withWhereFilter()) {
            this.tryRoleOnCost(root, true, withRoleOnCost);
        } else {
            for (QueryTreeNode child : root.getChildren()) {
                this.tryRoleOnCost(child, true, withRoleOnCost);
            }
            if (!withRoleOnCost.get()) {
                this.tryRoleOnCost(root, false, withRoleOnCost);
            }
        }
        return withRoleOnCost.get();
    }

    private void tryRoleOnCost(QueryTreeNode node, boolean recursive, AtomicBoolean withRoleOnCost) {
        if (node.getQuery().withWhereFilter()) {
            node.setCostRoleOn(true);
            withRoleOnCost.set(true);
        }
        if (recursive) {
            for (QueryTreeNode child : node.getChildren()) {
                this.tryRoleOnCost(child, recursive, withRoleOnCost);
            }
        }
    }

    List<PropertyField> moveUpField(QueryTreeNode node, AtomicBoolean optimized) {
        boolean moveUp;
        ArrayList<PropertyField> ret = new ArrayList<PropertyField>();
        for (QueryTreeNode subNode : new ArrayList<QueryTreeNode>(node.getChildren())) {
            List<PropertyField> subRet = this.moveUpField(subNode, optimized);
            ret.addAll(subRet);
        }
        boolean bl = moveUp = ret.size() == 0 && node.isLeaf() && node.getParent() != null;
        if (moveUp) {
            SingleQuery query = node.getQuery();
            EntityItem ei = this.qo.allCtx.getEntityItem(query.getFullObjName());
            PropertyField[] fields = query.getSelectFields();
            boolean bl2 = moveUp = !query.getCtx().isInnerJoinEntityItem(ei) && fields.length == 1;
            if (moveUp) {
                boolean bl3 = moveUp = query.getGroupByInfoList().size() == 0 && query.getCurFilterObjSet().size() == 1;
            }
            if (moveUp) {
                PropertyField pkPropertyField = fields[0];
                String string = query.getDataEntityType().getPrimaryKey().getAlias();
                if (string.equalsIgnoreCase(pkPropertyField.getField())) {
                    String pkPropertyFieldName = pkPropertyField.getParentFullName().toLowerCase();
                    Set<String> filterPropertySet = this.getFilterPropertySet(query.getFullObjName(), query.getWhereFilter());
                    boolean bl4 = moveUp = filterPropertySet.size() == 0 || filterPropertySet.size() == 1 && filterPropertySet.contains(pkPropertyFieldName);
                    if (moveUp) {
                        Set<String> orderByPropertySet = this.getOrderByPropertySet(query.getOrderInfoList());
                        boolean bl5 = moveUp = orderByPropertySet.size() == 0 || orderByPropertySet.size() == 1 && orderByPropertySet.contains(pkPropertyFieldName);
                    }
                    if (moveUp) {
                        boolean usingPKjoin = true;
                        if (query.getJoinOnFilter() != null) {
                            String joinProperty = String.valueOf(query.getJoinOnFilter().getValue());
                            if (!pkPropertyField.getAlias().equalsIgnoreCase(joinProperty)) {
                                usingPKjoin = false;
                            }
                        }
                        if (!usingPKjoin) {
                            moveUp = false;
                        }
                    }
                    if (moveUp) {
                        List<OrderByInfo> orderByList;
                        QFilter filter;
                        if (!optimized.get()) {
                            optimized.set(true);
                        }
                        QueryTreeNode parentNode = node.getParent();
                        node.removeFromParentIncludeField();
                        String fkName = ei.joinProperty.getParentOriginProperty().getName();
                        PropertyField fkField = new PropertyField(ei.joinProperty.getParentEntityItem().getFullObjectName(), fkName, pkPropertyField.getAlias());
                        if (!fkField.isInnerField()) {
                            ret.add(fkField);
                        }
                        if ((filter = query.getWhereFilter()) != null) {
                            String filterProperty = fkField.getParentFullName();
                            filter.__setProperty(filterProperty);
                            for (QFilter.QFilterNest next : filter.getNests(true)) {
                                next.getFilter().__setProperty(filterProperty);
                            }
                            query.getAllWhereFilterMap().remove(query.getFullObjName());
                            String parentFullObjectName = fkField.getFullObjectName();
                            QFilter parentFilter = query.getAllWhereFilterMap().get(parentFullObjectName);
                            parentFilter = parentFilter == null ? filter : parentFilter.and(filter);
                            query.getAllWhereFilterMap().put(parentFullObjectName, parentFilter);
                        }
                        if ((orderByList = query.getOrderInfoList()) != null && orderByList.size() > 0) {
                            for (OrderByInfo orderBy : orderByList) {
                                orderBy.replaceWhenOneProperty(fkField);
                            }
                        }
                        parentNode.setQuery(parentNode.getQuery().optRebuild());
                    }
                }
            }
        }
        if (!moveUp && ret.size() > 0) {
            PropertyField[] fields = node.getQuery().getSelectFields();
            String pkName = node.getQuery().getDataEntityType().getPrimaryKey().getName().toLowerCase(Locale.ENGLISH);
            HashSet<String> subNodeFKNameSet = new HashSet<String>(node.getChildren().size());
            for (QueryTreeNode queryTreeNode : node.getChildren()) {
                EntityItem ei = this.qo.allCtx.getEntityItem(queryTreeNode.getQuery().getFullObjName());
                String fkName = this.getPKName(ei, queryTreeNode.getQuery(), node.getQuery());
                subNodeFKNameSet.add(fkName.toLowerCase());
            }
            ArrayList<PropertyField> removedInner = new ArrayList<PropertyField>();
            for (PropertyField field : fields) {
                if (!field.isInnerField() || pkName.equals(field.getName().toLowerCase(Locale.ENGLISH)) || subNodeFKNameSet.contains(field.getName().toLowerCase())) continue;
                removedInner.add(field);
            }
            SingleQuery singleQuery = node.getQuery().optMergeFields(ret, removedInner);
            node.setQuery(singleQuery);
            ret.clear();
        }
        return ret;
    }

    private Set<String> getFilterPropertySet(String fullObjName, QFilter filter) {
        HashSet<String> propertySet = new HashSet<String>();
        if (filter != null) {
            String pname = filter.getProperty();
            if (pname.indexOf(46) == -1) {
                pname = fullObjName + '.' + pname;
            }
            propertySet.add(pname.toLowerCase());
            for (QFilter.QFilterNest next : filter.getNests(true)) {
                pname = next.getFilter().getProperty();
                if (pname.indexOf(46) == -1) {
                    pname = fullObjName + '.' + pname;
                }
                propertySet.add(pname.toLowerCase());
            }
        }
        return propertySet;
    }

    private Set<String> getOrderByPropertySet(List<OrderByInfo> orderList) {
        HashSet<String> propertySet = new HashSet<String>();
        if (orderList != null) {
            for (OrderByInfo oi : orderList) {
                for (String fullPropertyName : oi.getPropertySegExpress().getFullPropertyNames()) {
                    propertySet.add(fullPropertyName.toLowerCase());
                }
            }
        }
        return propertySet;
    }

    void queryWithRoleDown(String algoKey, QueryTreeNode node, int roleDownThreshold) {
        PeekingDataSet pds = node.getPeekingDataSet();
        if (pds == null) {
            OptimizeOnCostDownDataSet dataSet;
            PeekingDataSet parent_pds;
            boolean pendding = true;
            boolean parentDataSetIsNotNull = false;
            if (node.isCostRoleOn()) {
                pendding = false;
            }
            PeekingDataSet peekingDataSet = parent_pds = node.getParent() == null ? null : node.getParent().getPeekingDataSet();
            if (parent_pds != null) {
                parentDataSetIsNotNull = true;
                if (!node.getParent().isLazyQuery() && parent_pds.getPeekingRowCount() < roleDownThreshold) {
                    PropertyField field;
                    pendding = false;
                    SingleQuery query = node.getQuery();
                    EntityItem ei = query.getAllCtx().getEntityItem(query.getFullObjName());
                    String fkName = ei.joinProperty.getParentOriginProperty().getName().toLowerCase(Locale.ENGLISH);
                    String fkAlias = null;
                    PropertyField[] propertyFieldArray = node.getParent().getQuery().getSelectFields();
                    int n = propertyFieldArray.length;
                    for (int i = 0; !(i >= n || ((field = propertyFieldArray[i]).getName().equalsIgnoreCase(fkName) || ("INNER_" + fkName).equalsIgnoreCase(field.getAlias())) && (fkAlias = field.getAlias()) != null && fkAlias.equalsIgnoreCase(query.getParentFK())); ++i) {
                    }
                    if (fkAlias == null) {
                        throw new RuntimeException(BosRes.get((String)"bos-ormengine", (String)"QueryOptimizeMate_2", (String)"{0}#{1}the property of related object is not in the selectFields:{2}#{3}", (Object[])new Object[]{query.getFullObjName(), fkName, node.getParent().getQuery().getFullObjName(), node.getParent().getQuery().getSelectFields()}));
                    }
                    HashSet fkValueSet = new HashSet();
                    Iterator iter = parent_pds.peekingRowFieldIterator(fkAlias);
                    while (iter.hasNext()) {
                        Object fkValue = iter.next();
                        if (fkValue == null) continue;
                        fkValueSet.add(fkValue);
                    }
                    String pkName = query.getDataEntityType().getPrimaryKey().getName().toLowerCase();
                    QFilter filter = query.getWhereFilter();
                    boolean isMulTypeBasedata = ORMUtil.isMulTypeBasedata(fkName, ei);
                    String downFullName = QueryUtils.getDownFullName(filter, query.getFullObjName(), pkName, isMulTypeBasedata);
                    QFilter addFilter = new QFilter(downFullName, "in", fkValueSet);
                    boolean optimizedFakeFilter = false;
                    if (filter == null) {
                        filter = addFilter;
                        if (fkValueSet.size() == 1) {
                            Class pkCls;
                            Object pk = fkValueSet.iterator().next();
                            optimizedFakeFilter = pk == null ? true : ((pkCls = query.getDataEntityType().getPrimaryKey().getPropertyType()) == String.class ? " ".equals(pk) : String.valueOf(0).equals(String.valueOf(pk)));
                        }
                    } else {
                        filter = filter.and(addFilter);
                    }
                    query = query.optResetFilter(filter);
                    query.setEmptyQuery(optimizedFakeFilter);
                    node.setQuery(query);
                    node.setBeenPushed();
                }
            }
            DataSet origionDataSet = null;
            boolean isLazyQuery = this.isLazyQuery(node, parentDataSetIsNotNull);
            if (!pendding) {
                if (isLazyQuery) {
                    origionDataSet = node.getParent().getPeekingDataSet().getDataSet();
                    dataSet = new OptimizeOnCostDownDataSet(origionDataSet.copy(), node);
                    node.setPeekingDataSet(new PeekingDataSet("optimizeOnCost", new ArrayList(2), (DataSet)dataSet));
                    node.setLazyQuery();
                    node.setBeenPushed();
                } else {
                    pds = node.queryPeeking(algoKey, roleDownThreshold);
                    node.setPeekingDataSet(pds);
                }
            } else if (isLazyQuery) {
                origionDataSet = node.getParent().getPeekingDataSet().getDataSet();
                dataSet = new OptimizeOnCostDownDataSet(origionDataSet.copy(), node);
                node.setPeekingDataSet(new PeekingDataSet("optimizeOnCost", new ArrayList(2), (DataSet)dataSet));
                node.setLazyQuery();
                node.setBeenPushed();
            }
            DataSet rootDataSet = this.getRootDataSet(node);
            if (isLazyQuery && rootDataSet != null && origionDataSet != null) {
                final DataSet finalOrigionDataSet = origionDataSet;
                rootDataSet.addListener(new DataSet.Listener(){

                    public void afterClosed() {
                        if (finalOrigionDataSet != null) {
                            finalOrigionDataSet.close();
                        }
                    }
                });
            }
        }
        for (QueryTreeNode subNode : node.getChildren()) {
            this.queryWithRoleDown(algoKey, subNode, roleDownThreshold);
        }
    }

    int queryWithRoleUp(String algoKey, QueryTreeNode parentNode, boolean routeUpRoot, boolean peek) {
        if (parentNode == null || !routeUpRoot && parentNode.getParent() == null) {
            return 0;
        }
        List<QueryTreeNode> childrenNodes = parentNode.getChildren();
        if (childrenNodes.size() == 0) {
            if (parentNode.isCostRoleOn() && parentNode.getPeekingDataSet() == null) {
                PeekingDataSet pds = parentNode.queryPeeking(algoKey, this.qo.roleOnCostThreshold);
                parentNode.setPeekingDataSet(pds);
            }
            this.queryWithRoleUp(algoKey, parentNode.getParent(), routeUpRoot, peek);
            return 0;
        }
        int roleUpCount = 0;
        if (parentNode.getPeekingDataSet() == null) {
            boolean pending = true;
            SingleQuery parentQuery = parentNode.getQuery();
            HashMap<String, DataSet> canPushDataSets = new HashMap<String, DataSet>(2);
            HashMap<String, SingleQuery> querys = new HashMap<String, SingleQuery>(2);
            ArrayList<AbstractDataSet> dataSets = new ArrayList<AbstractDataSet>(2);
            final ArrayList<DataSet> origionDataSets = new ArrayList<DataSet>(2);
            for (QueryTreeNode childrenNode : childrenNodes) {
                boolean canPush;
                PeekingDataSet pds = childrenNode.getPeekingDataSet();
                boolean bl = canPush = pds != null && (childrenNode.isWithOriginFilter() || childrenNode.isWithInnerJoin());
                if (canPush && !childrenNode.isLazyQuery() && pds.getPeekingRowCount() < this.qo.roleOnCostThreshold) {
                    pending = false;
                    SingleQuery childrenQuery = childrenNode.getQuery();
                    EntityItem ei = childrenQuery.getAllCtx().getEntityItem(childrenQuery.getFullObjName());
                    String pkName = ei.entityType.getPrimaryKey().getName().toLowerCase(Locale.ENGLISH);
                    String pkAlias = null;
                    int indexFlag = -1;
                    for (PropertyField field : childrenQuery.getSelectFields()) {
                        ++indexFlag;
                        if (!field.getName().toLowerCase(Locale.ENGLISH).equals(pkName) || !field.getFullObjectName().equalsIgnoreCase(childrenQuery.getFullObjName())) continue;
                        pkAlias = field.getAlias();
                        break;
                    }
                    int pkFieldIndex = -1;
                    if (ORMConfig.ENABLE_USEFIELDINDEX.getBoolean(RequestContext.get().getTenantId())) {
                        pkFieldIndex = StringUtils.isEmpty(pkAlias) ? -1 : indexFlag;
                    }
                    HashSet<Object> pkValueSet = new HashSet<Object>();
                    Iterator iter = pds.peekingRowFieldIterator(pkAlias, pkFieldIndex);
                    while (iter.hasNext()) {
                        Object fkValue = iter.next();
                        if (fkValue == null) continue;
                        pkValueSet.add(fkValue);
                    }
                    String downFullName = QueryUtils.getUpFullName(childrenQuery, parentQuery);
                    int dot = downFullName.indexOf(46);
                    if (dot != -1) {
                        downFullName = downFullName.substring(dot + 1);
                    }
                    QFilter addFilter = QueryUtils.generateRoleUpCP(parentQuery, childrenQuery, downFullName, pkValueSet);
                    this.setInnerJoinCondition(parentQuery, downFullName, addFilter);
                    QFilter filter = parentQuery.getWhereFilter();
                    filter = filter == null ? addFilter : QueryUtils.generateRoleUpQFilter(filter, addFilter);
                    parentQuery = parentQuery.optResetFilter(filter);
                    parentNode.setQuery(parentQuery);
                    parentNode.setBeenPushed();
                    childrenNode.setPushUp();
                    ++roleUpCount;
                    continue;
                }
                if (ORMUtil.optimizeOnCostEnable(this.qo.allCtx) && !ORMUtil.hasOrderFields(childrenNode) && canPush && (this.canOptimizeOnCost(childrenNode.getQuery().getWhereFilter()) || childrenNode.isBeenPushed())) {
                    DataSet origionDataSet = childrenNode.getPeekingDataSet().getDataSet();
                    DataSet copyDataSet = origionDataSet.copy();
                    String fullObjName = childrenNode.getQuery().getFullObjName();
                    canPushDataSets.put(fullObjName, copyDataSet);
                    querys.put(fullObjName, childrenNode.getQuery());
                    dataSets.add((AbstractDataSet)copyDataSet);
                    origionDataSets.add(origionDataSet);
                    parentNode.setBeenPushed();
                    childrenNode.setPushUp();
                    ++roleUpCount;
                    continue;
                }
                if (!routeUpRoot || peek || childrenNode.isWithOriginFilter() || childrenNode.isWithInnerJoin()) continue;
                ++roleUpCount;
            }
            if (!pending && peek) {
                PeekingDataSet pds = parentNode.queryPeeking(algoKey, this.qo.roleOnCostThreshold);
                parentNode.setPeekingDataSet(pds);
            } else if (ORMUtil.optimizeOnCostEnable(this.qo.allCtx) && !ORMUtil.hasOrderFields(parentNode) && canPushDataSets.size() > 0) {
                OptimizeOnCostUpDataSet dataSet = new OptimizeOnCostUpDataSet(canPushDataSets, querys, dataSets, parentNode, this.qo);
                parentNode.setPeekingDataSet(new PeekingDataSet("optimizeOnCost", new ArrayList(), (DataSet)dataSet));
                parentNode.setLazyQuery();
                DataSet rootDataSet = this.getRootDataSet(parentNode);
                if (rootDataSet != null) {
                    rootDataSet.addListener(new DataSet.Listener(){

                        public void afterClosed() {
                            for (DataSet origionDataSet : origionDataSets) {
                                if (origionDataSet == null) continue;
                                origionDataSet.close();
                            }
                        }
                    });
                }
            }
        }
        this.queryWithRoleUp(algoKey, parentNode.getParent(), routeUpRoot, peek);
        return roleUpCount;
    }

    private String getPKName(EntityItem ei, SingleQuery childrenQuery, SingleQuery parentQuery) {
        return ei.joinProperty.getParentOriginProperty().getName();
    }

    DataSet joinAll(QueryTreeNode node, Map<QueryTreeNode, DataSet> dsMap) {
        this.shouldForceInnerJoin(node);
        return this.doJoinAll(node, dsMap);
    }

    private DataSet doJoinAll(QueryTreeNode node, Map<QueryTreeNode, DataSet> dsMap) {
        DataSet ds = dsMap.get(node);
        if (node.isLeaf()) {
            return ds;
        }
        List<QueryTreeNode> children = node.getChildren();
        ArrayList<SingleQuery> childrenQuery = new ArrayList<SingleQuery>(children.size());
        ArrayList<DataSet> childrenDS = new ArrayList<DataSet>(children.size());
        boolean hashJoinMultiEntriesEnable = ORMConfig.HASHJOIN_MULTI_ENTRIES_ENABLE.getBoolean(RequestContext.get().getTenantId());
        boolean isChildDSHasMultiRows = false;
        for (QueryTreeNode child : children) {
            if (hashJoinMultiEntriesEnable && child.getQuery().getTableToEntity() != null && child.getQuery().getTableToEntity().size() > 1) {
                for (JoinTableInfo joinTableInfo : child.getQuery().getCtx().getJoinTableList()) {
                    IDataEntityType entityType = joinTableInfo.getEntityItem().entityType;
                    if (!ORMConfiguration.isEntryEntityType(entityType) && !ORMConfiguration.isSubEntityType(entityType) && !ORMConfiguration.isMulBasedata(entityType)) continue;
                    isChildDSHasMultiRows = true;
                    break;
                }
            }
            childrenQuery.add(child.getQuery());
            childrenDS.add(this.doJoinAll(child, dsMap));
        }
        return ORMUtil.hashJoins(ds, node.getQuery(), node.getQuery().getSelectFieldAlias(), childrenDS, childrenQuery, isChildDSHasMultiRows);
    }

    private boolean shouldForceInnerJoin(QueryTreeNode root) {
        if (!root.isLeaf()) {
            for (QueryTreeNode child : root.getChildren()) {
                if (!this.shouldForceInnerJoin(child)) continue;
                root.getQuery().forceInnerJoin();
            }
        }
        return root.getQuery().isInnerJoin();
    }

    private void setInnerJoinCondition(SingleQuery parentQuery, String downFullName, QFilter addFilter) {
        if (!ORMUtil.useInnerJoin(parentQuery.getAllCtx().getORMHint())) {
            return;
        }
        if (parentQuery.getAllCtx().isAllAndQFilter()) {
            int valueSize;
            String cp = addFilter.getCP();
            if (("in".equalsIgnoreCase(cp) || "not in".equalsIgnoreCase(cp)) && (valueSize = ORMUtil.getValueSize(addFilter.getValue())) > ORMConfig.INNER_JOIN_IN_SIZE.getInt()) {
                return;
            }
            int index = downFullName.lastIndexOf(".");
            Map<String, QFilter> allJoinFilters = parentQuery.getAllJoinFilterMap();
            QContext allContext = parentQuery.getAllCtx();
            String rootName = allContext.getMainEntityItem().getFullObjectName();
            if (index > 0) {
                String subQueryFullName = rootName + "." + downFullName.substring(0, index);
                IDataEntityType entityType = allContext.getEntityItem((String)subQueryFullName).entityType;
                String propertyName = downFullName.substring(index + 1);
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)entityType.getProperties().get((Object)propertyName);
                String tableGroup = null;
                if (iDataEntityProperty != null) {
                    tableGroup = iDataEntityProperty.getTableGroup();
                }
                if ("kd.bos.entity.EntryType".equals(entityType.getClass().getName())) {
                    QFilter filter = tableGroup != null && tableGroup.length() > 0 ? allJoinFilters.get(subQueryFullName.toLowerCase() + "_" + tableGroup) : allJoinFilters.get(subQueryFullName.toLowerCase());
                    if (filter != null) {
                        filter.and(addFilter.__copy(false));
                        addFilter.maskCurrent();
                    }
                } else {
                    QFilter filter = tableGroup != null && tableGroup.length() > 0 ? allJoinFilters.get((rootName + "." + downFullName + "_" + tableGroup).toLowerCase()) : allJoinFilters.get((rootName + "." + downFullName).toLowerCase());
                    if (filter != null) {
                        filter.and(addFilter.__copy(false));
                        addFilter.maskCurrent();
                    }
                }
            } else {
                String key;
                QFilter filter;
                IDataEntityProperty propertyType = allContext.getEntityItem(rootName).getPropertyItem(downFullName).getPropertyType();
                String tableGroup = propertyType.getTableGroup();
                if (tableGroup != null && tableGroup.length() > 0 && (filter = allJoinFilters.get((key = rootName + "_" + tableGroup).toLowerCase())) != null) {
                    filter.and(addFilter.__copy(false));
                    addFilter.maskCurrent();
                }
            }
        }
    }

    private boolean isLazyQuery(QueryTreeNode node, boolean parentDataSetIsNotNull) {
        return ORMUtil.optimizeOnCostEnable(this.qo.allCtx) && !ORMUtil.hasOrderFields(node) && !node.getQuery().withWhereFilter() && parentDataSetIsNotNull && !node.isBeenPushed() && (this.canOptimizeOnCost(node.getParent().getQuery().getWhereFilter()) || node.getParent().isBeenPushed());
    }

    private boolean canOptimizeOnCost(QFilter filter) {
        if (filter == null) {
            return false;
        }
        if (!ORMConfig.OPTIMIZE_ON_COST_JUDGEFILTER.getBoolean()) {
            return true;
        }
        List<QFilter.QFilterNest> nests = filter.getNests(false);
        if (nests != null && nests.size() > 0) {
            for (QFilter.QFilterNest nest : nests) {
                if (nest.isAnd()) continue;
                return false;
            }
        } else {
            String cp = filter.getCP().trim();
            if ("is not null".equalsIgnoreCase(cp) || "!=".equalsIgnoreCase(cp) || "<>".equalsIgnoreCase(cp) || "not in".equalsIgnoreCase(cp) || "not like".equalsIgnoreCase(cp)) {
                return false;
            }
        }
        return true;
    }

    private DataSet getRootDataSet(QueryTreeNode node) {
        QueryTreeNode parent;
        QueryTreeNode current = node;
        while ((parent = current.getParent()) != null) {
            current = parent;
        }
        PeekingDataSet peekingDataSet = current.getPeekingDataSet();
        if (peekingDataSet != null) {
            return peekingDataSet.getDataSet();
        }
        return null;
    }
}

