/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.optimize;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bundle.BosRes;
import kd.bos.db.PeekingDataSet;
import kd.bos.orm.ORMHint;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.EntityItem;
import kd.bos.orm.query.EntityItemJoinProperty;
import kd.bos.orm.query.QContext;
import kd.bos.orm.query.cache.CacheQueryObjects;
import kd.bos.orm.query.cache.QueryHashJoinDataSetContext;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.orm.query.optimize.QueryTreeNodeDeepVisitor;
import kd.bos.orm.query.optimize.QueryTreeNodeVisitor;

public final class QueryTreeNode {
    private SingleQuery query;
    private QueryTreeNode parent;
    private List<QueryTreeNode> children = new ArrayList<QueryTreeNode>();
    private boolean canRoleOnCostIfRoot;
    private boolean pkRoleOn;
    private boolean costRoleOn;
    private boolean withOriginFilter;
    private boolean withInnerJoin;
    private boolean pushUp = false;
    private boolean hasBeenPushed = false;
    private PeekingDataSet peekingDataSet;
    private boolean lazyQuery = false;

    public static QueryTreeNode create(SingleQuery[] queries) {
        final QueryTreeNode root = new QueryTreeNode(queries[0]);
        int n = queries.length;
        for (int i = 1; i < n; ++i) {
            root.addNode(new QueryTreeNode(queries[i]));
        }
        root.accept(new QueryTreeNodeDeepVisitor(){

            @Override
            protected void deepFirstVisit(QueryTreeNode node) {
                if (node.getQuery().withWhereFilter()) {
                    node.withOriginFilter = true;
                } else if (node != root) {
                    for (QueryTreeNode child : node.getChildren()) {
                        if (!child.withOriginFilter) continue;
                        node.withOriginFilter = true;
                        break;
                    }
                    SingleQuery joinedNodeQuery = node.getQuery();
                    String joinEntityPath = ORMUtil.getFullObjNameWithoutRoot(joinedNodeQuery.getFullObjName());
                    ORMHint ormHint = joinedNodeQuery.getAllCtx().getORMHint();
                    ORMHint.JoinHint joinHint = ormHint.joinHint(joinEntityPath, joinedNodeQuery.isInnerJoin() ? ORMHint.JoinHint.INNER : ORMHint.JoinHint.DEFAULT);
                    if (joinHint == ORMHint.JoinHint.INNER) {
                        node.withInnerJoin = true;
                    } else {
                        for (QueryTreeNode child : node.getChildren()) {
                            if (!child.withInnerJoin) continue;
                            node.withInnerJoin = true;
                            break;
                        }
                    }
                }
            }
        });
        return root;
    }

    private QueryTreeNode(SingleQuery query) {
        this.setQuery(query);
    }

    public boolean isWithOriginFilter() {
        return this.withOriginFilter;
    }

    public boolean isWithInnerJoin() {
        return this.withInnerJoin;
    }

    public void setQuery(SingleQuery query) {
        this.query = query;
        this.canRoleOnCostIfRoot = ORMConfiguration.isBasedata(query.getDataEntityType());
    }

    private void addNode(QueryTreeNode node) {
        QContext allCtx = node.getQuery().getAllCtx();
        if (!this.addNode(node, this, allCtx)) {
            throw new RuntimeException(BosRes.get((String)"bos-ormengine", (String)"QueryTreeNode_0", (String)"The parent node of the current node {0} is null.", (Object[])new Object[]{node.getQuery().getFullObjName()}));
        }
    }

    private boolean addNode(QueryTreeNode node, QueryTreeNode root, QContext allCtx) {
        EntityItem ei;
        String name;
        String rootName = root.getQuery().getFullObjName();
        String pname = name = node.getQuery().getFullObjName();
        boolean anotherRoot = false;
        do {
            int dot;
            if ((dot = pname.lastIndexOf(46)) != -1) {
                pname = pname.substring(0, dot);
                continue;
            }
            anotherRoot = true;
        } while ((ei = allCtx.getEntityItem(pname)) == null || ORMConfiguration.isEntryEntityType(ei.entityType));
        if (rootName.equals(pname) || anotherRoot && allCtx.getEntityItem((String)pname).joinProperty.getParentEntityItem().getFullObjectName().equals(rootName) || this.parentIsEntry(allCtx, pname, rootName, anotherRoot)) {
            root.getChildren().add(node);
            node.parent = root;
            return true;
        }
        for (QueryTreeNode sub : root.getChildren()) {
            if (!this.addNode(node, sub, allCtx)) continue;
            return true;
        }
        return false;
    }

    private boolean parentIsEntry(QContext ctx, String pname, String rootName, boolean anotherRoot) {
        if (!anotherRoot) {
            return false;
        }
        EntityItem entityItem = ctx.getEntityItem(pname);
        if (entityItem == null) {
            return false;
        }
        EntityItemJoinProperty joinProperty = entityItem.joinProperty;
        if (joinProperty == null) {
            return false;
        }
        EntityItem parentEntityItem = joinProperty.getParentEntityItem();
        if (parentEntityItem == null) {
            return false;
        }
        EntityItem parentParentEntity = parentEntityItem.getParentEntityItem();
        if (parentParentEntity == null) {
            return false;
        }
        if (ORMConfiguration.isSubEntityType(parentEntityItem.entityType) && parentParentEntity.getParentEntityItem().getFullObjectName().equals(rootName)) {
            return true;
        }
        return ORMConfiguration.isEntryEntityType(parentEntityItem.entityType) && parentParentEntity.getFullObjectName().equals(rootName);
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public SingleQuery getQuery() {
        return this.query;
    }

    public PeekingDataSet queryPeeking(String algoKey, int peekingSize) {
        if (this.parent != null && QueryHashJoinDataSetContext.isLazyQueryEnable()) {
            if (!this.hasBeenPushed && QueryHashJoinDataSetContext.isCacheEnable()) {
                CacheQueryObjects cacheQueryObjects = this.query.getCtx().getORMHint().getCacheQueryObjects();
                boolean useCache = false;
                for (String objName : this.query.getCtx().getCurrentSelectObjectSet()) {
                    if (!cacheQueryObjects.hasHint(objName)) continue;
                    useCache = true;
                    break;
                }
                if (useCache) {
                    PeekingDataSet pds = cacheQueryObjects.getCache(this.query.getFullObjName());
                    if (pds == null) {
                        pds = this.query.queryPeekingForLazyHashJoin(algoKey, peekingSize);
                        cacheQueryObjects.setCache(this.query.getFullObjName(), pds);
                    }
                    return pds;
                }
            }
            return this.query.queryPeekingForLazyHashJoin(algoKey, peekingSize);
        }
        return this.query.queryPeeking(algoKey, peekingSize);
    }

    public List<QueryTreeNode> getChildren() {
        return this.children;
    }

    public QueryTreeNode getParent() {
        return this.parent;
    }

    public boolean canRoleOnCostIfRoot() {
        return this.canRoleOnCostIfRoot;
    }

    public void setCanRoleOnCostIfRoot(boolean canRoleOnCostIfRoot) {
        this.canRoleOnCostIfRoot = canRoleOnCostIfRoot;
    }

    public SingleQuery[] toQueries() {
        ArrayList<SingleQuery> ret = new ArrayList<SingleQuery>(1 + this.children.size());
        ret.add(this.query);
        for (QueryTreeNode node : this.children) {
            for (SingleQuery q : node.toQueries()) {
                ret.add(q);
            }
        }
        return ret.toArray(new SingleQuery[ret.size()]);
    }

    public void accept(QueryTreeNodeVisitor visitor) {
        visitor.visit(this);
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.getChildren().remove(this);
            this.parent = null;
        }
    }

    public void removeFromParentIncludeField() {
        if (this.parent != null) {
            this.parent.getChildren().remove(this);
            String fkFields = this.getQuery().getParentFK();
            this.parent.getQuery().removeSpecificInnerField(fkFields);
            this.parent = null;
        }
    }

    public void addToParent(QueryTreeNode parent) {
        parent.getChildren().add(this);
        this.parent = parent;
    }

    public String toString() {
        return this.query.toString();
    }

    public boolean isCostRoleOn() {
        return this.costRoleOn;
    }

    public void setCostRoleOn(boolean costRoleOn) {
        this.costRoleOn = costRoleOn;
    }

    public boolean isPkRoleOn() {
        return this.pkRoleOn;
    }

    public void setPkRoleOn(boolean pkRoleOn) {
        this.pkRoleOn = pkRoleOn;
    }

    public PeekingDataSet getPeekingDataSet() {
        return this.peekingDataSet;
    }

    public void setPeekingDataSet(PeekingDataSet peekingDataSet) {
        this.peekingDataSet = peekingDataSet;
    }

    public boolean isPushUp() {
        return this.pushUp;
    }

    public void setPushUp() {
        this.pushUp = true;
    }

    public boolean isBeenPushed() {
        return this.hasBeenPushed;
    }

    public void setBeenPushed() {
        this.hasBeenPushed = true;
    }

    public void setLazyQuery() {
        this.lazyQuery = true;
    }

    public boolean isLazyQuery() {
        return this.lazyQuery;
    }
}

