/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.oql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OQL {
    private int topSize = -1;
    private boolean isDistinct = false;
    private StringBuilder selectSB = new StringBuilder();
    private String entityName;
    private StringBuilder whereSB = new StringBuilder();
    private StringBuilder groupBySB = new StringBuilder();
    private StringBuilder havingSB = new StringBuilder();
    private StringBuilder orderBySB = new StringBuilder();
    private List<Object> havingParams = new ArrayList<Object>();
    private List<Object> whereParams = new ArrayList<Object>();

    public static OQL from(String entityName) {
        OQL oql = new OQL();
        oql.entityName = entityName;
        return oql;
    }

    public OQL setFrom(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public OQL top(int top) {
        this.topSize = top;
        return this;
    }

    public OQL distinct() {
        this.isDistinct = true;
        return this;
    }

    public OQL select(String fields) {
        this.selectSB.setLength(0);
        return this.appendSelect(fields);
    }

    public OQL appendSelect(String fields) {
        if (fields != null) {
            this.selectSB.append(fields);
        }
        return this;
    }

    public OQL where(String filters, Object ... params) {
        this.whereSB.setLength(0);
        return this.appendWhere(filters, params);
    }

    public OQL appendWhere(String filters, Object ... params) {
        if (filters != null) {
            this.whereSB.append(filters);
        }
        if (params != null && params.length > 0) {
            this.whereParams.addAll(Arrays.asList(params));
        }
        return this;
    }

    public OQL groupBy(String groupBy) {
        this.groupBySB.setLength(0);
        return this.appendGroupBy(groupBy);
    }

    public OQL appendGroupBy(String groupBy) {
        if (groupBy != null) {
            this.groupBySB.append(groupBy);
        }
        return this;
    }

    public OQL having(String having, Object ... params) {
        this.havingSB.setLength(0);
        return this.appendHaving(having, params);
    }

    public OQL appendHaving(String having, Object ... params) {
        if (having != null) {
            this.havingSB.append(having);
        }
        if (params != null && params.length > 0) {
            this.havingParams.addAll(Arrays.asList(params));
        }
        return this;
    }

    public OQL orderBy(String orderBy) {
        this.orderBySB.setLength(0);
        return this.appendOrderBy(orderBy);
    }

    public OQL appendOrderBy(String orderBy) {
        if (orderBy != null) {
            this.orderBySB.append(orderBy);
        }
        return this;
    }

    public Object[] getParams() {
        ArrayList<Object> params = new ArrayList<Object>(this.havingParams.size() + this.whereParams.size());
        params.addAll(this.havingParams);
        params.addAll(this.whereParams);
        return params.toArray();
    }

    public String getOql() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("SELECT");
        if (this.topSize >= 0) {
            sb.append(" TOP ").append(this.topSize);
        }
        if (this.isDistinct) {
            sb.append(" DISTINCT");
        }
        if (this.selectSB.length() > 0 && this.selectSB.toString().trim().length() > 0) {
            sb.append(' ').append(this.selectSB.toString().trim());
        }
        sb.append("\r\nFROM ");
        sb.append(this.entityName);
        if (this.whereSB.length() > 0 && this.whereSB.toString().trim().length() > 0) {
            sb.append("\r\nWHERE ");
            sb.append(this.whereSB.toString().trim());
        }
        if (this.groupBySB.length() > 0 && this.groupBySB.toString().trim().length() > 0) {
            sb.append("\r\nGROUP BY ");
            sb.append(this.groupBySB.toString().trim());
        }
        if (this.havingSB.length() > 0 && this.havingSB.toString().trim().length() > 0) {
            sb.append("\r\nHAVING ");
            sb.append(this.havingSB.toString().trim());
        }
        if (this.orderBySB.length() > 0 && this.orderBySB.toString().trim().length() > 0) {
            sb.append("\r\nORDER BY ");
            sb.append(this.orderBySB.toString().trim());
        }
        return sb.toString();
    }

    public String toString() {
        return this.getOql();
    }
}

