/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.oql.g.expr;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.ExprList;
import kd.bos.orm.query.multi.OrderByInfo;
import kd.bos.orm.query.multi.PropertySegExpress;
import kd.bos.orm.query.oql.g.expr.OQLExpr;
import kd.bos.orm.query.oql.g.parser.GParser;

public class OrderBys
extends OQLExpr {
    public static OrderBys parseFrom(String orderBys) {
        return GParser.parseOrderBys(orderBys);
    }

    public OrderBys(Expr expr) {
        super(expr);
    }

    public List<OrderByInfo> createOrderInfos(String rootObjName) {
        ArrayList<OrderByInfo> ret = new ArrayList<OrderByInfo>();
        if (this.expr instanceof ExprList) {
            for (Expr exp : this.expr.getChildren()) {
                PropertySegExpress pse = GParser.parse(exp);
                ret.add(this.createOrderInfo(pse, exp, rootObjName));
            }
        } else {
            ret.add(this.createOrderInfo(this.toExpress(), this.expr, rootObjName));
        }
        return ret;
    }

    private OrderByInfo createOrderInfo(PropertySegExpress pse, Expr exp, String rootObjName) {
        PropertySegExpress pfSEG = pse;
        String ordering = null;
        if (exp instanceof Alias) {
            Alias aliasExp = (Alias)exp;
            pfSEG = GParser.parse(aliasExp.getChild());
            ordering = aliasExp.getAlias();
        }
        List<String> ps = pfSEG.getFullPropertyNames();
        String fullObjectName = this.getPropertyObjName(ps, rootObjName);
        return new OrderByInfo(fullObjectName, pfSEG, ordering);
    }
}

