/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.oql.g.expr;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.sql.tree.And;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.BinaryOperator;
import kd.bos.algo.sql.tree.Equal;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.GT;
import kd.bos.algo.sql.tree.GTE;
import kd.bos.algo.sql.tree.In;
import kd.bos.algo.sql.tree.IsNotNull;
import kd.bos.algo.sql.tree.IsNull;
import kd.bos.algo.sql.tree.LT;
import kd.bos.algo.sql.tree.LTE;
import kd.bos.algo.sql.tree.Like;
import kd.bos.algo.sql.tree.Literal;
import kd.bos.algo.sql.tree.Not;
import kd.bos.algo.sql.tree.NotEqual;
import kd.bos.algo.sql.tree.Or;
import kd.bos.algo.sql.tree.Parameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.oql.g.visitor.ExprVisitor;

public class QFilterExpVisitor
extends ExprVisitor<Object> {
    private int pos = 0;
    private Object[] params;

    public QFilterExpVisitor(Object[] params) {
        this.params = params;
    }

    @Override
    public Object defaultVisit(Expr exp, Object context) {
        if (exp instanceof Literal) {
            return ((Literal)exp).getValue();
        }
        return exp.sql();
    }

    private IfExpressValue parseIfExpressValue(Expr vExpr) {
        Object value = vExpr.accept((AstVisitor)this, null);
        boolean expressValue = true;
        if (value instanceof ParamValue) {
            value = ((ParamValue)value).value;
            expressValue = false;
        } else if (vExpr instanceof Literal) {
            expressValue = false;
        }
        return new IfExpressValue(value, expressValue);
    }

    private QFilter parseFilter(BinaryOperator exp, String cp) {
        Object pv = exp.getChild(0).accept((AstVisitor)this, null);
        String property = String.valueOf(pv instanceof ParamValue ? ((ParamValue)pv).value : pv);
        Expr vExpr = exp.getChild(1);
        IfExpressValue ffExpressValue = this.parseIfExpressValue(vExpr);
        return new QFilter(property, cp, ffExpressValue.value, ffExpressValue.expressValue);
    }

    public Object visitAnd(And exp, Object context) {
        List list = exp.getChildren();
        QFilter left = (QFilter)exp.getChild(0).accept((AstVisitor)this, context);
        QFilter right = (QFilter)exp.getChild(1).accept((AstVisitor)this, context);
        QFilter filter = QFilter.and(left, right);
        for (int i = 2; i < list.size(); ++i) {
            filter = QFilter.and(filter, (QFilter)((Expr)list.get(i)).accept((AstVisitor)this, context));
        }
        return filter;
    }

    public Object visitOr(Or exp, Object context) {
        List list = exp.getChildren();
        QFilter left = (QFilter)exp.getChild(0).accept((AstVisitor)this, context);
        QFilter right = (QFilter)exp.getChild(1).accept((AstVisitor)this, context);
        QFilter filter = QFilter.or(left, right);
        for (int i = 2; i < list.size(); ++i) {
            filter = QFilter.or(filter, (QFilter)((Expr)list.get(i)).accept((AstVisitor)this, context));
        }
        return filter;
    }

    public Object visitGT(GT exp, Object context) {
        return this.parseFilter((BinaryOperator)exp, ">");
    }

    public Object visitGTE(GTE exp, Object context) {
        return this.parseFilter((BinaryOperator)exp, ">=");
    }

    public Object visitLT(LT exp, Object context) {
        return this.parseFilter((BinaryOperator)exp, "<");
    }

    public Object visitLTE(LTE exp, Object context) {
        return this.parseFilter((BinaryOperator)exp, "<=");
    }

    public Object visitEqual(Equal exp, Object context) {
        return this.parseFilter((BinaryOperator)exp, "=");
    }

    public Object visitNotEqual(NotEqual exp, Object context) {
        return this.parseFilter((BinaryOperator)exp, "!=");
    }

    public Object visitIsNull(IsNull exp, Object context) {
        return QFilter.isNull((String)exp.getChild().accept((AstVisitor)this, context));
    }

    public Object visitIsNotNull(IsNotNull exp, Object context) {
        return QFilter.isNotNull((String)exp.getChild().accept((AstVisitor)this, context));
    }

    public Object visitLike(Like exp, Object context) {
        return this.parseFilter((BinaryOperator)exp, "like");
    }

    public Object visitIn(In exp, Object context) {
        Expr[] children = exp.getChildren().toArray(new Expr[0]);
        String property = (String)exp.getChild(0).accept((AstVisitor)this, context);
        ArrayList<Object> values = new ArrayList<Object>(children.length - 1);
        for (int i = 1; i < children.length; ++i) {
            Object value = children[i].accept((AstVisitor)this, context);
            if (value instanceof ParamValue) {
                value = ((ParamValue)value).value;
            }
            values.add(value);
        }
        return new QFilter(property, "in", values);
    }

    public Object visitNot(Not exp, Object context) {
        Expr next = exp.getChild();
        QFilter filter = null;
        String cp = null;
        if (next instanceof Like) {
            filter = (QFilter)this.visitLike((Like)exp.getChild(), context);
            cp = "not like";
        } else if (next instanceof In) {
            filter = (QFilter)this.visitIn((In)exp.getChild(), context);
            cp = "not in";
        } else {
            throw new UnsupportedOperationException("Not supprot: Not " + next.accept((AstVisitor)this, context));
        }
        QFilter notFilter = new QFilter(filter.getProperty(), cp, filter.getValue(), filter.isExpressValue());
        for (QFilter.QFilterNest nest : notFilter.getNests(false)) {
            if (nest.isAnd()) {
                notFilter = notFilter.and(nest.getFilter());
                continue;
            }
            notFilter = notFilter.or(nest.getFilter());
        }
        return notFilter;
    }

    public Object visitParameter(Parameter exp, Object context) {
        return new ParamValue(this.params[this.pos++]);
    }

    public int usedParamCount() {
        return this.pos;
    }

    private static class ParamValue {
        final Object value;

        ParamValue(Object value) {
            this.value = value;
        }
    }

    private static class IfExpressValue {
        private final Object value;
        private final boolean expressValue;

        private IfExpressValue(Object value, boolean expressValue) {
            this.value = value;
            this.expressValue = expressValue;
        }
    }
}

