/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.oql.g.expr;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.ExprList;
import kd.bos.algo.sql.tree.Literal;
import kd.bos.algo.sql.tree.UnresolvedAttribute;
import kd.bos.algo.sql.tree.UnresolvedStar;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.orm.query.multi.PropertySegExpress;
import kd.bos.orm.query.oql.g.expr.OQLExpr;
import kd.bos.orm.query.oql.g.expr.SelectFieldsSQLInjectionVisitor;
import kd.bos.orm.query.oql.g.parser.GParser;

public class SelectFields
extends OQLExpr {
    public static SelectFields parseFrom(String selectFields) {
        return GParser.parseSelectFields(selectFields);
    }

    public SelectFields(Expr expr) {
        super(expr);
        expr.accept((AstVisitor)new SelectFieldsSQLInjectionVisitor(), null);
    }

    public List<PropertyField> createPropertyFields(String rootObjName) {
        ArrayList<PropertyField> ret = new ArrayList<PropertyField>();
        if (this.expr instanceof ExprList) {
            for (Expr exp : this.expr.getChildren()) {
                PropertySegExpress pse = GParser.parse(exp);
                ret.add(this.createPropertyField(pse, exp, rootObjName));
            }
        } else {
            ret.add(this.createPropertyField(this.toExpress(), this.expr, rootObjName));
        }
        HashSet<String> aliasSet = new HashSet<String>(ret.size());
        for (PropertyField pf : ret) {
            String alias = pf.getAlias().toLowerCase();
            if (aliasSet.contains(alias)) {
                throw new IllegalArgumentException("[ORM] Select duplicate field(alias): " + pf);
            }
            aliasSet.add(alias);
        }
        return ret;
    }

    private PropertyField createPropertyField(PropertySegExpress pse, Expr exp, String rootObjName) {
        int dot;
        String name;
        if (exp instanceof UnresolvedStar) {
            UnresolvedStar star = (UnresolvedStar)exp;
            return new PropertyField(star.getPrefix(), "*", null);
        }
        List<String> ps = pse.getFullPropertyNames();
        String alias = null;
        if (exp instanceof Alias) {
            Alias aliasExp = (Alias)exp;
            alias = aliasExp.getAlias();
            exp = aliasExp.getChild();
            if (exp instanceof UnresolvedStar) {
                UnresolvedStar star = (UnresolvedStar)exp;
                return new PropertyField(star.getPrefix(), "*", alias);
            }
            name = exp.sql();
            pse = GParser.parse(exp);
        } else {
            name = alias = exp.sql();
        }
        String fullObjectName = this.getPropertyObjName(ps, rootObjName);
        if (ps.size() > 0) {
            List nameParts;
            int size;
            if (exp instanceof UnresolvedAttribute && (size = (nameParts = ((UnresolvedAttribute)exp).getNameParts()).size()) > 1) {
                name = (String)nameParts.get(size - 1);
                fullObjectName = rootObjName + '.' + String.join((CharSequence)".", nameParts.subList(0, size - 1));
            }
        } else if (exp instanceof Alias && (dot = alias.lastIndexOf(46)) != -1) {
            fullObjectName = alias.substring(0, dot).toLowerCase();
        }
        PropertyField pf = new PropertyField(fullObjectName, name, alias);
        pf.setPropertySegExpress(pse);
        if (exp instanceof Literal) {
            pse.setLiteral((Literal)exp);
        }
        return pf;
    }
}

