/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.oql.g.visitor;

import java.util.List;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.And;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.BinaryOperator;
import kd.bos.algo.sql.tree.CaseWhenClause;
import kd.bos.algo.sql.tree.CaseWhenSearch;
import kd.bos.algo.sql.tree.CaseWhenSimple;
import kd.bos.algo.sql.tree.Cast;
import kd.bos.algo.sql.tree.Concat;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.ExprList;
import kd.bos.algo.sql.tree.In;
import kd.bos.algo.sql.tree.IsNotNull;
import kd.bos.algo.sql.tree.IsNull;
import kd.bos.algo.sql.tree.Not;
import kd.bos.algo.sql.tree.Or;
import kd.bos.algo.sql.tree.SortOrder;
import kd.bos.algo.sql.tree.StringAdd;
import kd.bos.algo.sql.tree.UnaryMinus;
import kd.bos.algo.sql.tree.UnresolvedAttribute;
import kd.bos.algo.sql.tree.UnresolvedFuncall;
import kd.bos.algo.sql.tree.agg.AggExpr;
import kd.bos.bundle.BosRes;
import kd.bos.orm.query.multi.PropertySegExpress;
import kd.bos.orm.query.oql.g.visitor.ExprVisitor;

public class ParsePropertyVisitor
extends ExprVisitor<Object> {
    private PropertySegExpress pse = new PropertySegExpress();

    public PropertySegExpress getPropertySegExpress() {
        return this.pse;
    }

    private void appendProperty(String fullPropertyName) {
        this.pse.appendProperty(fullPropertyName);
    }

    @Override
    public Object defaultVisit(Expr exp, Object context) {
        if (exp.getChildrenCount() != 0) {
            throw new UnsupportedOperationException(BosRes.get((String)"bos-ormengine", (String)"ParsePropertyVisitor_0", (String)"Not handle expr object:{0}", (Object[])new Object[]{exp.getClass().getSimpleName()}));
        }
        this.pse.appendString(exp.sql());
        return exp.sql();
    }

    public Object visitBinaryOperator(BinaryOperator exp, Object context) {
        boolean b2;
        boolean b1;
        boolean bl = b1 = exp.getChild(0).getChildrenCount() > 1;
        if (b1) {
            this.pse.appendString("(");
        }
        exp.getChild(0).accept((AstVisitor)this, context);
        if (b1) {
            this.pse.appendString(")");
        }
        this.pse.appendString(" ").appendString(exp.getOperator()).appendString(" ");
        boolean bl2 = b2 = exp.getChild(1).getChildrenCount() > 1;
        if (b2) {
            this.pse.appendString("(");
        }
        exp.getChild(1).accept((AstVisitor)this, context);
        if (b2) {
            this.pse.appendString(")");
        }
        return null;
    }

    public Object visitConcat(Concat exp, Object context) {
        Expr[] children = exp.getChildren().toArray(new Expr[0]);
        this.pse.appendString("CONCAT(");
        for (int i = 0; i < children.length; ++i) {
            if (i > 0) {
                this.pse.appendString(",");
            }
            children[i].accept((AstVisitor)this, context);
        }
        this.pse.appendString(")");
        return null;
    }

    public Object visitExprList(ExprList exp, Object context) {
        Expr[] children = exp.getChildren().toArray(new Expr[0]);
        for (int i = 0; i < children.length; ++i) {
            if (i > 0) {
                this.pse.appendString(",");
            }
            children[i].accept((AstVisitor)this, context);
        }
        return null;
    }

    public Object visitIn(In exp, Object context) {
        Expr[] children = exp.getChildren().toArray(new Expr[0]);
        children[0].accept((AstVisitor)this, context);
        this.pse.appendString(" IN (");
        for (int i = 1; i < children.length; ++i) {
            if (i > 1) {
                this.pse.appendString(",");
            }
            children[i].accept((AstVisitor)this, context);
        }
        this.pse.appendString(")");
        return null;
    }

    public Object visitUnresolvedAttribute(UnresolvedAttribute exp, Object context) {
        this.appendProperty(exp.sql());
        return null;
    }

    public Object visitAlias(Alias exp, Object context) {
        exp.getChild().accept((AstVisitor)this, context);
        this.pse.appendString(" AS ").appendString(exp.getAlias());
        return null;
    }

    public Object visitCast(Cast exp, Object context) {
        this.pse.appendString("CAST(");
        exp.getChild().accept((AstVisitor)this, context);
        this.pse.appendString(",");
        this.pse.appendString(exp.getDataType().getName());
        this.pse.appendString(")");
        return null;
    }

    public Object visitIsNotNull(IsNotNull exp, Object context) {
        exp.getChild().accept((AstVisitor)this, context);
        this.pse.appendString(" IS NOT NULL");
        return null;
    }

    public Object visitIsNull(IsNull exp, Object context) {
        exp.getChild().accept((AstVisitor)this, context);
        this.pse.appendString(" IS NULL");
        return null;
    }

    public Object visitNot(Not exp, Object context) {
        this.pse.appendString("NOT ");
        exp.getChild().accept((AstVisitor)this, context);
        return null;
    }

    public Object visitAnd(And expr, Object context) {
        List children = expr.getChildren();
        if (children.size() > 1) {
            this.pse.appendString("(");
        }
        for (int i = 0; i < children.size(); ++i) {
            ((Expr)children.get(i)).accept((AstVisitor)this, context);
            if (i == children.size() - 1) continue;
            this.pse.appendString(" and ");
        }
        if (children.size() > 1) {
            this.pse.appendString(")");
        }
        return null;
    }

    public Object visitOr(Or expr, Object context) {
        List children = expr.getChildren();
        if (children.size() > 1) {
            this.pse.appendString("(");
        }
        for (int i = 0; i < children.size(); ++i) {
            ((Expr)children.get(i)).accept((AstVisitor)this, context);
            if (i == children.size() - 1) continue;
            this.pse.appendString(" or ");
        }
        if (children.size() > 1) {
            this.pse.appendString(")");
        }
        return null;
    }

    public Object visitStringAdd(StringAdd exp, Object context) {
        boolean b2;
        boolean b1;
        boolean bl = b1 = exp.getChild(0).getChildrenCount() > 1;
        if (b1) {
            this.pse.appendString("(");
        }
        exp.getChild(0).accept((AstVisitor)this, context);
        if (b1) {
            this.pse.appendString(")");
        }
        this.pse.appendString(" ").appendString("||").appendString(" ");
        boolean bl2 = b2 = exp.getChild(1).getChildrenCount() > 1;
        if (b2) {
            this.pse.appendString("(");
        }
        exp.getChild(1).accept((AstVisitor)this, context);
        if (b2) {
            this.pse.appendString(")");
        }
        return null;
    }

    public Object visitSortOrder(SortOrder exp, Object context) {
        exp.getChild().accept((AstVisitor)this, context);
        this.pse.appendString(" ").appendString(exp.getSortDirect().name());
        return null;
    }

    public Object visitUnaryMinus(UnaryMinus exp, Object context) {
        this.pse.appendString("-");
        exp.getChild().accept((AstVisitor)this, context);
        return null;
    }

    public Object visitUnresolvedFuncall(UnresolvedFuncall exp, Object context) {
        Expr[] children;
        this.pse.appendString(exp.getName());
        this.pse.appendString("(");
        if (exp.isDistinct()) {
            this.pse.appendString("DISTINCT ");
        }
        if ((children = exp.getChildren().toArray(new Expr[0])) != null) {
            for (int i = 0; i < children.length; ++i) {
                if (i > 0) {
                    this.pse.appendString(",");
                }
                children[i].accept((AstVisitor)this, context);
            }
        }
        this.pse.appendString(")");
        return null;
    }

    public Object visitAggExpr(AggExpr exp, Object context) {
        this.pse.appendString(exp.getFunc() + "(");
        exp.getChild().accept((AstVisitor)this, context);
        this.pse.appendString(")");
        return null;
    }

    public Object visitCaseWhenSimple(CaseWhenSimple caseWhenSimple, Object context) {
        boolean hasElse = caseWhenSimple.hasElse();
        Expr[] children = caseWhenSimple.getChildren().toArray(new Expr[caseWhenSimple.getChildren().size()]);
        this.pse.appendString("CASE ");
        children[0].accept((AstVisitor)this, context);
        int length = hasElse ? children.length - 2 : children.length - 1;
        for (int i = 0; i < length; ++i) {
            children[i + 1].accept((AstVisitor)this, context);
        }
        if (hasElse) {
            this.pse.appendString(" ELSE ");
            children[children.length - 1].accept((AstVisitor)this, context);
        }
        this.pse.appendString(" END");
        return null;
    }

    public Object visitCaseWhenSearch(CaseWhenSearch caseWhenSearch, Object context) {
        boolean hasElse = caseWhenSearch.hasElse();
        Expr[] children = caseWhenSearch.getChildren().toArray(new Expr[caseWhenSearch.getChildren().size()]);
        this.pse.appendString("CASE");
        int length = hasElse ? children.length - 1 : children.length;
        for (int i = 0; i < length; ++i) {
            children[i].accept((AstVisitor)this, context);
        }
        if (hasElse) {
            this.pse.appendString(" ELSE ");
            children[children.length - 1].accept((AstVisitor)this, context);
        }
        this.pse.appendString(" END");
        return null;
    }

    public Object visitCaseWhenClause(CaseWhenClause caseWhenClause, Object context) {
        this.pse.appendString(" WHEN ");
        caseWhenClause.getChild(0).accept((AstVisitor)this, context);
        this.pse.appendString(" THEN ");
        caseWhenClause.getChild(1).accept((AstVisitor)this, context);
        return null;
    }
}

