/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.query.privacy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.db.DBRoute;
import kd.bos.db.privacy.model.DBIdQueryModel;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.privacy.PrivacyDataQuery;
import kd.bos.orm.query.privacy.PrivacyDataRow;
import kd.bos.orm.query.privacy.PrivacyFieldInfo;
import kd.bos.orm.query.privacy.TempField;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;

public class PrivacyDataSetIter
extends InnerRowIterator {
    private static Log logger = LogFactory.getLog(PrivacyDataSetIter.class);
    private Iterator<Row> iter;
    private List<Row> cacheRow = new ArrayList<Row>();
    private List<Row> cacheRow1 = new ArrayList<Row>();
    private Iterator<Row> cacheRowIter;
    private Map<String, PrivacyFieldInfo> privacyFieldMap;
    private Map<String, TempField> privacyColumnToField = new HashMap<String, TempField>();
    private String pkAlias;
    private int cacheSize = Integer.getInteger("orm.opt.privacy.batchSize", 5000);
    private final int maxCacheSize = Integer.getInteger("orm.opt.privacy.max.batchSize", 1000000);
    private DBRoute dbRoute;
    private String tableName;
    private RowMeta rowMeta;

    public PrivacyDataSetIter(Iterator<Row> iter, Map<String, PrivacyFieldInfo> privacyFieldMap, String pkAlias, DBRoute dbRoute, String tableName, RowMeta rowMeta, Integer cacheSize) {
        this.iter = iter;
        this.privacyFieldMap = privacyFieldMap;
        this.pkAlias = pkAlias;
        this.dbRoute = dbRoute;
        this.tableName = tableName;
        this.rowMeta = rowMeta;
        if (cacheSize != null) {
            this.cacheSize = Math.min(cacheSize, this.maxCacheSize);
        }
        for (PrivacyFieldInfo next : privacyFieldMap.values()) {
            Map<String, TempField> multiLangColumnToField;
            Map<String, TempField> columnToField = next.getColumnToField();
            if (columnToField != null && !columnToField.isEmpty()) {
                this.privacyColumnToField.putAll(columnToField);
            }
            if ((multiLangColumnToField = next.getMultiLangColumnToField()) == null || multiLangColumnToField.isEmpty()) continue;
            this.privacyColumnToField.putAll(multiLangColumnToField);
        }
    }

    public boolean _hasNext() {
        if (this.privacyFieldMap != null && !this.privacyFieldMap.isEmpty()) {
            if (CollectionUtils.isEmpty(this.cacheRow1)) {
                if (!this.iter.hasNext()) {
                    return false;
                }
                this.cacheData();
                return true;
            }
            boolean b = this.cacheRowIter.hasNext();
            if (!b) {
                this.cacheRow1 = new ArrayList<Row>();
                this.cacheData();
                b = this.cacheRowIter.hasNext();
            }
            return b;
        }
        return this.iter.hasNext();
    }

    public Row _next() {
        if (this.privacyFieldMap != null && !this.privacyFieldMap.isEmpty()) {
            if (this.cacheRowIter.hasNext()) {
                return this.cacheRowIter.next();
            }
            this.cacheRow1 = new ArrayList<Row>();
            this.cacheData();
            if (this.cacheRowIter.hasNext()) {
                return this.cacheRowIter.next();
            }
            return null;
        }
        return this.iter.next();
    }

    private void cacheData() {
        int count = 0;
        HashMap<String, DBIdQueryModel> queryModel = new HashMap<String, DBIdQueryModel>();
        HashSet<Object> idSet = new HashSet<Object>(1000);
        Set<Map.Entry<String, PrivacyFieldInfo>> entries = this.privacyFieldMap.entrySet();
        while (this.iter.hasNext()) {
            Row row = this.iter.next();
            row = RowUtil.persist((Row)row);
            for (Map.Entry<String, PrivacyFieldInfo> next : entries) {
                String tableName = next.getKey();
                PrivacyFieldInfo fieldInfo = next.getValue();
                DBIdQueryModel dbIdQueryModel = (DBIdQueryModel)queryModel.get(tableName);
                if (dbIdQueryModel == null) {
                    Map<String, TempField> multiLangColumnToField;
                    dbIdQueryModel = new DBIdQueryModel();
                    dbIdQueryModel.setTableName(tableName);
                    dbIdQueryModel.setLocaleId(Lang.get().toString());
                    Map<String, TempField> columnToField = fieldInfo.getColumnToField();
                    if (columnToField != null && !columnToField.isEmpty()) {
                        dbIdQueryModel.setFields(columnToField.keySet());
                    }
                    if ((multiLangColumnToField = fieldInfo.getMultiLangColumnToField()) != null && !multiLangColumnToField.isEmpty()) {
                        dbIdQueryModel.setMultiField(multiLangColumnToField.keySet());
                    }
                    ArrayList<Object> ids1 = new ArrayList<Object>();
                    ids1.add(row.get(fieldInfo.getPkAlias()));
                    dbIdQueryModel.setIds(ids1);
                } else {
                    dbIdQueryModel.getIds().add(row.get(fieldInfo.getPkAlias()));
                }
                queryModel.put(tableName, dbIdQueryModel);
                idSet.add(row.get(fieldInfo.getPkAlias()));
            }
            try {
                idSet.add(row.get(this.pkAlias));
            }
            catch (Exception e) {
                try {
                    logger.error("no field : '" + this.pkAlias + "',fields:" + this.rowMeta, (Throwable)e);
                    idSet.add(row.get("id"));
                }
                catch (Exception e1) {
                    logger.debug("no field : 'id' ", (Object)e);
                }
            }
            this.cacheRow.add(row);
            if (++count < this.cacheSize) continue;
            break;
        }
        if (queryModel != null && !queryModel.isEmpty()) {
            ArrayList ids = new ArrayList(idSet);
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)this.tableName, (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, ids)});){
                this.getValueOfPrivacyField(queryModel);
                this.cacheRowIter = this.cacheRow1.iterator();
            }
        }
    }

    private void getValueOfPrivacyField(Map<String, DBIdQueryModel> queryModel) {
        HashMap<String, Map> values = new HashMap<String, Map>();
        try {
            Iterator<Map.Entry<String, DBIdQueryModel>> iterator1 = queryModel.entrySet().iterator();
            while (iterator1.hasNext()) {
                DBIdQueryModel value = iterator1.next().getValue();
                Map<String, Map<String, Object>> values1 = PrivacyDataQuery.getValues(this.dbRoute, value.getTableName(), (List<Object>)value.getIds(), (Set<String>)value.getFields(), value.getMultiField());
                if (values1 == null || values1.isEmpty()) continue;
                for (Map.Entry<String, Object> entry : values1.entrySet()) {
                    String key = entry.getKey();
                    Map newValue = (Map)entry.getValue();
                    Map originValues = (Map)values.get(key);
                    if (originValues != null) {
                        originValues.putAll(newValue);
                        continue;
                    }
                    if (newValue == null) continue;
                    values.put(key, newValue);
                }
            }
            for (Row value : this.cacheRow) {
                Iterator<Map.Entry<String, Object>> iterator = this.privacyFieldMap.entrySet().iterator();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                while (iterator.hasNext()) {
                    Map privacyFieldValuetemp;
                    PrivacyFieldInfo fieldInfo = iterator.next().getValue();
                    String pkAlias = fieldInfo.getPkAlias();
                    String pk = String.valueOf(value.get(pkAlias));
                    if (values == null || values.isEmpty() || (privacyFieldValuetemp = (Map)values.get(pk)) == null || privacyFieldValuetemp.isEmpty()) continue;
                    hashMap.putAll(privacyFieldValuetemp);
                }
                PrivacyDataRow privacyRow = new PrivacyDataRow(value, this.rowMeta, hashMap, this.privacyColumnToField);
                this.cacheRow1.add((Row)privacyRow);
            }
            this.cacheRow.clear();
        }
        catch (Exception e) {
            throw new RuntimeException("get the value of the privacy field error", e);
        }
    }
}

