/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.sequence;

import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.sequence.Sequence;

public class Oracle
extends Sequence {
    public Oracle(DBRoute dbRoute) {
        super(dbRoute);
        this.sqlSequenceObjectQuery = "/*dialect*/ Select Count(*) From user_sequences Where Sequence_Name = ?";
        this.createSql = "/*dialect*/ CREATE SEQUENCE %1$s MINVALUE %2$dSTART WITH %2$d INCREMENT BY 1 CACHE 500";
        this.sqlSequenceQuery = "/*dialect*/ Select  %1$s.nextval as fkey From dual CONNECT BY LEVEL<=?";
        this.sqlTableQuery = "/*dialect*/ Select Count(*) From user_tables Where Table_Name = ?";
        this.sqlPkQuery = "/*dialect*/ select b.column_name  from user_constraints a, user_cons_columns b where a.table_name = ?   AND a.CONSTRAINT_TYPE = 'P'   and a.constraint_name = b.constraint_name";
    }

    @Override
    public void repairMaxValue(String seqName, String tableName, long seqValue) {
        long tableValue = this.getTableMaxSeq(tableName);
        if (seqValue <= tableValue) {
            long step = tableValue - seqValue + 1L;
            String sql = String.format("/*dialect*/ alter sequence %1$s increment by %2$d ", seqName, step);
            DB.execute((DBRoute)this.dbRoute, (String)sql, null);
            sql = String.format("/*dialect*/ select %1$s.nextval from dual", seqName);
            DB.execute((DBRoute)this.dbRoute, (String)sql, null);
            sql = String.format("/*dialect*/ alter sequence %1$s increment by 1", seqName);
            DB.execute((DBRoute)this.dbRoute, (String)sql, null);
        }
    }
}

