/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orm.sequence;

import java.sql.SQLException;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.sequence.Sequence;

public class PostgreSQL
extends Sequence {
    public PostgreSQL(DBRoute dbRoute) {
        super(dbRoute);
        this.sqlSequenceObjectQuery = "/*dialect*/ Select count(*) from pg_class where relkind = 'S' and relname = ?";
        this.createSql = "/*dialect*/ CREATE SEQUENCE %1$s MINVALUE %2$dSTART WITH %2$d INCREMENT BY 1 CACHE 500";
        this.sqlSequenceQuery = "/*dialect*/ select nextval('%1$s'); select setval('%1$s', currval('%1$s') + ? -1);";
        this.sqlTableQuery = "/*dialect*/ select Count(*) from pg_class where relname = ?";
        this.sqlPkQuery = "/*dialect*/ select pg_attribute.attname from pg_constraint   inner join pg_class on pg_constraint.conrelid = pg_class.oid  inner join pg_attribute on pg_attribute.attrelid = pg_class.oid and  pg_attribute.attnum = pg_constraint.conkey[1]  where pg_class.relname = ? and pg_constraint.contype='p'";
    }

    @Override
    void repairMaxValue(String seqName, String tableName, long seqValue) throws SQLException {
        Long tableValue = this.getTableMaxSeq(tableName);
        if (seqValue <= tableValue) {
            Long step = tableValue - seqValue + 1L;
            String sql = String.format("/*dialect*/ select nextval('%1$s'); select setval('%1$s', %2$d)", seqName, step);
            DB.execute((DBRoute)this.dbRoute, (String)sql, null);
        }
    }
}

